/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;

public class GenerateConstructorUsingFields {

    public static class Scoped
    extends JavaIsoRefactorVisitor {
        private final J.ClassDecl scope;
        private final List<J.VariableDecls> fields;

        public Scoped(J.ClassDecl scope, List<J.VariableDecls> fields) {
            this.scope = scope;
            this.fields = fields;
            this.setCursoringOn();
        }

        @Override
        public J.ClassDecl visitClassDecl(J.ClassDecl classDecl) {
            if (this.scope.isScope(classDecl) && !this.hasRequiredArgsConstructor(classDecl)) {
                ArrayList<J> statements = new ArrayList<J>(classDecl.getBody().getStatements());
                int lastField = -1;
                for (int i = 0; i < statements.size(); ++i) {
                    if (!(statements.get(i) instanceof J.VariableDecls)) continue;
                    lastField = i;
                }
                List<Statement> constructorParams = this.fields.stream().map(mv -> new J.VariableDecls(Tree.randomId(), Collections.emptyList(), Collections.emptyList(), mv.getTypeExpr() != null ? (TypeTree)mv.getTypeExpr().withFormatting(Formatting.EMPTY) : null, null, Formatting.formatFirstPrefix(mv.getDimensionsBeforeName(), (String)""), Formatting.formatFirstPrefix(mv.getVars(), (String)" "), Collections.emptyList(), Formatting.EMPTY, Markers.EMPTY)).collect(Collectors.toList());
                for (int i = 1; i < constructorParams.size(); ++i) {
                    constructorParams.set(i, (Statement)((Statement)constructorParams.get(i)).withFormatting(Formatting.format((String)" ")));
                }
                Formatting constructorFormatting = this.formatter.format(classDecl.getBody());
                J.MethodDecl constructor = new J.MethodDecl(Tree.randomId(), Collections.emptyList(), Collections.singletonList(new J.Modifier.Public(Tree.randomId(), Collections.emptyList(), Formatting.EMPTY, Markers.EMPTY)), null, null, J.Ident.build(Tree.randomId(), classDecl.getSimpleName(), classDecl.getType(), Collections.emptyList(), Formatting.format((String)" "), Markers.EMPTY), new J.MethodDecl.Parameters(Tree.randomId(), constructorParams, Collections.emptyList(), Formatting.EMPTY, Markers.EMPTY), null, new J.Block<Statement>(Tree.randomId(), null, Collections.emptyList(), Collections.emptyList(), Formatting.format((String)" "), Markers.EMPTY, new J.Block.End(Tree.randomId(), Collections.emptyList(), Formatting.format((String)this.formatter.findIndent(classDecl.getBody().getIndent(), classDecl.getBody().getStatements().toArray(new Tree[0])).getPrefix()), Markers.EMPTY)), null, Collections.emptyList(), constructorFormatting.withPrefix("\n" + constructorFormatting.getPrefix()), Markers.EMPTY);
                if (!this.fields.isEmpty()) {
                    this.andThen((RefactorVisitor)new AddAssignmentsToConstructor(constructor));
                }
                statements.add(lastField + 1, constructor);
                return classDecl.withBody(classDecl.getBody().withStatements(statements));
            }
            return super.visitClassDecl(classDecl);
        }

        private boolean hasRequiredArgsConstructor(J.ClassDecl cd) {
            Set injectedFieldNames = this.fields.stream().map(f -> f.getVars().get(0).getSimpleName()).collect(Collectors.toSet());
            return cd.getBody().getStatements().stream().anyMatch(stat -> stat.whenType(J.MethodDecl.class).filter(J.MethodDecl::isConstructor).map(md -> md.getParams().getParams().stream().map(p -> p.whenType(J.VariableDecls.class).map(mv -> mv.getVars().get(0).getSimpleName()).orElseThrow(() -> new RuntimeException("not possible to get here"))).allMatch(injectedFieldNames::contains)).orElse(false));
        }

        private class AddAssignmentsToConstructor
        extends JavaIsoRefactorVisitor {
            private final J.MethodDecl scope;

            private AddAssignmentsToConstructor(J.MethodDecl scope) {
                this.scope = scope;
                this.setCursoringOn();
            }

            @Override
            public J.MethodDecl visitMethod(J.MethodDecl method) {
                if (this.scope.isScope(method)) {
                    return method.withBody(method.getBody().withStatements(this.getTreeBuilder().buildSnippet(this.getCursor(), Scoped.this.fields.stream().map(mv -> {
                        String name = mv.getVars().get(0).getSimpleName();
                        return "this." + name + " = " + name + ";";
                    }).collect(Collectors.joining("\n", "", "\n")), new JavaType[0])));
                }
                return super.visitMethod(method);
            }
        }
    }
}

