/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.java.AbstractJavaSourceVisitor;

public class VisitRecorder
extends AbstractJavaSourceVisitor<List<VisitRecord>> {
    public VisitRecorder() {
        this.setCursoringOn();
    }

    public List<VisitRecord> defaultTo(Tree t) {
        return Collections.emptyList();
    }

    public List<VisitRecord> visitTree(Tree tree) {
        int parentCount = this.countParents(this.getCursor());
        return Collections.singletonList(new VisitRecord(parentCount, tree));
    }

    public int countParents(Cursor cursor) {
        return (int)cursor.getPathAsStream().count();
    }

    public static String printVisitRecords(List<VisitRecord> records) {
        StringBuilder sb = new StringBuilder();
        for (VisitRecord record : records) {
            sb.append(record.toString()).append("\n");
        }
        return sb.toString();
    }

    public static class VisitRecord {
        final int depth;
        final Tree tree;

        public VisitRecord(int depth, Tree tree) {
            this.depth = depth;
            this.tree = tree;
        }

        public String toString() {
            String padding = IntStream.range(0, this.depth + 1).mapToObj(it -> " ").collect(Collectors.joining());
            return padding + this.tree;
        }
    }
}

