/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.stream.Collectors;
import org.openrewrite.java.AspectjUtils;
import org.openrewrite.java.internal.grammar.RefactorMethodSignatureParser;
import org.openrewrite.java.internal.grammar.RefactorMethodSignatureParserBaseVisitor;

class TypeVisitor
extends RefactorMethodSignatureParserBaseVisitor<String> {
    TypeVisitor() {
    }

    @Override
    public String visitClassNameOrInterface(RefactorMethodSignatureParser.ClassNameOrInterfaceContext ctx) {
        String className = ctx.children.stream().map(c -> AspectjUtils.aspectjNameToPattern(c.getText())).collect(Collectors.joining(""));
        if (!className.contains(".")) {
            try {
                int arrInit = className.lastIndexOf("\\[");
                Class.forName("java.lang." + (arrInit == -1 ? className : className.substring(0, arrInit)), false, TypeVisitor.class.getClassLoader());
                return "java.lang." + className;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return className;
    }

    @Override
    public String visitPrimitiveType(RefactorMethodSignatureParser.PrimitiveTypeContext ctx) {
        return ctx.getText();
    }
}

