/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.koloboke.collect.map.hash.HashObjObjMaps;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.collect.set.hash.HashObjSets;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TreeBuilder;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
@JsonTypeInfo(use=JsonTypeInfo.Id.MINIMAL_CLASS, property="@c")
public interface JavaType
extends Serializable {
    public boolean deepEquals(@Nullable JavaType var1);

    public TypeTree toTypeTree();

    public static JavaType buildType(String typeName) {
        Primitive primitive = Primitive.fromKeyword(typeName);
        if (primitive != null) {
            return primitive;
        }
        return Class.build(typeName);
    }

    public static enum Primitive implements JavaType
    {
        Boolean,
        Byte,
        Char,
        Double,
        Float,
        Int,
        Long,
        Short,
        Void,
        String,
        None,
        Wildcard,
        Null;


        public static Primitive fromKeyword(String keyword) {
            switch (keyword) {
                case "boolean": {
                    return Boolean;
                }
                case "byte": {
                    return Byte;
                }
                case "char": {
                    return Char;
                }
                case "double": {
                    return Double;
                }
                case "float": {
                    return Float;
                }
                case "int": {
                    return Int;
                }
                case "long": {
                    return Long;
                }
                case "short": {
                    return Short;
                }
                case "void": {
                    return Void;
                }
                case "String": {
                    return String;
                }
                case "": {
                    return None;
                }
                case "*": {
                    return Wildcard;
                }
                case "null": {
                    return Null;
                }
            }
            return null;
        }

        @JsonIgnore
        public String getKeyword() {
            switch (this) {
                case Boolean: {
                    return "boolean";
                }
                case Byte: {
                    return "byte";
                }
                case Char: {
                    return "char";
                }
                case Double: {
                    return "double";
                }
                case Float: {
                    return "float";
                }
                case Int: {
                    return "int";
                }
                case Long: {
                    return "long";
                }
                case Short: {
                    return "short";
                }
                case Void: {
                    return "void";
                }
                case String: {
                    return "String";
                }
                case Wildcard: {
                    return "*";
                }
                case Null: {
                    return "null";
                }
            }
            return "";
        }

        @Override
        public boolean deepEquals(JavaType type) {
            return this == type;
        }

        @Override
        public TypeTree toTypeTree() {
            return new J.Primitive(Tree.randomId(), this, Formatting.EMPTY);
        }

        public J.Literal toLiteral(String value) {
            Object primitiveValue;
            switch (this) {
                case Int: {
                    primitiveValue = Integer.parseInt(value);
                    break;
                }
                case Boolean: {
                    primitiveValue = java.lang.Boolean.parseBoolean(value);
                    break;
                }
                case Byte: 
                case Char: {
                    primitiveValue = "'" + (value.length() > 0 ? value.charAt(0) : (char)'\u0000') + "'";
                    break;
                }
                case Double: {
                    primitiveValue = java.lang.Double.parseDouble(value);
                    break;
                }
                case Float: {
                    primitiveValue = java.lang.Float.valueOf(java.lang.Float.parseFloat(value));
                    break;
                }
                case Long: {
                    primitiveValue = java.lang.Long.parseLong(value);
                    break;
                }
                case Short: {
                    primitiveValue = java.lang.Short.parseShort(value);
                    break;
                }
                case Null: {
                    primitiveValue = null;
                    break;
                }
                case String: {
                    primitiveValue = "\"" + value + "\"";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unable to build literals for void, none, and wildcards");
                }
            }
            return new J.Literal(Tree.randomId(), primitiveValue, value, this, Formatting.EMPTY);
        }
    }

    public static class Array
    implements JavaType {
        private final JavaType elemType;

        @Override
        public boolean deepEquals(JavaType type) {
            return type instanceof Array && this.elemType.deepEquals(((Array)type).elemType);
        }

        @Override
        public TypeTree toTypeTree() {
            return new J.ArrayType(Tree.randomId(), this.elemType.toTypeTree(), Collections.emptyList(), Formatting.EMPTY);
        }

        @ConstructorProperties(value={"elemType"})
        public Array(JavaType elemType) {
            this.elemType = elemType;
        }

        public JavaType getElemType() {
            return this.elemType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Array)) {
                return false;
            }
            Array other = (Array)o;
            if (!other.canEqual(this)) {
                return false;
            }
            JavaType this$elemType = this.getElemType();
            JavaType other$elemType = other.getElemType();
            return !(this$elemType == null ? other$elemType != null : !this$elemType.equals(other$elemType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Array;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JavaType $elemType = this.getElemType();
            result = result * 59 + ($elemType == null ? 43 : $elemType.hashCode());
            return result;
        }

        public String toString() {
            return "JavaType.Array(elemType=" + this.getElemType() + ")";
        }
    }

    public static class GenericTypeVariable
    extends FullyQualified {
        private final String fullyQualifiedName;
        @Nullable
        private final Class bound;

        @Override
        public boolean deepEquals(JavaType type) {
            if (!(type instanceof GenericTypeVariable)) {
                return false;
            }
            GenericTypeVariable generic = (GenericTypeVariable)type;
            return this.fullyQualifiedName.equals(generic.fullyQualifiedName) && TypeUtils.deepEquals(this.bound, generic.bound);
        }

        @Override
        public TypeTree toTypeTree() {
            throw new UnsupportedOperationException("Cannot build a type tree for a GenericTypeVariable");
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GenericTypeVariable)) {
                return false;
            }
            GenericTypeVariable other = (GenericTypeVariable)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fullyQualifiedName = this.getFullyQualifiedName();
            String other$fullyQualifiedName = other.getFullyQualifiedName();
            if (this$fullyQualifiedName == null ? other$fullyQualifiedName != null : !this$fullyQualifiedName.equals(other$fullyQualifiedName)) {
                return false;
            }
            Class this$bound = this.getBound();
            Class other$bound = other.getBound();
            return !(this$bound == null ? other$bound != null : !this$bound.equals(other$bound));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GenericTypeVariable;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fullyQualifiedName = this.getFullyQualifiedName();
            result = result * 59 + ($fullyQualifiedName == null ? 43 : $fullyQualifiedName.hashCode());
            Class $bound = this.getBound();
            result = result * 59 + ($bound == null ? 43 : $bound.hashCode());
            return result;
        }

        @ConstructorProperties(value={"fullyQualifiedName", "bound"})
        public GenericTypeVariable(String fullyQualifiedName, Class bound) {
            this.fullyQualifiedName = fullyQualifiedName;
            this.bound = bound;
        }

        @Override
        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public Class getBound() {
            return this.bound;
        }

        public String toString() {
            return "JavaType.GenericTypeVariable(fullyQualifiedName=" + this.getFullyQualifiedName() + ", bound=" + this.getBound() + ")";
        }
    }

    public static class Method
    implements JavaType {
        private static final Map<FullyQualified, Map<String, Set<Method>>> flyweights = HashObjObjMaps.newMutableMap();
        private final FullyQualified declaringType;
        private final String name;
        private final Signature genericSignature;
        private final Signature resolvedSignature;
        private final List<String> paramNames;
        private final Set<Flag> flags;

        private Method(FullyQualified declaringType, String name, Signature genericSignature, Signature resolvedSignature, List<String> paramNames, Set<Flag> flags) {
            this.declaringType = declaringType;
            this.name = name;
            this.genericSignature = genericSignature;
            this.resolvedSignature = resolvedSignature;
            this.paramNames = paramNames;
            this.flags = flags;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JsonCreator
        public static Method build(@JsonProperty(value="declaringType") FullyQualified declaringType, @JsonProperty(value="name") String name, @JsonProperty(value="genericSignature") Signature genericSignature, @JsonProperty(value="resolvedSignature") Signature resolvedSignature, @JsonProperty(value="paramNames") List<String> paramNames, @JsonProperty(value="flags") Set<Flag> flags) {
            Method test = new Method(declaringType, name, genericSignature, resolvedSignature, paramNames, flags);
            Map<FullyQualified, Map<String, Set<Method>>> map = flyweights;
            synchronized (map) {
                Set methods = flyweights.computeIfAbsent(declaringType, dt -> HashObjObjMaps.newMutableMap()).computeIfAbsent(name, n -> HashObjSets.newMutableSet());
                return methods.stream().filter(m -> m.deepEquals(test)).findAny().orElseGet(() -> {
                    methods.add(test);
                    return test;
                });
            }
        }

        private static boolean signatureDeepEquals(@Nullable Signature s1, @Nullable Signature s2) {
            return s1 == null ? s2 == null : s2 != null && TypeUtils.deepEquals(s1.returnType, s2.returnType) && TypeUtils.deepEquals(s1.paramTypes, s2.paramTypes);
        }

        public boolean hasFlags(Flag ... test) {
            return Arrays.stream(test).allMatch(this.flags::contains);
        }

        @Override
        public boolean deepEquals(JavaType type) {
            if (!(type instanceof Method)) {
                return false;
            }
            Method m = (Method)type;
            return this.paramNames.equals(m.paramNames) && this.flags.equals(m.flags) && this.declaringType.deepEquals(m.declaringType) && Method.signatureDeepEquals(this.genericSignature, m.genericSignature) && Method.signatureDeepEquals(this.resolvedSignature, m.resolvedSignature);
        }

        @Override
        public TypeTree toTypeTree() {
            throw new UnsupportedOperationException("Cannot build a type tree for a Method");
        }

        public FullyQualified getDeclaringType() {
            return this.declaringType;
        }

        public String getName() {
            return this.name;
        }

        public Signature getGenericSignature() {
            return this.genericSignature;
        }

        public Signature getResolvedSignature() {
            return this.resolvedSignature;
        }

        public List<String> getParamNames() {
            return this.paramNames;
        }

        public Set<Flag> getFlags() {
            return this.flags;
        }

        public Method withDeclaringType(FullyQualified declaringType) {
            return this.declaringType == declaringType ? this : new Method(declaringType, this.name, this.genericSignature, this.resolvedSignature, this.paramNames, this.flags);
        }

        public Method withFlags(Set<Flag> flags) {
            return this.flags == flags ? this : new Method(this.declaringType, this.name, this.genericSignature, this.resolvedSignature, this.paramNames, flags);
        }

        public static class Signature
        implements Serializable {
            @Nullable
            private final JavaType returnType;
            private final List<JavaType> paramTypes;

            @ConstructorProperties(value={"returnType", "paramTypes"})
            public Signature(JavaType returnType, List<JavaType> paramTypes) {
                this.returnType = returnType;
                this.paramTypes = paramTypes;
            }

            public JavaType getReturnType() {
                return this.returnType;
            }

            public List<JavaType> getParamTypes() {
                return this.paramTypes;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Signature)) {
                    return false;
                }
                Signature other = (Signature)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                JavaType this$returnType = this.getReturnType();
                JavaType other$returnType = other.getReturnType();
                if (this$returnType == null ? other$returnType != null : !this$returnType.equals(other$returnType)) {
                    return false;
                }
                List<JavaType> this$paramTypes = this.getParamTypes();
                List<JavaType> other$paramTypes = other.getParamTypes();
                return !(this$paramTypes == null ? other$paramTypes != null : !((Object)this$paramTypes).equals(other$paramTypes));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Signature;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                JavaType $returnType = this.getReturnType();
                result = result * 59 + ($returnType == null ? 43 : $returnType.hashCode());
                List<JavaType> $paramTypes = this.getParamTypes();
                result = result * 59 + ($paramTypes == null ? 43 : ((Object)$paramTypes).hashCode());
                return result;
            }

            public String toString() {
                return "JavaType.Method.Signature(returnType=" + this.getReturnType() + ", paramTypes=" + this.getParamTypes() + ")";
            }
        }
    }

    public static class Var
    implements JavaType {
        private final String name;
        @Nullable
        private final JavaType type;
        private final Set<Flag> flags;

        public boolean hasFlags(Flag ... test) {
            return Arrays.stream(test).allMatch(this.flags::contains);
        }

        @Override
        public boolean deepEquals(@Nullable JavaType type) {
            if (!(type instanceof Var)) {
                return false;
            }
            Var v = (Var)type;
            return this.name.equals(v.name) && TypeUtils.deepEquals(this.type, v.type) && this.flags.equals(v.flags);
        }

        @Override
        public TypeTree toTypeTree() {
            return this.type == null ? null : this.type.toTypeTree();
        }

        @ConstructorProperties(value={"name", "type", "flags"})
        public Var(String name, JavaType type, Set<Flag> flags) {
            this.name = name;
            this.type = type;
            this.flags = flags;
        }

        public String getName() {
            return this.name;
        }

        public JavaType getType() {
            return this.type;
        }

        public Set<Flag> getFlags() {
            return this.flags;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Var)) {
                return false;
            }
            Var other = (Var)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            JavaType this$type = this.getType();
            JavaType other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Set<Flag> this$flags = this.getFlags();
            Set<Flag> other$flags = other.getFlags();
            return !(this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Var;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            JavaType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Set<Flag> $flags = this.getFlags();
            result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
            return result;
        }

        public String toString() {
            return "JavaType.Var(name=" + this.getName() + ", type=" + this.getType() + ", flags=" + this.getFlags() + ")";
        }
    }

    public static class Cyclic
    extends FullyQualified {
        private final String fullyQualifiedName;

        @Override
        public boolean deepEquals(JavaType type) {
            return this.equals(type);
        }

        public String toString() {
            return "Cyclic{" + this.fullyQualifiedName + '}';
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cyclic)) {
                return false;
            }
            Cyclic other = (Cyclic)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fullyQualifiedName = this.getFullyQualifiedName();
            String other$fullyQualifiedName = other.getFullyQualifiedName();
            return !(this$fullyQualifiedName == null ? other$fullyQualifiedName != null : !this$fullyQualifiedName.equals(other$fullyQualifiedName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Cyclic;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fullyQualifiedName = this.getFullyQualifiedName();
            result = result * 59 + ($fullyQualifiedName == null ? 43 : $fullyQualifiedName.hashCode());
            return result;
        }

        @ConstructorProperties(value={"fullyQualifiedName"})
        public Cyclic(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        @Override
        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }
    }

    public static class Class
    extends FullyQualified {
        private static final Map<String, HashObjSet<Class>> flyweights = HashObjObjMaps.newMutableMap();
        public static final Class OBJECT = Class.build("java.lang.Object");
        private final String fullyQualifiedName;
        private final List<Var> members;
        private final List<JavaType> typeParameters;
        private final List<JavaType> interfaces;
        @Nullable
        private volatile List<Method> constructors;
        @Nullable
        private final Class supertype;

        private Class(String fullyQualifiedName, List<Var> members, List<JavaType> typeParameters, List<JavaType> interfaces, @Nullable List<Method> constructors, @Nullable Class supertype) {
            this.fullyQualifiedName = fullyQualifiedName;
            this.members = members;
            this.typeParameters = typeParameters;
            this.interfaces = interfaces;
            this.constructors = constructors;
            this.supertype = supertype;
        }

        public static Class build(String fullyQualifiedName) {
            return Class.build(fullyQualifiedName, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true);
        }

        @JsonCreator
        public static Class build(@JsonProperty(value="fullyQualifiedName") String fullyQualifiedName, @JsonProperty(value="members") List<Var> members, @JsonProperty(value="typeParameters") List<JavaType> typeParameters, @JsonProperty(value="interfaces") List<JavaType> interfaces, @JsonProperty(value="constructors") List<Method> constructors, @JsonProperty(value="supertype") @Nullable Class supertype) {
            return Class.build(fullyQualifiedName, members, typeParameters, interfaces, constructors, supertype, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Class build(String fullyQualifiedName, List<Var> members, List<JavaType> typeParameters, List<JavaType> interfaces, @Nullable List<Method> constructors, @Nullable Class supertype, boolean relaxedClassTypeMatching) {
            Class test = new Class(fullyQualifiedName, members.stream().sorted(Comparator.comparing(Var::getName)).collect(Collectors.toList()), typeParameters, interfaces, constructors, supertype);
            Map<String, HashObjSet<Class>> map = flyweights;
            synchronized (map) {
                Set variants = (Set)flyweights.computeIfAbsent(fullyQualifiedName, fqn -> HashObjSets.newMutableSet());
                if (relaxedClassTypeMatching) {
                    return variants.stream().findFirst().orElseGet(() -> {
                        variants.add(test);
                        return test;
                    });
                }
                return variants.stream().filter(v -> v.deepEquals(test)).findFirst().orElseGet(() -> {
                    if (test.supertype == null) {
                        return variants.stream().findFirst().orElseGet(() -> {
                            variants.add(test);
                            return test;
                        });
                    }
                    variants.add(test);
                    return test;
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Method> getConstructors() {
            if (this.constructors != null) {
                return this.constructors;
            }
            Map<String, HashObjSet<Class>> map = flyweights;
            synchronized (map) {
                ArrayList<Method> reflectedConstructors = new ArrayList<Method>();
                try {
                    java.lang.Class<?> reflectionClass = java.lang.Class.forName(this.fullyQualifiedName, false, JavaType.class.getClassLoader());
                    for (Constructor<?> constructor : reflectionClass.getConstructors()) {
                        ShallowClass selfType = new ShallowClass(this.fullyQualifiedName);
                        Method.Signature resolvedSignature = new Method.Signature(selfType, Arrays.stream(constructor.getParameterTypes()).map(pt -> Class.build(pt.getName())).collect(Collectors.toList()));
                        List<String> parameterNames = Arrays.stream(constructor.getParameters()).map(Parameter::getName).collect(Collectors.toList());
                        reflectedConstructors.add(Method.build(selfType, "<reflection_constructor>", resolvedSignature, resolvedSignature, parameterNames, Collections.singleton(Flag.Public)));
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                return reflectedConstructors;
            }
        }

        @JsonIgnore
        public List<Var> getVisibleSupertypeMembers() {
            ArrayList<Var> members = new ArrayList<Var>();
            if (this.supertype != null) {
                this.supertype.getMembers().stream().filter(member -> !member.hasFlags(Flag.Private)).forEach(members::add);
                members.addAll(this.supertype.getVisibleSupertypeMembers());
            }
            return members;
        }

        @Override
        public boolean deepEquals(@Nullable JavaType type) {
            if (!(type instanceof Class)) {
                return false;
            }
            Class c = (Class)type;
            return this.fullyQualifiedName.equals(c.fullyQualifiedName) && TypeUtils.deepEquals(this.members, c.members) && TypeUtils.deepEquals(this.supertype, c.supertype) && TypeUtils.deepEquals(this.typeParameters, c.typeParameters);
        }

        public String toString() {
            return "Class{" + this.fullyQualifiedName + '}';
        }

        @Override
        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public List<Var> getMembers() {
            return this.members;
        }

        public List<JavaType> getTypeParameters() {
            return this.typeParameters;
        }

        public List<JavaType> getInterfaces() {
            return this.interfaces;
        }

        public Class getSupertype() {
            return this.supertype;
        }
    }

    public static class ShallowClass
    extends FullyQualified {
        private final String fullyQualifiedName;

        @Override
        public boolean deepEquals(JavaType type) {
            return type instanceof ShallowClass && this.fullyQualifiedName.equals(((ShallowClass)type).fullyQualifiedName);
        }

        public String toString() {
            return "ShallowClass{125";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShallowClass)) {
                return false;
            }
            ShallowClass other = (ShallowClass)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fullyQualifiedName = this.getFullyQualifiedName();
            String other$fullyQualifiedName = other.getFullyQualifiedName();
            return !(this$fullyQualifiedName == null ? other$fullyQualifiedName != null : !this$fullyQualifiedName.equals(other$fullyQualifiedName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ShallowClass;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fullyQualifiedName = this.getFullyQualifiedName();
            result = result * 59 + ($fullyQualifiedName == null ? 43 : $fullyQualifiedName.hashCode());
            return result;
        }

        @ConstructorProperties(value={"fullyQualifiedName"})
        public ShallowClass(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        @Override
        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }
    }

    public static abstract class FullyQualified
    implements JavaType {
        public abstract String getFullyQualifiedName();

        @Override
        public TypeTree toTypeTree() {
            return (TypeTree)((Expression)TreeBuilder.buildName(this.getFullyQualifiedName())).withType(Class.build(this.getFullyQualifiedName()));
        }

        @JsonIgnore
        public String getClassName() {
            AtomicBoolean dropWhile = new AtomicBoolean(false);
            return Arrays.stream(this.getFullyQualifiedName().split("\\.")).filter(part -> {
                dropWhile.set(dropWhile.get() || !Character.isLowerCase(part.charAt(0)));
                return dropWhile.get();
            }).collect(Collectors.joining("."));
        }

        @JsonIgnore
        public String getPackageName() {
            AtomicBoolean takeWhile = new AtomicBoolean(true);
            return Arrays.stream(this.getFullyQualifiedName().split("\\.")).filter(part -> {
                takeWhile.set(takeWhile.get() && !Character.isUpperCase(part.charAt(0)));
                return takeWhile.get();
            }).collect(Collectors.joining("."));
        }

        @JsonIgnore
        public boolean isAssignableFrom(@Nullable Class clazz) {
            return clazz != null && (this == Class.OBJECT || this.getFullyQualifiedName().equals(clazz.fullyQualifiedName) || this.isAssignableFrom(clazz.getSupertype()) || clazz.getInterfaces().stream().anyMatch(i -> i instanceof Class && this.isAssignableFrom((Class)i)));
        }
    }

    public static class MultiCatch
    implements JavaType {
        private final List<JavaType> throwableTypes;

        @Override
        public boolean deepEquals(@Nullable JavaType type) {
            return type instanceof MultiCatch && TypeUtils.deepEquals(this.throwableTypes, ((MultiCatch)type).throwableTypes);
        }

        @Override
        public TypeTree toTypeTree() {
            return new J.MultiCatch(Tree.randomId(), this.throwableTypes.stream().map(JavaType::toTypeTree).collect(Collectors.toList()), Formatting.EMPTY);
        }

        @ConstructorProperties(value={"throwableTypes"})
        public MultiCatch(List<JavaType> throwableTypes) {
            this.throwableTypes = throwableTypes;
        }

        public List<JavaType> getThrowableTypes() {
            return this.throwableTypes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiCatch)) {
                return false;
            }
            MultiCatch other = (MultiCatch)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<JavaType> this$throwableTypes = this.getThrowableTypes();
            List<JavaType> other$throwableTypes = other.getThrowableTypes();
            return !(this$throwableTypes == null ? other$throwableTypes != null : !((Object)this$throwableTypes).equals(other$throwableTypes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MultiCatch;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<JavaType> $throwableTypes = this.getThrowableTypes();
            result = result * 59 + ($throwableTypes == null ? 43 : ((Object)$throwableTypes).hashCode());
            return result;
        }

        public String toString() {
            return "JavaType.MultiCatch(throwableTypes=" + this.getThrowableTypes() + ")";
        }
    }
}

