/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.AutoFormat;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TreeBuilder;
import org.openrewrite.java.tree.TypeUtils;

public class GenerateGetter
extends JavaRefactorVisitor {
    private JavaType.Class type;
    private String field;

    public void setType(String enclosingClassType) {
        this.type = JavaType.Class.build(enclosingClassType);
    }

    public void setField(String field) {
        this.field = field;
    }

    public Validated validate() {
        return Validated.required((String)"type", (Object)this.type).and(Validated.required((String)"field", (Object)this.field));
    }

    @Override
    public J visitClassDecl(J.ClassDecl classDecl) {
        if (TypeUtils.isOfClassType(classDecl.getType(), this.type.getFullyQualifiedName())) {
            classDecl.getFields().stream().filter(field -> field.getVars().stream().anyMatch(var -> this.field.equals(var.getSimpleName()))).findAny().ifPresent(field -> {
                MethodMatcher getterMatcher = new MethodMatcher(this.type.getFullyQualifiedName() + " get" + StringUtils.capitalize((String)this.field) + "()");
                boolean getterAlreadyExists = classDecl.getMethods().stream().anyMatch(it -> getterMatcher.matches((J.MethodDecl)it, classDecl));
                if (!getterAlreadyExists) {
                    this.andThen((RefactorVisitor)new Scoped((J.VariableDecls)field));
                }
            });
        }
        return super.visitClassDecl(classDecl);
    }

    public static class Scoped
    extends JavaRefactorVisitor {
        private final J.VariableDecls field;

        public Scoped(J.VariableDecls field) {
            this.setCursoringOn();
            this.field = field;
        }

        @Override
        public J visitClassDecl(J.ClassDecl classDecl) {
            J.ClassDecl cd = (J.ClassDecl)this.refactor(classDecl, x$0 -> super.visitClassDecl((J.ClassDecl)x$0));
            for (int i = 0; i < cd.getFields().size(); ++i) {
                if (!this.field.isScope(cd.getFields().get(i))) continue;
                J.CompilationUnit cu = (J.CompilationUnit)this.getCursor().firstEnclosing(J.CompilationUnit.class);
                assert (cu != null);
                Object jp = ((JavaParser.Builder)JavaParser.fromJavaVersion().styles(cu.getStyles())).build();
                J.VariableDecls.NamedVar fieldVar = this.field.getVars().get(0);
                String fieldName = fieldVar.getSimpleName();
                assert (fieldVar.getType() != null);
                JavaType.FullyQualified type = TypeUtils.asFullyQualified(fieldVar.getType());
                assert (this.field.getTypeExpr() != null);
                J.MethodDecl getMethod = TreeBuilder.buildMethodDeclaration(jp, classDecl, "public " + this.field.getTypeExpr().print().trim() + " get" + StringUtils.capitalize((String)fieldName) + "() {\n    return " + fieldName + ";\n}\n", new JavaType[]{type});
                this.andThen((RefactorVisitor)new AutoFormat(getMethod));
                J.Block<J> body = cd.getBody();
                ArrayList<J> statements = new ArrayList<J>(body.getStatements());
                statements.add(i + 1, getMethod);
                cd = cd.withBody(body.withStatements(statements));
                break;
            }
            return cd;
        }
    }
}

