/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.Parser;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaStyle;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.style.TabAndIndentStyle;
import org.openrewrite.java.tree.J;

public interface JavaParser
extends Parser<J.CompilationUnit> {
    public static List<Path> dependenciesFromClasspath(String ... artifactNames) {
        List artifactNamePatterns = Arrays.stream(artifactNames).map(name -> Pattern.compile(name + "-.*?\\.jar$")).collect(Collectors.toList());
        return Arrays.stream(System.getProperty("java.class.path").split("\\Q" + System.getProperty("path.separator") + "\\E")).filter(cpEntry -> artifactNamePatterns.stream().anyMatch(namePattern -> namePattern.matcher((CharSequence)cpEntry).find())).map(cpEntry -> new File((String)cpEntry).toPath()).collect(Collectors.toList());
    }

    public static Builder<? extends JavaParser, ?> fromJavaVersion() {
        Builder javaParser;
        try {
            javaParser = System.getProperty("java.version").startsWith("1.8") ? (Builder)Class.forName("org.openrewrite.java.Java8Parser").getDeclaredMethod("builder", new Class[0]).invoke(null, new Object[0]) : (Builder)Class.forName("org.openrewrite.java.Java11Parser").getDeclaredMethod("builder", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create a Java parser instance. `rewrite-java-8` or `rewrite-java-11` must be on the classpath.");
        }
        return javaParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public List<J.CompilationUnit> parse(List<String> sources) {
        Path temp = Files.createTempDirectory("sources", new FileAttribute[0]);
        Pattern classPattern = Pattern.compile("(class|interface|enum)\\s*(<[^>]*>)?\\s+(\\w+)");
        Function<String, String> simpleName = sourceStr -> {
            Matcher classMatcher = classPattern.matcher((CharSequence)sourceStr);
            return classMatcher.find() ? classMatcher.group(3) : null;
        };
        Function<String, Path> sourceFile = sourceText -> {
            Path file = temp.resolve((String)simpleName.apply((String)sourceText) + ".java");
            try {
                Files.write(file, sourceText.getBytes(Charset.defaultCharset()), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return file;
        };
        try {
            List list = this.parse(sources.stream().map(sourceFile).collect(Collectors.toList()), null);
            Files.walk(temp, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            return list;
        }
        catch (Throwable throwable) {
            try {
                Files.walk(temp, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public JavaParser reset();

    public static abstract class Builder<P extends JavaParser, B extends Builder<P, B>> {
        @Nullable
        protected List<Path> classpath;
        protected Charset charset = Charset.defaultCharset();
        protected boolean relaxedClassTypeMatching = false;
        protected MeterRegistry meterRegistry = Metrics.globalRegistry;
        protected boolean logCompilationWarningsAndErrors = true;
        protected List<JavaStyle> styles = new ArrayList<JavaStyle>();

        public B logCompilationWarningsAndErrors(boolean logCompilationWarningsAndErrors) {
            this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
            return (B)this;
        }

        public B meterRegistry(MeterRegistry registry) {
            this.meterRegistry = registry;
            return (B)this;
        }

        public B charset(Charset charset) {
            this.charset = charset;
            return (B)this;
        }

        public B relaxedClassTypeMatching(boolean relaxedClassTypeMatching) {
            this.relaxedClassTypeMatching = relaxedClassTypeMatching;
            return (B)this;
        }

        public B classpath(List<Path> classpath) {
            this.classpath = classpath;
            return (B)this;
        }

        public B classpath(String ... classpath) {
            this.classpath = JavaParser.dependenciesFromClasspath(classpath);
            return (B)this;
        }

        public B importStyle(@Nullable ImportLayoutStyle importStyle) {
            if (importStyle != null) {
                this.styles.add(importStyle);
            }
            return (B)this;
        }

        public B tabAndIndentStyle(TabAndIndentStyle tabAndIndentStyle) {
            this.styles.add(tabAndIndentStyle);
            return (B)this;
        }

        public abstract P build();
    }
}

