/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class DeleteMethodArgument
extends JavaRefactorVisitor {
    private MethodMatcher methodMatcher;
    private Integer index;

    public boolean isIdempotent() {
        return false;
    }

    public void setMethod(String method) {
        this.methodMatcher = new MethodMatcher(method);
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public Validated validate() {
        return Validated.required((String)"method", (Object)this.methodMatcher).and(Validated.required((String)"index", (Object)this.index));
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method) {
        if (this.methodMatcher.matches(method)) {
            this.andThen((RefactorVisitor)new Scoped(method, this.index));
        }
        return super.visitMethodInvocation(method);
    }

    public static class Scoped
    extends JavaRefactorVisitor {
        private final J.MethodInvocation scope;
        private final int index;

        public Scoped(J.MethodInvocation scope, int index) {
            this.scope = scope;
            this.index = index;
        }

        public boolean isIdempotent() {
            return false;
        }

        @Override
        public J visitMethodInvocation(J.MethodInvocation method) {
            List<Expression> originalArgs = method.getArgs().getArgs();
            if (this.scope.isScope(method) && originalArgs.stream().filter(a -> !(a instanceof J.Empty)).count() >= (long)(this.index + 1)) {
                List<Expression> args = new ArrayList<Expression>(method.getArgs().getArgs());
                args.remove(this.index);
                if (args.isEmpty()) {
                    args = Collections.singletonList(new J.Empty(Tree.randomId(), Formatting.EMPTY));
                }
                return method.withArgs(method.getArgs().withArgs(args));
            }
            return super.visitMethodInvocation(method);
        }
    }
}

