/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaSourceVisitor;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TypeUtils;

public class FindType
extends JavaSourceVisitor<Set<NameTree>> {
    private final String clazz;

    public FindType(String clazz) {
        this.clazz = clazz;
    }

    public Iterable<Tag> getTags() {
        return Tags.of((String)"type", (String)this.clazz);
    }

    public Set<NameTree> defaultTo(Tree t) {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    public Set<NameTree> reduce(Set<NameTree> r1, Set<NameTree> r2) {
        r1.addAll(r2);
        return r1;
    }

    @Override
    public Set<NameTree> visitTypeName(NameTree name) {
        JavaType.Class asClass = TypeUtils.asClass(name.getType());
        if (asClass != null && asClass.getFullyQualifiedName().equals(this.clazz)) {
            Object names = this.defaultTo(name);
            names.add(name);
            return names;
        }
        return (Set)super.visitTypeName(name);
    }
}

