/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.refactor;

import java.util.ArrayList;
import java.util.Collections;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.java.refactor.JavaRefactorVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;

public class ImplementInterface
extends JavaRefactorVisitor {
    private final J.ClassDecl scope;
    private final String interfaze;
    private final JavaType.Class interfaceType;

    public ImplementInterface(J.ClassDecl scope, String interfaze) {
        super("java.ImplementInterface", "from", interfaze);
        this.scope = scope;
        this.interfaze = interfaze;
        this.interfaceType = JavaType.Class.build(interfaze);
    }

    @Override
    public J visitClassDecl(J.ClassDecl classDecl) {
        J.ClassDecl c = (J.ClassDecl)this.refactor(classDecl, x$0 -> super.visitClassDecl((J.ClassDecl)x$0));
        if (this.scope.isScope(classDecl) && (classDecl.getImplements() == null || classDecl.getImplements().getFrom().stream().noneMatch(f -> this.interfaceType.equals(f.getType())))) {
            this.maybeAddImport(this.interfaze);
            J.Ident lifeCycle = J.Ident.buildClassName(this.interfaze).withFormatting(Formatting.format((String)" "));
            if (c.getImplements() == null) {
                c = c.withImplements(new J.ClassDecl.Implements(Tree.randomId(), Collections.singletonList(lifeCycle), Formatting.format((String)" ")));
            } else {
                ArrayList<TypeTree> implementings = new ArrayList<TypeTree>(c.getImplements().getFrom());
                implementings.add(0, lifeCycle);
                c = c.withImplements(c.getImplements().withFrom(implementings));
            }
        }
        return c;
    }
}

