/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.refactor;

import java.util.ArrayList;
import java.util.Collections;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.java.refactor.ScopedJavaRefactorVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TypeTree;

public class ImplementInterface
extends ScopedJavaRefactorVisitor {
    private final String interfaze;

    public ImplementInterface(J.ClassDecl scope, String interfaze) {
        super(scope.getId());
        this.interfaze = interfaze;
    }

    @Override
    public J visitClassDecl(J.ClassDecl classDecl) {
        J.ClassDecl c = (J.ClassDecl)this.refactor(classDecl, x$0 -> super.visitClassDecl((J.ClassDecl)x$0));
        if (classDecl.getId().equals(this.getScope())) {
            this.maybeAddImport(this.interfaze);
            J.Ident lifeCycle = J.Ident.buildClassName(this.interfaze).withFormatting(Formatting.format((String)" "));
            if (c.getImplements() == null) {
                c = c.withImplements(new J.ClassDecl.Implements(Tree.randomId(), Collections.singletonList(lifeCycle), Formatting.format((String)" ")));
            } else {
                ArrayList<TypeTree> implementings = new ArrayList<TypeTree>(c.getImplements().getFrom());
                implementings.add(0, lifeCycle);
                c = c.withImplements(c.getImplements().withFrom(implementings));
            }
        }
        return c;
    }
}

