/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.junit.jupiter.api.Test;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;

class TypeUtilsTest
implements RewriteTest {
    TypeUtilsTest() {
    }

    static Consumer<SourceSpec<J.CompilationUnit>> typeIsPresent() {
        return s -> s.afterRecipe(cu -> {
            JavaType.Method fooMethodType = ((J.MethodDeclaration)((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0)).getMethodType();
            org.assertj.core.api.Assertions.assertThat((Optional)TypeUtils.findOverriddenMethod((JavaType.Method)fooMethodType)).isPresent();
        });
    }

    @Test
    void isOverrideBasicInterface() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"interface Interface {\n    void foo();\n}\n"), Assertions.java((String)"class Clazz implements Interface {\n    @Override void foo() { }\n}\n", TypeUtilsTest.typeIsPresent())});
    }

    @Test
    void isOverrideBasicInheritance() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Superclass {\n    void foo() { }\n}\n"), Assertions.java((String)"class Clazz extends Superclass {\n    @Override void foo() { }\n}\n", TypeUtilsTest.typeIsPresent())});
    }

    @Test
    void isOverrideOnlyVisible() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"package foo;\npublic class Superclass {\n    void foo() { }\n}\n"), Assertions.java((String)"package bar;\nimport foo.Superclass;\nclass Clazz extends Superclass {\n    public void foo() { }\n}\n", s -> s.afterRecipe(cu -> {
            JavaType.Method fooMethodType = ((J.MethodDeclaration)((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0)).getMethodType();
            org.assertj.core.api.Assertions.assertThat((Optional)TypeUtils.findOverriddenMethod((JavaType.Method)fooMethodType)).isEmpty();
        }))});
    }

    @Test
    void isOverrideParameterizedInterface() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.Comparator;\n\nclass TestComparator implements Comparator<String> {\n    @Override public int compare(String o1, String o2) {\n        return 0;\n    }\n}\n", TypeUtilsTest.typeIsPresent())});
    }

    @Test
    void isOverrideParameterizedMethod() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"interface Interface {\n    <T> void foo(T t);\n}\n"), Assertions.java((String)"class Clazz implements Interface {\n    @Override <T> void foo(T t) { }\n}\n", TypeUtilsTest.typeIsPresent())});
    }

    @Test
    void isOverrideConsidersTypeParameterPositions() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"interface Interface <T, Y> {\n     void foo(Y y, T t);\n}\n"), Assertions.java((String)"class Clazz implements Interface<Integer, String> {\n    void foo(Integer t, String y) { }\n\n    @Override\n    void foo(String y, Integer t) { }\n}\n", s -> s.afterRecipe(cu -> {
            List methods = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements();
            org.assertj.core.api.Assertions.assertThat((Optional)TypeUtils.findOverriddenMethod((JavaType.Method)((J.MethodDeclaration)methods.get(0)).getMethodType())).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Optional)TypeUtils.findOverriddenMethod((JavaType.Method)((J.MethodDeclaration)methods.get(1)).getMethodType())).isPresent();
        }))});
    }

    @Test
    void isFullyQualifiedOfType() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    Integer integer1;\n    Integer integer2;\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(){

            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Object o) {
                org.assertj.core.api.Assertions.assertThat((Object)variable.getVariableType().getType()).isInstanceOf(JavaType.Class.class);
                return super.visitVariable(variable, o);
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    void isParameterizedTypeOfType() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    java.util.List<Integer> integer;\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(){

            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Object o) {
                JavaType type = variable.getVariableType().getType();
                org.assertj.core.api.Assertions.assertThat((Object)type).isInstanceOf(JavaType.Parameterized.class);
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((String)"java.util.List", (JavaType)type)).isTrue();
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((String)"java.util.List<java.lang.Integer>", (JavaType)type)).isTrue();
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((String)"java.util.List<java.lang.String>", (JavaType)type)).isFalse();
                return super.visitVariable(variable, o);
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    void isParameterizedTypeWithShallowClassesOfType() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    java.util.List<Integer> integer1;\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(){

            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Object o) {
                JavaType varType = variable.getVariableType().getType();
                org.assertj.core.api.Assertions.assertThat((Object)varType).isInstanceOf(JavaType.Parameterized.class);
                JavaType.Parameterized shallowParameterizedType = new JavaType.Parameterized(null, (JavaType.FullyQualified)JavaType.ShallowClass.build((String)"java.util.List"), Collections.singletonList(JavaType.ShallowClass.build((String)"java.lang.Integer")));
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isOfType((JavaType)varType, (JavaType)shallowParameterizedType)).isTrue();
                return super.visitVariable(variable, o);
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    void isAssignableToGenericTypeVariable() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.Map;\nimport java.util.function.Supplier;\n\nclass Test {\n    <K, V> void m(Supplier<? extends Map<K, ? extends V>> map) {\n    }\n    void foo() {\n        Map<String, Integer> map = null;\n        m(() -> map);\n    }\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, Object o) {
                JavaType paramType = (JavaType)method.getMethodType().getParameterTypes().get(0);
                org.assertj.core.api.Assertions.assertThat((Object)paramType).isInstanceOf(JavaType.Parameterized.class);
                JavaType argType = ((Expression)method.getArguments().get(0)).getType();
                org.assertj.core.api.Assertions.assertThat((Object)argType).isInstanceOf(JavaType.Parameterized.class);
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)paramType, (JavaType)argType)).isTrue();
                return method;
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }
}

