/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import org.junit.jupiter.api.Test;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.MinimumJava17;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@MinimumJava17
class RecordTest
implements RewriteTest {
    RecordTest() {
    }

    @Test
    void emptyRecord() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public record JavaRecord() {\n}\n")});
    }

    @Test
    void javaRecord() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public record JavaRecord(String name, @jdk.jfr.Name(\"A\") @Deprecated int age) {\n}\n")});
    }

    @Test
    void typeParameterAnnotation() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n\nimport static java.lang.annotation.ElementType.*;\n\n@Retention(RetentionPolicy.RUNTIME)\n@Target(PARAMETER)\npublic @interface A {\n    String value() default \"\";\n}\n"), Assertions.java((String)"record JavaRecord(@jdk.jfr.Name(\"A\") @A(\"one value\") String name) {\n}\n")});
    }

    @Test
    void differentLiteralTypesAnnotation() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n\nimport static java.lang.annotation.ElementType.*;\n\n@Retention(RetentionPolicy.RUNTIME)\n@Target({PARAMETER})\npublic @interface A {\n    String value() default \"\";\n    Long a() default 0L;\n    int b() default 0;\n}\n"), Assertions.java((String)"record JavaRecord(@jdk.jfr.Name(\"A\") @A(value = \"\"\"\n    one value \"with a quote\" and\n    another value\n    \"\"\", a=2_000L, b=123) String name) {\n}\n")});
    }

    @Test
    void compactConstructor() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public record JavaRecord(String name, @Deprecated int age) {\n    public JavaRecord {\n        java.util.Objects.requireNonNull(name);\n    }\n}\n")});
    }

    @Test
    void annotationsAndRecords() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n\n@Retention(RetentionPolicy.RUNTIME)\n@Target({ElementType.RECORD_COMPONENT})\n@interface Select {\n    String value() default \"\";\n}\n\npublic record File(@Select(\"native\") String value) {\n}\n")});
    }

    @Test
    void recordWithMultipleAnnotations() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n\n@Retention(RetentionPolicy.RUNTIME)\n@Target({ElementType.RECORD_COMPONENT})\n@interface A {\n    String value() default \"\";\n}\n\n@Retention(RetentionPolicy.RUNTIME)\n@Target({ElementType.RECORD_COMPONENT})\n@interface B {\n    String value() default \"\";\n}\n\npublic record File(@A(\"a\") @B(\"b\") String value) {\n}\n")});
    }
}

