/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import org.junit.jupiter.api.Test;
import org.openrewrite.java.Assertions;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

class TypeParameterAndWildcardTest
implements RewriteTest {
    TypeParameterAndWildcardTest() {
    }

    @Test
    void annotatedTypeParametersOnWildcardBounds() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.List;\ninterface B {}\nclass A {\n    List<? extends @NotNull B> checks;\n}\n")});
    }

    @Test
    void annotatedTypeParametersOnReturnTypeExpression() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.List;\ninterface B {}\nclass A {\n    public List<\n        @NotNull(groups = Prioritized.P1.class)\n        @javax.validation.Valid\n        B> foo() {\n        return null;\n    }\n}\n")});
    }

    @Test
    void extendsAndSuper() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.List;\ninterface B {}\ninterface C {}\npublic class A {\n    public <P  extends B> void foo(List<P> out, List<? super C> in) {}\n}\n")});
    }

    @Test
    void multipleExtends() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"interface B {}\ninterface C {}\npublic class A< T extends  B & C > {}\n")});
    }

    @Test
    void wildcardExtends() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.*;\ninterface B {}\npublic class A {\n    List< ?  extends  B > bs;\n}\n")});
    }

    @Test
    void emptyWildcard() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.*;\npublic class A {\n    List< ? > a;\n}\n")});
    }
}

