/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import org.junit.jupiter.api.Test;
import org.openrewrite.DocumentExample;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

class LiteralTest
implements RewriteTest {
    LiteralTest() {
    }

    @DocumentExample
    @Test
    void nullableStringIsNull() {
        this.rewriteRun(spec -> spec.recipe((Recipe)RewriteTest.toRecipe(() -> new JavaIsoVisitor<ExecutionContext>(this){

            public J.Literal visitLiteral(J.Literal literal, ExecutionContext ctx) {
                org.assertj.core.api.Assertions.assertThat((boolean)J.Literal.isLiteralValue((Expression)literal, null)).isTrue();
                return (J.Literal)SearchResult.found((Tree)literal);
            }
        })), new SourceSpecs[]{Assertions.java((String)"class Test {\n    String s = null;\n}\n", (String)"class Test {\n    String s = /*~~>*/null;\n}\n")});
    }

    @Test
    void intentionallyBadUnicodeCharacter() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    void test() {\n        String[] strings = new String[] { \"\\\\u{U1}\", \"\\\\u1234\", \"\\\\u{00AUF}\" };\n    }\n}\n")});
    }

    @Test
    void literalField() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    int n = 0;\n}\n")});
    }

    @Test
    void literalCharacter() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    char c = 'a';\n}\n")});
    }

    @Test
    void literalNumerics() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    double d1 = 1.0d;\n    double d2 = 1.0;\n    long l1 = 1L;\n    long l2 = 1;\n}\n")});
    }

    @Test
    void literalOctal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    long l = 01L;\n    byte b = 01;\n    short s = 01;\n    int i = 01;\n    double d = 01;\n    float f = 01;\n}\n")});
    }

    @Test
    void literalBinary() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    long l = 0b10L;\n    byte b = 0b10;\n    short s = 0b10;\n    int i = 0b10;\n}\n")});
    }

    @Test
    void literalHex() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    long l = 0xA0L;\n    byte b = 0xA0;\n    short s = 0xA0;\n    int i = 0xA0;\n}\n")});
    }

    @Test
    void unmatchedSurrogatePair() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    char c1 = '\ud800';\n    char c2 = '\udfff';\n}\n")});
    }

    @Test
    void unmatchedSurrogatePairInString() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    String s1 = \"\ud800\";\n    String s2 = \"\udfff\";\n}\n")});
    }

    @Test
    void multipleUnicodeEscapeCharactersAtValueSourceIndex() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    String s1 = \"A\ud83c\udf09\";\n    String s2 = \"B\ud83c\udf09\ud83c\udf09\";\n    String s3 = \"C\udfff D \ud83c\udf09\ud83c\udf09\";\n}\n")});
    }

    @Test
    void transformString() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    String s = \"foo ''\";\n}\n")});
    }

    @Test
    void nullLiteral() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    String s = null;\n}\n")});
    }

    @Test
    void transformLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    Long l = 2L;\n}\n")});
    }

    @Test
    void variationInSuffixCasing() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    Long l = 0l;\n    Long m = 0L;\n}\n")});
    }

    @Test
    void escapedString() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    String s = \"\\t\t\\n\";\n}\n")});
    }

    @Test
    void escapedCharacter() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    char c = '\\'';\n    char tab = '\t';\n}\n")});
    }
}

