/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.Objects;
import java.util.Optional;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MinimumJava11;
import org.openrewrite.java.MinimumJava17;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.JavaVarKeyword;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;
import org.openrewrite.test.TypeValidation;

class VariableDeclarationsTest
implements RewriteTest {
    VariableDeclarationsTest() {
    }

    @Test
    void generic() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.Collections;\nimport java.util.ArrayList;\n\nclass Test {\n    void test() {\n        ArrayList<String> categories = new ArrayList<>();\n        Collections.sort(categories);\n    }\n}\n")});
    }

    @Test
    void fieldDefinition() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    public String a = \"\";\n}\n")});
    }

    @Test
    @MinimumJava11
    void finalVar() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    void test() {\n        final var a = \"\";\n    }\n}\n")});
    }

    @Test
    void localVariableDefinition() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    String a = \"\";\n}\n")});
    }

    @Test
    void fieldWithNoInitializer() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    public String a;\n}\n")});
    }

    @Test
    void arrayVariables() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)" class Test {\n    int n [ ];\n    String s [ ] [ ];\n    int [ ] n2;\n    String [ ] [ ] s2;\n}\n")});
    }

    @Test
    void multipleDeclarationOneAssignment() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    void test() {\n        int i , j = 0;\n    }\n}\n")});
    }

    @Test
    void multipleDeclaration() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    void test() {\n        Integer[] m = { 0 }, n[] = { { 0 } };\n    }\n}\n")});
    }

    @Test
    void modifierOrdering() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    public /* static */ final static Integer n = 0;\n}\n")});
    }

    @Test
    void primitiveClassType() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    public String fred;\n    public Class<?> a = boolean.class;\n}\n")});
    }

    @Test
    void voidClassType() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"@interface Test {\n    Class<?> interfaceClass() default void.class;\n}\n")});
    }

    @MinimumJava17
    @Test
    void implicitlyDeclaredLocalVariable() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    void test() {\n        var a = \"\";\n        var/* comment */b = \"\";\n        /*comment*/var c = \"\";\n        var     d = \"\";\n        long /* yep */ i /* comments */, /*everywhere*/ j;\n    }\n}\n")});
    }

    @MinimumJava17
    @Test
    void string() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class Test {\n    static {\n        var a = \"\";\n    }\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(this){

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, Object o) {
                org.assertj.core.api.Assertions.assertThat((String)Objects.requireNonNull(multiVariable.getTypeAsFullyQualified()).getFullyQualifiedName()).isEqualTo("java.lang.String");
                return multiVariable;
            }
        }))});
    }

    @MinimumJava17
    @Test
    void typeOnVarKeyword() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.Date;\npublic class Test {\n    static {\n        var a = new Date();\n    }\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(this){

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, Object o) {
                org.assertj.core.api.Assertions.assertThat((Optional)multiVariable.getMarkers().findFirst(JavaVarKeyword.class)).isPresent();
                TypeTree typeExpression = multiVariable.getTypeExpression();
                org.assertj.core.api.Assertions.assertThat((Object)typeExpression).isNotNull();
                org.assertj.core.api.Assertions.assertThat((String)Objects.requireNonNull(TypeUtils.asFullyQualified((JavaType)typeExpression.getType())).getFullyQualifiedName()).isEqualTo("java.util.Date");
                return multiVariable;
            }
        }))});
    }

    @Test
    @MinimumJava11
    void unknownVar() {
        this.rewriteRun(spec -> spec.typeValidationOptions(TypeValidation.none()), new SourceSpecs[]{Assertions.java((String)"class Test {\n    void test(Unknown b) {\n        final var a = b;\n    }\n}\n")});
    }
}

