/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

class MethodInvocationTest
implements RewriteTest {
    MethodInvocationTest() {
    }

    @Test
    void methodInvocation() {
        this.rewriteRun(spec -> spec.recipe((Recipe)RewriteTest.toRecipe(() -> new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                if (method.getSimpleName().equals("foo")) {
                    org.assertj.core.api.Assertions.assertThat((String)"foo").isEqualTo(method.getSimpleName());
                    org.assertj.core.api.Assertions.assertThat((String)"java.lang.Integer").isEqualTo(TypeUtils.asFullyQualified((JavaType)method.getType()).getFullyQualifiedName());
                    List effectParams = method.getMethodType().getParameterTypes();
                    org.assertj.core.api.Assertions.assertThat((String)"java.lang.Integer").isEqualTo(TypeUtils.asFullyQualified((JavaType)((JavaType)effectParams.get(0))).getFullyQualifiedName());
                    org.assertj.core.api.Assertions.assertThat((String)"java.lang.Integer").isEqualTo(TypeUtils.asFullyQualified((JavaType)TypeUtils.asArray((JavaType)((JavaType)effectParams.get(1))).getElemType()).getFullyQualifiedName());
                    org.assertj.core.api.Assertions.assertThat((String)method.getMethodType().getDeclaringType().getFullyQualifiedName()).isEqualTo("A");
                }
                return method;
            }
        })), new SourceSpecs[]{Assertions.java((String)"public class A {\n    Integer m = foo ( 0, 1, 2 );\n\n    public Integer foo(Integer n, Integer... ns) { return n; }\n}\n")});
    }

    @Test
    void genericMethodInvocation() {
        this.rewriteRun(spec -> spec.recipe((Recipe)RewriteTest.toRecipe(() -> new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                if (method.getSimpleName().equals("generic")) {
                    JavaType.Method methType = method.getMethodType();
                    org.assertj.core.api.Assertions.assertThat((String)TypeUtils.asFullyQualified((JavaType)methType.getReturnType()).getFullyQualifiedName()).isEqualTo("java.lang.Integer");
                    org.assertj.core.api.Assertions.assertThat((String)TypeUtils.asFullyQualified((JavaType)((JavaType)methType.getParameterTypes().get(0))).getFullyQualifiedName()).isEqualTo("java.lang.Integer");
                    org.assertj.core.api.Assertions.assertThat((String)TypeUtils.asFullyQualified((JavaType)TypeUtils.asArray((JavaType)((JavaType)methType.getParameterTypes().get(1))).getElemType()).getFullyQualifiedName()).isEqualTo("java.lang.Integer");
                }
                return method;
            }
        })), new SourceSpecs[]{Assertions.java((String)"public class A {\n    Integer o = generic ( 0, 1, 2 );\n    Integer p = this . < Integer > generic ( 0, 1, 2 );\n\n    public <TTTT> TTTT generic(TTTT n, TTTT... ns) { return n; }\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(){

            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Object o) {
                if ("ns".equals(variable.getSimpleName())) {
                    org.assertj.core.api.Assertions.assertThat((String)variable.getPrefix().getWhitespace()).isEqualTo(" ");
                }
                return super.visitVariable(variable, o);
            }
        }))});
    }

    @Test
    void intersectionTypeSignature() {
        this.rewriteRun(spec -> spec.recipe((Recipe)RewriteTest.toRecipe(() -> new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                JavaType.Method methodType = method.getMethodType();
                Optional ignore = TypeUtils.findDeclaredMethod((JavaType.FullyQualified)methodType.getDeclaringType(), (String)methodType.getName(), (List)methodType.getParameterTypes());
                return method;
            }
        })), new SourceSpecs[]{Assertions.java((String)"import java.util.Collections;\nimport java.util.HashSet;\nimport java.util.Set;\n\nclass A {\n    void m() {\n        Set<Class<?>> primitiveTypes = new HashSet<>(32);\n        Collections.addAll(primitiveTypes, boolean[].class, byte[].class, char[].class,\n                double[].class, float[].class, int[].class, long[].class, short[].class);\n    }\n}\n")});
    }
}

