/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010\n\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J\u0018\u0010\f\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J\u0018\u0010\r\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000e"}, d2={"Lorg/openrewrite/java/JavaTypeTest;", "", "executionContext", "Lorg/openrewrite/ExecutionContext;", "getExecutionContext", "()Lorg/openrewrite/ExecutionContext;", "annotationsOnTypeAttribution", "", "jp", "Lorg/openrewrite/java/JavaParser;", "noNewMethodType", "Lorg/openrewrite/java/JavaParser$Builder;", "noStackOverflow", "resolvedSignatureOfGenericMethodDeclarations", "rewrite-java-tck"})
public interface JavaTypeTest {
    @NotNull
    public ExecutionContext getExecutionContext();

    @Test
    public void resolvedSignatureOfGenericMethodDeclarations(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void annotationsOnTypeAttribution(@NotNull JavaParser var1);

    @Test
    public void noStackOverflow(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void noNewMethodType(@NotNull JavaParser.Builder<?, ?> var1);

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull JavaTypeTest $this) {
            InMemoryExecutionContext ctx = new InMemoryExecutionContext(DefaultImpls::_get_executionContext_$lambda$0);
            ctx.putMessage("org.openrewrite.java.skipSourceSetTypeGeneration", (Object)true);
            return (ExecutionContext)ctx;
        }

        @Test
        public static void resolvedSignatureOfGenericMethodDeclarations(@NotNull JavaTypeTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            String[] stringArray = new String[]{"import java.util.ListIterator;\nimport static java.util.Collections.singletonList;\n\ninterface MyList<E> {\n    ListIterator<E> listIterator();\n}\n\nclass Test {\n    ListIterator<Integer> s = singletonList(1).listIterator();\n}"};
            J.CompilationUnit cu = (J.CompilationUnit)jp.logCompilationWarningsAndErrors(true).build().parse($this.getExecutionContext(), stringArray).get(0);
            JavaType.FullyQualified fullyQualified = ((J.ClassDeclaration)cu.getClasses().get(0)).getType();
            Intrinsics.checkNotNull((Object)fullyQualified);
            JavaType.Method declaredMethod = (JavaType.Method)fullyQualified.getMethods().get(0);
            Assertions.assertThat((Object)declaredMethod.getReturnType()).isInstanceOf(JavaType.Parameterized.class);
            Object e = ((J.ClassDeclaration)cu.getClasses().get(1)).getBody().getStatements().get(0);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            Expression expression = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e).getVariables().get(0)).getInitializer();
            Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            J.MethodInvocation inv = (J.MethodInvocation)expression;
            JavaType.Method method = inv.getMethodType();
            Intrinsics.checkNotNull((Object)method);
            JavaType rt = method.getReturnType();
            JavaType.Parameterized parameterized = TypeUtils.asParameterized((JavaType)rt);
            Intrinsics.checkNotNull((Object)parameterized);
            JavaType.FullyQualified fullyQualified2 = TestKt.asFullyQualified((JavaType)parameterized.getTypeParameters().get(0));
            Intrinsics.checkNotNull((Object)fullyQualified2);
            Assertions.assertThat((String)fullyQualified2.getFullyQualifiedName()).isEqualTo("java.lang.Integer");
        }

        @Test
        public static void annotationsOnTypeAttribution(@NotNull JavaTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            import java.util.function.Consumer;\n            class Test {\n                Consumer<String> c;\n            }\n        "};
            J.CompilationUnit cu = (J.CompilationUnit)jp.parse($this.getExecutionContext(), stringArray).get(0);
            Statement field = (Statement)((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            Intrinsics.checkNotNull((Object)field, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            JavaType.FullyQualified fullyQualified = ((J.VariableDeclarations)field).getTypeAsFullyQualified();
            List annotations = fullyQualified != null ? fullyQualified.getAnnotations() : null;
            Assertions.assertThat((List)annotations).hasSize(1);
            List list = annotations;
            Intrinsics.checkNotNull((Object)list);
            JavaType.FullyQualified fullyQualified2 = TestKt.asFullyQualified((JavaType)list.get(0));
            Assertions.assertThat((String)(fullyQualified2 != null ? fullyQualified2.getFullyQualifiedName() : null)).isEqualTo("java.lang.FunctionalInterface");
        }

        @Test
        public static void noStackOverflow(@NotNull JavaTypeTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter(jp, (String)"jp");
                String[] stringArray = new String[]{"\n            import java.util.HashMap;\n            import java.util.Map;\n            class A {\n                Map<String, Map<String, Map<Integer, String>>> overflowMap = new HashMap<>();\n            }\n            "};
                List cu = jp.build().parse($this.getExecutionContext(), stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)cu, (String)"cu");
                Iterable iterable = cu;
                for (Object t : iterable) {
                    J.CompilationUnit it = (J.CompilationUnit)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)((J.ClassDeclaration)it.getClasses().get(0)).getName().getSimpleName(), (Object)"A")) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            Intrinsics.checkNotNull(v0);
            J.CompilationUnit foo = v0;
            Set foundTypes = foo.getTypesInUse().getTypesInUse();
            Intrinsics.checkNotNullExpressionValue((Object)foundTypes, (String)"foundTypes");
            Assertions.assertThat((!((Collection)foundTypes).isEmpty() ? 1 : 0) != 0);
        }

        @Test
        public static void noNewMethodType(@NotNull JavaTypeTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            String[] stringArray = new String[]{"\n                public class Test {\n                }\n            ", "\n            public class A {\n                void method() {\n                    Test a = test(null);\n                }\n                \n                Test test(Test test) {\n                    return test;\n                }\n            }\n            "};
            List cu = jp.build().parse($this.getExecutionContext(), stringArray);
            Tree tree = new JavaIsoVisitor<ExecutionContext>(){

                @NotNull
                public J.MethodInvocation visitMethodInvocation(@NotNull J.MethodInvocation method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.MethodInvocation m = super.visitMethodInvocation(method, (Object)p);
                    String string = m.getName().getPrefix().getWhitespace();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"m.name.prefix.whitespace");
                    if (((CharSequence)string).length() == 0) {
                        m = m.withName(m.getName().withPrefix(m.getName().getPrefix().withWhitespace("  ")));
                    }
                    J.MethodInvocation methodInvocation2 = m;
                    Intrinsics.checkNotNullExpressionValue((Object)methodInvocation2, (String)"m");
                    return methodInvocation2;
                }
            }.visit((Tree)cu.get(1), (Object)new InMemoryExecutionContext());
            Intrinsics.checkNotNull((Object)tree, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.CompilationUnit");
            J.CompilationUnit cu22 = (J.CompilationUnit)tree;
            Object e = ((J.ClassDeclaration)cu22.getClasses().get(0)).getBody().getStatements().get(0);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            Object e3 = ((J.VariableDeclarations)e2).getVariables().get(0);
            Intrinsics.checkNotNull(e3, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations.NamedVariable");
            Expression expression = ((J.VariableDeclarations.NamedVariable)e3).getInitializer();
            Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            J.MethodInvocation mi = (J.MethodInvocation)expression;
            Assertions.assertThat((mi.getName().getType() == mi.getMethodType() ? 1 : 0) != 0).isTrue();
        }

        private static void _get_executionContext_$lambda$0(Throwable t) {
            Assertions.fail((String)"Failed to parse", (Throwable)t);
        }
    }
}

