/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.cleanup.UnnecessaryCatch;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017\u00a8\u0006\n"}, d2={"Lorg/openrewrite/java/cleanup/UnnecessaryCatchTest;", "Lorg/openrewrite/test/RewriteTest;", "defaults", "", "spec", "Lorg/openrewrite/test/RecipeSpec;", "doNotRemoveRuntimeException", "doNotRemoveThrownException", "removeCatch", "unwrapTry", "rewrite-java-tck"})
public interface UnnecessaryCatchTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void unwrapTry();

    @Test
    public void removeCatch();

    @Test
    public void doNotRemoveRuntimeException();

    @Test
    public void doNotRemoveThrownException();

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull UnnecessaryCatchTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new UnnecessaryCatch());
        }

        @Test
        public static void unwrapTry(@NotNull UnnecessaryCatchTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.io.IOException;\n                \n                public class AnExample {\n                    public void method() {\n                        try {\n                            java.util.Base64.getDecoder().decode(\"abc\".getBytes());\n                        } catch (IOException e) {\n                            System.out.println(\"an exception!\");\n                        }\n                    }\n                }\n            ", (String)"\n                public class AnExample {\n                    public void method() {\n                        java.util.Base64.getDecoder().decode(\"abc\".getBytes());\n                    }\n                }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void removeCatch(@NotNull UnnecessaryCatchTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.io.IOException;\n                \n                public class AnExample {\n                    public void method() {\n                        try {\n                            java.util.Base64.getDecoder().decode(\"abc\".getBytes());\n                        } catch (IOException e1) {\n                            System.out.println(\"an exception!\");\n                        } catch (IllegalStateException e2) {\n                            System.out.println(\"another exception!\");\n                        }\n                    }\n                }\n            ", (String)"\n                public class AnExample {\n                    public void method() {\n                        try {\n                            java.util.Base64.getDecoder().decode(\"abc\".getBytes());\n                        } catch (IllegalStateException e2) {\n                            System.out.println(\"another exception!\");\n                        }\n                    }\n                }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotRemoveRuntimeException(@NotNull UnnecessaryCatchTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)" \n                public class AnExample {\n                    public void method() {\n                        try {\n                            java.util.Base64.getDecoder().decode(\"abc\".getBytes());\n                        } catch (IllegalStateException e) {\n                            System.out.println(\"an exception!\");            \n                        }\n                    }\n                }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotRemoveThrownException(@NotNull UnnecessaryCatchTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.io.IOException;\n                \n                public class AnExample {\n                    public void method() {\n                        try {\n                            fred();\n                        } catch (IOException e) {\n                            System.out.println(\"an exception!\");            \n                        }\n                    }\n                    \n                    public void fred() throws IOException {\n                    }\n                }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }
    }
}

