/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.cleanup.AddSerialVersionUidToSerializable;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017J\b\u0010\r\u001a\u00020\u0003H\u0017J\b\u0010\u000e\u001a\u00020\u0003H\u0017J\b\u0010\u000f\u001a\u00020\u0003H\u0017J\b\u0010\u0010\u001a\u00020\u0003H\u0017\u00a8\u0006\u0011"}, d2={"Lorg/openrewrite/java/cleanup/AddSerialVersionUidToSerializableTest;", "Lorg/openrewrite/test/RewriteTest;", "addSerialVersionUID", "", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "doNotAlterARuntimeException", "doNotAlterAnException", "doNotAlterAnInterface", "doNothingNotSerializable", "fixSerialVersionUIDModifiers", "fixSerialVersionUIDNoModifiers", "fixSerialVersionUIDNoModifiersWrongType", "methodDeclarationsAreNotVisited", "serializableInnerClass", "uidAlreadyPresent", "rewrite-java-tck"})
public interface AddSerialVersionUidToSerializableTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void doNothingNotSerializable();

    @Test
    public void addSerialVersionUID();

    @Test
    public void fixSerialVersionUIDModifiers();

    @Test
    public void fixSerialVersionUIDNoModifiers();

    @Test
    public void fixSerialVersionUIDNoModifiersWrongType();

    @Test
    public void uidAlreadyPresent();

    @Test
    public void methodDeclarationsAreNotVisited();

    @Test
    public void doNotAlterAnInterface();

    @Test
    public void doNotAlterAnException();

    @Test
    public void doNotAlterARuntimeException();

    @Test
    public void serializableInnerClass();

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull AddSerialVersionUidToSerializableTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new AddSerialVersionUidToSerializable());
        }

        @Test
        public static void doNothingNotSerializable(@NotNull AddSerialVersionUidToSerializableTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class Example {\n                private String fred;\n                private int numberOfFreds;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void addSerialVersionUID(@NotNull AddSerialVersionUidToSerializableTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.io.Serializable;\n                        \n            public class Example implements Serializable {\n                private String fred;\n                private int numberOfFreds;\n            }\n        ", (String)"\n            import java.io.Serializable;\n                        \n            public class Example implements Serializable {\n                private static final long serialVersionUID = 1;\n                private String fred;\n                private int numberOfFreds;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void fixSerialVersionUIDModifiers(@NotNull AddSerialVersionUidToSerializableTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.io.Serializable;\n                        \n            public class Example implements Serializable {\n                private final long serialVersionUID = 1;\n                private String fred;\n                private int numberOfFreds;\n            }\n        ", (String)"\n            import java.io.Serializable;\n                        \n            public class Example implements Serializable {\n                private static final long serialVersionUID = 1;\n                private String fred;\n                private int numberOfFreds;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void fixSerialVersionUIDNoModifiers(@NotNull AddSerialVersionUidToSerializableTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.io.Serializable;\n                        \n            public class Example implements Serializable {\n                long serialVersionUID = 1;\n                private String fred;\n                private int numberOfFreds;\n            }\n        ", (String)"\n            import java.io.Serializable;\n                        \n            public class Example implements Serializable {\n                private static final long serialVersionUID = 1;\n                private String fred;\n                private int numberOfFreds;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void fixSerialVersionUIDNoModifiersWrongType(@NotNull AddSerialVersionUidToSerializableTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.io.Serializable;\n\n            public class Example implements Serializable {\n                Long serialVersionUID = 1L;\n                private String fred;\n                private int numberOfFreds;\n            }\n        ", (String)"\n            import java.io.Serializable;\n\n            public class Example implements Serializable {\n                private static final long serialVersionUID = 1L;\n                private String fred;\n                private int numberOfFreds;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void uidAlreadyPresent(@NotNull AddSerialVersionUidToSerializableTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.io.Serializable;\n                        \n            public class Example implements Serializable {\n                private static final long serialVersionUID = 1;\n                private String fred;\n                private int numberOfFreds;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void methodDeclarationsAreNotVisited(@NotNull AddSerialVersionUidToSerializableTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.io.Serializable;\n                        \n            public class Example implements Serializable {\n                private String fred;\n                private int numberOfFreds;\n                void doSomething() {\n                    int serialVersionUID = 1;\n                }\n            }\n        ", (String)"\n            import java.io.Serializable;\n                        \n            public class Example implements Serializable {\n                private static final long serialVersionUID = 1;\n                private String fred;\n                private int numberOfFreds;\n                void doSomething() {\n                    int serialVersionUID = 1;\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotAlterAnInterface(@NotNull AddSerialVersionUidToSerializableTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.io.Serializable;\n                        \n            public interface Example extends Serializable {\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotAlterAnException(@NotNull AddSerialVersionUidToSerializableTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.io.Serializable;\n                        \n            public class MyException extends Exception implements Serializable {\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotAlterARuntimeException(@NotNull AddSerialVersionUidToSerializableTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.io.Serializable;\n                        \n            public class MyException extends RuntimeException implements Serializable {\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void serializableInnerClass(@NotNull AddSerialVersionUidToSerializableTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.io.Serializable;\n            public class Outer {\n                public static class Inner implements Serializable {\n                \n                }\n            }\n        ", (String)"\n            import java.io.Serializable;\n            public class Outer {\n                public static class Inner implements Serializable {\n                    private static final long serialVersionUID = 1;\n                \n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }
    }
}

