/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaTypeSignatureBuilder;

public interface JavaTypeSignatureBuilderTest {
    public String fieldSignature(String var1);

    public String methodSignature(String var1);

    public String constructorSignature();

    public Object firstMethodParameter(String var1);

    public Object innerClassSignature(String var1);

    public Object lastClassTypeParameter();

    public JavaTypeSignatureBuilder signatureBuilder();

    @Test
    default public void constructor() {
        Assertions.assertThat((String)this.constructorSignature()).isEqualTo("org.openrewrite.java.JavaTypeGoat{name=<constructor>,return=org.openrewrite.java.JavaTypeGoat,parameters=[]}");
    }

    @Test
    default public void parameterizedField() {
        Assertions.assertThat((String)this.fieldSignature("parameterizedField")).isEqualTo("org.openrewrite.java.JavaTypeGoat{name=parameterizedField}");
    }

    @Test
    default public void array() {
        Assertions.assertThat((String)this.signatureBuilder().signature(this.firstMethodParameter("array"))).isEqualTo("org.openrewrite.java.C[][]");
        Assertions.assertThat((String)this.methodSignature("array")).isEqualTo("org.openrewrite.java.JavaTypeGoat{name=array,return=void,parameters=[org.openrewrite.java.C[][]]}");
    }

    @Test
    default public void classSignature() {
        Assertions.assertThat((String)this.signatureBuilder().signature(this.firstMethodParameter("clazz"))).isEqualTo("org.openrewrite.java.C");
        Assertions.assertThat((String)this.methodSignature("clazz")).isEqualTo("org.openrewrite.java.JavaTypeGoat{name=clazz,return=void,parameters=[org.openrewrite.java.C]}");
    }

    @Test
    default public void primitive() {
        Assertions.assertThat((String)this.signatureBuilder().signature(this.firstMethodParameter("primitive"))).isEqualTo("int");
        Assertions.assertThat((String)this.methodSignature("primitive")).isEqualTo("org.openrewrite.java.JavaTypeGoat{name=primitive,return=void,parameters=[int]}");
    }

    @Test
    default public void parameterized() {
        Assertions.assertThat((String)this.signatureBuilder().signature(this.firstMethodParameter("parameterized"))).isEqualTo("org.openrewrite.java.PT<org.openrewrite.java.C>");
        Assertions.assertThat((String)this.methodSignature("parameterized")).isEqualTo("org.openrewrite.java.JavaTypeGoat{name=parameterized,return=org.openrewrite.java.PT<org.openrewrite.java.C>,parameters=[org.openrewrite.java.PT<org.openrewrite.java.C>]}");
    }

    @Test
    default public void parameterizedRecursive() {
        Assertions.assertThat((String)this.signatureBuilder().signature(this.firstMethodParameter("parameterizedRecursive"))).isEqualTo("org.openrewrite.java.PT<org.openrewrite.java.PT<org.openrewrite.java.C>>");
        Assertions.assertThat((String)this.methodSignature("parameterizedRecursive")).isEqualTo("org.openrewrite.java.JavaTypeGoat{name=parameterizedRecursive,return=org.openrewrite.java.PT<org.openrewrite.java.PT<org.openrewrite.java.C>>,parameters=[org.openrewrite.java.PT<org.openrewrite.java.PT<org.openrewrite.java.C>>]}");
    }

    @Test
    default public void generic() {
        Assertions.assertThat((String)this.signatureBuilder().signature(this.firstMethodParameter("generic"))).isEqualTo("org.openrewrite.java.PT<Generic{? extends org.openrewrite.java.C}>");
        Assertions.assertThat((String)this.methodSignature("generic")).isEqualTo("org.openrewrite.java.JavaTypeGoat{name=generic,return=org.openrewrite.java.PT<Generic{? extends org.openrewrite.java.C}>,parameters=[org.openrewrite.java.PT<Generic{? extends org.openrewrite.java.C}>]}");
    }

    @Test
    default public void genericT() {
        Assertions.assertThat((String)this.signatureBuilder().signature(this.firstMethodParameter("genericT"))).isEqualTo("Generic{T}");
        Assertions.assertThat((String)this.methodSignature("genericT")).isEqualTo("org.openrewrite.java.JavaTypeGoat{name=genericT,return=Generic{T},parameters=[Generic{T}]}");
    }

    @Test
    default public void genericContravariant() {
        Assertions.assertThat((String)this.signatureBuilder().signature(this.firstMethodParameter("genericContravariant"))).isEqualTo("org.openrewrite.java.PT<Generic{? super org.openrewrite.java.C}>");
        Assertions.assertThat((String)this.methodSignature("genericContravariant")).isEqualTo("org.openrewrite.java.JavaTypeGoat{name=genericContravariant,return=org.openrewrite.java.PT<Generic{? super org.openrewrite.java.C}>,parameters=[org.openrewrite.java.PT<Generic{? super org.openrewrite.java.C}>]}");
    }

    @Test
    default public void genericRecursiveInClassDefinition() {
        Assertions.assertThat((String)this.signatureBuilder().signature(this.lastClassTypeParameter())).isEqualTo("Generic{S extends org.openrewrite.java.PT<Generic{S}> & org.openrewrite.java.C}");
    }

    @Test
    default public void genericRecursiveInMethodDeclaration() {
        Assertions.assertThat((String)this.signatureBuilder().signature(this.firstMethodParameter("genericRecursive"))).isEqualTo("org.openrewrite.java.JavaTypeGoat<Generic{? extends Generic{U extends org.openrewrite.java.JavaTypeGoat<Generic{U}, Generic{?}>}[]}, Generic{?}>");
        Assertions.assertThat((String)this.methodSignature("genericRecursive")).isEqualTo("org.openrewrite.java.JavaTypeGoat{name=genericRecursive,return=org.openrewrite.java.JavaTypeGoat<Generic{? extends Generic{U extends org.openrewrite.java.JavaTypeGoat<Generic{U}, Generic{?}>}[]}, Generic{?}>,parameters=[org.openrewrite.java.JavaTypeGoat<Generic{? extends Generic{U extends org.openrewrite.java.JavaTypeGoat<Generic{U}, Generic{?}>}[]}, Generic{?}>]}");
    }

    @Test
    default public void genericUnbounded() {
        Assertions.assertThat((String)this.signatureBuilder().signature(this.firstMethodParameter("genericUnbounded"))).isEqualTo("org.openrewrite.java.PT<Generic{U}>");
        Assertions.assertThat((String)this.methodSignature("genericUnbounded")).isEqualTo("org.openrewrite.java.JavaTypeGoat{name=genericUnbounded,return=org.openrewrite.java.PT<Generic{U}>,parameters=[org.openrewrite.java.PT<Generic{U}>]}");
    }

    @Test
    default public void innerClass() {
        Assertions.assertThat((String)this.signatureBuilder().signature(this.firstMethodParameter("inner"))).isEqualTo("org.openrewrite.java.C$Inner");
        Assertions.assertThat((String)this.methodSignature("inner")).isEqualTo("org.openrewrite.java.JavaTypeGoat{name=inner,return=void,parameters=[org.openrewrite.java.C$Inner]}");
    }

    @Test
    default public void inheritedJavaTypeGoat() {
        Assertions.assertThat((String)this.signatureBuilder().signature(this.firstMethodParameter("inheritedJavaTypeGoat"))).isEqualTo("org.openrewrite.java.JavaTypeGoat$InheritedJavaTypeGoat<Generic{T}, Generic{U extends org.openrewrite.java.PT<Generic{U}> & org.openrewrite.java.C}>");
        Assertions.assertThat((String)this.methodSignature("inheritedJavaTypeGoat")).isEqualTo("org.openrewrite.java.JavaTypeGoat{name=inheritedJavaTypeGoat,return=org.openrewrite.java.JavaTypeGoat$InheritedJavaTypeGoat<Generic{T}, Generic{U extends org.openrewrite.java.PT<Generic{U}> & org.openrewrite.java.C}>,parameters=[org.openrewrite.java.JavaTypeGoat$InheritedJavaTypeGoat<Generic{T}, Generic{U extends org.openrewrite.java.PT<Generic{U}> & org.openrewrite.java.C}>]}");
    }

    @Test
    default public void extendsJavaTypeGoat() {
        Assertions.assertThat((String)this.signatureBuilder().signature(this.innerClassSignature("ExtendsJavaTypeGoat"))).isEqualTo("org.openrewrite.java.JavaTypeGoat$ExtendsJavaTypeGoat");
    }

    @Test
    default public void genericIntersection() {
        Assertions.assertThat((String)this.signatureBuilder().signature(this.firstMethodParameter("genericIntersection"))).isEqualTo("Generic{U extends org.openrewrite.java.JavaTypeGoat$TypeA & org.openrewrite.java.PT<Generic{U}> & org.openrewrite.java.C}");
        Assertions.assertThat((String)this.methodSignature("genericIntersection")).isEqualTo("org.openrewrite.java.JavaTypeGoat{name=genericIntersection,return=Generic{U extends org.openrewrite.java.JavaTypeGoat$TypeA & org.openrewrite.java.PT<Generic{U}> & org.openrewrite.java.C},parameters=[Generic{U extends org.openrewrite.java.JavaTypeGoat$TypeA & org.openrewrite.java.PT<Generic{U}> & org.openrewrite.java.C}]}");
    }

    @Test
    default public void recursiveIntersection() {
        Assertions.assertThat((String)this.signatureBuilder().signature(this.firstMethodParameter("recursiveIntersection"))).isEqualTo("Generic{U extends org.openrewrite.java.JavaTypeGoat$Extension<Generic{U}> & org.openrewrite.java.Intersection<Generic{U}>}");
        Assertions.assertThat((String)this.methodSignature("recursiveIntersection")).isEqualTo("org.openrewrite.java.JavaTypeGoat{name=recursiveIntersection,return=void,parameters=[Generic{U extends org.openrewrite.java.JavaTypeGoat$Extension<Generic{U}> & org.openrewrite.java.Intersection<Generic{U}>}]}");
    }
}

