/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.cleanup.ReferentialEqualityToObjectEquals;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u000f"}, d2={"Lorg/openrewrite/java/cleanup/ReferentialEqualityToObjectEqualsTest;", "Lorg/openrewrite/test/RewriteTest;", "both sides override equals", "", "jp", "Lorg/openrewrite/java/JavaParser;", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "doNotModifyWithinEqualsMethod", "does not modify boxed types", "does not modify class comparisons", "does not modify enum comparison", "only one side overrides equals", "type does not override equals", "rewrite-java-tck"})
public interface ReferentialEqualityToObjectEqualsTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void does not modify boxed types(@NotNull JavaParser var1);

    @Test
    public void does not modify enum comparison(@NotNull JavaParser var1);

    @Test
    public void does not modify class comparisons(@NotNull JavaParser var1);

    @Test
    public void type does not override equals(@NotNull JavaParser var1);

    @Test
    public void only one side overrides equals(@NotNull JavaParser var1);

    @Test
    public void doNotModifyWithinEqualsMethod(@NotNull JavaParser var1);

    @Test
    public void both sides override equals(@NotNull JavaParser var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull ReferentialEqualityToObjectEqualsTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new ReferentialEqualityToObjectEquals());
        }

        @Test
        public static void does not modify boxed types(@NotNull ReferentialEqualityToObjectEqualsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class C {\n                char c = 'c';\n                void isC(Integer value){\n                    return value == c || value == 99;\n                }\n            }\n        ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.does_not_modify_boxed_types$lambda-0(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void does not modify enum comparison(@NotNull ReferentialEqualityToObjectEqualsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class B {\n                  private void method() {\n                    if(Foo.FOO == Foo.BAR) {}\n                  }\n                  enum Foo {FOO, BAR}\n                }\n            ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.does_not_modify_enum_comparison$lambda-1(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void does not modify class comparisons(@NotNull ReferentialEqualityToObjectEqualsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class A {\n                    void check() {\n                        B b = new B();\n                        if(b == this) {}\n                    }\n                    \n                    class B {\n                        @Override\n                        public boolean equals(Object anObject) {return true;}\n                    }\n                }\n            ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.does_not_modify_class_comparisons$lambda-2(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void type does not override equals(@NotNull ReferentialEqualityToObjectEqualsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class T {\n                void doSomething() {\n                    A a1 = new A();\n                    B b1 = new B();\n                    if (a1 == b1) {}\n                }\n                class A {}\n                class B {}\n            }\n        ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.type_does_not_override_equals$lambda-3(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void only one side overrides equals(@NotNull ReferentialEqualityToObjectEqualsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class T {\n                void doSomething() {\n                    A a1 = new A();\n                    B b1 = new B();\n                    if (a1 == b1) {}\n                }\n                class A {\n                    @Override\n                    public boolean equals(Object anObject) {return true;}\n                }\n                class B {}\n            }\n        ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.only_one_side_overrides_equals$lambda-4(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void doNotModifyWithinEqualsMethod(@NotNull ReferentialEqualityToObjectEqualsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class T {\n                String s1;\n                String s2;\n                @Override\n                public boolean equals(Object obj) {\n                    if (s1 != s2) {}\n                    if (s1 == s2) {}\n                    return super.equals(obj);\n                }\n            }\n        ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.doNotModifyWithinEqualsMethod$lambda-5(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void both sides override equals(@NotNull ReferentialEqualityToObjectEqualsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class T {\n                void doSomething() {\n                    A a1 = new A();\n                    A a2 = new A();\n                    if (a1 == a2) {}\n                }\n                class A {\n                    @Override\n                    public boolean equals(Object anObject) {return true;}\n                }\n            }\n        ", (String)"\n            class T {\n                void doSomething() {\n                    A a1 = new A();\n                    A a2 = new A();\n                    if (a1.equals(a2)) {}\n                }\n                class A {\n                    @Override\n                    public boolean equals(Object anObject) {return true;}\n                }\n            }\n        ")};
            this_.rewriteRun(arg_0 -> DefaultImpls.both_sides_override_equals$lambda-6(jp, arg_0), sourceSpecsArray);
        }

        private static void does_not_modify_boxed_types$lambda-0(JavaParser $jp, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            spec.parser((Parser)$jp);
        }

        private static void does_not_modify_enum_comparison$lambda-1(JavaParser $jp, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            spec.parser((Parser)$jp);
        }

        private static void does_not_modify_class_comparisons$lambda-2(JavaParser $jp, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            spec.parser((Parser)$jp);
        }

        private static void type_does_not_override_equals$lambda-3(JavaParser $jp, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            spec.parser((Parser)$jp);
        }

        private static void only_one_side_overrides_equals$lambda-4(JavaParser $jp, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            spec.parser((Parser)$jp);
        }

        private static void doNotModifyWithinEqualsMethod$lambda-5(JavaParser $jp, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            spec.parser((Parser)$jp);
        }

        private static void both_sides_override_equals$lambda-6(JavaParser $jp, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            spec.parser((Parser)$jp);
        }
    }
}

