/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Parser;
import org.openrewrite.PathUtils;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.cleanup.LowercasePackage;
import org.openrewrite.java.tree.J;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\t"}, d2={"Lorg/openrewrite/java/cleanup/LowercasePackageTest;", "Lorg/openrewrite/test/RewriteTest;", "defaults", "", "spec", "Lorg/openrewrite/test/RecipeSpec;", "lowerCasePackage", "jp", "Lorg/openrewrite/java/JavaParser;", "rewrite-java-tck"})
public interface LowercasePackageTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void lowerCasePackage(@NotNull JavaParser var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull LowercasePackageTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new LowercasePackage());
        }

        @Test
        public static void lowerCasePackage(@NotNull LowercasePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.UPPERCASE.CamelCase;\n            class A {}\n        ", (String)"\n            package com.uppercase.camelcase;\n            class A {}\n        ", DefaultImpls::lowerCasePackage$lambda-2)};
            this_.rewriteRun(arg_0 -> DefaultImpls.lowerCasePackage$lambda-0(jp, arg_0), sourceSpecsArray);
        }

        private static void lowerCasePackage$lambda-0(JavaParser $jp, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            spec.parser((Parser)$jp);
        }

        private static void lowerCasePackage$lambda-2$lambda-1(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((boolean)PathUtils.equalIgnoringSeparators((Path)cu.getSourcePath(), (Path)Paths.get("com/uppercase/camelcase/A.java", new String[0]))).isTrue();
        }

        private static void lowerCasePackage$lambda-2(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::lowerCasePackage$lambda-2$lambda-1);
        }
    }
}

