/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Modules;
import com.sun.tools.javac.comp.Todo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import org.openrewrite.Formatting;
import org.openrewrite.Parser;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.Java11ParserInputFileObject;
import org.openrewrite.java.Java11ParserVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaStyle;
import org.openrewrite.java.tree.J;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class Java11Parser
implements JavaParser {
    private static final Logger logger = LoggerFactory.getLogger(Java11Parser.class);
    @Nullable
    private final Collection<Path> classpath;
    private final MeterRegistry meterRegistry;
    private final boolean relaxedClassTypeMatching;
    private final JavacFileManager pfm;
    private final Context context = new Context();
    private final JavaCompiler compiler;
    private final ResettableLog compilerLog = new ResettableLog(this.context);
    private final Collection<JavaStyle> styles;

    private Java11Parser(@Nullable Collection<Path> classpath, Charset charset, boolean relaxedClassTypeMatching, MeterRegistry meterRegistry, final boolean logCompilationWarningsAndErrors, Collection<JavaStyle> styles) {
        this.meterRegistry = meterRegistry;
        this.classpath = classpath;
        this.relaxedClassTypeMatching = relaxedClassTypeMatching;
        this.styles = styles;
        this.pfm = new JavacFileManager(this.context, true, charset);
        this.context.put(JavaFileManager.class, this.pfm);
        Options.instance(this.context).put("allowStringFolding", "false");
        this.compiler = new JavaCompiler(this.context);
        this.compiler.genEndPos = true;
        this.compiler.keepComments = true;
        this.compilerLog.setWriters(new PrintWriter(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) {
                String log = new String(Arrays.copyOfRange(cbuf, off, len));
                if (logCompilationWarningsAndErrors && !log.isBlank()) {
                    logger.warn(log);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        }));
    }

    public static Builder builder() {
        return new Builder();
    }

    public java.util.List<J.CompilationUnit> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo) {
        if (this.classpath != null) {
            if (this.context.get(JavaFileManager.class) != this.pfm) {
                throw new IllegalStateException("JavaFileManager has been forked unexpectedly");
            }
            try {
                this.pfm.setLocation(StandardLocation.CLASS_PATH, this.classpath.stream().map(Path::toFile).collect(Collectors.toList()));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        LinkedHashMap cus = this.acceptedInputs(sourceFiles).stream().collect(Collectors.toMap(Function.identity(), input -> (JCTree.JCCompilationUnit)Timer.builder((String)"rewrite.parse").description("The time spent by the JDK in parsing and tokenizing the source file").tag("file.type", "Java").tag("step", "JDK parsing").register(this.meterRegistry).record(() -> {
            try {
                return this.compiler.parse(new Java11ParserInputFileObject((Parser.Input)input));
            }
            catch (IllegalStateException e) {
                if (e.getMessage().equals("endPosTable already set")) {
                    throw new IllegalStateException("Call reset() on JavaParser before parsing anotherset of source files that have some of the same fully qualified names", e);
                }
                throw e;
            }
        }), (e2, e1) -> e1, LinkedHashMap::new));
        try {
            this.initModules(cus.values());
            this.enterAll(cus.values());
            Annotate annotate = Annotate.instance(this.context);
            while (annotate.annotationsBlocked()) {
                annotate.unblockAnnotations();
            }
            this.compiler.attribute(new TimedTodo(this.compiler.todo));
        }
        catch (Throwable t) {
            logger.warn("Failed symbol entering or attribution", t);
        }
        return cus.entrySet().stream().map(cuByPath -> (J.CompilationUnit)Timer.builder((String)"rewrite.parse").description("The time spent mapping the OpenJDK AST to Rewrite's AST").tag("file.type", "Java").tag("step", "Map to Rewrite AST").register(this.meterRegistry).record(() -> {
            Parser.Input input = (Parser.Input)cuByPath.getKey();
            logger.trace("Building AST for {}", (Object)input.getPath().getFileName());
            Java11ParserVisitor parser = new Java11ParserVisitor(input.getRelativePath(relativeTo), StringUtils.readFully((InputStream)input.getSource()), this.relaxedClassTypeMatching, this.styles);
            return (J.CompilationUnit)parser.scan((Tree)cuByPath.getValue(), Formatting.EMPTY);
        })).collect(Collectors.toList());
    }

    public Java11Parser reset() {
        this.compilerLog.reset();
        this.pfm.flush();
        Check.instance(this.context).newRound();
        Annotate.instance(this.context).newRound();
        Enter.instance(this.context).newRound();
        Modules.instance(this.context).newRound();
        return this;
    }

    private void initModules(Collection<JCTree.JCCompilationUnit> cus) {
        Modules modules = Modules.instance(this.context);
        modules.initModules(List.from(cus));
    }

    private void enterAll(Collection<JCTree.JCCompilationUnit> cus) {
        Enter enter = Enter.instance(this.context);
        List<JCTree.JCCompilationUnit> compilationUnits = List.from((JCTree.JCCompilationUnit[])cus.toArray(JCTree.JCCompilationUnit[]::new));
        enter.main(compilationUnits);
    }

    public static class Builder
    extends JavaParser.Builder<Java11Parser, Builder> {
        public Java11Parser build() {
            return new Java11Parser(this.classpath, this.charset, this.relaxedClassTypeMatching, this.meterRegistry, this.logCompilationWarningsAndErrors, this.styles);
        }
    }

    private class TimedTodo
    extends Todo {
        private final Todo todo;
        private Timer.Sample sample;

        private TimedTodo(Todo todo) {
            super(new Context());
            this.todo = todo;
        }

        @Override
        public boolean isEmpty() {
            if (this.sample != null) {
                this.sample.stop(Timer.builder((String)"rewrite.parse").description("The time spent by the JDK in type attributing the source file").tag("file.type", "Java").tag("step", "Type attribution").register(Java11Parser.this.meterRegistry));
            }
            return this.todo.isEmpty();
        }

        @Override
        public Env<AttrContext> remove() {
            this.sample = Timer.start();
            return (Env)this.todo.remove();
        }
    }

    private static class ResettableLog
    extends Log {
        protected ResettableLog(Context context) {
            super(context);
        }

        public void reset() {
            this.sourceMap.clear();
        }
    }
}

