/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl.internal;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.openrewrite.FileAttributes;
import org.openrewrite.Tree;
import org.openrewrite.hcl.internal.grammar.HCLParser;
import org.openrewrite.hcl.internal.grammar.HCLParserBaseVisitor;
import org.openrewrite.hcl.tree.BodyContent;
import org.openrewrite.hcl.tree.Expression;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.hcl.tree.HclContainer;
import org.openrewrite.hcl.tree.HclLeftPadded;
import org.openrewrite.hcl.tree.HclRightPadded;
import org.openrewrite.hcl.tree.Label;
import org.openrewrite.hcl.tree.Space;
import org.openrewrite.marker.Markers;

public class HclParserVisitor
extends HCLParserBaseVisitor<Hcl> {
    private final Path path;
    private final String source;
    private final Charset charset;
    private final boolean charsetBomMarked;
    private final @Nullable FileAttributes fileAttributes;
    private int cursor = 0;

    public HclParserVisitor(Path path, String source, Charset charset, boolean charsetBomMarked, @Nullable FileAttributes fileAttributes) {
        this.path = path;
        this.source = source;
        this.charset = charset;
        this.charsetBomMarked = charsetBomMarked;
        this.fileAttributes = fileAttributes;
    }

    @Override
    public Hcl visitAttribute(HCLParser.AttributeContext ctx) {
        return this.convert(ctx, (c, prefix) -> new Hcl.Attribute(Tree.randomId(), Space.format(prefix), Markers.EMPTY, this.visitIdentifier(c.Identifier()), new HclLeftPadded<Hcl.Attribute.Type>(this.sourceBefore("="), Hcl.Attribute.Type.Assignment, Markers.EMPTY), (Expression)this.visit((ParseTree)c.expression()), null));
    }

    @Override
    public Hcl visitAttributeAccessExpression(HCLParser.AttributeAccessExpressionContext ctx) {
        return this.convert(ctx, (c, prefix) -> new Hcl.AttributeAccess(Tree.randomId(), Space.format(prefix), Markers.EMPTY, (Expression)this.visit((ParseTree)c.exprTerm()), new HclLeftPadded<Hcl.Identifier>(this.sourceBefore("."), this.visitIdentifier(c.getAttr().Identifier()), Markers.EMPTY)));
    }

    @Override
    public Hcl visitBinaryOp(HCLParser.BinaryOpContext ctx) {
        return this.convert(ctx, (c, prefix) -> {
            Hcl.Binary.Type op;
            Expression left = c.unaryOp() != null ? (Expression)this.visit((ParseTree)c.unaryOp()) : (Expression)this.visit((ParseTree)c.exprTerm(0));
            switch (ctx.binaryOperator().getText()) {
                case "+": {
                    op = Hcl.Binary.Type.Addition;
                    break;
                }
                case "-": {
                    op = Hcl.Binary.Type.Subtraction;
                    break;
                }
                case "*": {
                    op = Hcl.Binary.Type.Multiplication;
                    break;
                }
                case "/": {
                    op = Hcl.Binary.Type.Division;
                    break;
                }
                case "%": {
                    op = Hcl.Binary.Type.Modulo;
                    break;
                }
                case "||": {
                    op = Hcl.Binary.Type.Or;
                    break;
                }
                case "&&": {
                    op = Hcl.Binary.Type.And;
                    break;
                }
                case "<": {
                    op = Hcl.Binary.Type.LessThan;
                    break;
                }
                case "<=": {
                    op = Hcl.Binary.Type.LessThanOrEqual;
                    break;
                }
                case ">": {
                    op = Hcl.Binary.Type.GreaterThan;
                    break;
                }
                case ">=": {
                    op = Hcl.Binary.Type.GreaterThanOrEqual;
                    break;
                }
                case "==": {
                    op = Hcl.Binary.Type.Equal;
                    break;
                }
                default: {
                    op = Hcl.Binary.Type.NotEqual;
                }
            }
            Space opPrefix = Space.format(this.prefix(ctx.binaryOperator()));
            this.cursor = ctx.binaryOperator().getStop().getStopIndex() + 1;
            Expression right = c.unaryOp() != null ? (Expression)this.visit((ParseTree)(c.operation() != null ? c.operation() : c.exprTerm(0))) : (Expression)this.visit((ParseTree)(c.operation() != null ? c.operation() : c.exprTerm(1)));
            return new Hcl.Binary(Tree.randomId(), Space.format(prefix), Markers.EMPTY, left, new HclLeftPadded<Hcl.Binary.Type>(opPrefix, op, Markers.EMPTY), right);
        });
    }

    @Override
    public Hcl visitBlockExpr(HCLParser.BlockExprContext ctx) {
        return this.convert(ctx, (c, prefix) -> new Hcl.Block(Tree.randomId(), Space.format(prefix), Markers.EMPTY, null, Collections.emptyList(), this.sourceBefore("{"), c.body().bodyContent().stream().map(bc -> (BodyContent)this.visit((ParseTree)bc)).collect(Collectors.toList()), this.sourceBefore("}")));
    }

    @Override
    public Hcl visitBlock(HCLParser.BlockContext ctx) {
        return this.convert(ctx, (c, prefix) -> {
            Hcl.Identifier type = this.visitIdentifier(ctx.Identifier());
            List<Label> labels = c.blockLabel().stream().map(l -> l.Identifier() != null ? this.visitIdentifier(l.Identifier()) : (Label)this.visit((ParseTree)l)).collect(Collectors.toList());
            Hcl.Block blockExpr = ((Hcl.Block)this.visit((ParseTree)c.blockExpr())).withType(type).withLabels(labels);
            return blockExpr.withOpen(blockExpr.getPrefix()).withPrefix(Space.format(prefix));
        });
    }

    @Override
    public Hcl visitBlockLabel(HCLParser.BlockLabelContext ctx) {
        return this.convert(ctx, (c, prefix) -> {
            if (ctx.Identifier() != null) {
                return this.visitIdentifier(ctx.Identifier());
            }
            TerminalNode stringLiteral = ctx.stringLiteral().TemplateStringLiteral();
            this.skip(stringLiteral);
            this.sourceBefore("\"");
            return new Hcl.Literal(Tree.randomId(), Space.format(prefix), Markers.EMPTY, stringLiteral.getText(), "\"" + stringLiteral.getText() + '\"');
        });
    }

    @Override
    public Hcl visitConditionalExpression(HCLParser.ConditionalExpressionContext ctx) {
        return this.convert(ctx, (c, prefix) -> new Hcl.Conditional(Tree.randomId(), Space.format(prefix), Markers.EMPTY, (Expression)this.visit((ParseTree)c.expression(0)), new HclLeftPadded<Expression>(this.sourceBefore("?"), (Expression)this.visit((ParseTree)c.expression(1)), Markers.EMPTY), new HclLeftPadded<Expression>(this.sourceBefore(":"), (Expression)this.visit((ParseTree)c.expression(2)), Markers.EMPTY)));
    }

    @Override
    public Hcl visitConfigFile(HCLParser.ConfigFileContext ctx) {
        return this.convert(ctx, (c, prefix) -> new Hcl.ConfigFile(Tree.randomId(), this.path, this.fileAttributes, Space.format(prefix), Markers.EMPTY, this.charset.name(), this.charsetBomMarked, null, c.body().bodyContent().stream().map(bc -> (BodyContent)this.visit((ParseTree)bc)).collect(Collectors.toList()), Space.format(this.source.substring(this.cursor))));
    }

    @Override
    public Hcl visitForIntro(HCLParser.ForIntroContext ctx) {
        return this.convert(ctx, (c, prefix) -> {
            ArrayList mappedVariables = new ArrayList();
            List<TerminalNode> variables = ctx.Identifier();
            int lastFor = prefix.lastIndexOf("for");
            String beforeFor = prefix.substring(0, lastFor);
            String afterFor = prefix.substring(lastFor + 3);
            for (int i = 0; i < variables.size(); ++i) {
                TerminalNode variable = variables.get(i);
                Hcl.Identifier expression = this.visitIdentifier(variable);
                if (i == 0) {
                    expression = expression.withPrefix(Space.format(afterFor));
                }
                mappedVariables.add(HclRightPadded.build(expression).withAfter(this.sourceBefore(i == variables.size() - 1 ? "in" : ",")));
            }
            return new Hcl.ForIntro(Tree.randomId(), Space.format(beforeFor), Markers.EMPTY, HclContainer.build(Space.EMPTY, mappedVariables, Markers.EMPTY), (Expression)this.visit((ParseTree)ctx.expression()));
        });
    }

    @Override
    public Hcl visitForObjectExpr(HCLParser.ForObjectExprContext ctx) {
        return this.convert(ctx, (c, prefix) -> {
            this.sourceBefore("{");
            return new Hcl.ForObject(Tree.randomId(), Space.format(prefix), Markers.EMPTY, (Hcl.ForIntro)this.visit((ParseTree)ctx.forIntro()), new HclLeftPadded<Expression>(this.sourceBefore(":"), (Expression)this.visit((ParseTree)ctx.expression().get(0)), Markers.EMPTY), new HclLeftPadded<Expression>(this.sourceBefore("=>"), (Expression)this.visit((ParseTree)ctx.expression().get(1)), Markers.EMPTY), ctx.ELLIPSIS() == null ? null : new Hcl.Empty(Tree.randomId(), this.sourceBefore("..."), Markers.EMPTY), ctx.forCond() == null ? null : new HclLeftPadded<Expression>(this.sourceBefore("if"), (Expression)this.visit((ParseTree)ctx.forCond().expression()), Markers.EMPTY), this.sourceBefore("}"));
        });
    }

    @Override
    public Hcl visitForTupleExpr(HCLParser.ForTupleExprContext ctx) {
        return this.convert(ctx, (c, prefix) -> {
            this.sourceBefore("[");
            return new Hcl.ForTuple(Tree.randomId(), Space.format(prefix), Markers.EMPTY, (Hcl.ForIntro)this.visit((ParseTree)ctx.forIntro()), new HclLeftPadded<Expression>(this.sourceBefore(":"), (Expression)this.visit((ParseTree)ctx.expression()), Markers.EMPTY), ctx.forCond() == null ? null : new HclLeftPadded<Expression>(this.sourceBefore("if"), (Expression)this.visit((ParseTree)ctx.forCond().expression()), Markers.EMPTY), this.sourceBefore("]"));
        });
    }

    @Override
    public Hcl visitFunctionCall(HCLParser.FunctionCallContext ctx) {
        return this.convert(ctx, (c, prefix) -> {
            Hcl.Identifier name = this.visitIdentifier(ctx.Identifier());
            Space argPrefix = this.sourceBefore("(");
            ArrayList mappedArgs = new ArrayList();
            if (ctx.arguments() != null) {
                List<HCLParser.ExpressionContext> args = ctx.arguments().expression();
                for (int i = 0; i < args.size(); ++i) {
                    HCLParser.ExpressionContext arg = args.get(i);
                    mappedArgs.add(HclRightPadded.build((Expression)this.visit((ParseTree)arg)).withAfter(this.sourceBefore(i == args.size() - 1 ? ")" : ",")));
                }
            } else {
                mappedArgs = Collections.singletonList(HclRightPadded.build(new Hcl.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY)).withAfter(this.sourceBefore(")")));
            }
            return new Hcl.FunctionCall(Tree.randomId(), Space.format(prefix), Markers.EMPTY, name, HclContainer.build(argPrefix, mappedArgs, Markers.EMPTY));
        });
    }

    @Override
    public Hcl visitHeredoc(HCLParser.HeredocContext ctx) {
        return this.convert(ctx, (c, prefix) -> {
            String arrow = ctx.HEREDOC_START().getText();
            this.sourceBefore(arrow);
            Hcl.Identifier delimiter = this.visitIdentifier(ctx.Identifier(0));
            List<Expression> expressions = this.visitHeredocTemplateExpressions(ctx.heredocTemplatePart());
            return new Hcl.HeredocTemplate(Tree.randomId(), Space.format(prefix), Markers.EMPTY, arrow, delimiter, expressions, this.sourceBefore(ctx.Identifier(0).getText()));
        });
    }

    private @NonNull List<Expression> visitHeredocTemplateExpressions(List<HCLParser.HeredocTemplatePartContext> ctx) {
        ArrayList<Expression> expressions = new ArrayList<Expression>(ctx.size());
        for (HCLParser.HeredocTemplatePartContext part : ctx) {
            Space prefix;
            if (part.heredocLiteral() != null) {
                prefix = Space.format(this.prefix(part.heredocLiteral()));
                String value = part.heredocLiteral().getText();
                this.cursor = part.heredocLiteral().getStop().getStopIndex() + 1;
                expressions.add(new Hcl.Literal(Tree.randomId(), prefix, Markers.EMPTY, value, value));
                continue;
            }
            if (part.templateInterpolation() != null) {
                prefix = Space.format(this.prefix(part.templateInterpolation()));
                expressions.add((Expression)((Hcl)this.visit((ParseTree)part.templateInterpolation())).withPrefix(prefix));
                continue;
            }
            throw new IllegalStateException("Unsupported terminal node");
        }
        return expressions;
    }

    @Override
    public Hcl visitIndexAccessExpression(HCLParser.IndexAccessExpressionContext ctx) {
        return this.convert(ctx, (c, prefix) -> new Hcl.Index(Tree.randomId(), Space.format(prefix), Markers.EMPTY, (Expression)this.visit((ParseTree)ctx.exprTerm()), new Hcl.Index.Position(Tree.randomId(), this.sourceBefore("["), Markers.EMPTY, HclRightPadded.build((Expression)this.visit((ParseTree)ctx.index().expression())).withAfter(this.sourceBefore("]")))));
    }

    @Override
    public Hcl visitLiteralValue(HCLParser.LiteralValueContext ctx) {
        return this.convert(ctx, (c, prefix) -> {
            Comparable<Boolean> value;
            String valueSource;
            if (c.BooleanLiteral() != null) {
                valueSource = c.BooleanLiteral().getText();
                value = Boolean.parseBoolean(valueSource);
            } else if (c.NumericLiteral() != null) {
                valueSource = c.NumericLiteral().getText();
                if (valueSource.contains(".")) {
                    value = Double.parseDouble(valueSource);
                } else {
                    value = Long.parseLong(valueSource);
                    if ((Long)value < Integer.MAX_VALUE) {
                        value = ((Long)value).intValue();
                    }
                }
            } else if (c.NULL() != null) {
                valueSource = c.NULL().getText();
                value = null;
            } else {
                throw new IllegalStateException("Unsupported terminal node");
            }
            return new Hcl.Literal(Tree.randomId(), Space.format(prefix), Markers.EMPTY, value, valueSource);
        });
    }

    @Override
    public Hcl visitObject(HCLParser.ObjectContext ctx) {
        return this.convert(ctx, (c, prefix) -> {
            Space tuplePrefix = this.sourceBefore("{");
            ArrayList mappedValues = new ArrayList();
            List<HCLParser.ObjectelemContext> values = ctx.objectelem();
            for (int i = 0; i < values.size(); ++i) {
                HCLParser.ObjectelemContext value = values.get(i);
                mappedValues.add(HclRightPadded.build((Expression)this.visit((ParseTree)value)).withAfter(i == values.size() - 1 ? this.sourceBefore("}") : Space.EMPTY));
            }
            return new Hcl.ObjectValue(Tree.randomId(), Space.format(prefix), Markers.EMPTY, HclContainer.build(tuplePrefix, mappedValues, Markers.EMPTY));
        });
    }

    @Override
    public Hcl visitObjectelem(HCLParser.ObjectelemContext ctx) {
        return this.convert(ctx, (c, prefix) -> {
            Expression name;
            if (ctx.QUOTE(0) != null) {
                Space quotePrefix = this.sourceBefore("\"");
                List<Expression> expressions = this.visitTemplateExpressions(ctx.quotedTemplatePart());
                name = new Hcl.QuotedTemplate(Tree.randomId(), quotePrefix, Markers.EMPTY, expressions);
                this.skip(ctx.QUOTE(1));
            } else {
                Space parenthesesPrefix = null;
                if (ctx.LPAREN() != null) {
                    parenthesesPrefix = this.sourceBefore("(");
                }
                name = this.visitIdentifier(ctx.Identifier());
                if (ctx.RPAREN() != null) {
                    name = new Hcl.Parentheses(Tree.randomId(), parenthesesPrefix, Markers.EMPTY, HclRightPadded.build(name).withAfter(this.sourceBefore(")")));
                }
            }
            return new Hcl.Attribute(Tree.randomId(), Space.format(prefix), Markers.EMPTY, name, new HclLeftPadded<Hcl.Attribute.Type>(c.ASSIGN() != null ? this.sourceBefore("=") : this.sourceBefore(":"), c.ASSIGN() != null ? Hcl.Attribute.Type.Assignment : Hcl.Attribute.Type.ObjectElement, Markers.EMPTY), (Expression)this.visit((ParseTree)c.expression()), ctx.COMMA() == null ? null : new Hcl.Empty(Tree.randomId(), this.sourceBefore(","), Markers.EMPTY));
        });
    }

    @Override
    public Hcl visitParentheticalExpression(HCLParser.ParentheticalExpressionContext ctx) {
        return this.convert(ctx, (c, prefix) -> {
            this.sourceBefore("(");
            return new Hcl.Parentheses(Tree.randomId(), Space.format(prefix), Markers.EMPTY, HclRightPadded.build((Expression)this.visit((ParseTree)c.expression())).withAfter(this.sourceBefore(")")));
        });
    }

    @Override
    public Hcl visitSplatExpression(HCLParser.SplatExpressionContext ctx) {
        return this.convert(ctx, (c, prefix) -> {
            Expression select = (Expression)this.visit((ParseTree)ctx.exprTerm());
            Hcl.Splat.Operator operator = c.splat().attrSplat() != null ? new Hcl.Splat.Operator(Tree.randomId(), this.sourceBefore("."), Markers.EMPTY, Hcl.Splat.Operator.Type.Attribute, HclRightPadded.build(new Hcl.Empty(Tree.randomId(), this.sourceBefore("*"), Markers.EMPTY))) : new Hcl.Splat.Operator(Tree.randomId(), this.sourceBefore("["), Markers.EMPTY, Hcl.Splat.Operator.Type.Full, HclRightPadded.build(new Hcl.Empty(Tree.randomId(), this.sourceBefore("*"), Markers.EMPTY)).withAfter(this.sourceBefore("]")));
            Hcl.Splat splat = new Hcl.Splat(Tree.randomId(), Space.format(prefix), Markers.EMPTY, select, operator);
            return this.visitSplatAttr(splat, c.splat().attrSplat() != null ? c.splat().attrSplat().children : c.splat().fullSplat().children);
        });
    }

    public Expression visitSplatAttr(Expression acc, List<ParseTree> attrs) {
        for (ParseTree attr : attrs) {
            if (attr instanceof HCLParser.GetAttrContext) {
                acc = new Hcl.AttributeAccess(Tree.randomId(), acc.getPrefix(), Markers.EMPTY, (Expression)acc.withPrefix(Space.EMPTY), new HclLeftPadded<Hcl.Identifier>(this.sourceBefore("."), this.visitIdentifier(((HCLParser.GetAttrContext)attr).Identifier()), Markers.EMPTY));
                continue;
            }
            if (!(attr instanceof HCLParser.IndexContext)) continue;
            acc = new Hcl.Index(Tree.randomId(), acc.getPrefix(), Markers.EMPTY, (Expression)acc.withPrefix(Space.EMPTY), new Hcl.Index.Position(Tree.randomId(), this.sourceBefore("["), Markers.EMPTY, HclRightPadded.build((Expression)this.visit((ParseTree)((HCLParser.IndexContext)attr).expression())).withAfter(this.sourceBefore("]"))));
        }
        return acc;
    }

    @Override
    public Hcl visitQuotedTemplate(HCLParser.QuotedTemplateContext ctx) {
        Space quotePrefix = this.sourceBefore("\"");
        Hcl.QuotedTemplate quotedTemplate = this.convert(ctx, (c, prefix) -> {
            List<Expression> expressions = this.visitTemplateExpressions(ctx.quotedTemplatePart());
            return new Hcl.QuotedTemplate(Tree.randomId(), quotePrefix, Markers.EMPTY, expressions);
        });
        this.skip(ctx.QUOTE(1));
        return quotedTemplate;
    }

    private @NonNull List<Expression> visitTemplateExpressions(List<HCLParser.QuotedTemplatePartContext> ctx) {
        ArrayList<Expression> expressions = new ArrayList<Expression>(ctx.size());
        for (HCLParser.QuotedTemplatePartContext part : ctx) {
            Space prefix;
            if (part.stringLiteral() != null) {
                prefix = Space.format(this.prefix(part.stringLiteral()));
                String value = part.stringLiteral().getText();
                this.cursor = part.stringLiteral().getStop().getStopIndex() + 1;
                expressions.add(new Hcl.Literal(Tree.randomId(), prefix, Markers.EMPTY, value, value));
                continue;
            }
            if (part.templateInterpolation() != null) {
                prefix = Space.format(this.prefix(part.templateInterpolation()));
                expressions.add((Expression)((Hcl)this.visit((ParseTree)part.templateInterpolation())).withPrefix(prefix));
                continue;
            }
            throw new IllegalStateException("Unsupported terminal node");
        }
        return expressions;
    }

    @Override
    public Hcl visitTemplateInterpolation(HCLParser.TemplateInterpolationContext ctx) {
        this.skip(ctx.TEMPLATE_INTERPOLATION_START());
        Hcl.TemplateInterpolation templateInterpolation = this.convert(ctx, (c, prefix) -> new Hcl.TemplateInterpolation(Tree.randomId(), Space.format(prefix), Markers.EMPTY, (Expression)this.visit((ParseTree)ctx.expression())));
        this.skip(ctx.RBRACE());
        return templateInterpolation;
    }

    @Override
    public Hcl visitTuple(HCLParser.TupleContext ctx) {
        return this.convert(ctx, (c, prefix) -> {
            Space tuplePrefix = this.sourceBefore("[");
            ArrayList mappedValues = new ArrayList();
            List<HCLParser.ExpressionContext> values = ctx.expression();
            for (int i = 0; i < values.size(); ++i) {
                HCLParser.ExpressionContext value = values.get(i);
                mappedValues.add(HclRightPadded.build((Expression)this.visit((ParseTree)value)).withAfter(i == values.size() - 1 ? this.sourceBefore("]") : this.sourceBefore(",")));
            }
            return new Hcl.Tuple(Tree.randomId(), Space.format(prefix), Markers.EMPTY, HclContainer.build(tuplePrefix, mappedValues, Markers.EMPTY));
        });
    }

    @Override
    public Hcl visitUnaryOp(HCLParser.UnaryOpContext ctx) {
        return this.convert(ctx, (c, prefix) -> {
            Hcl.Unary.Type op;
            if (ctx.MINUS() != null) {
                this.skip(ctx.MINUS());
                op = Hcl.Unary.Type.Negative;
            } else {
                this.skip(ctx.NOT());
                op = Hcl.Unary.Type.Not;
            }
            return new Hcl.Unary(Tree.randomId(), Space.format(prefix), Markers.EMPTY, op, (Expression)this.visit((ParseTree)c.exprTerm()));
        });
    }

    @Override
    public Hcl visitVariableExpr(HCLParser.VariableExprContext ctx) {
        return this.convert(ctx, (c, prefix) -> {
            Hcl.Identifier ident = this.visitIdentifier(c.Identifier());
            return new Hcl.VariableExpression(Tree.randomId(), Space.format(prefix), Markers.EMPTY, ident);
        });
    }

    private @NonNull Hcl.Identifier visitIdentifier(TerminalNode identifier) {
        Hcl.Identifier ident = new Hcl.Identifier(Tree.randomId(), Space.format(this.prefix(identifier)), Markers.EMPTY, identifier.getText());
        this.skip(identifier);
        return ident;
    }

    private String prefix(ParserRuleContext ctx) {
        return this.prefix(ctx.getStart());
    }

    private String prefix(Token token) {
        int start = token.getStartIndex();
        if (start < this.cursor) {
            return "";
        }
        String prefix = this.source.substring(this.cursor, start);
        this.cursor = start;
        return prefix;
    }

    private String prefix(@Nullable TerminalNode terminalNode) {
        return terminalNode == null ? "" : this.prefix(terminalNode.getSymbol());
    }

    private <C extends ParserRuleContext, T> @Nullable T convert(C ctx, BiFunction<C, String, T> conversion) {
        if (ctx == null) {
            return null;
        }
        T t = conversion.apply(ctx, this.prefix(ctx));
        if (ctx.getStop() != null) {
            this.cursor = ctx.getStop().getStopIndex() + (Character.isWhitespace(this.source.charAt(ctx.getStop().getStopIndex())) ? 0 : 1);
        }
        return t;
    }

    private String skip(TerminalNode node) {
        String prefix = this.prefix(node);
        this.cursor = node.getSymbol().getStopIndex() + 1;
        return prefix;
    }

    private Space sourceBefore(String untilDelim) {
        return this.sourceBefore(untilDelim, null);
    }

    private Space sourceBefore(String untilDelim, @Nullable Character stop) {
        int delimIndex = this.positionOfNext(untilDelim, stop);
        if (delimIndex < 0) {
            return Space.EMPTY;
        }
        String prefix = this.source.substring(this.cursor, delimIndex);
        this.cursor += prefix.length() + untilDelim.length();
        return Space.format(prefix);
    }

    private int positionOfNext(String untilDelim, @Nullable Character stop) {
        int delimIndex;
        boolean inMultiLineComment = false;
        boolean inSingleLineComment = false;
        for (delimIndex = this.cursor; delimIndex < this.source.length() - untilDelim.length() + 1; ++delimIndex) {
            if (inSingleLineComment && this.source.charAt(delimIndex) == '\n') {
                inSingleLineComment = false;
                continue;
            }
            if (this.source.length() - untilDelim.length() > delimIndex + 1) {
                if ('#' == this.source.charAt(delimIndex)) {
                    inSingleLineComment = true;
                    ++delimIndex;
                } else {
                    switch (this.source.substring(delimIndex, delimIndex + 2)) {
                        case "//": 
                        case "/*": {
                            inMultiLineComment = true;
                            ++delimIndex;
                            break;
                        }
                        case "*/": {
                            inMultiLineComment = false;
                            delimIndex += 2;
                        }
                    }
                }
            }
            if (inMultiLineComment || inSingleLineComment) continue;
            if (stop != null && this.source.charAt(delimIndex) == stop.charValue()) {
                return -1;
            }
            if (this.source.startsWith(untilDelim, delimIndex)) break;
        }
        return delimIndex > this.source.length() - untilDelim.length() ? -1 : delimIndex;
    }
}

