/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl.search;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.hcl.HclIsoVisitor;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.AlreadyReplaced;
import org.openrewrite.marker.Marker;

public final class FindAndReplaceLiteral
extends Recipe {
    @Option(displayName="Find", description="The literal to find (and replace)", example="blacklist")
    private final String find;
    @Option(displayName="Replace", description="The replacement literal for `find`. This snippet can be multiline.", example="denylist", required=false)
    @Nullable
    private final String replace;
    @Option(displayName="Regex", description="Default false. If true, `find` will be interpreted as a Regular Expression, and capture group contents will be available in `replace`.", required=false)
    @Nullable
    private final Boolean regex;
    @Option(displayName="Case sensitive", description="If `true` the search will be sensitive to case. Default `false`.", required=false)
    @Nullable
    private final Boolean caseSensitive;

    public String getDisplayName() {
        return "Find and replace literals in HCL files";
    }

    public String getDescription() {
        return "Find and replace literal values in HCL files. This recipe parses the source files on which it runs as HCL, meaning you can execute HCL language-specific recipes before and after this recipe in a single recipe run.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new HclIsoVisitor<ExecutionContext>(){

            @Override
            public Hcl.Literal visitLiteral(Hcl.Literal literal, ExecutionContext ctx) {
                String replacement;
                Pattern pattern;
                Matcher matcher;
                for (AlreadyReplaced alreadyReplaced : literal.getMarkers().findAll(AlreadyReplaced.class)) {
                    if (!Objects.equals(FindAndReplaceLiteral.this.find, alreadyReplaced.getFind()) || !Objects.equals(FindAndReplaceLiteral.this.replace, alreadyReplaced.getReplace())) continue;
                    return literal;
                }
                String searchStr = FindAndReplaceLiteral.this.find;
                if (!Boolean.TRUE.equals(FindAndReplaceLiteral.this.regex)) {
                    searchStr = Pattern.quote(searchStr);
                }
                int patternOptions = 0;
                if (!Boolean.TRUE.equals(FindAndReplaceLiteral.this.caseSensitive)) {
                    patternOptions |= 2;
                }
                if (!(matcher = (pattern = Pattern.compile(searchStr, patternOptions)).matcher(literal.getValue().toString())).find()) {
                    return literal;
                }
                String string = replacement = FindAndReplaceLiteral.this.replace == null ? "" : FindAndReplaceLiteral.this.replace;
                if (!Boolean.TRUE.equals(FindAndReplaceLiteral.this.regex)) {
                    replacement = replacement.replace("$", "\\$");
                }
                String newLiteral = matcher.replaceAll(replacement);
                return literal.withValue(newLiteral).withValueSource(newLiteral).withMarkers(literal.getMarkers().add((Marker)new AlreadyReplaced(Tree.randomId(), FindAndReplaceLiteral.this.find, FindAndReplaceLiteral.this.replace)));
            }
        };
    }

    @Generated
    public FindAndReplaceLiteral(String find, @Nullable String replace, @Nullable Boolean regex, @Nullable Boolean caseSensitive) {
        this.find = find;
        this.replace = replace;
        this.regex = regex;
        this.caseSensitive = caseSensitive;
    }

    @Generated
    public String getFind() {
        return this.find;
    }

    @Nullable
    @Generated
    public String getReplace() {
        return this.replace;
    }

    @Nullable
    @Generated
    public Boolean getRegex() {
        return this.regex;
    }

    @Nullable
    @Generated
    public Boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindAndReplaceLiteral(find=" + this.getFind() + ", replace=" + this.getReplace() + ", regex=" + this.getRegex() + ", caseSensitive=" + this.getCaseSensitive() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindAndReplaceLiteral)) {
            return false;
        }
        FindAndReplaceLiteral other = (FindAndReplaceLiteral)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$regex = this.getRegex();
        Boolean other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !((Object)this$regex).equals(other$regex)) {
            return false;
        }
        Boolean this$caseSensitive = this.getCaseSensitive();
        Boolean other$caseSensitive = other.getCaseSensitive();
        if (this$caseSensitive == null ? other$caseSensitive != null : !((Object)this$caseSensitive).equals(other$caseSensitive)) {
            return false;
        }
        String this$find = this.getFind();
        String other$find = other.getFind();
        if (this$find == null ? other$find != null : !this$find.equals(other$find)) {
            return false;
        }
        String this$replace = this.getReplace();
        String other$replace = other.getReplace();
        return !(this$replace == null ? other$replace != null : !this$replace.equals(other$replace));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindAndReplaceLiteral;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : ((Object)$regex).hashCode());
        Boolean $caseSensitive = this.getCaseSensitive();
        result = result * 59 + ($caseSensitive == null ? 43 : ((Object)$caseSensitive).hashCode());
        String $find = this.getFind();
        result = result * 59 + ($find == null ? 43 : $find.hashCode());
        String $replace = this.getReplace();
        result = result * 59 + ($replace == null ? 43 : $replace.hashCode());
        return result;
    }
}

