/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl.internal;

import java.util.List;
import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.hcl.HclVisitor;
import org.openrewrite.hcl.tree.Comment;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.hcl.tree.HclContainer;
import org.openrewrite.hcl.tree.HclLeftPadded;
import org.openrewrite.hcl.tree.HclRightPadded;
import org.openrewrite.hcl.tree.Space;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class HclPrinter<P>
extends HclVisitor<PrintOutputCapture<P>> {
    private static final UnaryOperator<String> HCL_MARKER_WRAPPER = out -> "/*~~" + out + (out.isEmpty() ? "" : "~~") + ">*/";

    @Override
    public Space visitSpace(Space space, Space.Location loc, PrintOutputCapture<P> p) {
        p.append(space.getWhitespace());
        for (Comment comment : space.getComments()) {
            this.visitMarkers(comment.getMarkers(), p);
            switch (comment.getStyle()) {
                case LINE_SLASH: {
                    p.append("//").append(comment.getText());
                    break;
                }
                case LINE_HASH: {
                    p.append("#").append(comment.getText());
                    break;
                }
                case INLINE: {
                    p.append("/*").append(comment.getText()).append("*/");
                }
            }
            p.append(comment.getSuffix());
        }
        return space;
    }

    protected void visitLeftPadded(@Nullable String prefix, @Nullable HclLeftPadded<? extends Hcl> leftPadded, HclLeftPadded.Location location, PrintOutputCapture<P> p) {
        if (leftPadded != null) {
            this.beforeSyntax(leftPadded.getBefore(), leftPadded.getMarkers(), location.getBeforeLocation(), p);
            if (prefix != null) {
                p.append(prefix);
            }
            this.visit(leftPadded.getElement(), p);
            this.afterSyntax(leftPadded.getMarkers(), p);
        }
    }

    protected void visitRightPadded(List<? extends HclRightPadded<? extends Hcl>> nodes, HclRightPadded.Location location, String suffixBetween, PrintOutputCapture<P> p) {
        for (int i = 0; i < nodes.size(); ++i) {
            HclRightPadded<? extends Hcl> node = nodes.get(i);
            this.beforeSyntax(Space.EMPTY, node.getMarkers(), null, p);
            this.visit(node.getElement(), p);
            this.visitSpace(node.getAfter(), location.getAfterLocation(), p);
            if (i < nodes.size() - 1) {
                p.append(suffixBetween);
            }
            this.afterSyntax(node.getMarkers(), p);
        }
    }

    protected void visitContainer(String before, @Nullable HclContainer<? extends Hcl> container, HclContainer.Location location, String suffixBetween, @Nullable String after, PrintOutputCapture<P> p) {
        if (container == null) {
            return;
        }
        this.beforeSyntax(container.getBefore(), container.getMarkers(), location.getBeforeLocation(), p);
        p.append(before);
        this.visitRightPadded(container.getPadding().getElements(), location.getElementLocation(), suffixBetween, p);
        p.append(after == null ? "" : after);
        this.afterSyntax(container.getMarkers(), p);
    }

    @Override
    public Hcl visitAttribute(Hcl.Attribute attribute, PrintOutputCapture<P> p) {
        this.beforeSyntax(attribute, Space.Location.ATTRIBUTE, p);
        this.visit(attribute.getName(), p);
        this.visitSpace(attribute.getPadding().getType().getBefore(), Space.Location.ATTRIBUTE_ASSIGNMENT, p);
        p.append(attribute.getType().equals((Object)Hcl.Attribute.Type.Assignment) ? "=" : ":");
        this.visit(attribute.getValue(), p);
        if (attribute.getComma() != null) {
            this.visitSpace(attribute.getComma().getPrefix(), Space.Location.OBJECT_VALUE_ATTRIBUTE_COMMA, p);
            p.append(",");
        }
        this.afterSyntax(attribute, p);
        return attribute;
    }

    @Override
    public Hcl visitAttributeAccess(Hcl.AttributeAccess attributeAccess, PrintOutputCapture<P> p) {
        this.beforeSyntax(attributeAccess, Space.Location.ATTRIBUTE_ACCESS, p);
        this.visit(attributeAccess.getAttribute(), p);
        this.visitLeftPadded(".", attributeAccess.getPadding().getName(), HclLeftPadded.Location.ATTRIBUTE_ACCESS_NAME, p);
        this.afterSyntax(attributeAccess, p);
        return attributeAccess;
    }

    @Override
    public Hcl visitBinary(Hcl.Binary binary, PrintOutputCapture<P> p) {
        this.beforeSyntax(binary, Space.Location.BINARY, p);
        this.visit(binary.getLeft(), p);
        this.visitSpace(binary.getPadding().getOperator().getBefore(), Space.Location.BINARY_OPERATOR, p);
        switch (binary.getOperator()) {
            case Addition: {
                p.append('+');
                break;
            }
            case Subtraction: {
                p.append('-');
                break;
            }
            case Multiplication: {
                p.append('*');
                break;
            }
            case Division: {
                p.append('/');
                break;
            }
            case Modulo: {
                p.append('%');
                break;
            }
            case LessThan: {
                p.append('<');
                break;
            }
            case GreaterThan: {
                p.append('>');
                break;
            }
            case LessThanOrEqual: {
                p.append("<=");
                break;
            }
            case GreaterThanOrEqual: {
                p.append(">=");
                break;
            }
            case Equal: {
                p.append("==");
                break;
            }
            case NotEqual: {
                p.append("!=");
                break;
            }
            case Or: {
                p.append("||");
                break;
            }
            case And: {
                p.append("&&");
            }
        }
        this.visit(binary.getRight(), p);
        this.afterSyntax(binary, p);
        return binary;
    }

    @Override
    public Hcl visitBlock(Hcl.Block block, PrintOutputCapture<P> p) {
        this.beforeSyntax(block, Space.Location.BLOCK, p);
        this.visit(block.getType(), p);
        this.visit(block.getLabels(), p);
        this.visitSpace(block.getOpen(), Space.Location.BLOCK_OPEN, p);
        p.append('{');
        this.visit(block.getBody(), p);
        this.visitSpace(block.getEnd(), Space.Location.BLOCK_CLOSE, p);
        p.append('}');
        this.afterSyntax(block, p);
        return block;
    }

    @Override
    public Hcl visitConditional(Hcl.Conditional conditional, PrintOutputCapture<P> p) {
        this.beforeSyntax(conditional, Space.Location.CONDITIONAL, p);
        this.visit(conditional.getCondition(), p);
        this.visitLeftPadded("?", conditional.getPadding().getTruePart(), HclLeftPadded.Location.CONDITIONAL_TRUE, p);
        this.visitLeftPadded(":", conditional.getPadding().getFalsePart(), HclLeftPadded.Location.CONDITIONAL_FALSE, p);
        this.afterSyntax(conditional, p);
        return conditional;
    }

    @Override
    public Hcl visitConfigFile(Hcl.ConfigFile configFile, PrintOutputCapture<P> p) {
        this.beforeSyntax(configFile, Space.Location.CONFIG_FILE, p);
        this.visit(configFile.getBody(), p);
        this.visitSpace(configFile.getEof(), Space.Location.CONFIG_FILE_EOF, p);
        this.afterSyntax(configFile, p);
        return configFile;
    }

    @Override
    public Hcl visitForIntro(Hcl.ForIntro forIntro, PrintOutputCapture<P> p) {
        this.beforeSyntax(forIntro, Space.Location.FOR_INTRO, p);
        this.visitContainer("for", forIntro.getPadding().getVariables(), HclContainer.Location.FOR_VARIABLES, ",", "in", p);
        this.visit(forIntro.getIn(), p);
        this.afterSyntax(forIntro, p);
        return forIntro;
    }

    @Override
    public Hcl visitForObject(Hcl.ForObject forObject, PrintOutputCapture<P> p) {
        this.beforeSyntax(forObject, Space.Location.FOR_OBJECT, p);
        p.append("{");
        this.visit(forObject.getIntro(), p);
        this.visitLeftPadded(":", forObject.getPadding().getUpdateName(), HclLeftPadded.Location.FOR_UPDATE, p);
        this.visitLeftPadded("=>", forObject.getPadding().getUpdateValue(), HclLeftPadded.Location.FOR_UPDATE_VALUE, p);
        if (forObject.getEllipsis() != null) {
            this.visitSpace(forObject.getEllipsis().getPrefix(), Space.Location.FOR_UPDATE_VALUE_ELLIPSIS, p);
            p.append("...");
        }
        if (forObject.getPadding().getCondition() != null) {
            this.visitLeftPadded("if", forObject.getPadding().getCondition(), HclLeftPadded.Location.FOR_CONDITION, p);
        }
        this.visitSpace(forObject.getEnd(), Space.Location.FOR_OBJECT_SUFFIX, p);
        p.append("}");
        this.afterSyntax(forObject, p);
        return forObject;
    }

    @Override
    public Hcl visitForTuple(Hcl.ForTuple forTuple, PrintOutputCapture<P> p) {
        this.beforeSyntax(forTuple, Space.Location.FOR_TUPLE, p);
        p.append("[");
        this.visit(forTuple.getIntro(), p);
        this.visitLeftPadded(":", forTuple.getPadding().getUpdate(), HclLeftPadded.Location.FOR_UPDATE, p);
        if (forTuple.getPadding().getCondition() != null) {
            this.visitLeftPadded("if", forTuple.getPadding().getCondition(), HclLeftPadded.Location.FOR_CONDITION, p);
        }
        this.visitSpace(forTuple.getEnd(), Space.Location.FOR_TUPLE_SUFFIX, p);
        p.append("]");
        this.afterSyntax(forTuple, p);
        return forTuple;
    }

    @Override
    public Hcl visitFunctionCall(Hcl.FunctionCall functionCall, PrintOutputCapture<P> p) {
        this.beforeSyntax(functionCall, Space.Location.FUNCTION_CALL, p);
        this.visit(functionCall.getName(), p);
        this.visitContainer("(", functionCall.getPadding().getArguments(), HclContainer.Location.FUNCTION_CALL_ARGUMENTS, ",", ")", p);
        this.afterSyntax(functionCall, p);
        return functionCall;
    }

    @Override
    public Hcl visitHeredocTemplate(Hcl.HeredocTemplate heredocTemplate, PrintOutputCapture<P> p) {
        this.beforeSyntax(heredocTemplate, Space.Location.HEREDOC, p);
        p.append(heredocTemplate.getArrow());
        this.visit(heredocTemplate.getDelimiter(), p);
        this.visit(heredocTemplate.getExpressions(), p);
        this.visitSpace(heredocTemplate.getEnd(), Space.Location.HEREDOC_END, p);
        p.append(heredocTemplate.getDelimiter().getName());
        this.afterSyntax(heredocTemplate, p);
        return heredocTemplate;
    }

    @Override
    public Hcl visitIdentifier(Hcl.Identifier identifier, PrintOutputCapture<P> p) {
        this.beforeSyntax(identifier, Space.Location.IDENTIFIER, p);
        p.append(identifier.getName());
        this.afterSyntax(identifier, p);
        return identifier;
    }

    @Override
    public Hcl visitIndex(Hcl.Index index, PrintOutputCapture<P> p) {
        this.beforeSyntax(index, Space.Location.INDEX, p);
        this.visit(index.getIndexed(), p);
        this.visit(index.getPosition(), p);
        this.afterSyntax(index, p);
        return index;
    }

    @Override
    public Hcl visitIndexPosition(Hcl.Index.Position indexPosition, PrintOutputCapture<P> p) {
        this.beforeSyntax(indexPosition, Space.Location.INDEX_POSITION, p);
        p.append("[");
        this.visitMarkers(indexPosition.getMarkers(), p);
        this.visitRightPadded(indexPosition.getPadding().getPosition(), HclRightPadded.Location.INDEX_POSITION, p);
        p.append("]");
        this.afterSyntax(indexPosition, p);
        return indexPosition;
    }

    @Override
    public Hcl visitLiteral(Hcl.Literal literal, PrintOutputCapture<P> p) {
        this.beforeSyntax(literal, Space.Location.LITERAL, p);
        p.append(literal.getValueSource());
        this.afterSyntax(literal, p);
        return literal;
    }

    @Override
    public Hcl visitObjectValue(Hcl.ObjectValue objectValue, PrintOutputCapture<P> p) {
        this.beforeSyntax(objectValue, Space.Location.OBJECT_VALUE, p);
        this.visitContainer("{", objectValue.getPadding().getAttributes(), HclContainer.Location.OBJECT_VALUE_ATTRIBUTES, "", "}", p);
        this.afterSyntax(objectValue, p);
        return objectValue;
    }

    @Override
    public Hcl visitParentheses(Hcl.Parentheses parentheses, PrintOutputCapture<P> p) {
        this.beforeSyntax(parentheses, Space.Location.PARENTHETICAL_EXPRESSION, p);
        p.append('(');
        this.visitRightPadded(parentheses.getPadding().getExpression(), HclRightPadded.Location.PARENTHESES, p);
        p.append(')');
        this.afterSyntax(parentheses, p);
        return parentheses;
    }

    @Override
    public Hcl visitQuotedTemplate(Hcl.QuotedTemplate template, PrintOutputCapture<P> p) {
        this.beforeSyntax(template, Space.Location.QUOTED_TEMPLATE, p);
        p.append('\"');
        this.visit(template.getExpressions(), p);
        p.append('\"');
        this.afterSyntax(template, p);
        return template;
    }

    @Override
    public Hcl visitTemplateInterpolation(Hcl.TemplateInterpolation template, PrintOutputCapture<P> p) {
        this.beforeSyntax(template, Space.Location.TEMPLATE_INTERPOLATION, p);
        p.append("${");
        this.visit(template.getExpression(), p);
        p.append('}');
        this.afterSyntax(template, p);
        return template;
    }

    @Override
    public Hcl visitSplat(Hcl.Splat splat, PrintOutputCapture<P> p) {
        this.beforeSyntax(splat, Space.Location.ATTRIBUTE_ACCESS, p);
        this.visit(splat.getSelect(), p);
        this.visit(splat.getOperator(), p);
        this.afterSyntax(splat, p);
        return splat;
    }

    @Override
    public Hcl visitSplatOperator(Hcl.Splat.Operator splatOperator, PrintOutputCapture<P> p) {
        this.beforeSyntax(splatOperator, Space.Location.SPLAT_OPERATOR, p);
        if (splatOperator.getType().equals((Object)Hcl.Splat.Operator.Type.Full)) {
            p.append('[');
        } else {
            p.append('.');
        }
        this.visitSpace(splatOperator.getSplat().getElement().getPrefix(), Space.Location.SPLAT_OPERATOR_PREFIX, p);
        p.append('*');
        if (splatOperator.getType().equals((Object)Hcl.Splat.Operator.Type.Full)) {
            this.visitSpace(splatOperator.getSplat().getAfter(), Space.Location.SPLAT_OPERATOR_SUFFIX, p);
            p.append(']');
        }
        this.afterSyntax(splatOperator, p);
        return splatOperator;
    }

    @Override
    public Hcl visitTuple(Hcl.Tuple tuple, PrintOutputCapture<P> p) {
        this.beforeSyntax(tuple, Space.Location.FUNCTION_CALL, p);
        this.visitContainer("[", tuple.getPadding().getValues(), HclContainer.Location.TUPLE_VALUES, ",", "]", p);
        this.afterSyntax(tuple, p);
        return tuple;
    }

    @Override
    public Hcl visitUnary(Hcl.Unary unary, PrintOutputCapture<P> p) {
        this.beforeSyntax(unary, Space.Location.UNARY, p);
        switch (unary.getOperator()) {
            case Negative: {
                p.append('-');
                break;
            }
            case Not: {
                p.append('!');
            }
        }
        this.visit(unary.getExpression(), p);
        this.afterSyntax(unary, p);
        return unary;
    }

    @Override
    public Hcl visitVariableExpression(Hcl.VariableExpression variableExpression, PrintOutputCapture<P> p) {
        this.beforeSyntax(variableExpression, Space.Location.VARIABLE_EXPRESSION, p);
        this.visit(variableExpression.getName(), p);
        this.afterSyntax(variableExpression, p);
        return variableExpression;
    }

    private void beforeSyntax(Hcl h, Space.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(h.getPrefix(), h.getMarkers(), loc, p);
    }

    private void beforeSyntax(Space prefix, Markers markers, @Nullable Space.Location loc, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), HCL_MARKER_WRAPPER));
        }
        if (loc != null) {
            this.visitSpace(prefix, loc, p);
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), HCL_MARKER_WRAPPER));
        }
    }

    private void afterSyntax(Hcl h, PrintOutputCapture<P> p) {
        this.afterSyntax(h.getMarkers(), p);
    }

    private void afterSyntax(Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), (Object)marker), HCL_MARKER_WRAPPER));
        }
    }
}

