/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.hcl.HclIsoVisitor;
import org.openrewrite.hcl.HclParser;
import org.openrewrite.hcl.JsonPathMatcher;
import org.openrewrite.hcl.tree.BodyContent;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.hcl.tree.Space;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class MoveContentToFile
extends Recipe {
    @Option(displayName="Content path", description="A JSONPath expression specifying the block to move.", example="$.provider")
    private final String contentPath;
    @Option(displayName="From path", description="The source path of the file from which content is being moved.", example="from.tf")
    private final String fromPath;
    @Option(displayName="To path", description="The source path of the file to move the content to.", example="to.tf")
    private final String destinationPath;

    public String getDisplayName() {
        return "Move content to another file";
    }

    public String getDescription() {
        return "Move content to another HCL file, deleting it in the original file.";
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        final AtomicReference toMove = new AtomicReference();
        final JsonPathMatcher pathMatcher = new JsonPathMatcher(this.contentPath);
        Path from = Paths.get(this.fromPath, new String[0]);
        List after = ListUtils.map(before, sourceFile -> sourceFile.getSourcePath().equals(from) ? (SourceFile)new HclIsoVisitor<ExecutionContext>(){

            @Override
            public BodyContent visitBodyContent(BodyContent bodyContent, ExecutionContext ctx) {
                Hcl b = super.visitBodyContent(bodyContent, ctx);
                if (pathMatcher.matches(this.getCursor())) {
                    toMove.set(bodyContent);
                    return null;
                }
                return b;
            }
        }.visit((Tree)sourceFile, ctx) : sourceFile);
        if (toMove.get() == null) {
            return before;
        }
        Path dest = Paths.get(this.destinationPath, new String[0]);
        if (after.stream().anyMatch(sourceFile -> sourceFile.getSourcePath().equals(dest))) {
            return ListUtils.map((List)after, sourceFile -> {
                if (sourceFile.getSourcePath().equals(dest)) {
                    return (SourceFile)new HclIsoVisitor<ExecutionContext>(){

                        @Override
                        public BodyContent visitBodyContent(BodyContent bodyContent, ExecutionContext ctx) {
                            Hcl b = super.visitBodyContent(bodyContent, ctx);
                            if (pathMatcher.matches(this.getCursor())) {
                                return (BodyContent)toMove.get();
                            }
                            return b;
                        }
                    }.visit((Tree)sourceFile, ctx);
                }
                return sourceFile;
            });
        }
        Hcl.ConfigFile configFile = (Hcl.ConfigFile)HclParser.builder().build().parse(new String[]{""}).get(0);
        configFile = configFile.withBody(Collections.singletonList(((BodyContent)toMove.get()).withPrefix(Space.EMPTY))).withSourcePath(dest);
        return ListUtils.concat((List)after, (Object)configFile);
    }

    public MoveContentToFile(String contentPath, String fromPath, String destinationPath) {
        this.contentPath = contentPath;
        this.fromPath = fromPath;
        this.destinationPath = destinationPath;
    }

    public String getContentPath() {
        return this.contentPath;
    }

    public String getFromPath() {
        return this.fromPath;
    }

    public String getDestinationPath() {
        return this.destinationPath;
    }

    @NonNull
    public String toString() {
        return "MoveContentToFile(contentPath=" + this.getContentPath() + ", fromPath=" + this.getFromPath() + ", destinationPath=" + this.getDestinationPath() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MoveContentToFile)) {
            return false;
        }
        MoveContentToFile other = (MoveContentToFile)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$contentPath = this.getContentPath();
        String other$contentPath = other.getContentPath();
        if (this$contentPath == null ? other$contentPath != null : !this$contentPath.equals(other$contentPath)) {
            return false;
        }
        String this$fromPath = this.getFromPath();
        String other$fromPath = other.getFromPath();
        if (this$fromPath == null ? other$fromPath != null : !this$fromPath.equals(other$fromPath)) {
            return false;
        }
        String this$destinationPath = this.getDestinationPath();
        String other$destinationPath = other.getDestinationPath();
        return !(this$destinationPath == null ? other$destinationPath != null : !this$destinationPath.equals(other$destinationPath));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MoveContentToFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $contentPath = this.getContentPath();
        result = result * 59 + ($contentPath == null ? 43 : $contentPath.hashCode());
        String $fromPath = this.getFromPath();
        result = result * 59 + ($fromPath == null ? 43 : $fromPath.hashCode());
        String $destinationPath = this.getDestinationPath();
        result = result * 59 + ($destinationPath == null ? 43 : $destinationPath.hashCode());
        return result;
    }
}

