/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl.internal;

import java.util.List;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.hcl.HclVisitor;
import org.openrewrite.hcl.tree.Comment;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.hcl.tree.HclContainer;
import org.openrewrite.hcl.tree.HclLeftPadded;
import org.openrewrite.hcl.tree.HclRightPadded;
import org.openrewrite.hcl.tree.Space;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;

public class HclPrinter<P>
extends HclVisitor<PrintOutputCapture<P>> {
    @Override
    public Space visitSpace(Space space, Space.Location loc, PrintOutputCapture<P> p) {
        p.out.append(space.getWhitespace());
        for (Comment comment : space.getComments()) {
            this.visitMarkers(comment.getMarkers(), p);
            switch (comment.getStyle()) {
                case LINE_SLASH: {
                    p.out.append("//").append(comment.getText());
                    break;
                }
                case LINE_HASH: {
                    p.out.append("#").append(comment.getText());
                    break;
                }
                case INLINE: {
                    p.out.append("/*").append(comment.getText()).append("*/");
                }
            }
            p.out.append(comment.getSuffix());
        }
        return space;
    }

    protected void visitLeftPadded(@Nullable String prefix, @Nullable HclLeftPadded<? extends Hcl> leftPadded, HclLeftPadded.Location location, PrintOutputCapture<P> p) {
        if (leftPadded != null) {
            this.visitSpace(leftPadded.getBefore(), location.getBeforeLocation(), p);
            if (prefix != null) {
                p.out.append(prefix);
            }
            this.visit(leftPadded.getElement(), p);
        }
    }

    protected void visitRightPadded(List<? extends HclRightPadded<? extends Hcl>> nodes, HclRightPadded.Location location, String suffixBetween, PrintOutputCapture<P> p) {
        for (int i = 0; i < nodes.size(); ++i) {
            HclRightPadded<? extends Hcl> node = nodes.get(i);
            this.visit(node.getElement(), p);
            this.visitSpace(node.getAfter(), location.getAfterLocation(), p);
            if (i >= nodes.size() - 1) continue;
            p.out.append(suffixBetween);
        }
    }

    protected void visitContainer(String before, @Nullable HclContainer<? extends Hcl> container, HclContainer.Location location, String suffixBetween, @Nullable String after, PrintOutputCapture<P> p) {
        if (container == null) {
            return;
        }
        this.visitSpace(container.getBefore(), location.getBeforeLocation(), p);
        p.out.append(before);
        this.visitRightPadded(container.getPadding().getElements(), location.getElementLocation(), suffixBetween, p);
        p.out.append(after == null ? "" : after);
    }

    @Override
    public Hcl visitAttribute(Hcl.Attribute attribute, PrintOutputCapture<P> p) {
        this.visitSpace(attribute.getPrefix(), Space.Location.ATTRIBUTE, p);
        this.visitMarkers(attribute.getMarkers(), p);
        this.visit(attribute.getName(), p);
        this.visitSpace(attribute.getPadding().getType().getBefore(), Space.Location.ATTRIBUTE_ASSIGNMENT, p);
        p.out.append(attribute.getType().equals((Object)Hcl.Attribute.Type.Assignment) ? "=" : ":");
        this.visit(attribute.getValue(), p);
        if (attribute.getComma() != null) {
            this.visitSpace(attribute.getComma().getPrefix(), Space.Location.OBJECT_VALUE_ATTRIBUTE_COMMA, p);
            p.out.append(",");
        }
        return attribute;
    }

    @Override
    public Hcl visitAttributeAccess(Hcl.AttributeAccess attributeAccess, PrintOutputCapture<P> p) {
        this.visitSpace(attributeAccess.getPrefix(), Space.Location.ATTRIBUTE_ACCESS, p);
        this.visitMarkers(attributeAccess.getMarkers(), p);
        this.visit(attributeAccess.getAttribute(), p);
        this.visitLeftPadded(".", attributeAccess.getPadding().getName(), HclLeftPadded.Location.ATTRIBUTE_ACCESS_NAME, p);
        return attributeAccess;
    }

    @Override
    public Hcl visitBinary(Hcl.Binary binary, PrintOutputCapture<P> p) {
        this.visitSpace(binary.getPrefix(), Space.Location.BINARY, p);
        this.visitMarkers(binary.getMarkers(), p);
        this.visit(binary.getLeft(), p);
        this.visitSpace(binary.getPadding().getOperator().getBefore(), Space.Location.BINARY_OPERATOR, p);
        switch (binary.getOperator()) {
            case Addition: {
                p.out.append('+');
                break;
            }
            case Subtraction: {
                p.out.append('-');
                break;
            }
            case Multiplication: {
                p.out.append('*');
                break;
            }
            case Division: {
                p.out.append('/');
                break;
            }
            case Modulo: {
                p.out.append('%');
                break;
            }
            case LessThan: {
                p.out.append('<');
                break;
            }
            case GreaterThan: {
                p.out.append('>');
                break;
            }
            case LessThanOrEqual: {
                p.out.append("<=");
                break;
            }
            case GreaterThanOrEqual: {
                p.out.append(">=");
                break;
            }
            case Equal: {
                p.out.append("==");
                break;
            }
            case NotEqual: {
                p.out.append("!=");
                break;
            }
            case Or: {
                p.out.append("||");
                break;
            }
            case And: {
                p.out.append("&&");
            }
        }
        this.visit(binary.getRight(), p);
        return binary;
    }

    @Override
    public Hcl visitBlock(Hcl.Block block, PrintOutputCapture<P> p) {
        this.visitSpace(block.getPrefix(), Space.Location.BLOCK, p);
        this.visitMarkers(block.getMarkers(), p);
        this.visit(block.getType(), p);
        this.visit(block.getLabels(), p);
        this.visitSpace(block.getOpen(), Space.Location.BLOCK_OPEN, p);
        p.out.append('{');
        this.visit(block.getBody(), p);
        this.visitSpace(block.getEnd(), Space.Location.BLOCK_CLOSE, p);
        p.out.append('}');
        return block;
    }

    @Override
    public Hcl visitConditional(Hcl.Conditional conditional, PrintOutputCapture<P> p) {
        this.visitSpace(conditional.getPrefix(), Space.Location.CONDITIONAL, p);
        this.visitMarkers(conditional.getMarkers(), p);
        this.visit(conditional.getCondition(), p);
        this.visitLeftPadded("?", conditional.getPadding().getTruePart(), HclLeftPadded.Location.CONDITIONAL_TRUE, p);
        this.visitLeftPadded(":", conditional.getPadding().getFalsePart(), HclLeftPadded.Location.CONDITIONAL_FALSE, p);
        return conditional;
    }

    @Override
    public Hcl visitConfigFile(Hcl.ConfigFile configFile, PrintOutputCapture<P> p) {
        this.visitSpace(configFile.getPrefix(), Space.Location.CONFIG_FILE, p);
        this.visitMarkers(configFile.getMarkers(), p);
        this.visit(configFile.getBody(), p);
        this.visitSpace(configFile.getEof(), Space.Location.CONFIG_FILE_EOF, p);
        return configFile;
    }

    @Override
    public Hcl visitForIntro(Hcl.ForIntro forIntro, PrintOutputCapture<P> p) {
        this.visitSpace(forIntro.getPrefix(), Space.Location.FOR_INTRO, p);
        this.visitMarkers(forIntro.getMarkers(), p);
        this.visitContainer("for", forIntro.getPadding().getVariables(), HclContainer.Location.FOR_VARIABLES, ",", "in", p);
        this.visit(forIntro.getIn(), p);
        return forIntro;
    }

    @Override
    public Hcl visitForObject(Hcl.ForObject forObject, PrintOutputCapture<P> p) {
        this.visitSpace(forObject.getPrefix(), Space.Location.FOR_OBJECT, p);
        this.visitMarkers(forObject.getMarkers(), p);
        p.out.append("{");
        this.visit(forObject.getIntro(), p);
        this.visitLeftPadded(":", forObject.getPadding().getUpdateName(), HclLeftPadded.Location.FOR_UPDATE, p);
        this.visitLeftPadded("=>", forObject.getPadding().getUpdateValue(), HclLeftPadded.Location.FOR_UPDATE_VALUE, p);
        if (forObject.getEllipsis() != null) {
            this.visitSpace(forObject.getEllipsis().getPrefix(), Space.Location.FOR_UPDATE_VALUE_ELLIPSIS, p);
            p.out.append("...");
        }
        if (forObject.getPadding().getCondition() != null) {
            this.visitLeftPadded("if", forObject.getPadding().getCondition(), HclLeftPadded.Location.FOR_CONDITION, p);
        }
        this.visitSpace(forObject.getEnd(), Space.Location.FOR_OBJECT_SUFFIX, p);
        p.out.append("}");
        return forObject;
    }

    @Override
    public Hcl visitForTuple(Hcl.ForTuple forTuple, PrintOutputCapture<P> p) {
        this.visitSpace(forTuple.getPrefix(), Space.Location.FOR_TUPLE, p);
        this.visitMarkers(forTuple.getMarkers(), p);
        p.out.append("[");
        this.visit(forTuple.getIntro(), p);
        this.visitLeftPadded(":", forTuple.getPadding().getUpdate(), HclLeftPadded.Location.FOR_UPDATE, p);
        if (forTuple.getPadding().getCondition() != null) {
            this.visitLeftPadded("if", forTuple.getPadding().getCondition(), HclLeftPadded.Location.FOR_CONDITION, p);
        }
        this.visitSpace(forTuple.getEnd(), Space.Location.FOR_TUPLE_SUFFIX, p);
        p.out.append("]");
        return forTuple;
    }

    @Override
    public Hcl visitFunctionCall(Hcl.FunctionCall functionCall, PrintOutputCapture<P> p) {
        this.visitSpace(functionCall.getPrefix(), Space.Location.FUNCTION_CALL, p);
        this.visitMarkers(functionCall.getMarkers(), p);
        this.visit(functionCall.getName(), p);
        this.visitContainer("(", functionCall.getPadding().getArguments(), HclContainer.Location.FUNCTION_CALL_ARGUMENTS, ",", ")", p);
        return functionCall;
    }

    @Override
    public Hcl visitHeredocTemplate(Hcl.HeredocTemplate heredocTemplate, PrintOutputCapture<P> p) {
        this.visitSpace(heredocTemplate.getPrefix(), Space.Location.HEREDOC, p);
        this.visitMarkers(heredocTemplate.getMarkers(), p);
        p.out.append(heredocTemplate.getArrow());
        this.visit(heredocTemplate.getDelimiter(), p);
        this.visit(heredocTemplate.getExpressions(), p);
        this.visitSpace(heredocTemplate.getEnd(), Space.Location.HEREDOC_END, p);
        p.out.append(heredocTemplate.getDelimiter().getName());
        return heredocTemplate;
    }

    @Override
    public Hcl visitIdentifier(Hcl.Identifier identifier, PrintOutputCapture<P> p) {
        this.visitSpace(identifier.getPrefix(), Space.Location.IDENTIFIER, p);
        this.visitMarkers(identifier.getMarkers(), p);
        p.out.append(identifier.getName());
        return identifier;
    }

    @Override
    public Hcl visitIndex(Hcl.Index index, PrintOutputCapture<P> p) {
        this.visitSpace(index.getPrefix(), Space.Location.INDEX, p);
        this.visitMarkers(index.getMarkers(), p);
        this.visit(index.getIndexed(), p);
        this.visit(index.getPosition(), p);
        return index;
    }

    @Override
    public Hcl visitIndexPosition(Hcl.Index.Position indexPosition, PrintOutputCapture<P> p) {
        this.visitSpace(indexPosition.getPrefix(), Space.Location.INDEX_POSITION, p);
        this.visitMarkers(indexPosition.getMarkers(), p);
        p.out.append("[");
        this.visitMarkers(indexPosition.getMarkers(), p);
        this.visitRightPadded(indexPosition.getPadding().getPosition(), HclRightPadded.Location.INDEX_POSITION, p);
        p.out.append("]");
        return indexPosition;
    }

    @Override
    public Hcl visitLiteral(Hcl.Literal literal, PrintOutputCapture<P> p) {
        this.visitSpace(literal.getPrefix(), Space.Location.LITERAL, p);
        this.visitMarkers(literal.getMarkers(), p);
        p.out.append(literal.getValueSource());
        return literal;
    }

    @Override
    public Hcl visitObjectValue(Hcl.ObjectValue objectValue, PrintOutputCapture<P> p) {
        this.visitSpace(objectValue.getPrefix(), Space.Location.OBJECT_VALUE, p);
        this.visitMarkers(objectValue.getMarkers(), p);
        this.visitContainer("{", objectValue.getPadding().getAttributes(), HclContainer.Location.OBJECT_VALUE_ATTRIBUTES, "", "}", p);
        return objectValue;
    }

    @Override
    public Hcl visitParentheses(Hcl.Parentheses parentheses, PrintOutputCapture<P> p) {
        this.visitSpace(parentheses.getPrefix(), Space.Location.PARENTHETICAL_EXPRESSION, p);
        this.visitMarkers(parentheses.getMarkers(), p);
        p.out.append('(');
        this.visitRightPadded(parentheses.getPadding().getExpression(), HclRightPadded.Location.PARENTHESES, p);
        p.out.append(')');
        return parentheses;
    }

    @Override
    public Hcl visitQuotedTemplate(Hcl.QuotedTemplate template, PrintOutputCapture<P> p) {
        this.visitSpace(template.getPrefix(), Space.Location.QUOTED_TEMPLATE, p);
        this.visitMarkers(template.getMarkers(), p);
        p.out.append('\"');
        this.visit(template.getExpressions(), p);
        p.out.append('\"');
        return template;
    }

    @Override
    public Hcl visitTemplateInterpolation(Hcl.TemplateInterpolation template, PrintOutputCapture<P> p) {
        this.visitSpace(template.getPrefix(), Space.Location.TEMPLATE_INTERPOLATION, p);
        this.visitMarkers(template.getMarkers(), p);
        p.out.append("${");
        this.visit(template.getExpression(), p);
        p.out.append('}');
        return template;
    }

    @Override
    public Hcl visitSplat(Hcl.Splat splat, PrintOutputCapture<P> p) {
        this.visitSpace(splat.getPrefix(), Space.Location.ATTRIBUTE_ACCESS, p);
        this.visitMarkers(splat.getMarkers(), p);
        this.visit(splat.getSelect(), p);
        this.visit(splat.getOperator(), p);
        return splat;
    }

    @Override
    public Hcl visitSplatOperator(Hcl.Splat.Operator splatOperator, PrintOutputCapture<P> p) {
        this.visitSpace(splatOperator.getPrefix(), Space.Location.SPLAT_OPERATOR, p);
        this.visitMarkers(splatOperator.getMarkers(), p);
        if (splatOperator.getType().equals((Object)Hcl.Splat.Operator.Type.Full)) {
            p.out.append('[');
        } else {
            p.out.append('.');
        }
        this.visitSpace(splatOperator.getSplat().getElement().getPrefix(), Space.Location.SPLAT_OPERATOR_PREFIX, p);
        p.out.append('*');
        if (splatOperator.getType().equals((Object)Hcl.Splat.Operator.Type.Full)) {
            this.visitSpace(splatOperator.getSplat().getAfter(), Space.Location.SPLAT_OPERATOR_SUFFIX, p);
            p.out.append(']');
        }
        return splatOperator;
    }

    @Override
    public Hcl visitTuple(Hcl.Tuple tuple, PrintOutputCapture<P> p) {
        this.visitSpace(tuple.getPrefix(), Space.Location.FUNCTION_CALL, p);
        this.visitMarkers(tuple.getMarkers(), p);
        this.visitContainer("[", tuple.getPadding().getValues(), HclContainer.Location.TUPLE_VALUES, ",", "]", p);
        return tuple;
    }

    @Override
    public Hcl visitUnary(Hcl.Unary unary, PrintOutputCapture<P> p) {
        this.visitSpace(unary.getPrefix(), Space.Location.UNARY, p);
        this.visitMarkers(unary.getMarkers(), p);
        switch (unary.getOperator()) {
            case Negative: {
                p.out.append('-');
                break;
            }
            case Not: {
                p.out.append('!');
            }
        }
        this.visit(unary.getExpression(), p);
        return unary;
    }

    @Override
    public Hcl visitVariableExpression(Hcl.VariableExpression variableExpression, PrintOutputCapture<P> p) {
        this.visitSpace(variableExpression.getPrefix(), Space.Location.VARIABLE_EXPRESSION, p);
        this.visitMarkers(variableExpression.getMarkers(), p);
        this.visit(variableExpression.getName(), p);
        return variableExpression;
    }

    public <M extends Marker> M visitMarker(Marker marker, PrintOutputCapture<P> p) {
        if (marker instanceof SearchResult) {
            String description = ((SearchResult)marker).getDescription();
            p.out.append("/*~~").append(description == null ? "" : "(" + description + ")~~").append(">*/");
        }
        return (M)marker;
    }
}

