/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl.tree;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.Incubating;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.hcl.HclParser;
import org.openrewrite.hcl.HclVisitor;
import org.openrewrite.hcl.internal.HclPrinter;
import org.openrewrite.hcl.tree.BodyContent;
import org.openrewrite.hcl.tree.CollectionValue;
import org.openrewrite.hcl.tree.CoordinateBuilder;
import org.openrewrite.hcl.tree.Expression;
import org.openrewrite.hcl.tree.HclContainer;
import org.openrewrite.hcl.tree.HclCoordinates;
import org.openrewrite.hcl.tree.HclLeftPadded;
import org.openrewrite.hcl.tree.HclRightPadded;
import org.openrewrite.hcl.tree.Label;
import org.openrewrite.hcl.tree.Space;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.template.Coordinates;
import org.openrewrite.template.SourceTemplate;

public interface Hcl
extends Tree {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)this.acceptHcl((HclVisitor)v.adapt(HclVisitor.class), p);
    }

    @Nullable
    default public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
        return (Hcl)v.defaultValue(this, p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(HclVisitor.class);
    }

    public Space getPrefix();

    public <H extends Hcl> H withPrefix(Space var1);

    default public <H extends Hcl> H withTemplate(SourceTemplate<Hcl, HclCoordinates> template, HclCoordinates coordinates, Object ... parameters) {
        return (H)((Hcl)template.withTemplate((Tree)this, (Coordinates)coordinates, parameters));
    }

    public <T extends Hcl> T withMarkers(Markers var1);

    public Markers getMarkers();

    public static class VariableExpression
    implements Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Identifier name;

        @Override
        public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
            return v.visitVariableExpression(this, p);
        }

        public String toString() {
            return "Variable{" + this.name + "}";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VariableExpression)) {
                return false;
            }
            VariableExpression other = (VariableExpression)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof VariableExpression;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public VariableExpression(UUID id, Space prefix, Markers markers, Identifier name) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        public Identifier getName() {
            return this.name;
        }

        @NonNull
        public VariableExpression withId(UUID id) {
            return this.id == id ? this : new VariableExpression(id, this.prefix, this.markers, this.name);
        }

        @NonNull
        public VariableExpression withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new VariableExpression(this.id, prefix, this.markers, this.name);
        }

        @NonNull
        public VariableExpression withMarkers(Markers markers) {
            return this.markers == markers ? this : new VariableExpression(this.id, this.prefix, markers, this.name);
        }

        @NonNull
        public VariableExpression withName(Identifier name) {
            return this.name == name ? this : new VariableExpression(this.id, this.prefix, this.markers, name);
        }
    }

    public static class Unary
    implements Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Type operator;
        private final Expression expression;

        @Override
        public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
            return v.visitUnary(this, p);
        }

        public String toString() {
            return "Unary";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Unary)) {
                return false;
            }
            Unary other = (Unary)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Unary;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Unary(UUID id, Space prefix, Markers markers, Type operator, Expression expression) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.operator = operator;
            this.expression = expression;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        public Type getOperator() {
            return this.operator;
        }

        public Expression getExpression() {
            return this.expression;
        }

        @NonNull
        public Unary withId(UUID id) {
            return this.id == id ? this : new Unary(id, this.prefix, this.markers, this.operator, this.expression);
        }

        @NonNull
        public Unary withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Unary(this.id, prefix, this.markers, this.operator, this.expression);
        }

        @NonNull
        public Unary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Unary(this.id, this.prefix, markers, this.operator, this.expression);
        }

        @NonNull
        public Unary withOperator(Type operator) {
            return this.operator == operator ? this : new Unary(this.id, this.prefix, this.markers, operator, this.expression);
        }

        @NonNull
        public Unary withExpression(Expression expression) {
            return this.expression == expression ? this : new Unary(this.id, this.prefix, this.markers, this.operator, expression);
        }

        public static enum Type {
            Negative,
            Not;

        }
    }

    public static class Tuple
    implements CollectionValue {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final HclContainer<Expression> values;

        public List<Expression> getValues() {
            return this.values.getElements();
        }

        public Tuple withValues(List<Expression> values) {
            return this.getPadding().withValues(HclContainer.withElements(this.values, values));
        }

        @Override
        public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
            return v.visitTuple(this, p);
        }

        public String toString() {
            return "Tuple";
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tuple)) {
                return false;
            }
            Tuple other = (Tuple)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Tuple;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Tuple(UUID id, Space prefix, Markers markers, HclContainer<Expression> values) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.values = values;
        }

        private Tuple(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, HclContainer<Expression> values) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.values = values;
        }

        @NonNull
        public Tuple withId(UUID id) {
            return this.id == id ? this : new Tuple(this.padding, id, this.prefix, this.markers, this.values);
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        @NonNull
        public Tuple withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Tuple(this.padding, this.id, prefix, this.markers, this.values);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Tuple withMarkers(Markers markers) {
            return this.markers == markers ? this : new Tuple(this.padding, this.id, this.prefix, markers, this.values);
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding {
            private final Tuple t;

            public HclContainer<Expression> getValues() {
                return this.t.values;
            }

            public Tuple withValues(HclContainer<Expression> values) {
                return this.t.values == values ? this.t : new Tuple(this.t.id, this.t.prefix, this.t.markers, values);
            }

            public Padding(Tuple t) {
                this.t = t;
            }
        }
    }

    public static class TemplateInterpolation
    implements Hcl,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression expression;

        @Override
        public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
            return v.visitTemplateInterpolation(this, p);
        }

        public String toString() {
            return "TemplateInterpolation";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TemplateInterpolation)) {
                return false;
            }
            TemplateInterpolation other = (TemplateInterpolation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof TemplateInterpolation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public TemplateInterpolation(UUID id, Space prefix, Markers markers, Expression expression) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getExpression() {
            return this.expression;
        }

        @NonNull
        public TemplateInterpolation withId(UUID id) {
            return this.id == id ? this : new TemplateInterpolation(id, this.prefix, this.markers, this.expression);
        }

        @NonNull
        public TemplateInterpolation withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TemplateInterpolation(this.id, prefix, this.markers, this.expression);
        }

        @NonNull
        public TemplateInterpolation withMarkers(Markers markers) {
            return this.markers == markers ? this : new TemplateInterpolation(this.id, this.prefix, markers, this.expression);
        }

        @NonNull
        public TemplateInterpolation withExpression(Expression expression) {
            return this.expression == expression ? this : new TemplateInterpolation(this.id, this.prefix, this.markers, expression);
        }
    }

    public static class Splat
    implements Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression select;
        private final Operator operator;

        @Override
        public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
            return v.visitSplat(this, p);
        }

        public String toString() {
            return "Splat{" + this.select + "}";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Splat)) {
                return false;
            }
            Splat other = (Splat)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Splat;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Splat(UUID id, Space prefix, Markers markers, Expression select, Operator operator) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.select = select;
            this.operator = operator;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getSelect() {
            return this.select;
        }

        public Operator getOperator() {
            return this.operator;
        }

        @NonNull
        public Splat withId(UUID id) {
            return this.id == id ? this : new Splat(id, this.prefix, this.markers, this.select, this.operator);
        }

        @NonNull
        public Splat withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Splat(this.id, prefix, this.markers, this.select, this.operator);
        }

        @NonNull
        public Splat withMarkers(Markers markers) {
            return this.markers == markers ? this : new Splat(this.id, this.prefix, markers, this.select, this.operator);
        }

        @NonNull
        public Splat withSelect(Expression select) {
            return this.select == select ? this : new Splat(this.id, this.prefix, this.markers, select, this.operator);
        }

        @NonNull
        public Splat withOperator(Operator operator) {
            return this.operator == operator ? this : new Splat(this.id, this.prefix, this.markers, this.select, operator);
        }

        public static class Operator
        implements Hcl {
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final Type type;
            private final HclRightPadded<Empty> splat;

            @Override
            public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
                return v.visitSplatOperator(this, p);
            }

            public String toString() {
                return "SplatOperator";
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Operator)) {
                    return false;
                }
                Operator other = (Operator)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(@Nullable Object other) {
                return other instanceof Operator;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public Operator(UUID id, Space prefix, Markers markers, Type type, HclRightPadded<Empty> splat) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.type = type;
                this.splat = splat;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            @Override
            public Markers getMarkers() {
                return this.markers;
            }

            public Type getType() {
                return this.type;
            }

            public HclRightPadded<Empty> getSplat() {
                return this.splat;
            }

            @NonNull
            public Operator withId(UUID id) {
                return this.id == id ? this : new Operator(id, this.prefix, this.markers, this.type, this.splat);
            }

            @NonNull
            public Operator withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Operator(this.id, prefix, this.markers, this.type, this.splat);
            }

            @NonNull
            public Operator withMarkers(Markers markers) {
                return this.markers == markers ? this : new Operator(this.id, this.prefix, markers, this.type, this.splat);
            }

            @NonNull
            public Operator withType(Type type) {
                return this.type == type ? this : new Operator(this.id, this.prefix, this.markers, type, this.splat);
            }

            @NonNull
            public Operator withSplat(HclRightPadded<Empty> splat) {
                return this.splat == splat ? this : new Operator(this.id, this.prefix, this.markers, this.type, splat);
            }

            public static enum Type {
                Attribute,
                Full;

            }
        }
    }

    public static class QuotedTemplate
    implements Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Expression> expressions;

        @Override
        public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
            return v.visitQuotedTemplate(this, p);
        }

        public String toString() {
            return "QuotedTemplate";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QuotedTemplate)) {
                return false;
            }
            QuotedTemplate other = (QuotedTemplate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof QuotedTemplate;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public QuotedTemplate(UUID id, Space prefix, Markers markers, List<Expression> expressions) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expressions = expressions;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        public List<Expression> getExpressions() {
            return this.expressions;
        }

        @NonNull
        public QuotedTemplate withId(UUID id) {
            return this.id == id ? this : new QuotedTemplate(id, this.prefix, this.markers, this.expressions);
        }

        @NonNull
        public QuotedTemplate withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new QuotedTemplate(this.id, prefix, this.markers, this.expressions);
        }

        @NonNull
        public QuotedTemplate withMarkers(Markers markers) {
            return this.markers == markers ? this : new QuotedTemplate(this.id, this.prefix, markers, this.expressions);
        }

        @NonNull
        public QuotedTemplate withExpressions(List<Expression> expressions) {
            return this.expressions == expressions ? this : new QuotedTemplate(this.id, this.prefix, this.markers, expressions);
        }
    }

    public static class Parentheses
    implements Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final HclRightPadded<Expression> expression;

        public Expression getExpression() {
            return this.expression.getElement();
        }

        public Parentheses withExpression(Expression expression) {
            return this.getPadding().withExpression(this.expression.withElement(expression));
        }

        @Override
        public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
            return v.visitParentheses(this, p);
        }

        public String toString() {
            return "Parentheses";
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parentheses)) {
                return false;
            }
            Parentheses other = (Parentheses)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Parentheses;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Parentheses(UUID id, Space prefix, Markers markers, HclRightPadded<Expression> expression) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
        }

        private Parentheses(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, HclRightPadded<Expression> expression) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
        }

        @NonNull
        public Parentheses withId(UUID id) {
            return this.id == id ? this : new Parentheses(this.padding, id, this.prefix, this.markers, this.expression);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Parentheses withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Parentheses(this.padding, this.id, prefix, this.markers, this.expression);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Parentheses withMarkers(Markers markers) {
            return this.markers == markers ? this : new Parentheses(this.padding, this.id, this.prefix, markers, this.expression);
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding {
            private final Parentheses t;

            public HclRightPadded<Expression> getExpression() {
                return this.t.expression;
            }

            public Parentheses withExpression(HclRightPadded<Expression> expression) {
                return this.t.expression == expression ? this.t : new Parentheses(this.t.id, this.t.prefix, this.t.markers, expression);
            }

            public Padding(Parentheses t) {
                this.t = t;
            }
        }
    }

    public static class ObjectValue
    implements Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final HclContainer<Expression> attributes;

        public List<Expression> getAttributes() {
            return this.attributes.getElements();
        }

        public ObjectValue withArguments(List<Expression> attributes) {
            return this.getPadding().withAttributes(HclContainer.withElements(this.attributes, attributes));
        }

        @Override
        public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
            return v.visitObjectValue(this, p);
        }

        public String toString() {
            return "ObjectValue";
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ObjectValue)) {
                return false;
            }
            ObjectValue other = (ObjectValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof ObjectValue;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ObjectValue(UUID id, Space prefix, Markers markers, HclContainer<Expression> attributes) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.attributes = attributes;
        }

        private ObjectValue(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, HclContainer<Expression> attributes) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.attributes = attributes;
        }

        @NonNull
        public ObjectValue withId(UUID id) {
            return this.id == id ? this : new ObjectValue(this.padding, id, this.prefix, this.markers, this.attributes);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public ObjectValue withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ObjectValue(this.padding, this.id, prefix, this.markers, this.attributes);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public ObjectValue withMarkers(Markers markers) {
            return this.markers == markers ? this : new ObjectValue(this.padding, this.id, this.prefix, markers, this.attributes);
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding {
            private final ObjectValue t;

            public HclContainer<Expression> getAttributes() {
                return this.t.attributes;
            }

            public ObjectValue withAttributes(HclContainer<Expression> attributes) {
                return this.t.attributes == attributes ? this.t : new ObjectValue(this.t.id, this.t.prefix, this.t.markers, attributes);
            }

            public Padding(ObjectValue t) {
                this.t = t;
            }
        }
    }

    public static class Literal
    implements Hcl,
    Expression,
    Label {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Object value;
        private final String valueSource;

        @Override
        public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
            return v.visitLiteral(this, p);
        }

        public String toString() {
            return "Literal{" + this.valueSource + "}";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Literal)) {
                return false;
            }
            Literal other = (Literal)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Literal;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Literal(UUID id, Space prefix, Markers markers, Object value, String valueSource) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.value = value;
            this.valueSource = valueSource;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        public Object getValue() {
            return this.value;
        }

        public String getValueSource() {
            return this.valueSource;
        }

        @NonNull
        public Literal withId(UUID id) {
            return this.id == id ? this : new Literal(id, this.prefix, this.markers, this.value, this.valueSource);
        }

        @NonNull
        public Literal withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Literal(this.id, prefix, this.markers, this.value, this.valueSource);
        }

        @NonNull
        public Literal withMarkers(Markers markers) {
            return this.markers == markers ? this : new Literal(this.id, this.prefix, markers, this.value, this.valueSource);
        }

        @NonNull
        public Literal withValue(Object value) {
            return this.value == value ? this : new Literal(this.id, this.prefix, this.markers, value, this.valueSource);
        }

        @NonNull
        public Literal withValueSource(String valueSource) {
            return this.valueSource == valueSource ? this : new Literal(this.id, this.prefix, this.markers, this.value, valueSource);
        }
    }

    public static class Index
    implements Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression indexed;
        private final Position position;

        @Override
        public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
            return v.visitIndex(this, p);
        }

        public String toString() {
            return "Index";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Index)) {
                return false;
            }
            Index other = (Index)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Index;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Index(UUID id, Space prefix, Markers markers, Expression indexed, Position position) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.indexed = indexed;
            this.position = position;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getIndexed() {
            return this.indexed;
        }

        public Position getPosition() {
            return this.position;
        }

        @NonNull
        public Index withId(UUID id) {
            return this.id == id ? this : new Index(id, this.prefix, this.markers, this.indexed, this.position);
        }

        @NonNull
        public Index withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Index(this.id, prefix, this.markers, this.indexed, this.position);
        }

        @NonNull
        public Index withMarkers(Markers markers) {
            return this.markers == markers ? this : new Index(this.id, this.prefix, markers, this.indexed, this.position);
        }

        @NonNull
        public Index withIndexed(Expression indexed) {
            return this.indexed == indexed ? this : new Index(this.id, this.prefix, this.markers, indexed, this.position);
        }

        @NonNull
        public Index withPosition(Position position) {
            return this.position == position ? this : new Index(this.id, this.prefix, this.markers, this.indexed, position);
        }

        public static class Position
        implements Hcl {
            @Nullable
            private transient WeakReference<Padding> padding;
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final HclRightPadded<Expression> position;

            public Expression getPosition() {
                return this.position.getElement();
            }

            public Position withPosition(Expression position) {
                return this.getPadding().withPosition(this.position.withElement(position));
            }

            @Override
            public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
                return v.visitIndexPosition(this, p);
            }

            public String toString() {
                return "IndexPosition";
            }

            public Padding getPadding() {
                Padding p;
                if (this.padding == null) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                } else {
                    p = (Padding)this.padding.get();
                    if (p == null || p.t != this) {
                        p = new Padding(this);
                        this.padding = new WeakReference<Padding>(p);
                    }
                }
                return p;
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Position)) {
                    return false;
                }
                Position other = (Position)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(@Nullable Object other) {
                return other instanceof Position;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public Position(UUID id, Space prefix, Markers markers, HclRightPadded<Expression> position) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.position = position;
            }

            private Position(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, HclRightPadded<Expression> position) {
                this.padding = padding;
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.position = position;
            }

            @NonNull
            public Position withId(UUID id) {
                return this.id == id ? this : new Position(this.padding, id, this.prefix, this.markers, this.position);
            }

            public UUID getId() {
                return this.id;
            }

            @NonNull
            public Position withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Position(this.padding, this.id, prefix, this.markers, this.position);
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            @NonNull
            public Position withMarkers(Markers markers) {
                return this.markers == markers ? this : new Position(this.padding, this.id, this.prefix, markers, this.position);
            }

            @Override
            public Markers getMarkers() {
                return this.markers;
            }

            public static class Padding {
                private final Position t;

                public HclRightPadded<Expression> getPosition() {
                    return this.t.position;
                }

                public Position withPosition(HclRightPadded<Expression> position) {
                    return this.t.position == position ? this.t : new Position(this.t.id, this.t.prefix, this.t.markers, position);
                }

                public Padding(Position t) {
                    this.t = t;
                }
            }
        }
    }

    public static class Identifier
    implements Expression,
    Label {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final String name;

        @Override
        public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
            return v.visitIdentifier(this, p);
        }

        public String toString() {
            return "Identifier{" + this.name + "}";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Identifier)) {
                return false;
            }
            Identifier other = (Identifier)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Identifier;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Identifier(UUID id, Space prefix, Markers markers, String name) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        public String getName() {
            return this.name;
        }

        @NonNull
        public Identifier withId(UUID id) {
            return this.id == id ? this : new Identifier(id, this.prefix, this.markers, this.name);
        }

        @NonNull
        public Identifier withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Identifier(this.id, prefix, this.markers, this.name);
        }

        @NonNull
        public Identifier withMarkers(Markers markers) {
            return this.markers == markers ? this : new Identifier(this.id, this.prefix, markers, this.name);
        }

        @NonNull
        public Identifier withName(String name) {
            return this.name == name ? this : new Identifier(this.id, this.prefix, this.markers, name);
        }
    }

    public static class HeredocTemplate
    implements Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final String arrow;
        private final Identifier delimiter;
        private final List<Expression> expressions;
        private final Space end;

        public HeredocTemplate withArrow(String arrow) {
            if (!"<<".equals(arrow) && !"<<-".equals(arrow)) {
                throw new IllegalArgumentException("Heredoc arrow must be one of << or <<-");
            }
            return this.arrow.equals(arrow) ? this : new HeredocTemplate(this.id, this.prefix, this.markers, arrow, this.delimiter, this.expressions, this.end);
        }

        @Override
        public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
            return v.visitHeredocTemplate(this, p);
        }

        public String toString() {
            return "QuotedTemplate";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HeredocTemplate)) {
                return false;
            }
            HeredocTemplate other = (HeredocTemplate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof HeredocTemplate;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public HeredocTemplate(UUID id, Space prefix, Markers markers, String arrow, Identifier delimiter, List<Expression> expressions, Space end) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.arrow = arrow;
            this.delimiter = delimiter;
            this.expressions = expressions;
            this.end = end;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        public String getArrow() {
            return this.arrow;
        }

        public Identifier getDelimiter() {
            return this.delimiter;
        }

        public List<Expression> getExpressions() {
            return this.expressions;
        }

        public Space getEnd() {
            return this.end;
        }

        @NonNull
        public HeredocTemplate withId(UUID id) {
            return this.id == id ? this : new HeredocTemplate(id, this.prefix, this.markers, this.arrow, this.delimiter, this.expressions, this.end);
        }

        @NonNull
        public HeredocTemplate withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new HeredocTemplate(this.id, prefix, this.markers, this.arrow, this.delimiter, this.expressions, this.end);
        }

        @NonNull
        public HeredocTemplate withMarkers(Markers markers) {
            return this.markers == markers ? this : new HeredocTemplate(this.id, this.prefix, markers, this.arrow, this.delimiter, this.expressions, this.end);
        }

        @NonNull
        public HeredocTemplate withDelimiter(Identifier delimiter) {
            return this.delimiter == delimiter ? this : new HeredocTemplate(this.id, this.prefix, this.markers, this.arrow, delimiter, this.expressions, this.end);
        }

        @NonNull
        public HeredocTemplate withExpressions(List<Expression> expressions) {
            return this.expressions == expressions ? this : new HeredocTemplate(this.id, this.prefix, this.markers, this.arrow, this.delimiter, expressions, this.end);
        }

        @NonNull
        public HeredocTemplate withEnd(Space end) {
            return this.end == end ? this : new HeredocTemplate(this.id, this.prefix, this.markers, this.arrow, this.delimiter, this.expressions, end);
        }
    }

    public static class FunctionCall
    implements Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Identifier name;
        private final HclContainer<Expression> arguments;

        public List<Expression> getVariables() {
            return this.arguments.getElements();
        }

        public FunctionCall withArguments(List<Expression> arguments) {
            return this.getPadding().withArguments(HclContainer.withElements(this.arguments, arguments));
        }

        @Override
        public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
            return v.visitFunctionCall(this, p);
        }

        public String toString() {
            return "FunctionCall{" + this.name + ", argArity=" + this.arguments.getElements().size() + "}";
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionCall)) {
                return false;
            }
            FunctionCall other = (FunctionCall)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof FunctionCall;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public FunctionCall(UUID id, Space prefix, Markers markers, Identifier name, HclContainer<Expression> arguments) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.arguments = arguments;
        }

        private FunctionCall(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Identifier name, HclContainer<Expression> arguments) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.arguments = arguments;
        }

        @NonNull
        public FunctionCall withId(UUID id) {
            return this.id == id ? this : new FunctionCall(this.padding, id, this.prefix, this.markers, this.name, this.arguments);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public FunctionCall withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new FunctionCall(this.padding, this.id, prefix, this.markers, this.name, this.arguments);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public FunctionCall withMarkers(Markers markers) {
            return this.markers == markers ? this : new FunctionCall(this.padding, this.id, this.prefix, markers, this.name, this.arguments);
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public FunctionCall withName(Identifier name) {
            return this.name == name ? this : new FunctionCall(this.padding, this.id, this.prefix, this.markers, name, this.arguments);
        }

        public Identifier getName() {
            return this.name;
        }

        public static class Padding {
            private final FunctionCall t;

            public HclContainer<Expression> getArguments() {
                return this.t.arguments;
            }

            public FunctionCall withArguments(HclContainer<Expression> arguments) {
                return this.t.arguments == arguments ? this.t : new FunctionCall(this.t.id, this.t.prefix, this.t.markers, this.t.name, arguments);
            }

            public Padding(FunctionCall t) {
                this.t = t;
            }
        }
    }

    public static class ForTuple
    implements Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ForIntro intro;
        private final HclLeftPadded<Expression> update;
        @Nullable
        private final HclLeftPadded<Expression> condition;
        private final Space end;

        public Expression getUpdateName() {
            return this.update.getElement();
        }

        public ForTuple withUpdateName(Expression updateName) {
            return this.getPadding().withUpdate(this.update.withElement(updateName));
        }

        @Nullable
        public Expression getCondition() {
            return this.condition == null ? null : this.condition.getElement();
        }

        public ForTuple withCondition(Expression condition) {
            return this.getPadding().withCondition(HclLeftPadded.withElement(this.condition, condition));
        }

        @Override
        public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
            return v.visitForTuple(this, p);
        }

        public String toString() {
            return "ForTuple";
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForTuple)) {
                return false;
            }
            ForTuple other = (ForTuple)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof ForTuple;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ForTuple(UUID id, Space prefix, Markers markers, ForIntro intro, HclLeftPadded<Expression> update, @Nullable HclLeftPadded<Expression> condition, Space end) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.intro = intro;
            this.update = update;
            this.condition = condition;
            this.end = end;
        }

        private ForTuple(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, ForIntro intro, HclLeftPadded<Expression> update, @Nullable HclLeftPadded<Expression> condition, Space end) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.intro = intro;
            this.update = update;
            this.condition = condition;
            this.end = end;
        }

        @NonNull
        public ForTuple withId(UUID id) {
            return this.id == id ? this : new ForTuple(this.padding, id, this.prefix, this.markers, this.intro, this.update, this.condition, this.end);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public ForTuple withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ForTuple(this.padding, this.id, prefix, this.markers, this.intro, this.update, this.condition, this.end);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public ForTuple withMarkers(Markers markers) {
            return this.markers == markers ? this : new ForTuple(this.padding, this.id, this.prefix, markers, this.intro, this.update, this.condition, this.end);
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public ForTuple withIntro(ForIntro intro) {
            return this.intro == intro ? this : new ForTuple(this.padding, this.id, this.prefix, this.markers, intro, this.update, this.condition, this.end);
        }

        public ForIntro getIntro() {
            return this.intro;
        }

        @NonNull
        public ForTuple withEnd(Space end) {
            return this.end == end ? this : new ForTuple(this.padding, this.id, this.prefix, this.markers, this.intro, this.update, this.condition, end);
        }

        public Space getEnd() {
            return this.end;
        }

        public static class Padding {
            private final ForTuple t;

            public HclLeftPadded<Expression> getUpdate() {
                return this.t.update;
            }

            public ForTuple withUpdate(HclLeftPadded<Expression> update) {
                return this.t.update == update ? this.t : new ForTuple(this.t.id, this.t.prefix, this.t.markers, this.t.intro, update, this.t.condition, this.t.end);
            }

            @Nullable
            public HclLeftPadded<Expression> getCondition() {
                return this.t.condition;
            }

            public ForTuple withCondition(@Nullable HclLeftPadded<Expression> condition) {
                return this.t.condition == condition ? this.t : new ForTuple(this.t.id, this.t.prefix, this.t.markers, this.t.intro, this.t.update, condition, this.t.end);
            }

            public Padding(ForTuple t) {
                this.t = t;
            }
        }
    }

    public static class ForObject
    implements Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ForIntro intro;
        private final HclLeftPadded<Expression> updateName;
        private final HclLeftPadded<Expression> updateValue;
        @Nullable
        private final Empty ellipsis;
        @Nullable
        private final HclLeftPadded<Expression> condition;
        private final Space end;

        public Expression getUpdateName() {
            return this.updateName.getElement();
        }

        public ForObject withUpdateName(Expression updateName) {
            return this.getPadding().withUpdateName(this.updateName.withElement(updateName));
        }

        public Expression getUpdateValue() {
            return this.updateValue.getElement();
        }

        public ForObject withUpdateValue(Expression updateValue) {
            return this.getPadding().withUpdateValue(this.updateValue.withElement(updateValue));
        }

        @Nullable
        public Expression getCondition() {
            return this.condition == null ? null : this.condition.getElement();
        }

        public ForObject withCondition(Expression condition) {
            return this.getPadding().withCondition(HclLeftPadded.withElement(this.condition, condition));
        }

        @Override
        public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
            return v.visitForObject(this, p);
        }

        public String toString() {
            return "ForTuple";
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForObject)) {
                return false;
            }
            ForObject other = (ForObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof ForObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ForObject(UUID id, Space prefix, Markers markers, ForIntro intro, HclLeftPadded<Expression> updateName, HclLeftPadded<Expression> updateValue, @Nullable Empty ellipsis, @Nullable HclLeftPadded<Expression> condition, Space end) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.intro = intro;
            this.updateName = updateName;
            this.updateValue = updateValue;
            this.ellipsis = ellipsis;
            this.condition = condition;
            this.end = end;
        }

        private ForObject(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, ForIntro intro, HclLeftPadded<Expression> updateName, HclLeftPadded<Expression> updateValue, @Nullable Empty ellipsis, @Nullable HclLeftPadded<Expression> condition, Space end) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.intro = intro;
            this.updateName = updateName;
            this.updateValue = updateValue;
            this.ellipsis = ellipsis;
            this.condition = condition;
            this.end = end;
        }

        @NonNull
        public ForObject withId(UUID id) {
            return this.id == id ? this : new ForObject(this.padding, id, this.prefix, this.markers, this.intro, this.updateName, this.updateValue, this.ellipsis, this.condition, this.end);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public ForObject withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ForObject(this.padding, this.id, prefix, this.markers, this.intro, this.updateName, this.updateValue, this.ellipsis, this.condition, this.end);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public ForObject withMarkers(Markers markers) {
            return this.markers == markers ? this : new ForObject(this.padding, this.id, this.prefix, markers, this.intro, this.updateName, this.updateValue, this.ellipsis, this.condition, this.end);
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public ForObject withIntro(ForIntro intro) {
            return this.intro == intro ? this : new ForObject(this.padding, this.id, this.prefix, this.markers, intro, this.updateName, this.updateValue, this.ellipsis, this.condition, this.end);
        }

        public ForIntro getIntro() {
            return this.intro;
        }

        @NonNull
        public ForObject withEllipsis(@Nullable Empty ellipsis) {
            return this.ellipsis == ellipsis ? this : new ForObject(this.padding, this.id, this.prefix, this.markers, this.intro, this.updateName, this.updateValue, ellipsis, this.condition, this.end);
        }

        @Nullable
        public Empty getEllipsis() {
            return this.ellipsis;
        }

        @NonNull
        public ForObject withEnd(Space end) {
            return this.end == end ? this : new ForObject(this.padding, this.id, this.prefix, this.markers, this.intro, this.updateName, this.updateValue, this.ellipsis, this.condition, end);
        }

        public Space getEnd() {
            return this.end;
        }

        public static class Padding {
            private final ForObject t;

            public HclLeftPadded<Expression> getUpdateName() {
                return this.t.updateName;
            }

            public ForObject withUpdateName(HclLeftPadded<Expression> updateName) {
                return this.t.updateName == updateName ? this.t : new ForObject(this.t.id, this.t.prefix, this.t.markers, this.t.intro, updateName, this.t.updateValue, this.t.ellipsis, this.t.condition, this.t.end);
            }

            public HclLeftPadded<Expression> getUpdateValue() {
                return this.t.updateValue;
            }

            public ForObject withUpdateValue(HclLeftPadded<Expression> updateValue) {
                return this.t.updateValue == updateValue ? this.t : new ForObject(this.t.id, this.t.prefix, this.t.markers, this.t.intro, this.t.updateName, updateValue, this.t.ellipsis, this.t.condition, this.t.end);
            }

            @Nullable
            public HclLeftPadded<Expression> getCondition() {
                return this.t.condition;
            }

            public ForObject withCondition(@Nullable HclLeftPadded<Expression> condition) {
                return this.t.condition == condition ? this.t : new ForObject(this.t.id, this.t.prefix, this.t.markers, this.t.intro, this.t.updateName, this.t.updateValue, this.t.ellipsis, condition, this.t.end);
            }

            public Padding(ForObject t) {
                this.t = t;
            }
        }
    }

    public static class ForIntro
    implements Hcl {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final HclContainer<Identifier> variables;
        private final Expression in;

        public List<Identifier> getVariables() {
            return this.variables.getElements();
        }

        public ForIntro withVariables(List<Identifier> variables) {
            return this.getPadding().withVariables(HclContainer.withElements(this.variables, variables));
        }

        @Override
        public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
            return v.visitForIntro(this, p);
        }

        public String toString() {
            return "ForIntro";
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForIntro)) {
                return false;
            }
            ForIntro other = (ForIntro)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof ForIntro;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ForIntro(UUID id, Space prefix, Markers markers, HclContainer<Identifier> variables, Expression in) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.variables = variables;
            this.in = in;
        }

        private ForIntro(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, HclContainer<Identifier> variables, Expression in) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.variables = variables;
            this.in = in;
        }

        @NonNull
        public ForIntro withId(UUID id) {
            return this.id == id ? this : new ForIntro(this.padding, id, this.prefix, this.markers, this.variables, this.in);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public ForIntro withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ForIntro(this.padding, this.id, prefix, this.markers, this.variables, this.in);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public ForIntro withMarkers(Markers markers) {
            return this.markers == markers ? this : new ForIntro(this.padding, this.id, this.prefix, markers, this.variables, this.in);
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public ForIntro withIn(Expression in) {
            return this.in == in ? this : new ForIntro(this.padding, this.id, this.prefix, this.markers, this.variables, in);
        }

        public Expression getIn() {
            return this.in;
        }

        public static class Padding {
            private final ForIntro t;

            public HclContainer<Identifier> getVariables() {
                return this.t.variables;
            }

            public ForIntro withVariables(HclContainer<Identifier> variables) {
                return this.t.variables == variables ? this.t : new ForIntro(this.t.id, this.t.prefix, this.t.markers, variables, this.t.in);
            }

            public Padding(ForIntro t) {
                this.t = t;
            }
        }
    }

    public static class Empty
    implements Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;

        @Override
        public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
            return v.visitEmpty(this, p);
        }

        public String toString() {
            return "Empty";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Empty)) {
                return false;
            }
            Empty other = (Empty)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Empty;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Empty(UUID id, Space prefix, Markers markers) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Empty withId(UUID id) {
            return this.id == id ? this : new Empty(id, this.prefix, this.markers);
        }

        @NonNull
        public Empty withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Empty(this.id, prefix, this.markers);
        }

        @NonNull
        public Empty withMarkers(Markers markers) {
            return this.markers == markers ? this : new Empty(this.id, this.prefix, markers);
        }
    }

    public static class ConfigFile
    implements Hcl,
    SourceFile {
        private final UUID id;
        private final Path sourcePath;
        @Nullable
        private final FileAttributes fileAttributes;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final String charsetName;
        private final boolean charsetBomMarked;
        @Nullable
        private final Checksum checksum;
        private final List<BodyContent> body;
        private final Space eof;

        public Charset getCharset() {
            return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }

        public SourceFile withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        public CoordinateBuilder.ConfigFile getCoordinates() {
            return new CoordinateBuilder.ConfigFile(this);
        }

        @Override
        public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
            return v.visitConfigFile(this, p);
        }

        public String toString() {
            return "ConfigFile";
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new HclPrinter();
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfigFile)) {
                return false;
            }
            ConfigFile other = (ConfigFile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof ConfigFile;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ConfigFile(UUID id, Path sourcePath, @Nullable FileAttributes fileAttributes, Space prefix, Markers markers, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, List<BodyContent> body, Space eof) {
            this.id = id;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.prefix = prefix;
            this.markers = markers;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.body = body;
            this.eof = eof;
        }

        public UUID getId() {
            return this.id;
        }

        public Path getSourcePath() {
            return this.sourcePath;
        }

        @Nullable
        public FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        @Nullable
        public String getCharsetName() {
            return this.charsetName;
        }

        public List<BodyContent> getBody() {
            return this.body;
        }

        public Space getEof() {
            return this.eof;
        }

        @NonNull
        public ConfigFile withId(UUID id) {
            return this.id == id ? this : new ConfigFile(id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.body, this.eof);
        }

        @NonNull
        public ConfigFile withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new ConfigFile(this.id, sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.body, this.eof);
        }

        @NonNull
        public ConfigFile withFileAttributes(@Nullable FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new ConfigFile(this.id, this.sourcePath, fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.body, this.eof);
        }

        @NonNull
        public ConfigFile withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ConfigFile(this.id, this.sourcePath, this.fileAttributes, prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.body, this.eof);
        }

        @NonNull
        public ConfigFile withMarkers(Markers markers) {
            return this.markers == markers ? this : new ConfigFile(this.id, this.sourcePath, this.fileAttributes, this.prefix, markers, this.charsetName, this.charsetBomMarked, this.checksum, this.body, this.eof);
        }

        @NonNull
        private ConfigFile withCharsetName(@Nullable String charsetName) {
            return this.charsetName == charsetName ? this : new ConfigFile(this.id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, charsetName, this.charsetBomMarked, this.checksum, this.body, this.eof);
        }

        @NonNull
        public ConfigFile withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new ConfigFile(this.id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, charsetBomMarked, this.checksum, this.body, this.eof);
        }

        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        @NonNull
        public ConfigFile withChecksum(@Nullable Checksum checksum) {
            return this.checksum == checksum ? this : new ConfigFile(this.id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, checksum, this.body, this.eof);
        }

        @Nullable
        public Checksum getChecksum() {
            return this.checksum;
        }

        @NonNull
        public ConfigFile withBody(List<BodyContent> body) {
            return this.body == body ? this : new ConfigFile(this.id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, body, this.eof);
        }

        @NonNull
        public ConfigFile withEof(Space eof) {
            return this.eof == eof ? this : new ConfigFile(this.id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.body, eof);
        }
    }

    public static class Conditional
    implements Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression condition;
        private final HclLeftPadded<Expression> truePart;
        private final HclLeftPadded<Expression> falsePart;

        public Expression getTruePart() {
            return this.truePart.getElement();
        }

        public Conditional withTruePart(Expression truePart) {
            return this.getPadding().withTruePart(this.truePart.withElement(truePart));
        }

        public Expression getFalsePart() {
            return this.falsePart.getElement();
        }

        public Conditional withFalsePart(Expression falsePart) {
            return this.getPadding().withFalsePart(this.falsePart.withElement(falsePart));
        }

        @Override
        public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
            return v.visitConditional(this, p);
        }

        public String toString() {
            return "Block";
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Conditional)) {
                return false;
            }
            Conditional other = (Conditional)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Conditional;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Conditional(UUID id, Space prefix, Markers markers, Expression condition, HclLeftPadded<Expression> truePart, HclLeftPadded<Expression> falsePart) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.condition = condition;
            this.truePart = truePart;
            this.falsePart = falsePart;
        }

        private Conditional(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression condition, HclLeftPadded<Expression> truePart, HclLeftPadded<Expression> falsePart) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.condition = condition;
            this.truePart = truePart;
            this.falsePart = falsePart;
        }

        @NonNull
        public Conditional withId(UUID id) {
            return this.id == id ? this : new Conditional(this.padding, id, this.prefix, this.markers, this.condition, this.truePart, this.falsePart);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Conditional withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Conditional(this.padding, this.id, prefix, this.markers, this.condition, this.truePart, this.falsePart);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Conditional withMarkers(Markers markers) {
            return this.markers == markers ? this : new Conditional(this.padding, this.id, this.prefix, markers, this.condition, this.truePart, this.falsePart);
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Conditional withCondition(Expression condition) {
            return this.condition == condition ? this : new Conditional(this.padding, this.id, this.prefix, this.markers, condition, this.truePart, this.falsePart);
        }

        public Expression getCondition() {
            return this.condition;
        }

        public static class Padding {
            private final Conditional t;

            public HclLeftPadded<Expression> getTruePart() {
                return this.t.truePart;
            }

            public Conditional withTruePart(HclLeftPadded<Expression> truePart) {
                return this.t.truePart == truePart ? this.t : new Conditional(this.t.id, this.t.prefix, this.t.markers, this.t.condition, truePart, this.t.falsePart);
            }

            public HclLeftPadded<Expression> getFalsePart() {
                return this.t.falsePart;
            }

            public Conditional withFalsePart(HclLeftPadded<Expression> falsePart) {
                return this.t.falsePart == falsePart ? this.t : new Conditional(this.t.id, this.t.prefix, this.t.markers, this.t.condition, this.t.truePart, falsePart);
            }

            public Padding(Conditional t) {
                this.t = t;
            }
        }
    }

    public static class Block
    implements BodyContent,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Identifier type;
        private final List<Label> labels;
        private final Space open;
        private final List<BodyContent> body;
        private final Space end;

        @Nullable
        @Incubating(since="7.27.0")
        public Attribute getAttribute(String attrName) {
            for (BodyContent t : this.body) {
                Attribute attribute;
                if (!(t instanceof Attribute) || !(attribute = (Attribute)t).getSimpleName().equals(attrName)) continue;
                return attribute;
            }
            return null;
        }

        @Incubating(since="7.27.0")
        public Block withAttributeValue(String attrName, Object value) {
            Attribute attr = this.getAttribute(attrName);
            if (attr == null || this.getAttributeValue(attrName).equals(value)) {
                return this;
            }
            return this.withBody(ListUtils.map(this.body, b -> {
                if (b == attr) {
                    if (attr.getValue() instanceof Literal) {
                        Literal l = (Literal)attr.getValue();
                        return attr.withValue(l.withValue(value.toString()).withValueSource("\"" + value + "\""));
                    }
                    if (attr.getValue() instanceof QuotedTemplate) {
                        QuotedTemplate q = (QuotedTemplate)attr.getValue();
                        return attr.withValue(q.withExpressions(Collections.singletonList(new Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, value, value.toString()))));
                    }
                }
                return b;
            }));
        }

        @Nullable
        @Incubating(since="7.27.0")
        public <T> T getAttributeValue(String attrName) {
            String value;
            Attribute attr = this.getAttribute(attrName);
            if (attr == null) {
                return null;
            }
            String string = value = attr.getValue() instanceof Literal ? ((Literal)attr.getValue()).getValueSource() : null;
            if (attr.getValue() instanceof QuotedTemplate) {
                Cursor root = new Cursor(null, HclParser.builder().build().parse(new String[]{""}).get(0));
                StringBuilder valueBuilder = new StringBuilder();
                for (Expression expr : ((QuotedTemplate)attr.getValue()).getExpressions()) {
                    valueBuilder.append(expr.print(root));
                }
                value = valueBuilder.toString();
            }
            return (T)value;
        }

        @Override
        public CoordinateBuilder.Block getCoordinates() {
            return new CoordinateBuilder.Block(this);
        }

        @Override
        public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
            return v.visitBlock(this, p);
        }

        public String toString() {
            return "Block";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Block)) {
                return false;
            }
            Block other = (Block)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Block;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Block(UUID id, Space prefix, Markers markers, @Nullable Identifier type, List<Label> labels, Space open, List<BodyContent> body, Space end) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.type = type;
            this.labels = labels;
            this.open = open;
            this.body = body;
            this.end = end;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        @Nullable
        public Identifier getType() {
            return this.type;
        }

        public List<Label> getLabels() {
            return this.labels;
        }

        public Space getOpen() {
            return this.open;
        }

        public List<BodyContent> getBody() {
            return this.body;
        }

        public Space getEnd() {
            return this.end;
        }

        @NonNull
        public Block withId(UUID id) {
            return this.id == id ? this : new Block(id, this.prefix, this.markers, this.type, this.labels, this.open, this.body, this.end);
        }

        @Override
        @NonNull
        public Block withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Block(this.id, prefix, this.markers, this.type, this.labels, this.open, this.body, this.end);
        }

        @NonNull
        public Block withMarkers(Markers markers) {
            return this.markers == markers ? this : new Block(this.id, this.prefix, markers, this.type, this.labels, this.open, this.body, this.end);
        }

        @NonNull
        public Block withType(@Nullable Identifier type) {
            return this.type == type ? this : new Block(this.id, this.prefix, this.markers, type, this.labels, this.open, this.body, this.end);
        }

        @NonNull
        public Block withLabels(List<Label> labels) {
            return this.labels == labels ? this : new Block(this.id, this.prefix, this.markers, this.type, labels, this.open, this.body, this.end);
        }

        @NonNull
        public Block withOpen(Space open) {
            return this.open == open ? this : new Block(this.id, this.prefix, this.markers, this.type, this.labels, open, this.body, this.end);
        }

        @NonNull
        public Block withBody(List<BodyContent> body) {
            return this.body == body ? this : new Block(this.id, this.prefix, this.markers, this.type, this.labels, this.open, body, this.end);
        }

        @NonNull
        public Block withEnd(Space end) {
            return this.end == end ? this : new Block(this.id, this.prefix, this.markers, this.type, this.labels, this.open, this.body, end);
        }
    }

    public static class Binary
    implements Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression left;
        private final HclLeftPadded<Type> operator;
        private final Expression right;

        public Type getOperator() {
            return this.operator.getElement();
        }

        public Binary withOperator(Type type) {
            return this.getPadding().withOperator(this.operator.withElement(type));
        }

        @Override
        public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
            return v.visitBinary(this, p);
        }

        public String toString() {
            return "Binary";
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Binary)) {
                return false;
            }
            Binary other = (Binary)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Binary;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Binary(UUID id, Space prefix, Markers markers, Expression left, HclLeftPadded<Type> operator, Expression right) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
        }

        private Binary(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression left, HclLeftPadded<Type> operator, Expression right) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
        }

        @NonNull
        public Binary withId(UUID id) {
            return this.id == id ? this : new Binary(this.padding, id, this.prefix, this.markers, this.left, this.operator, this.right);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Binary withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Binary(this.padding, this.id, prefix, this.markers, this.left, this.operator, this.right);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Binary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Binary(this.padding, this.id, this.prefix, markers, this.left, this.operator, this.right);
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Binary withLeft(Expression left) {
            return this.left == left ? this : new Binary(this.padding, this.id, this.prefix, this.markers, left, this.operator, this.right);
        }

        public Expression getLeft() {
            return this.left;
        }

        @NonNull
        public Binary withRight(Expression right) {
            return this.right == right ? this : new Binary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, right);
        }

        public Expression getRight() {
            return this.right;
        }

        public static enum Type {
            Addition,
            Subtraction,
            Multiplication,
            Division,
            Modulo,
            LessThan,
            GreaterThan,
            LessThanOrEqual,
            GreaterThanOrEqual,
            Equal,
            NotEqual,
            Or,
            And;

        }

        public static class Padding {
            private final Binary t;

            public HclLeftPadded<Type> getOperator() {
                return this.t.operator;
            }

            public Binary withOperator(HclLeftPadded<Type> operator) {
                return this.t.operator == operator ? this.t : new Binary(this.t.id, this.t.prefix, this.t.markers, this.t.left, operator, this.t.right);
            }

            public Padding(Binary t) {
                this.t = t;
            }
        }
    }

    public static class AttributeAccess
    implements Expression,
    Label {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression attribute;
        private final HclLeftPadded<Identifier> name;

        public Identifier getType() {
            return this.name.getElement();
        }

        public AttributeAccess withType(Identifier name) {
            return this.getPadding().withName(this.name.withElement(name));
        }

        @Override
        public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
            return v.visitAttributeAccess(this, p);
        }

        public String toString() {
            return "AttributeAccess{" + this.attribute + "." + this.name + "}";
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AttributeAccess)) {
                return false;
            }
            AttributeAccess other = (AttributeAccess)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof AttributeAccess;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public AttributeAccess(UUID id, Space prefix, Markers markers, Expression attribute, HclLeftPadded<Identifier> name) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.attribute = attribute;
            this.name = name;
        }

        private AttributeAccess(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression attribute, HclLeftPadded<Identifier> name) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.attribute = attribute;
            this.name = name;
        }

        @NonNull
        public AttributeAccess withId(UUID id) {
            return this.id == id ? this : new AttributeAccess(this.padding, id, this.prefix, this.markers, this.attribute, this.name);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public AttributeAccess withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new AttributeAccess(this.padding, this.id, prefix, this.markers, this.attribute, this.name);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public AttributeAccess withMarkers(Markers markers) {
            return this.markers == markers ? this : new AttributeAccess(this.padding, this.id, this.prefix, markers, this.attribute, this.name);
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public AttributeAccess withAttribute(Expression attribute) {
            return this.attribute == attribute ? this : new AttributeAccess(this.padding, this.id, this.prefix, this.markers, attribute, this.name);
        }

        public Expression getAttribute() {
            return this.attribute;
        }

        public static class Padding {
            private final AttributeAccess t;

            public HclLeftPadded<Identifier> getName() {
                return this.t.name;
            }

            public AttributeAccess withName(HclLeftPadded<Identifier> name) {
                return this.t.name == name ? this.t : new AttributeAccess(this.t.id, this.t.prefix, this.t.markers, this.t.attribute, name);
            }

            public Padding(AttributeAccess t) {
                this.t = t;
            }
        }
    }

    public static class Attribute
    implements BodyContent,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression name;
        private final HclLeftPadded<Type> type;
        private final Expression value;

        @JsonIgnore
        public String getSimpleName() {
            return this.getSimpleName(this.name);
        }

        private String getSimpleName(Expression e) {
            return e instanceof Parentheses ? this.getSimpleName(((Parentheses)e).getExpression()) : ((Identifier)e).getName();
        }

        public Type getType() {
            return this.type.getElement();
        }

        public Attribute withType(Type type) {
            return this.getPadding().withType(this.type.withElement(type));
        }

        @Override
        public <P> Hcl acceptHcl(HclVisitor<P> v, P p) {
            return v.visitAttribute(this, p);
        }

        public String toString() {
            return "Attribute{" + this.name + "}";
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Attribute)) {
                return false;
            }
            Attribute other = (Attribute)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Attribute;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Attribute(UUID id, Space prefix, Markers markers, Expression name, HclLeftPadded<Type> type, Expression value) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.type = type;
            this.value = value;
        }

        private Attribute(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression name, HclLeftPadded<Type> type, Expression value) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.type = type;
            this.value = value;
        }

        @NonNull
        public Attribute withId(UUID id) {
            return this.id == id ? this : new Attribute(this.padding, id, this.prefix, this.markers, this.name, this.type, this.value);
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        @NonNull
        public Attribute withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Attribute(this.padding, this.id, prefix, this.markers, this.name, this.type, this.value);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Attribute withMarkers(Markers markers) {
            return this.markers == markers ? this : new Attribute(this.padding, this.id, this.prefix, markers, this.name, this.type, this.value);
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Attribute withName(Expression name) {
            return this.name == name ? this : new Attribute(this.padding, this.id, this.prefix, this.markers, name, this.type, this.value);
        }

        public Expression getName() {
            return this.name;
        }

        @NonNull
        public Attribute withValue(Expression value) {
            return this.value == value ? this : new Attribute(this.padding, this.id, this.prefix, this.markers, this.name, this.type, value);
        }

        public Expression getValue() {
            return this.value;
        }

        public static enum Type {
            ObjectElement,
            Assignment;

        }

        public static class Padding {
            private final Attribute t;

            public HclLeftPadded<Type> getType() {
                return this.t.type;
            }

            public Attribute withType(HclLeftPadded<Type> type) {
                return this.t.type == type ? this.t : new Attribute(this.t.id, this.t.prefix, this.t.markers, this.t.name, type, this.t.value);
            }

            public Padding(Attribute t) {
                this.t = t;
            }
        }
    }
}

