/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl.format;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.Tree;
import org.openrewrite.hcl.HclIsoVisitor;
import org.openrewrite.hcl.style.SpacesStyle;
import org.openrewrite.hcl.tree.BodyContent;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.hcl.tree.HclLeftPadded;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;

public class AttributeSpaceVisitor<P>
extends HclIsoVisitor<P> {
    @Nullable
    private final Tree stopAfter;
    private final SpacesStyle style;

    public AttributeSpaceVisitor(SpacesStyle style) {
        this(style, null);
    }

    public AttributeSpaceVisitor(SpacesStyle style, @Nullable Tree stopAfter) {
        this.style = style;
        this.stopAfter = stopAfter;
    }

    @Override
    public Hcl.Attribute visitAttribute(Hcl.Attribute attribute, P p) {
        Hcl a = super.visitAttribute(attribute, (Object)p);
        Hcl parent = (Hcl)this.getCursor().dropParentUntil(t -> t instanceof Hcl).getValue();
        if (parent instanceof Hcl.Block) {
            Hcl.Block block = (Hcl.Block)parent;
            if (attribute.getType().equals((Object)Hcl.Attribute.Type.Assignment)) {
                HclLeftPadded<Hcl.Attribute.Type> type = ((Hcl.Attribute)a).getPadding().getType();
                if (Boolean.TRUE.equals(this.style.getBodyContent().getColumnarAlignment())) {
                    List<Hcl.Attribute> groupAttributes = this.attributesInGroup(block, attribute);
                    int rightMostColumnOfAttributeKey = 0;
                    for (Hcl.Attribute sibling : groupAttributes) {
                        rightMostColumnOfAttributeKey = Math.max(rightMostColumnOfAttributeKey, this.endColumn(sibling));
                    }
                    rightMostColumnOfAttributeKey = Math.max(rightMostColumnOfAttributeKey, this.endColumn((Hcl.Attribute)a));
                    int indent = rightMostColumnOfAttributeKey - this.endColumn((Hcl.Attribute)a) + 1;
                    a = ((Hcl.Attribute)a).getPadding().withType(type.withBefore(type.getBefore().withWhitespace(StringUtils.repeat((String)" ", (int)indent))));
                } else if (Boolean.FALSE.equals(this.style.getBodyContent().getColumnarAlignment())) {
                    a = ((Hcl.Attribute)a).getPadding().withType(type.withBefore(type.getBefore().withWhitespace(" ")));
                }
            }
        }
        return a;
    }

    private List<Hcl.Attribute> attributesInGroup(Hcl.Block block, Hcl.Attribute attribute) {
        boolean isAttributeMultiline;
        boolean bl = isAttributeMultiline = attribute.getValue().print(this.getCursor()).split("\r\n|\r|\n").length > 2;
        if (isAttributeMultiline) {
            return Collections.singletonList(attribute);
        }
        ArrayList<Hcl.Attribute> groupAttributes = new ArrayList<Hcl.Attribute>();
        boolean groupFound = false;
        Hcl.Attribute perviousSibling = null;
        for (BodyContent bodyContent : block.getBody()) {
            boolean newGroup;
            Hcl.Attribute sibling;
            if (!(bodyContent instanceof Hcl.Attribute) || !(sibling = (Hcl.Attribute)bodyContent).getType().equals((Object)Hcl.Attribute.Type.Assignment)) continue;
            boolean siblingPrefixHasNewLines = sibling.getPrefix().getWhitespace().split("\r\n|\r|\n").length > 2;
            boolean siblingIsMultiline = sibling.getValue().print(this.getCursor()).split("\r\n|\r|\n").length > 2;
            boolean previousSiblingIsMultiline = perviousSibling != null && perviousSibling.getValue().print(this.getCursor()).split("\r\n|\r|\n").length > 2;
            boolean bl2 = newGroup = siblingPrefixHasNewLines || previousSiblingIsMultiline || siblingIsMultiline;
            if (newGroup) {
                if (groupFound) break;
                groupAttributes.clear();
            }
            if (sibling.getId() == attribute.getId()) {
                groupFound = true;
            }
            groupAttributes.add(sibling);
            perviousSibling = sibling;
        }
        return groupAttributes;
    }

    private int endColumn(Hcl.Attribute attribute) {
        return (attribute.getPrefix().getIndent() + attribute.getName().print(this.getCursor())).length();
    }

    @Nullable
    public Hcl postVisit(Hcl tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(Hcl.ConfigFile.class, "stop", (Object)true);
        }
        return (Hcl)super.postVisit((Tree)tree, p);
    }

    @Nullable
    public Hcl visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (Hcl)tree;
        }
        return (Hcl)super.visit(tree, p);
    }
}

