/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.hcl.HclIsoVisitor;
import org.openrewrite.hcl.HclVisitor;
import org.openrewrite.hcl.JsonPathMatcher;
import org.openrewrite.hcl.tree.BodyContent;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class DeleteContent
extends Recipe {
    @Option(displayName="Content path", description="A JSONPath expression specifying the block to delete.", example="$.provider")
    private final String contentPath;

    public String getDisplayName() {
        return "Delete content";
    }

    public String getDescription() {
        return "Delete HCL content by path.";
    }

    public HclVisitor<ExecutionContext> getVisitor() {
        final JsonPathMatcher pathMatcher = new JsonPathMatcher(this.contentPath);
        return new HclIsoVisitor<ExecutionContext>(){

            @Override
            public BodyContent visitBodyContent(BodyContent bodyContent, ExecutionContext ctx) {
                Hcl b = super.visitBodyContent(bodyContent, ctx);
                if (pathMatcher.matches(this.getCursor())) {
                    return null;
                }
                return b;
            }
        };
    }

    public DeleteContent(String contentPath) {
        this.contentPath = contentPath;
    }

    public String getContentPath() {
        return this.contentPath;
    }

    @NonNull
    public String toString() {
        return "DeleteContent(contentPath=" + this.getContentPath() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteContent)) {
            return false;
        }
        DeleteContent other = (DeleteContent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$contentPath = this.getContentPath();
        String other$contentPath = other.getContentPath();
        return !(this$contentPath == null ? other$contentPath != null : !this$contentPath.equals(other$contentPath));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DeleteContent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $contentPath = this.getContentPath();
        result = result * 59 + ($contentPath == null ? 43 : $contentPath.hashCode());
        return result;
    }
}

