/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl.format;

import org.openrewrite.Tree;
import org.openrewrite.hcl.HclIsoVisitor;
import org.openrewrite.hcl.format.AttributeSpaceVisitor;
import org.openrewrite.hcl.style.SpacesStyle;
import org.openrewrite.hcl.tree.Expression;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.internal.lang.Nullable;

public class SpacesVisitor<P>
extends HclIsoVisitor<P> {
    @Nullable
    private final Tree stopAfter;
    private final SpacesStyle style;

    public SpacesVisitor(SpacesStyle style) {
        this(style, null);
    }

    public SpacesVisitor(SpacesStyle style, @Nullable Tree stopAfter) {
        this.style = style;
        this.stopAfter = stopAfter;
    }

    @Override
    public Hcl.Attribute visitAttribute(Hcl.Attribute attribute, P p) {
        Hcl a = super.visitAttribute(attribute, (Object)p);
        return (Hcl.Attribute)new AttributeSpaceVisitor(this.style).visit(a, p, this.getCursor().getParentOrThrow());
    }

    @Override
    public Expression visitExpression(Expression expression, P p) {
        Hcl e = super.visitExpression(expression, (Object)p);
        Hcl parent = (Hcl)this.getCursor().getParentOrThrow().getValue();
        if (parent instanceof Hcl.Attribute && ((Hcl.Attribute)parent).getValue() == expression && e.getPrefix().getWhitespace().isEmpty()) {
            e = (Expression)e.withPrefix(e.getPrefix().withWhitespace(" "));
        }
        return e;
    }

    @Override
    public Hcl.Block visitBlock(Hcl.Block block, P p) {
        return super.visitBlock(block.withOpen(block.getOpen().withWhitespace(" ")), (Object)p);
    }

    @Nullable
    public Hcl postVisit(Hcl tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(Hcl.ConfigFile.class, "stop", (Object)true);
        }
        return (Hcl)super.postVisit((Tree)tree, p);
    }

    @Nullable
    public Hcl visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (Hcl)tree;
        }
        return (Hcl)super.visit(tree, p);
    }
}

