/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.hcl.HclParsingException;
import org.openrewrite.hcl.internal.HclParserVisitor;
import org.openrewrite.hcl.internal.grammar.HCLLexer;
import org.openrewrite.hcl.internal.grammar.HCLParser;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.style.NamedStyles;

public class HclParser
implements Parser<Hcl.ConfigFile> {
    private final List<NamedStyles> styles;

    private HclParser(List<NamedStyles> styles) {
        this.styles = styles;
    }

    public List<Hcl.ConfigFile> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        return this.acceptedInputs(sourceFiles).stream().map(sourceFile -> {
            Timer.Builder timer = Timer.builder((String)"rewrite.parse").description("The time spent parsing an HCL file").tag("file.type", "HCL");
            Timer.Sample sample = Timer.start();
            try {
                HCLLexer lexer = new HCLLexer(CharStreams.fromStream((InputStream)sourceFile.getSource()));
                lexer.removeErrorListeners();
                lexer.addErrorListener((ANTLRErrorListener)new ForwardingErrorListener(sourceFile.getPath(), ctx));
                HCLParser parser = new HCLParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
                parser.removeErrorListeners();
                parser.addErrorListener((ANTLRErrorListener)new ForwardingErrorListener(sourceFile.getPath(), ctx));
                Hcl.ConfigFile configFile = (Hcl.ConfigFile)new HclParserVisitor(sourceFile.getRelativePath(relativeTo), StringUtils.readFully((InputStream)sourceFile.getSource())).visitConfigFile(parser.configFile());
                configFile = configFile.withMarkers(Markers.build(this.styles));
                sample.stop(MetricsHelper.successTags((Timer.Builder)timer).register((MeterRegistry)Metrics.globalRegistry));
                return configFile;
            }
            catch (Throwable t) {
                sample.stop(MetricsHelper.errorTags((Timer.Builder)timer, (Throwable)t).register((MeterRegistry)Metrics.globalRegistry));
                ctx.getOnError().accept(t);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean accept(Path path) {
        return path.toString().endsWith(".tf");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected final List<NamedStyles> styles = new ArrayList<NamedStyles>();

        public Builder styles(Iterable<? extends NamedStyles> styles) {
            for (NamedStyles namedStyles : styles) {
                this.styles.add(namedStyles);
            }
            return this;
        }

        public HclParser build() {
            return new HclParser(this.styles);
        }
    }

    private static class ForwardingErrorListener
    extends BaseErrorListener {
        private final Path sourcePath;
        private final ExecutionContext ctx;

        private ForwardingErrorListener(Path sourcePath, ExecutionContext ctx) {
            this.sourcePath = sourcePath;
            this.ctx = ctx;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            this.ctx.getOnError().accept(new HclParsingException(this.sourcePath, String.format("Syntax error at line %d:%d %s.", line, charPositionInLine, msg), e));
        }
    }
}

