/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.ResolveVisitor;

class NoInlineAnnotationTransformationResolveVisitor
extends ResolveVisitor {
    public NoInlineAnnotationTransformationResolveVisitor(CompilationUnit compilationUnit) {
        super(compilationUnit);
    }

    public void visitAnnotations(AnnotatedNode node) {
        List annotations = node.getAnnotations();
        if (annotations.isEmpty()) {
            return;
        }
        HashMap<String, AnnotationNode> tmpAnnotations = new HashMap<String, AnnotationNode>();
        for (AnnotationNode an : annotations) {
            AnnotationNode anyPrevAnnNode;
            Class annTypeClass;
            Retention retention;
            if (an.isBuiltIn()) continue;
            ClassNode annType = an.getClassNode();
            this.resolveOrFail(annType, " for annotation", (ASTNode)an);
            for (Map.Entry entry : an.getMembers().entrySet()) {
                Expression newValue = this.transform((Expression)entry.getValue());
                Expression adjusted = NoInlineAnnotationTransformationResolveVisitor.transformInlineConstants(newValue);
                entry.setValue(adjusted);
                this.checkAnnotationMemberValue(adjusted);
            }
            if (!annType.isResolved() || (retention = (annTypeClass = annType.getTypeClass()).getAnnotation(Retention.class)) == null || retention.value() == RetentionPolicy.SOURCE || this.isRepeatable(annTypeClass) || (anyPrevAnnNode = tmpAnnotations.put(annTypeClass.getName(), an)) == null) continue;
            this.addError("Cannot specify duplicate annotation on the same member : " + annType.getName(), (ASTNode)an);
        }
    }

    private static Expression transformInlineConstants(Expression exp) {
        ConstantExpression ce;
        if (exp instanceof AnnotationConstantExpression && (ce = (ConstantExpression)exp).getValue() instanceof AnnotationNode) {
            AnnotationNode an = (AnnotationNode)ce.getValue();
            for (Map.Entry entry : an.getMembers().entrySet()) {
                entry.setValue(NoInlineAnnotationTransformationResolveVisitor.transformInlineConstants((Expression)entry.getValue()));
            }
        }
        return exp;
    }

    private void resolveOrFail(ClassNode type, String msg, ASTNode node) {
        try {
            Method method = ResolveVisitor.class.getDeclaredMethod("resolveOrFail", ClassNode.class, String.class, ASTNode.class);
            method.setAccessible(true);
            method.invoke((Object)this, type, msg, node);
        }
        catch (Exception e) {
            throw new RuntimeException("Error invoking `resolveOrFail` method", e);
        }
    }

    private void checkAnnotationMemberValue(Expression newValue) {
        if (newValue instanceof PropertyExpression) {
            PropertyExpression pe = (PropertyExpression)newValue;
            if (!(pe.getObjectExpression() instanceof ClassExpression)) {
                this.addError("unable to find class '" + pe.getText() + "' for annotation attribute constant", (ASTNode)pe.getObjectExpression());
            }
        } else if (newValue instanceof ListExpression) {
            ListExpression le = (ListExpression)newValue;
            for (Expression e : le.getExpressions()) {
                this.checkAnnotationMemberValue(e);
            }
        }
    }

    private boolean isRepeatable(Class<?> annTypeClass) {
        Annotation[] annTypeAnnotations;
        for (Annotation annTypeAnnotation : annTypeAnnotations = annTypeClass.getAnnotations()) {
            if (!annTypeAnnotation.annotationType().getName().equals("java.lang.annotation.Repeatable")) continue;
            return true;
        }
        return false;
    }
}

