/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy;

import groovy.lang.GroovyClassLoader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.Janitor;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.InputStreamReaderSource;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingVisitor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.groovy.CompiledGroovySource;
import org.openrewrite.groovy.GroovyParserVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;
import org.slf4j.LoggerFactory;

public class GroovyParser
implements Parser<G.CompilationUnit> {
    @Nullable
    private final Collection<Path> classpath;
    private final List<NamedStyles> styles;
    private final boolean logCompilationWarningsAndErrors;
    private final JavaTypeCache typeCache;

    public List<G.CompilationUnit> parse(String ... sources) {
        Pattern packagePattern = Pattern.compile("^package\\s+([^;]+);");
        Pattern classPattern = Pattern.compile("(class|interface|enum)\\s*(<[^>]*>)?\\s+(\\w+)");
        Function<String, String> simpleName = sourceStr -> {
            Matcher classMatcher = classPattern.matcher((CharSequence)sourceStr);
            return classMatcher.find() ? classMatcher.group(3) : null;
        };
        return this.parseInputs(Arrays.stream(sources).map(sourceFile -> {
            Matcher packageMatcher = packagePattern.matcher((CharSequence)sourceFile);
            String pkg = packageMatcher.find() ? packageMatcher.group(1).replace('.', '/') + "/" : "";
            String className = Optional.ofNullable((String)simpleName.apply((String)sourceFile)).orElse(Long.toString(System.nanoTime())) + ".java";
            Path path = Paths.get(pkg + className, new String[0]);
            return new Parser.Input(path, null, () -> new ByteArrayInputStream(sourceFile.getBytes(StandardCharsets.UTF_8)), true);
        }).collect(Collectors.toList()), null, (ExecutionContext)new InMemoryExecutionContext());
    }

    public List<G.CompilationUnit> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        ParsingEventListener parsingListener = ParsingExecutionContextView.view((ExecutionContext)ctx).getParsingListener();
        List<CompiledGroovySource> compilerCus = this.parseInputsToCompilerAst(sources, relativeTo, ctx);
        ArrayList<G.CompilationUnit> cus = new ArrayList<G.CompilationUnit>(compilerCus.size());
        for (CompiledGroovySource compiled : compilerCus) {
            try {
                GroovyParserVisitor mappingVisitor = new GroovyParserVisitor(compiled.getInput().getRelativePath(relativeTo), compiled.getInput().getFileAttributes(), compiled.getInput().getSource(), this.typeCache, ctx);
                G.CompilationUnit gcu = mappingVisitor.visit(compiled.getSourceUnit(), compiled.getModule());
                cus.add(gcu);
                parsingListener.parsed(compiled.getInput(), (SourceFile)gcu);
            }
            catch (Throwable t) {
                ctx.getOnError().accept(t);
            }
        }
        return cus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<CompiledGroovySource> parseInputsToCompilerAst(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        ArrayList<CompiledGroovySource> cus = new ArrayList<CompiledGroovySource>();
        for (Parser.Input input : sources) {
            CompilerConfiguration configuration = new CompilerConfiguration();
            configuration.setTolerance(Integer.MAX_VALUE);
            configuration.setClasspathList(this.classpath == null ? Collections.emptyList() : this.classpath.stream().flatMap(cp -> {
                try {
                    return Stream.of(cp.toFile().toString());
                }
                catch (UnsupportedOperationException e) {
                    return Stream.empty();
                }
            }).collect(Collectors.toList()));
            ErrorCollector errorCollector = new ErrorCollector(configuration);
            SourceUnit unit = new SourceUnit("doesntmatter", (ReaderSource)new InputStreamReaderSource((InputStream)input.getSource(), configuration), configuration, null, errorCollector);
            GroovyClassLoader transformLoader = new GroovyClassLoader(this.getClass().getClassLoader());
            CompilationUnit compUnit = new CompilationUnit(configuration, null, null, transformLoader);
            compUnit.addSource(unit);
            try {
                compUnit.compile(5);
                ModuleNode ast = unit.getAST();
                for (ClassNode aClass : ast.getClasses()) {
                    try {
                        new StaticTypeCheckingVisitor(unit, aClass).visitClass(aClass);
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {}
                }
                cus.add(new CompiledGroovySource(input, unit, ast));
            }
            catch (Throwable t) {
                ctx.getOnError().accept(t);
            }
            finally {
                if (!this.logCompilationWarningsAndErrors || !errorCollector.hasErrors() && !errorCollector.hasWarnings()) continue;
                try (StringWriter sw = new StringWriter();
                     PrintWriter pw = new PrintWriter(sw);){
                    errorCollector.write(pw, new Janitor());
                    LoggerFactory.getLogger(GroovyParser.class).warn(sw.toString());
                }
                catch (IOException sw2) {}
            }
        }
        return cus;
    }

    public boolean accept(Path path) {
        return path.toString().endsWith(".groovy");
    }

    public GroovyParser reset() {
        this.typeCache.clear();
        return this;
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.groovy");
    }

    public static Builder builder() {
        return new Builder();
    }

    private GroovyParser(@Nullable Collection<Path> classpath, List<NamedStyles> styles, boolean logCompilationWarningsAndErrors, JavaTypeCache typeCache) {
        this.classpath = classpath;
        this.styles = styles;
        this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
        this.typeCache = typeCache;
    }

    public static class Builder {
        @Nullable
        private Collection<Path> classpath = JavaParser.runtimeClasspath();
        private JavaTypeCache typeCache = new JavaTypeCache();
        private boolean logCompilationWarningsAndErrors = false;
        private final List<NamedStyles> styles = new ArrayList<NamedStyles>();

        public Builder logCompilationWarningsAndErrors(boolean logCompilationWarningsAndErrors) {
            this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
            return this;
        }

        public Builder classpath(Collection<Path> classpath) {
            this.classpath = classpath;
            return this;
        }

        public Builder classpath(String ... classpath) {
            this.classpath = JavaParser.dependenciesFromClasspath((String[])classpath);
            return this;
        }

        public Builder typeCache(JavaTypeCache typeCache) {
            this.typeCache = typeCache;
            return this;
        }

        public Builder styles(Iterable<? extends NamedStyles> styles) {
            for (NamedStyles namedStyles : styles) {
                this.styles.add(namedStyles);
            }
            return this;
        }

        public GroovyParser build() {
            return new GroovyParser(this.classpath, this.styles, this.logCompilationWarningsAndErrors, this.typeCache);
        }
    }
}

