/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy.tree;

import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.groovy.GroovyPrinter;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.internal.TypeCache;
import org.openrewrite.java.search.FindTypes;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.CoordinateBuilder;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Markers;

public interface G
extends J {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        if (v instanceof GroovyVisitor) {
            return (R)this.acceptGroovy((GroovyVisitor)v, p);
        }
        return (R)this.acceptJava((JavaVisitor)v, p);
    }

    @Nullable
    default public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
        return (G)v.defaultValue((Tree)this, p);
    }

    public Space getPrefix();

    default public List<Comment> getComments() {
        return this.getPrefix().getComments();
    }

    public static final class GString
    implements G,
    Statement,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<J> strings;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
            return v.visitGString(this, p);
        }

        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof GString;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public GString(UUID id, Space prefix, Markers markers, List<J> strings, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.strings = strings;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<J> getStrings() {
            return this.strings;
        }

        @Nullable
        public JavaType getType() {
            return this.type;
        }

        @NonNull
        public String toString() {
            return "G.GString(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", strings=" + this.getStrings() + ", type=" + this.getType() + ")";
        }

        @NonNull
        public GString withId(UUID id) {
            return this.id == id ? this : new GString(id, this.prefix, this.markers, this.strings, this.type);
        }

        @NonNull
        public GString withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new GString(this.id, prefix, this.markers, this.strings, this.type);
        }

        @NonNull
        public GString withMarkers(Markers markers) {
            return this.markers == markers ? this : new GString(this.id, this.prefix, markers, this.strings, this.type);
        }

        @NonNull
        public GString withStrings(List<J> strings) {
            return this.strings == strings ? this : new GString(this.id, this.prefix, this.markers, strings, this.type);
        }

        @NonNull
        public GString withType(@Nullable JavaType type) {
            return this.type == type ? this : new GString(this.id, this.prefix, this.markers, this.strings, type);
        }

        public static final class Value
        implements G {
            private final UUID id;
            private final Markers markers;
            private final J tree;
            private final boolean enclosedInBraces;

            public <J2 extends J> J2 withPrefix(Space space) {
                return (J2)this;
            }

            @Override
            public Space getPrefix() {
                return Space.EMPTY;
            }

            @Override
            public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
                return v.visitGStringValue(this, p);
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                return o instanceof Value;
            }

            public int hashCode() {
                boolean result = true;
                return 1;
            }

            public Value(UUID id, Markers markers, J tree, boolean enclosedInBraces) {
                this.id = id;
                this.markers = markers;
                this.tree = tree;
                this.enclosedInBraces = enclosedInBraces;
            }

            public UUID getId() {
                return this.id;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public J getTree() {
                return this.tree;
            }

            public boolean isEnclosedInBraces() {
                return this.enclosedInBraces;
            }

            @NonNull
            public String toString() {
                return "G.GString.Value(id=" + this.getId() + ", markers=" + this.getMarkers() + ", tree=" + this.getTree() + ", enclosedInBraces=" + this.isEnclosedInBraces() + ")";
            }

            @NonNull
            public Value withId(UUID id) {
                return this.id == id ? this : new Value(id, this.markers, this.tree, this.enclosedInBraces);
            }

            @NonNull
            public Value withMarkers(Markers markers) {
                return this.markers == markers ? this : new Value(this.id, markers, this.tree, this.enclosedInBraces);
            }

            @NonNull
            public Value withTree(J tree) {
                return this.tree == tree ? this : new Value(this.id, this.markers, tree, this.enclosedInBraces);
            }

            @NonNull
            public Value withEnclosedInBraces(boolean enclosedInBraces) {
                return this.enclosedInBraces == enclosedInBraces ? this : new Value(this.id, this.markers, this.tree, enclosedInBraces);
            }
        }
    }

    public static final class ListLiteral
    implements G,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JContainer<Expression> elements;
        @Nullable
        private final JavaType type;

        public List<Expression> getElements() {
            return this.elements.getElements();
        }

        public ListLiteral withElements(List<Expression> elements) {
            return this.getPadding().withElements((JContainer<Expression>)JContainer.withElements(this.elements, elements));
        }

        @Override
        public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
            return v.visitListLiteral(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListLiteral)) {
                return false;
            }
            ListLiteral other = (ListLiteral)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ListLiteral(UUID id, Space prefix, Markers markers, JContainer<Expression> elements, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        private ListLiteral(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JContainer<Expression> elements, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public ListLiteral withId(UUID id) {
            return this.id == id ? this : new ListLiteral(this.padding, id, this.prefix, this.markers, this.elements, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public ListLiteral withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ListLiteral(this.padding, this.id, prefix, this.markers, this.elements, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public ListLiteral withMarkers(Markers markers) {
            return this.markers == markers ? this : new ListLiteral(this.padding, this.id, this.prefix, markers, this.elements, this.type);
        }

        @Nullable
        public JavaType getType() {
            return this.type;
        }

        @NonNull
        public ListLiteral withType(@Nullable JavaType type) {
            return this.type == type ? this : new ListLiteral(this.padding, this.id, this.prefix, this.markers, this.elements, type);
        }

        public static class Padding {
            private final ListLiteral t;

            public JContainer<Expression> getElements() {
                return this.t.elements;
            }

            public ListLiteral withElements(JContainer<Expression> elements) {
                return this.t.elements == elements ? this.t : new ListLiteral(this.t.id, this.t.prefix, this.t.markers, elements, this.t.type);
            }

            public Padding(ListLiteral t) {
                this.t = t;
            }
        }
    }

    public static final class MapLiteral
    implements G,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JContainer<MapEntry> elements;
        @Nullable
        private final JavaType type;

        public List<MapEntry> getElements() {
            return this.elements.getElements();
        }

        public MapLiteral withElements(List<MapEntry> elements) {
            return this.getPadding().withElements((JContainer<MapEntry>)JContainer.withElements(this.elements, elements));
        }

        @Override
        public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
            return v.visitMapLiteral(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapLiteral)) {
                return false;
            }
            MapLiteral other = (MapLiteral)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public MapLiteral(UUID id, Space prefix, Markers markers, JContainer<MapEntry> elements, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        private MapLiteral(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JContainer<MapEntry> elements, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public MapLiteral withId(UUID id) {
            return this.id == id ? this : new MapLiteral(this.padding, id, this.prefix, this.markers, this.elements, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public MapLiteral withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MapLiteral(this.padding, this.id, prefix, this.markers, this.elements, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public MapLiteral withMarkers(Markers markers) {
            return this.markers == markers ? this : new MapLiteral(this.padding, this.id, this.prefix, markers, this.elements, this.type);
        }

        @Nullable
        public JavaType getType() {
            return this.type;
        }

        @NonNull
        public MapLiteral withType(@Nullable JavaType type) {
            return this.type == type ? this : new MapLiteral(this.padding, this.id, this.prefix, this.markers, this.elements, type);
        }

        public static class Padding {
            private final MapLiteral t;

            public JContainer<MapEntry> getElements() {
                return this.t.elements;
            }

            public MapLiteral withElements(JContainer<MapEntry> elements) {
                return this.t.elements == elements ? this.t : new MapLiteral(this.t.id, this.t.prefix, this.t.markers, elements, this.t.type);
            }

            public Padding(MapLiteral t) {
                this.t = t;
            }
        }
    }

    public static final class MapEntry
    implements G,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Expression> key;
        private final Expression value;
        @Nullable
        private final JavaType type;

        public Expression getKey() {
            return (Expression)this.key.getElement();
        }

        public MapEntry withKey(@Nullable Expression key) {
            return this.getPadding().withKey((JRightPadded<Expression>)JRightPadded.withElement(this.key, (Object)key));
        }

        @Override
        public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
            return v.visitMapEntry(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapEntry)) {
                return false;
            }
            MapEntry other = (MapEntry)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public MapEntry(UUID id, Space prefix, Markers markers, JRightPadded<Expression> key, Expression value, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.key = key;
            this.value = value;
            this.type = type;
        }

        private MapEntry(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Expression> key, Expression value, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.key = key;
            this.value = value;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public MapEntry withId(UUID id) {
            return this.id == id ? this : new MapEntry(this.padding, id, this.prefix, this.markers, this.key, this.value, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public MapEntry withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MapEntry(this.padding, this.id, prefix, this.markers, this.key, this.value, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public MapEntry withMarkers(Markers markers) {
            return this.markers == markers ? this : new MapEntry(this.padding, this.id, this.prefix, markers, this.key, this.value, this.type);
        }

        public Expression getValue() {
            return this.value;
        }

        @NonNull
        public MapEntry withValue(Expression value) {
            return this.value == value ? this : new MapEntry(this.padding, this.id, this.prefix, this.markers, this.key, value, this.type);
        }

        @Nullable
        public JavaType getType() {
            return this.type;
        }

        @NonNull
        public MapEntry withType(@Nullable JavaType type) {
            return this.type == type ? this : new MapEntry(this.padding, this.id, this.prefix, this.markers, this.key, this.value, type);
        }

        public static class Padding {
            private final MapEntry t;

            @Nullable
            public JRightPadded<Expression> getKey() {
                return this.t.key;
            }

            public MapEntry withKey(@Nullable JRightPadded<Expression> key) {
                return this.t.key == key ? this.t : new MapEntry(this.t.id, this.t.prefix, this.t.markers, key, this.t.value, this.t.type);
            }

            public Padding(MapEntry t) {
                this.t = t;
            }
        }
    }

    public static final class CompilationUnit
    implements G,
    JavaSourceFile,
    SourceFile {
        @Nullable
        private transient SoftReference<TypeCache> typesInUse;
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Path sourcePath;
        @Nullable
        private final JRightPadded<J.Package> packageDeclaration;
        private final List<JRightPadded<Statement>> statements;
        private final Space eof;

        @Nullable
        public J.Package getPackageDeclaration() {
            return this.packageDeclaration == null ? null : (J.Package)this.packageDeclaration.getElement();
        }

        public CompilationUnit withPackageDeclaration(J.Package packageDeclaration) {
            return this.getPadding().withPackageDeclaration((JRightPadded<J.Package>)JRightPadded.withElement(this.packageDeclaration, (Object)packageDeclaration));
        }

        public List<Statement> getStatements() {
            return JRightPadded.getElements(this.statements);
        }

        public CompilationUnit withStatements(List<Statement> statements) {
            return this.getPadding().withStatements(JRightPadded.withElements(this.statements, statements));
        }

        public List<J.Import> getImports() {
            return this.statements.stream().map(JRightPadded::getElement).filter(J.Import.class::isInstance).map(J.Import.class::cast).collect(Collectors.toList());
        }

        public CompilationUnit withImports(List<J.Import> imports) {
            return this;
        }

        public List<J.ClassDeclaration> getClasses() {
            return this.statements.stream().map(JRightPadded::getElement).filter(J.ClassDeclaration.class::isInstance).map(J.ClassDeclaration.class::cast).collect(Collectors.toList());
        }

        public CompilationUnit withClasses(List<J.ClassDeclaration> classes) {
            return this;
        }

        public <P> J acceptJava(final JavaVisitor<P> v, P p) {
            return new GroovyVisitor<P>(){

                public J visit(@Nullable Tree tree, P p) {
                    return tree instanceof CompilationUnit ? this.visitJavaSourceFile((JavaSourceFile)v.visitJavaSourceFile((JavaSourceFile)((CompilationUnit)tree), p), p) : (J)v.visit(tree, p);
                }
            }.visit((Tree)this, p);
        }

        @Override
        public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
            return v.visitJavaSourceFile(this, p);
        }

        public Set<NameTree> findType(String clazz) {
            return FindTypes.find((J)this, (String)clazz);
        }

        public Set<JavaType> getTypesInUse() {
            return this.typeCache().getTypesInUse();
        }

        public Set<JavaType.Method> getDeclaredMethods() {
            return this.typeCache().getDeclaredMethods();
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new GroovyPrinter();
        }

        private TypeCache typeCache() {
            TypeCache cache;
            if (this.typesInUse == null) {
                cache = TypeCache.build((JavaSourceFile)this);
                this.typesInUse = new SoftReference<TypeCache>(cache);
            } else {
                cache = this.typesInUse.get();
                if (cache == null || cache.getCu() != this) {
                    cache = TypeCache.build((JavaSourceFile)this);
                    this.typesInUse = new SoftReference<TypeCache>(cache);
                }
            }
            return cache;
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "G.CompilationUnit(typesInUse=" + this.getTypesInUse() + ", padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", sourcePath=" + this.getSourcePath() + ", packageDeclaration=" + this.getPackageDeclaration() + ", statements=" + this.getStatements() + ", eof=" + this.getEof() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilationUnit)) {
                return false;
            }
            CompilationUnit other = (CompilationUnit)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public CompilationUnit(UUID id, Space prefix, Markers markers, Path sourcePath, @Nullable JRightPadded<J.Package> packageDeclaration, List<JRightPadded<Statement>> statements, Space eof) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.packageDeclaration = packageDeclaration;
            this.statements = statements;
            this.eof = eof;
        }

        private CompilationUnit(@Nullable SoftReference<TypeCache> typesInUse, @Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Path sourcePath, @Nullable JRightPadded<J.Package> packageDeclaration, List<JRightPadded<Statement>> statements, Space eof) {
            this.typesInUse = typesInUse;
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.packageDeclaration = packageDeclaration;
            this.statements = statements;
            this.eof = eof;
        }

        @NonNull
        public CompilationUnit withId(UUID id) {
            return this.id == id ? this : new CompilationUnit(this.typesInUse, this.padding, id, this.prefix, this.markers, this.sourcePath, this.packageDeclaration, this.statements, this.eof);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public CompilationUnit withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, prefix, this.markers, this.sourcePath, this.packageDeclaration, this.statements, this.eof);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public CompilationUnit withMarkers(Markers markers) {
            return this.markers == markers ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, markers, this.sourcePath, this.packageDeclaration, this.statements, this.eof);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public CompilationUnit withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, sourcePath, this.packageDeclaration, this.statements, this.eof);
        }

        public Path getSourcePath() {
            return this.sourcePath;
        }

        @NonNull
        public CompilationUnit withEof(Space eof) {
            return this.eof == eof ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.packageDeclaration, this.statements, eof);
        }

        public Space getEof() {
            return this.eof;
        }

        public static class Padding
        implements JavaSourceFile.Padding {
            private final CompilationUnit t;

            @Nullable
            public JRightPadded<J.Package> getPackageDeclaration() {
                return this.t.packageDeclaration;
            }

            public CompilationUnit withPackageDeclaration(@Nullable JRightPadded<J.Package> packageDeclaration) {
                return this.t.packageDeclaration == packageDeclaration ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, packageDeclaration, this.t.statements, this.t.eof);
            }

            public List<JRightPadded<J.Import>> getImports() {
                return this.t.statements.stream().filter(s -> s.getElement() instanceof J.Import).map(s -> s).collect(Collectors.toList());
            }

            public CompilationUnit withImports(List<JRightPadded<J.Import>> imports) {
                return this.t;
            }

            public List<JRightPadded<Statement>> getStatements() {
                return this.t.statements;
            }

            public CompilationUnit withStatements(List<JRightPadded<Statement>> statements) {
                return this.t.statements == statements ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, (JRightPadded<J.Package>)this.t.packageDeclaration, statements, this.t.eof);
            }

            public Padding(CompilationUnit t) {
                this.t = t;
            }
        }
    }
}

