/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

class TypeMapping {
    private static final int KIND_BITMASK_INTERFACE = 512;
    private static final int KIND_BITMASK_ANNOTATION = 8192;
    private static final int KIND_BITMASK_ENUM = 16384;
    private final Map<String, JavaType.Class> sharedClassTypes;

    @Nullable
    public JavaType.Method type(@Nullable MethodNode node) {
        if (node == null) {
            return null;
        }
        JavaType.Method.Signature signature = new JavaType.Method.Signature(this.type(node.getReturnType(), Collections.emptyList()), Arrays.stream(node.getParameters()).map(p -> {
            JavaType paramType = this.type(p.getOriginType(), Collections.emptyList());
            if (paramType instanceof JavaType.Parameterized) {
                return ((JavaType.Parameterized)paramType).getType();
            }
            return paramType;
        }).collect(Collectors.toList()));
        return JavaType.Method.build((long)node.getModifiers(), (JavaType.FullyQualified)((JavaType.FullyQualified)this.type(node.getDeclaringClass(), Collections.emptyList())), (String)node.getName(), (JavaType.Method.Signature)signature, (JavaType.Method.Signature)signature, Arrays.stream(node.getParameters()).map(Parameter::getName).collect(Collectors.toList()), Arrays.stream(node.getExceptions()).map(e -> (JavaType.FullyQualified)this.type((ClassNode)e, Collections.emptyList())).collect(Collectors.toList()), node.getAnnotations().stream().map(a -> (JavaType.FullyQualified)this.type(a.getClassNode(), Collections.emptyList())).collect(Collectors.toList()));
    }

    @Nullable
    public JavaType type(@Nullable ClassNode node) {
        return this.type(node, Collections.emptyList());
    }

    @Nullable
    public JavaType type(@Nullable ClassNode node, List<Class<?>> stack) {
        if (node == null) {
            return null;
        }
        JavaType.Primitive primitiveType = JavaType.Primitive.fromKeyword((String)node.getUnresolvedName());
        if (primitiveType != null) {
            return primitiveType;
        }
        try {
            return node.getGenericsTypes() != null && node.getGenericsTypes().length > 0 ? this.parameterizedType(node.getTypeClass(), node.getGenericsTypes(), stack) : this.type(node.getTypeClass(), stack);
        }
        catch (NoClassDefFoundError | GroovyBugError ignored) {
            return JavaType.Class.build((String)node.getName());
        }
    }

    private JavaType parameterizedType(Class<?> clazz, GenericsType[] generics, List<Class<?>> stack) {
        if (stack.contains(clazz)) {
            return new JavaType.Cyclic(clazz.getName());
        }
        ArrayList stackWithSym = new ArrayList(stack);
        stackWithSym.add(clazz);
        return JavaType.Parameterized.build((JavaType.FullyQualified)((JavaType.FullyQualified)this.type(clazz, stackWithSym)), Arrays.stream(generics).map(g -> {
            if (g.getUpperBounds() != null) {
                return new JavaType.GenericTypeVariable(g.getName(), TypeUtils.asFullyQualified((JavaType)this.type(g.getUpperBounds()[0], stackWithSym)));
            }
            return this.type(g.getType(), stackWithSym);
        }).collect(Collectors.toList()));
    }

    private <T extends JavaType> T type(@Nullable Class<?> clazz, List<Class<?>> stack) {
        if (clazz == null) {
            return null;
        }
        if (clazz.getName().equals("java.lang.Object")) {
            return (T)JavaType.Class.OBJECT;
        }
        if (clazz.getName().equals("java.lang.Class")) {
            return (T)JavaType.Class.build((String)"java.lang.Class");
        }
        JavaType.Primitive primitiveType = JavaType.Primitive.fromKeyword((String)clazz.getName());
        if (primitiveType != null) {
            return (T)primitiveType;
        }
        if (stack.contains(clazz)) {
            return (T)new JavaType.Cyclic(clazz.getName());
        }
        JavaType.Class sharedClass = this.sharedClassTypes.get(clazz.getName());
        if (sharedClass != null) {
            return (T)sharedClass;
        }
        JavaType.Class cached = JavaType.Class.find((String)clazz.getName());
        if (cached != null) {
            return (T)cached;
        }
        ArrayList stackWithSym = new ArrayList(stack);
        stackWithSym.add(clazz);
        JavaType.Class.Kind kind = (clazz.getModifiers() & 0x4000) != 0 ? JavaType.Class.Kind.Enum : ((clazz.getModifiers() & 0x2000) != 0 ? JavaType.Class.Kind.Annotation : ((clazz.getModifiers() & 0x200) != 0 ? JavaType.Class.Kind.Interface : JavaType.Class.Kind.Class));
        return (T)JavaType.Class.build((long)clazz.getModifiers(), (String)clazz.getName(), (JavaType.Class.Kind)kind, Arrays.stream(clazz.getDeclaredFields()).map(f -> this.field((Field)f, stackWithSym)).collect(Collectors.toList()), Arrays.stream(clazz.getInterfaces()).map(i -> (JavaType.FullyQualified)this.type((Class<?>)i, (List<Class<?>>)stackWithSym)).collect(Collectors.toList()), Arrays.stream(clazz.getDeclaredMethods()).map(m -> this.method((Method)m, stackWithSym)).collect(Collectors.toList()), (JavaType.FullyQualified)((JavaType.FullyQualified)this.type(clazz.getSuperclass(), stackWithSym)), (JavaType.FullyQualified)((JavaType.FullyQualified)this.type(clazz.getDeclaringClass(), stackWithSym)), Arrays.stream(clazz.getDeclaredAnnotations()).map(a -> (JavaType.FullyQualified)this.type(a.annotationType(), stackWithSym)).collect(Collectors.toList()), null, (boolean)false);
    }

    private JavaType.Variable field(Field field, List<Class<?>> stack) {
        return JavaType.Variable.build((String)field.getName(), (JavaType.FullyQualified)((JavaType.FullyQualified)this.type(field.getDeclaringClass(), stack)), this.type(field.getType(), stack), Arrays.stream(field.getDeclaredAnnotations()).map(a -> (JavaType.FullyQualified)this.type(a.annotationType(), stack)).collect(Collectors.toList()), (long)field.getModifiers());
    }

    private JavaType.Method method(Method method, List<Class<?>> stack) {
        return JavaType.Method.build((long)method.getModifiers(), (JavaType.FullyQualified)((JavaType.FullyQualified)this.type(method.getDeclaringClass(), stack)), (String)method.getName(), null, null, Arrays.stream(method.getParameters()).map(java.lang.reflect.Parameter::getName).collect(Collectors.toList()), Arrays.stream(method.getExceptionTypes()).map(e -> (JavaType.FullyQualified)this.type((Class<?>)e, stack)).collect(Collectors.toList()), Arrays.stream(method.getDeclaredAnnotations()).map(a -> (JavaType.FullyQualified)this.type(a.annotationType(), stack)).collect(Collectors.toList()));
    }

    public TypeMapping(Map<String, JavaType.Class> sharedClassTypes) {
        this.sharedClassTypes = sharedClassTypes;
    }
}

