/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy;

import java.util.List;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Tree;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.marker.Elvis;
import org.openrewrite.groovy.marker.ImplicitDot;
import org.openrewrite.groovy.marker.ImplicitReturn;
import org.openrewrite.groovy.marker.InStyleForEachLoop;
import org.openrewrite.groovy.marker.NullSafe;
import org.openrewrite.groovy.marker.OmitParentheses;
import org.openrewrite.groovy.marker.Semicolon;
import org.openrewrite.groovy.marker.StarDot;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.groovy.tree.GContainer;
import org.openrewrite.groovy.tree.GRightPadded;
import org.openrewrite.groovy.tree.GSpace;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class GroovyPrinter<P>
extends GroovyVisitor<PrintOutputCapture<P>> {
    private final GroovyJavaPrinter delegate = new GroovyJavaPrinter();

    public J visit(@Nullable Tree tree, PrintOutputCapture<P> p) {
        if (!(tree instanceof G)) {
            return this.delegate.visit(tree, p);
        }
        return (J)super.visit(tree, p);
    }

    @Override
    public J visitJavaSourceFile(JavaSourceFile sourceFile, PrintOutputCapture<P> p) {
        G.CompilationUnit cu = (G.CompilationUnit)sourceFile;
        this.visitSpace(cu.getPrefix(), Space.Location.COMPILATION_UNIT_PREFIX, p);
        this.visitMarkers(cu.getMarkers(), p);
        JRightPadded<J.Package> pkg = cu.getPadding().getPackageDeclaration();
        if (pkg != null) {
            this.visit((Tree)pkg.getElement(), p);
            this.visitSpace(pkg.getAfter(), Space.Location.PACKAGE_SUFFIX, p);
        }
        for (JRightPadded<Statement> statement : cu.getPadding().getStatements()) {
            this.visitRightPadded(statement, GRightPadded.Location.TOP_LEVEL_STATEMENT_SUFFIX, p);
        }
        this.visitSpace(cu.getEof(), Space.Location.COMPILATION_UNIT_EOF, p);
        return cu;
    }

    @Override
    public J visitGString(G.GString gString, PrintOutputCapture<P> p) {
        this.visitSpace(gString.getPrefix(), GSpace.Location.GSTRING, p);
        this.visitMarkers(gString.getMarkers(), p);
        p.out.append('\"');
        this.visit(gString.getStrings(), p);
        p.out.append('\"');
        return gString;
    }

    @Override
    public J visitGStringValue(G.GString.Value value, PrintOutputCapture<P> p) {
        this.visitMarkers(value.getMarkers(), p);
        if (value.isEnclosedInBraces()) {
            p.out.append("${");
        } else {
            p.out.append("$");
        }
        this.visit((Tree)value.getTree(), p);
        if (value.isEnclosedInBraces()) {
            p.out.append('}');
        }
        return value;
    }

    @Override
    public J visitListLiteral(G.ListLiteral listLiteral, PrintOutputCapture<P> p) {
        this.visitSpace(listLiteral.getPrefix(), GSpace.Location.LIST_LITERAL, p);
        this.visitMarkers(listLiteral.getMarkers(), p);
        this.visitContainer("[", listLiteral.getPadding().getElements(), GContainer.Location.LIST_LITERAL_ELEMENTS, ",", "]", p);
        return listLiteral;
    }

    @Override
    public J visitMapEntry(G.MapEntry mapEntry, PrintOutputCapture<P> p) {
        this.visitSpace(mapEntry.getPrefix(), GSpace.Location.MAP_ENTRY, p);
        this.visitMarkers(mapEntry.getMarkers(), p);
        this.visitRightPadded(mapEntry.getPadding().getKey(), GRightPadded.Location.MAP_ENTRY_KEY, p);
        p.out.append(':');
        this.visit((Tree)mapEntry.getValue(), p);
        return mapEntry;
    }

    @Override
    public J visitMapLiteral(G.MapLiteral mapLiteral, PrintOutputCapture<P> p) {
        this.visitSpace(mapLiteral.getPrefix(), GSpace.Location.MAP_LITERAL, p);
        this.visitMarkers(mapLiteral.getMarkers(), p);
        this.visitContainer("[", mapLiteral.getPadding().getElements(), GContainer.Location.MAP_LITERAL_ELEMENTS, ",", "]", p);
        return mapLiteral;
    }

    @Override
    public Space visitSpace(Space space, GSpace.Location loc, PrintOutputCapture<P> p) {
        return this.delegate.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, p);
    }

    protected void visitContainer(String before, @Nullable JContainer<? extends J> container, GContainer.Location location, String suffixBetween, @Nullable String after, PrintOutputCapture<P> p) {
        if (container == null) {
            return;
        }
        this.visitSpace(container.getBefore(), location.getBeforeLocation(), p);
        p.out.append(before);
        this.visitRightPadded(container.getPadding().getElements(), location.getElementLocation(), suffixBetween, p);
        p.out.append(after == null ? "" : after);
    }

    protected void visitRightPadded(List<? extends JRightPadded<? extends J>> nodes, GRightPadded.Location location, String suffixBetween, PrintOutputCapture<P> p) {
        for (int i = 0; i < nodes.size(); ++i) {
            JRightPadded<? extends J> node = nodes.get(i);
            this.visit((Tree)node.getElement(), p);
            this.visitSpace(node.getAfter(), location.getAfterLocation(), p);
            if (i >= nodes.size() - 1) continue;
            p.out.append(suffixBetween);
        }
    }

    public <M extends Marker> M visitMarker(Marker marker, PrintOutputCapture<P> p) {
        return this.delegate.visitMarker(marker, p);
    }

    private class GroovyJavaPrinter
    extends JavaPrinter<P> {
        private GroovyJavaPrinter() {
        }

        public J visit(@Nullable Tree tree, PrintOutputCapture<P> p) {
            if (tree instanceof G) {
                return GroovyPrinter.this.visit(tree, p);
            }
            return (J)super.visit(tree, p);
        }

        public J visitLambda(J.Lambda lambda, PrintOutputCapture<P> p) {
            this.visitSpace(lambda.getPrefix(), Space.Location.LAMBDA_PREFIX, p);
            this.visitMarkers(lambda.getMarkers(), p);
            p.out.append('{');
            this.visit((Tree)lambda.getParameters(), p);
            if (!lambda.getParameters().getParameters().isEmpty()) {
                this.visitSpace(lambda.getArrow(), Space.Location.LAMBDA_ARROW_PREFIX, p);
                p.out.append("->");
            }
            if (lambda.getBody() instanceof J.Block) {
                J.Block block = (J.Block)lambda.getBody();
                this.visitStatements(block.getPadding().getStatements(), JRightPadded.Location.BLOCK_STATEMENT, p);
                this.visitSpace(block.getEnd(), Space.Location.BLOCK_END, p);
            } else {
                this.visit((Tree)lambda.getBody(), p);
            }
            p.out.append('}');
            return lambda;
        }

        public J visitFieldAccess(J.FieldAccess fieldAccess, PrintOutputCapture<P> p) {
            this.visitSpace(fieldAccess.getPrefix(), Space.Location.FIELD_ACCESS_PREFIX, p);
            this.visitMarkers(fieldAccess.getMarkers(), p);
            this.visit((Tree)fieldAccess.getTarget(), p);
            Markers nameMarkers = fieldAccess.getName().getMarkers();
            if (nameMarkers.findFirst(NullSafe.class).isPresent()) {
                p.out.append('?');
            }
            if (nameMarkers.findFirst(StarDot.class).isPresent()) {
                p.out.append('*');
            }
            this.visitLeftPadded(".", fieldAccess.getPadding().getName(), JLeftPadded.Location.FIELD_ACCESS_NAME, p);
            return fieldAccess;
        }

        public J visitForEachLoop(J.ForEachLoop forEachLoop, PrintOutputCapture<P> p) {
            this.visitSpace(forEachLoop.getPrefix(), Space.Location.FOR_EACH_LOOP_PREFIX, p);
            this.visitMarkers(forEachLoop.getMarkers(), p);
            p.out.append("for");
            J.ForEachLoop.Control ctrl = forEachLoop.getControl();
            this.visitSpace(ctrl.getPrefix(), Space.Location.FOR_EACH_CONTROL_PREFIX, p);
            p.out.append('(');
            String suffix = forEachLoop.getMarkers().findFirst(InStyleForEachLoop.class).isPresent() ? "in" : ":";
            this.visitRightPadded(ctrl.getPadding().getVariable(), JRightPadded.Location.FOREACH_VARIABLE, suffix, p);
            this.visitRightPadded(ctrl.getPadding().getIterable(), JRightPadded.Location.FOREACH_ITERABLE, "", p);
            p.out.append(')');
            this.visitStatement((JRightPadded<Statement>)forEachLoop.getPadding().getBody(), JRightPadded.Location.FOR_BODY, p);
            return forEachLoop;
        }

        public J visitMethodInvocation(J.MethodInvocation method, PrintOutputCapture<P> p) {
            this.visitSpace(method.getPrefix(), Space.Location.METHOD_INVOCATION_PREFIX, p);
            this.visitMarkers(method.getMarkers(), p);
            Markers nameMarkers = method.getName().getMarkers();
            this.visitRightPadded(method.getPadding().getSelect(), JRightPadded.Location.METHOD_SELECT, nameMarkers.findFirst(NullSafe.class).isPresent() ? "?." : (nameMarkers.findFirst(StarDot.class).isPresent() ? "*." : (nameMarkers.findFirst(ImplicitDot.class).isPresent() ? "" : ".")), p);
            this.visitContainer("<", method.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
            this.visit((Tree)method.getName(), p);
            JContainer argContainer = method.getPadding().getArguments();
            this.visitSpace(argContainer.getBefore(), Space.Location.METHOD_INVOCATION_ARGUMENTS, p);
            List args = argContainer.getPadding().getElements();
            for (int i = 0; i < args.size(); ++i) {
                JRightPadded arg = (JRightPadded)args.get(i);
                boolean omitParens = ((Expression)arg.getElement()).getMarkers().findFirst(OmitParentheses.class).isPresent();
                if (i == 0 && !omitParens) {
                    p.out.append('(');
                } else if (i > 0 && omitParens && !((Expression)((JRightPadded)args.get(0)).getElement()).getMarkers().findFirst(OmitParentheses.class).isPresent()) {
                    p.out.append(')');
                } else if (i > 0) {
                    p.out.append(',');
                }
                this.visitRightPadded(arg, JRightPadded.Location.METHOD_INVOCATION_ARGUMENT, p);
                if (i != args.size() - 1 || omitParens) continue;
                p.out.append(')');
            }
            return method;
        }

        public J visitReturn(J.Return retrn, PrintOutputCapture<P> p) {
            if (retrn.getMarkers().findFirst(ImplicitReturn.class).isPresent()) {
                this.visitSpace(retrn.getPrefix(), Space.Location.RETURN_PREFIX, p);
                this.visitMarkers(retrn.getMarkers(), p);
                this.visit((Tree)retrn.getExpression(), p);
                return retrn;
            }
            return super.visitReturn(retrn, p);
        }

        protected void visitStatement(@Nullable JRightPadded<Statement> paddedStat, JRightPadded.Location location, PrintOutputCapture<P> p) {
            if (paddedStat != null) {
                this.visit((Tree)paddedStat.getElement(), p);
                this.visitSpace(paddedStat.getAfter(), location.getAfterLocation(), p);
                this.visitMarkers(paddedStat.getMarkers(), p);
            }
        }

        public J visitTernary(J.Ternary ternary, PrintOutputCapture<P> p) {
            this.visitSpace(ternary.getPrefix(), Space.Location.TERNARY_PREFIX, p);
            this.visitMarkers(ternary.getMarkers(), p);
            this.visit((Tree)ternary.getCondition(), p);
            if (ternary.getMarkers().findFirst(Elvis.class).isPresent()) {
                this.visitSpace(ternary.getPadding().getTruePart().getBefore(), Space.Location.TERNARY_TRUE, p);
                p.out.append("?:");
                this.visit((Tree)ternary.getFalsePart(), p);
            } else {
                this.visitLeftPadded("?", ternary.getPadding().getTruePart(), JLeftPadded.Location.TERNARY_TRUE, p);
                this.visitLeftPadded(":", ternary.getPadding().getFalsePart(), JLeftPadded.Location.TERNARY_FALSE, p);
            }
            return ternary;
        }

        public <M extends Marker> M visitMarker(Marker marker, PrintOutputCapture<P> p) {
            if (marker instanceof Semicolon) {
                p.out.append(';');
            }
            return (M)super.visitMarker(marker, p);
        }
    }
}

