/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingVisitor;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;
import org.jetbrains.annotations.NotNull;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.groovy.GroovyParsingException;
import org.openrewrite.groovy.TypeMapping;
import org.openrewrite.groovy.marker.Elvis;
import org.openrewrite.groovy.marker.ImplicitDot;
import org.openrewrite.groovy.marker.ImplicitReturn;
import org.openrewrite.groovy.marker.InStyleForEachLoop;
import org.openrewrite.groovy.marker.NullSafe;
import org.openrewrite.groovy.marker.OmitParentheses;
import org.openrewrite.groovy.marker.Semicolon;
import org.openrewrite.groovy.marker.StarDot;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class GroovyParserVisitor {
    private final Path sourcePath;
    private final String source;
    private final TypeMapping typeMapping;
    private final ExecutionContext ctx;
    private int cursor = 0;
    private static final Pattern whitespacePrefixPattern = Pattern.compile("^\\s*");
    private static final Pattern whitespaceSuffixPattern = Pattern.compile("\\s*[^\\s]+(\\s*)");

    public GroovyParserVisitor(Path sourcePath, String source, Map<String, JavaType.Class> sharedClassTypes, ExecutionContext ctx) {
        this.sourcePath = sourcePath;
        this.source = source;
        this.typeMapping = new TypeMapping(sharedClassTypes);
        this.ctx = ctx;
    }

    public G.CompilationUnit visit(SourceUnit unit, ModuleNode ast) throws GroovyParsingException {
        for (Object aClass : ast.getClasses()) {
            try {
                new StaticTypeCheckingVisitor(unit, (ClassNode)aClass).visitClass((ClassNode)aClass);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
        TreeMap<LineColumn, List> sortedByPosition = new TreeMap<LineColumn, List>();
        for (org.codehaus.groovy.ast.stmt.Statement s : ast.getStatementBlock().getStatements()) {
            if (GroovyParserVisitor.isSynthetic((ASTNode)s)) continue;
            sortedByPosition.computeIfAbsent(GroovyParserVisitor.pos((ASTNode)s), i -> new ArrayList()).add(s);
        }
        JRightPadded pkg = null;
        if (ast.getPackage() != null) {
            this.cursor += "package".length();
            Object pkgName = ast.getPackage().getName();
            if (((String)pkgName).endsWith(".")) {
                pkgName = ((String)pkgName).substring(0, ((String)pkgName).length() - 1);
            }
            pkg = JRightPadded.build((Object)new J.Package(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Expression)this.buildName((String)pkgName), Collections.emptyList()));
        }
        for (ImportNode anImport : ast.getImports()) {
            sortedByPosition.computeIfAbsent(GroovyParserVisitor.pos((ASTNode)anImport), i -> new ArrayList()).add(anImport);
        }
        for (ImportNode anImport : ast.getStarImports()) {
            sortedByPosition.computeIfAbsent(GroovyParserVisitor.pos((ASTNode)anImport), i -> new ArrayList()).add(anImport);
        }
        for (ImportNode anImport : ast.getStaticImports().values()) {
            sortedByPosition.computeIfAbsent(GroovyParserVisitor.pos((ASTNode)anImport), i -> new ArrayList()).add(anImport);
        }
        for (ImportNode anImport : ast.getStaticStarImports().values()) {
            sortedByPosition.computeIfAbsent(GroovyParserVisitor.pos((ASTNode)anImport), i -> new ArrayList()).add(anImport);
        }
        for (ClassNode aClass : ast.getClasses()) {
            if (aClass.getSuperClass() != null && aClass.getSuperClass().getName().equals("groovy.lang.Script")) continue;
            sortedByPosition.computeIfAbsent(GroovyParserVisitor.pos((ASTNode)aClass), i -> new ArrayList()).add(aClass);
        }
        for (MethodNode method : ast.getMethods()) {
            sortedByPosition.computeIfAbsent(GroovyParserVisitor.pos((ASTNode)method), i -> new ArrayList()).add(method);
        }
        ArrayList<JRightPadded<Statement>> statements = new ArrayList<JRightPadded<Statement>>(sortedByPosition.size());
        for (List values : sortedByPosition.values()) {
            try {
                for (ASTNode value : values) {
                    statements.add(this.convertTopLevelStatement(unit, value));
                }
            }
            catch (Throwable t) {
                if (t instanceof StringIndexOutOfBoundsException) {
                    throw new GroovyParsingException("Failed to parse, cursor position likely inaccurate.", t);
                }
                throw new GroovyParsingException("Failed to parse at cursor position " + this.cursor + ". The next 10 characters in the original source are `" + this.source.substring(this.cursor, Math.min(this.source.length(), this.cursor + 10)) + "`", t);
            }
        }
        return new G.CompilationUnit(Tree.randomId(), Space.EMPTY, Markers.EMPTY, this.sourcePath, (JRightPadded<J.Package>)pkg, statements, Space.format((String)this.source.substring(this.cursor)));
    }

    private JRightPadded<Statement> convertTopLevelStatement(SourceUnit unit, ASTNode node) {
        if (node instanceof ClassNode) {
            ClassNode classNode = (ClassNode)node;
            RewriteGroovyClassVisitor classVisitor = new RewriteGroovyClassVisitor(unit);
            classVisitor.visitClass(classNode);
            return JRightPadded.build((Object)((Statement)classVisitor.pollQueue()));
        }
        if (node instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)node;
            RewriteGroovyClassVisitor classVisitor = new RewriteGroovyClassVisitor(unit);
            classVisitor.visitMethod(methodNode);
            return JRightPadded.build((Object)((Statement)classVisitor.pollQueue()));
        }
        if (node instanceof ImportNode) {
            ImportNode importNode = (ImportNode)node;
            String packageName = importNode.getPackageName();
            if (importNode.isStar()) {
                packageName = packageName + "*";
            }
            J.Import anImport = new J.Import(Tree.randomId(), this.sourceBefore("import"), Markers.EMPTY, this.padLeft(importNode.isStatic() ? this.sourceBefore("static") : Space.EMPTY, importNode.isStatic()), (J.FieldAccess)TypeTree.build((String)packageName).withPrefix(this.sourceBefore(packageName)));
            return this.maybeSemicolon(anImport);
        }
        RewriteGroovyVisitor groovyVisitor = new RewriteGroovyVisitor(node);
        node.visit((GroovyCodeVisitor)groovyVisitor);
        return this.maybeSemicolon((Statement)groovyVisitor.pollQueue());
    }

    private static LineColumn pos(ASTNode node) {
        return new LineColumn(node.getLineNumber(), node.getColumnNumber());
    }

    private static boolean isSynthetic(ASTNode node) {
        return node.getLineNumber() == -1;
    }

    private <T> JLeftPadded<T> padLeft(Space left, T tree) {
        return new JLeftPadded(left, tree, Markers.EMPTY);
    }

    private int positionOfNext(String untilDelim) {
        int delimIndex;
        boolean inMultiLineComment = false;
        boolean inSingleLineComment = false;
        for (delimIndex = this.cursor; delimIndex < this.source.length() - untilDelim.length() + 1; ++delimIndex) {
            if (inSingleLineComment && this.source.charAt(delimIndex) == '\n') {
                inSingleLineComment = false;
                continue;
            }
            if (this.source.length() - untilDelim.length() > delimIndex + 1) {
                switch (this.source.substring(delimIndex, delimIndex + 2)) {
                    case "//": {
                        inSingleLineComment = true;
                        ++delimIndex;
                        break;
                    }
                    case "/*": {
                        inMultiLineComment = true;
                        ++delimIndex;
                        break;
                    }
                    case "*/": {
                        inMultiLineComment = false;
                        delimIndex += 2;
                    }
                }
            }
            if (!inMultiLineComment && !inSingleLineComment && this.source.startsWith(untilDelim, delimIndex)) break;
        }
        return delimIndex > this.source.length() - untilDelim.length() ? -1 : delimIndex;
    }

    /*
     * Unable to fully structure code
     */
    private Space whitespace() {
        inMultiLineComment = false;
        inSingleLineComment = false;
        block10: for (delimIndex = this.cursor; delimIndex < this.source.length(); ++delimIndex) {
            if (inSingleLineComment && (this.source.charAt(delimIndex) == '\n' || this.source.charAt(delimIndex) == '\r')) {
                inSingleLineComment = false;
                continue;
            }
            if (this.source.length() <= delimIndex + 1) ** GOTO lbl-1000
            var4_4 = this.source.substring(delimIndex, delimIndex + 2);
            var5_5 = -1;
            switch (var4_4.hashCode()) {
                case 1504: {
                    if (!var4_4.equals("//")) break;
                    var5_5 = 0;
                    break;
                }
                case 1499: {
                    if (!var4_4.equals("/*")) break;
                    var5_5 = 1;
                    break;
                }
                case 1349: {
                    if (!var4_4.equals("*/")) break;
                    var5_5 = 2;
                }
            }
            switch (var5_5) {
                case 0: {
                    inSingleLineComment = true;
                    ++delimIndex;
                    continue block10;
                }
                case 1: {
                    inMultiLineComment = true;
                    ++delimIndex;
                    continue block10;
                }
                case 2: {
                    inMultiLineComment = false;
                    ++delimIndex;
                    continue block10;
                }
                default: lbl-1000:
                // 2 sources

                {
                    if (!inMultiLineComment && !inSingleLineComment && !Character.isWhitespace(this.source.substring(delimIndex, delimIndex + 1).charAt(0))) break block10;
                }
            }
        }
        prefix = this.source.substring(this.cursor, delimIndex);
        this.cursor += prefix.length();
        return Space.format((String)prefix);
    }

    private <T extends TypeTree & Expression> T buildName(String fullyQualifiedName) {
        Space prefix = this.whitespace();
        this.cursor += fullyQualifiedName.length();
        String[] parts = fullyQualifiedName.split("\\.");
        String fullName = "";
        J.Identifier expr = null;
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (i == 0) {
                fullName = part;
                expr = J.Identifier.build((UUID)Tree.randomId(), (Space)Space.EMPTY, (Markers)Markers.EMPTY, (String)part, null);
                continue;
            }
            fullName = fullName + "." + part;
            Matcher whitespacePrefix = whitespacePrefixPattern.matcher(part);
            Space identFmt = whitespacePrefix.matches() ? Space.format((String)whitespacePrefix.group(0)) : Space.EMPTY;
            Matcher whitespaceSuffix = whitespaceSuffixPattern.matcher(part);
            whitespaceSuffix.matches();
            Space namePrefix = i == parts.length - 1 ? Space.EMPTY : Space.format((String)whitespaceSuffix.group(1));
            expr = new J.FieldAccess(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Expression)expr, this.padLeft(namePrefix, J.Identifier.build((UUID)Tree.randomId(), (Space)identFmt, (Markers)Markers.EMPTY, (String)part.trim(), null)), (JavaType)(Character.isUpperCase(part.charAt(0)) || i == parts.length - 1 ? JavaType.Class.build((String)fullName) : null));
        }
        assert (expr != null);
        return (T)((TypeTree)expr.withPrefix(prefix));
    }

    private Space sourceBefore(String untilDelim) {
        int delimIndex = this.positionOfNext(untilDelim);
        if (delimIndex < 0) {
            return Space.EMPTY;
        }
        String prefix = this.source.substring(this.cursor, delimIndex);
        this.cursor += prefix.length() + untilDelim.length();
        return Space.format((String)prefix);
    }

    private TypeTree visitTypeTree(ClassNode classNode) {
        JavaType.Primitive primitiveType = JavaType.Primitive.fromKeyword((String)classNode.getUnresolvedName());
        if (primitiveType != null) {
            return new J.Primitive(Tree.randomId(), this.sourceBefore(classNode.getUnresolvedName()), Markers.EMPTY, primitiveType);
        }
        int saveCursor = this.cursor;
        Space fmt = this.whitespace();
        if (this.cursor < this.source.length() && this.source.startsWith("def", this.cursor)) {
            this.cursor += 3;
            return J.Identifier.build((UUID)Tree.randomId(), (Space)fmt, (Markers)Markers.EMPTY, (String)"def", (JavaType)JavaType.Class.build((String)"java.lang.Object"));
        }
        this.cursor = saveCursor;
        return this.buildName(classNode.getUnresolvedName());
    }

    private List<J.Modifier> visitModifiers(int modifiers) {
        ArrayList<J.Modifier> unorderedModifiers = new ArrayList<J.Modifier>();
        if ((modifiers & 0x400) != 0) {
            unorderedModifiers.add(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Abstract, Collections.emptyList()));
        }
        if ((modifiers & 0x10) != 0) {
            unorderedModifiers.add(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Final, Collections.emptyList()));
        }
        if ((modifiers & 2) != 0) {
            unorderedModifiers.add(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Private, Collections.emptyList()));
        }
        if ((modifiers & 4) != 0) {
            unorderedModifiers.add(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Protected, Collections.emptyList()));
        }
        if ((modifiers & 1) != 0) {
            unorderedModifiers.add(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Public, Collections.emptyList()));
        }
        if ((modifiers & 8) != 0) {
            unorderedModifiers.add(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Static, Collections.emptyList()));
        }
        if ((modifiers & 0x20) != 0) {
            unorderedModifiers.add(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Synchronized, Collections.emptyList()));
        }
        if ((modifiers & 0x80) != 0) {
            unorderedModifiers.add(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Transient, Collections.emptyList()));
        }
        if ((modifiers & 0x40) != 0) {
            unorderedModifiers.add(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Volatile, Collections.emptyList()));
        }
        ArrayList<J.Modifier> orderedModifiers = new ArrayList<J.Modifier>(unorderedModifiers.size());
        boolean foundModifier = true;
        block0: while (foundModifier) {
            int saveCursor = this.cursor;
            Space fmt = this.whitespace();
            for (J.Modifier mod : unorderedModifiers) {
                String modName = mod.getType().name().toLowerCase();
                if (!this.source.startsWith(modName, this.cursor)) continue;
                orderedModifiers.add(mod.withPrefix(fmt));
                unorderedModifiers.remove(mod);
                this.cursor += modName.length();
                continue block0;
            }
            foundModifier = false;
            this.cursor = saveCursor;
        }
        return orderedModifiers;
    }

    private <G2 extends J> JRightPadded<G2> maybeSemicolon(G2 g) {
        int saveCursor = this.cursor;
        Space beforeSemi = this.whitespace();
        Semicolon semicolon = null;
        if (this.cursor < this.source.length() && this.source.charAt(this.cursor) == ';') {
            semicolon = new Semicolon(Tree.randomId());
            ++this.cursor;
        } else {
            beforeSemi = Space.EMPTY;
            this.cursor = saveCursor;
        }
        JRightPadded paddedG = JRightPadded.build(g).withAfter(beforeSemi);
        if (semicolon != null) {
            paddedG = paddedG.withMarkers(paddedG.getMarkers().add((Marker)semicolon));
        }
        return paddedG;
    }

    private static final class LineColumn
    implements Comparable<LineColumn> {
        private final int line;
        private final int column;

        @Override
        public int compareTo(@NotNull LineColumn lc) {
            return this.line != lc.line ? this.line - lc.line : this.column - lc.column;
        }

        public LineColumn(int line, int column) {
            this.line = line;
            this.column = column;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LineColumn)) {
                return false;
            }
            LineColumn other = (LineColumn)o;
            if (this.getLine() != other.getLine()) {
                return false;
            }
            return this.getColumn() == other.getColumn();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLine();
            result = result * 59 + this.getColumn();
            return result;
        }

        @NonNull
        public String toString() {
            return "GroovyParserVisitor.LineColumn(line=" + this.getLine() + ", column=" + this.getColumn() + ")";
        }
    }

    private class RewriteGroovyVisitor
    extends CodeVisitorSupport {
        private Cursor nodeCursor;
        private final Queue<Object> queue = new LinkedList<Object>();

        public RewriteGroovyVisitor(ASTNode root) {
            this.nodeCursor = new Cursor(null, (Object)root);
        }

        private <T> T visit(ASTNode node) {
            this.nodeCursor = new Cursor(this.nodeCursor, (Object)node);
            node.visit((GroovyCodeVisitor)this);
            this.nodeCursor = this.nodeCursor.getParentOrThrow();
            return this.pollQueue();
        }

        private <T> List<JRightPadded<T>> visitRightPadded(ASTNode[] nodes, String between, @Nullable String afterLast) {
            ArrayList<JRightPadded<T>> ts = new ArrayList<JRightPadded<T>>(nodes.length);
            for (int i = 0; i < nodes.length; ++i) {
                ASTNode node = nodes[i];
                JRightPadded converted = JRightPadded.build(node instanceof ClassNode ? GroovyParserVisitor.this.visitTypeTree((ClassNode)node) : this.visit(node));
                if (i == nodes.length - 1) {
                    ts.add(converted.withAfter(afterLast == null ? Space.EMPTY : GroovyParserVisitor.this.sourceBefore(afterLast)));
                    continue;
                }
                ts.add(converted.withAfter(GroovyParserVisitor.this.sourceBefore(between)));
            }
            return ts;
        }

        public void visitArgumentlistExpression(ArgumentListExpression expression) {
            MapExpression namedArgExpressions;
            ArrayList<JRightPadded> args = new ArrayList<JRightPadded>(expression.getExpressions().size());
            int saveCursor = GroovyParserVisitor.this.cursor;
            Space beforeOpenParen = GroovyParserVisitor.this.whitespace();
            OmitParentheses omitParentheses = null;
            if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '(') {
                GroovyParserVisitor.this.cursor++;
            } else {
                omitParentheses = new OmitParentheses(Tree.randomId());
                beforeOpenParen = Space.EMPTY;
                GroovyParserVisitor.this.cursor = saveCursor;
            }
            List unparsedArgs = expression.getExpressions();
            if (unparsedArgs.size() > 1 && unparsedArgs.get(0) instanceof MapExpression && (((org.codehaus.groovy.ast.expr.Expression)unparsedArgs.get(0)).getLastLineNumber() > ((org.codehaus.groovy.ast.expr.Expression)unparsedArgs.get(1)).getLastLineNumber() || ((org.codehaus.groovy.ast.expr.Expression)unparsedArgs.get(0)).getLastLineNumber() == ((org.codehaus.groovy.ast.expr.Expression)unparsedArgs.get(1)).getLastLineNumber() && ((org.codehaus.groovy.ast.expr.Expression)unparsedArgs.get(0)).getLastColumnNumber() > ((org.codehaus.groovy.ast.expr.Expression)unparsedArgs.get(1)).getLastColumnNumber())) {
                namedArgExpressions = (MapExpression)unparsedArgs.get(0);
                unparsedArgs = Stream.concat(namedArgExpressions.getMapEntryExpressions().stream(), unparsedArgs.subList(1, unparsedArgs.size()).stream()).sorted(Comparator.comparing(ASTNode::getLastLineNumber).thenComparing(ASTNode::getLastColumnNumber)).collect(Collectors.toList());
            } else if (unparsedArgs.size() > 0 && unparsedArgs.get(0) instanceof MapExpression) {
                namedArgExpressions = (MapExpression)unparsedArgs.get(0);
                unparsedArgs = Stream.concat(namedArgExpressions.getMapEntryExpressions().stream(), unparsedArgs.subList(1, unparsedArgs.size()).stream()).collect(Collectors.toList());
            }
            for (int i = 0; i < unparsedArgs.size(); ++i) {
                Expression arg = (Expression)this.visit((ASTNode)unparsedArgs.get(i));
                if (omitParentheses != null) {
                    arg = (Expression)arg.withMarkers(arg.getMarkers().add((Marker)omitParentheses));
                }
                Space after = Space.EMPTY;
                if (i == unparsedArgs.size() - 1) {
                    if (omitParentheses == null) {
                        after = GroovyParserVisitor.this.sourceBefore(")");
                    }
                } else {
                    after = GroovyParserVisitor.this.whitespace();
                    if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == ')') {
                        omitParentheses = new OmitParentheses(Tree.randomId());
                    }
                    GroovyParserVisitor.this.cursor++;
                }
                args.add(JRightPadded.build((Object)arg).withAfter(after));
            }
            if (unparsedArgs.isEmpty()) {
                J.Empty element = new J.Empty(Tree.randomId(), omitParentheses == null ? GroovyParserVisitor.this.sourceBefore(")") : Space.EMPTY, Markers.EMPTY);
                if (omitParentheses != null) {
                    element = (Expression)element.withMarkers(element.getMarkers().add((Marker)omitParentheses));
                }
                args.add(JRightPadded.build((Object)element));
            }
            this.queue.add(JContainer.build((Space)beforeOpenParen, args, (Markers)Markers.EMPTY));
        }

        public void visitClassExpression(ClassExpression clazz) {
            this.queue.add(TypeTree.build((String)clazz.getType().getUnresolvedName()).withType(GroovyParserVisitor.this.typeMapping.type(clazz.getType())).withPrefix(GroovyParserVisitor.this.sourceBefore(clazz.getType().getUnresolvedName())));
        }

        public void visitBinaryExpression(BinaryExpression binary) {
            Space fmt = GroovyParserVisitor.this.whitespace();
            Expression left = (Expression)this.visit((ASTNode)binary.getLeftExpression());
            Space opPrefix = GroovyParserVisitor.this.whitespace();
            boolean assignment = false;
            J.AssignmentOperation.Type assignOp = null;
            J.Binary.Type binaryOp = null;
            switch (binary.getOperation().getText()) {
                case "+": {
                    binaryOp = J.Binary.Type.Addition;
                    break;
                }
                case "&&": {
                    binaryOp = J.Binary.Type.And;
                    break;
                }
                case "&": {
                    binaryOp = J.Binary.Type.BitAnd;
                    break;
                }
                case "|": {
                    binaryOp = J.Binary.Type.BitOr;
                    break;
                }
                case "^": {
                    binaryOp = J.Binary.Type.BitXor;
                    break;
                }
                case "/": {
                    binaryOp = J.Binary.Type.Division;
                    break;
                }
                case "==": {
                    binaryOp = J.Binary.Type.Equal;
                    break;
                }
                case ">": {
                    binaryOp = J.Binary.Type.GreaterThan;
                    break;
                }
                case ">=": {
                    binaryOp = J.Binary.Type.GreaterThanOrEqual;
                    break;
                }
                case "<<": {
                    binaryOp = J.Binary.Type.LeftShift;
                    break;
                }
                case "<": {
                    binaryOp = J.Binary.Type.LessThan;
                    break;
                }
                case "<=": {
                    binaryOp = J.Binary.Type.LessThanOrEqual;
                    break;
                }
                case "%": {
                    binaryOp = J.Binary.Type.Modulo;
                    break;
                }
                case "*": {
                    binaryOp = J.Binary.Type.Multiplication;
                    break;
                }
                case "!=": {
                    binaryOp = J.Binary.Type.NotEqual;
                    break;
                }
                case "||": {
                    binaryOp = J.Binary.Type.Or;
                    break;
                }
                case ">>": {
                    binaryOp = J.Binary.Type.RightShift;
                    break;
                }
                case "-": {
                    binaryOp = J.Binary.Type.Subtraction;
                    break;
                }
                case ">>>": {
                    binaryOp = J.Binary.Type.UnsignedRightShift;
                    break;
                }
                case "=": {
                    assignment = true;
                    break;
                }
                case "+=": {
                    assignOp = J.AssignmentOperation.Type.Addition;
                    break;
                }
                case "-=": {
                    assignOp = J.AssignmentOperation.Type.BitAnd;
                    break;
                }
                case "&=": {
                    assignOp = J.AssignmentOperation.Type.BitOr;
                    break;
                }
                case "|=": {
                    assignOp = J.AssignmentOperation.Type.BitXor;
                    break;
                }
                case "/=": {
                    assignOp = J.AssignmentOperation.Type.Division;
                    break;
                }
                case "<<=": {
                    assignOp = J.AssignmentOperation.Type.LeftShift;
                    break;
                }
                case "%=": {
                    assignOp = J.AssignmentOperation.Type.Modulo;
                    break;
                }
                case "*=": {
                    assignOp = J.AssignmentOperation.Type.Multiplication;
                    break;
                }
                case ">>=": {
                    assignOp = J.AssignmentOperation.Type.RightShift;
                    break;
                }
                case "^=": {
                    assignOp = J.AssignmentOperation.Type.Subtraction;
                    break;
                }
                case ">>>=": {
                    assignOp = J.AssignmentOperation.Type.UnsignedRightShift;
                }
            }
            GroovyParserVisitor.this.cursor += binary.getOperation().getText().length();
            Expression right = (Expression)this.visit((ASTNode)binary.getRightExpression());
            if (assignment) {
                this.queue.add(new J.Assignment(Tree.randomId(), fmt, Markers.EMPTY, left, JLeftPadded.build((Object)right).withBefore(opPrefix), GroovyParserVisitor.this.typeMapping.type(binary.getType())));
            } else if (assignOp != null) {
                this.queue.add(new J.AssignmentOperation(Tree.randomId(), fmt, Markers.EMPTY, left, JLeftPadded.build((Object)assignOp).withBefore(opPrefix), right, GroovyParserVisitor.this.typeMapping.type(binary.getType())));
            } else if (binaryOp != null) {
                this.queue.add(new J.Binary(Tree.randomId(), fmt, Markers.EMPTY, left, JLeftPadded.build((Object)binaryOp).withBefore(opPrefix), right, GroovyParserVisitor.this.typeMapping.type(binary.getType())));
            }
        }

        public void visitBlockStatement(BlockStatement block) {
            Space fmt = Space.EMPTY;
            Object parent = this.nodeCursor.getParentOrThrow().getValue();
            if (!(parent instanceof ClosureExpression)) {
                fmt = GroovyParserVisitor.this.sourceBefore("{");
            }
            ArrayList<JRightPadded> statements = new ArrayList<JRightPadded>(block.getStatements().size());
            List blockStatements = block.getStatements();
            for (int i = 0; i < blockStatements.size(); ++i) {
                ASTNode statement = (ASTNode)blockStatements.get(i);
                J expr = (J)this.visit(statement);
                if (i == blockStatements.size() - 1 && expr instanceof Expression && (parent instanceof ClosureExpression || parent instanceof MethodNode && !JavaType.Primitive.Void.equals((Object)GroovyParserVisitor.this.typeMapping.type(((MethodNode)parent).getReturnType())))) {
                    expr = new J.Return(Tree.randomId(), expr.getPrefix(), Markers.EMPTY, (Expression)expr.withPrefix(Space.EMPTY));
                    expr = expr.withMarkers(expr.getMarkers().add((Marker)new ImplicitReturn(Tree.randomId())));
                }
                JRightPadded stat = JRightPadded.build((Object)((Statement)expr));
                int saveCursor = GroovyParserVisitor.this.cursor;
                Space beforeSemicolon = GroovyParserVisitor.this.whitespace();
                if (GroovyParserVisitor.this.cursor < GroovyParserVisitor.this.source.length() && GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == ';') {
                    stat = stat.withMarkers(stat.getMarkers().add((Marker)new Semicolon(Tree.randomId()))).withAfter(beforeSemicolon);
                    GroovyParserVisitor.this.cursor++;
                } else {
                    GroovyParserVisitor.this.cursor = saveCursor;
                }
                statements.add(stat);
            }
            Space beforeBrace = GroovyParserVisitor.this.whitespace();
            this.queue.add(new J.Block(Tree.randomId(), fmt, Markers.EMPTY, JRightPadded.build((Object)false), statements, beforeBrace));
            if (!(parent instanceof ClosureExpression)) {
                GroovyParserVisitor.this.sourceBefore("}");
            }
        }

        public void visitClosureExpression(ClosureExpression expression) {
            J.Lambda.Parameters params;
            Space prefix = GroovyParserVisitor.this.sourceBefore("{");
            List paramExprs = Collections.emptyList();
            if (expression.getParameters().length > 0) {
                paramExprs = new ArrayList(expression.getParameters().length);
                Parameter[] parameters = expression.getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    Parameter p = parameters[i];
                    JavaType type = GroovyParserVisitor.this.typeMapping.type(p.getType());
                    J.VariableDeclarations expr = new J.VariableDeclarations(Tree.randomId(), GroovyParserVisitor.this.whitespace(), Markers.EMPTY, Collections.emptyList(), Collections.emptyList(), p.isDynamicTyped() ? null : GroovyParserVisitor.this.visitTypeTree(p.getType()), null, Collections.emptyList(), Collections.singletonList(JRightPadded.build((Object)new J.VariableDeclarations.NamedVariable(Tree.randomId(), GroovyParserVisitor.this.sourceBefore(p.getName()), Markers.EMPTY, J.Identifier.build((UUID)Tree.randomId(), (Space)Space.EMPTY, (Markers)Markers.EMPTY, (String)p.getName(), (JavaType)type), Collections.emptyList(), null, type))));
                    JRightPadded param = JRightPadded.build((Object)expr);
                    if (i != parameters.length - 1) {
                        param = param.withAfter(GroovyParserVisitor.this.sourceBefore(","));
                    }
                    paramExprs.add(param);
                }
            }
            Space arrow = (params = new J.Lambda.Parameters(Tree.randomId(), Space.EMPTY, Markers.EMPTY, false, paramExprs)).getParameters().isEmpty() ? Space.EMPTY : GroovyParserVisitor.this.sourceBefore("->");
            this.queue.add(new J.Lambda(Tree.randomId(), prefix, Markers.EMPTY, params, arrow, (J)this.visit((ASTNode)expression.getCode()), null));
            GroovyParserVisitor.this.cursor += 1;
        }

        public void visitClosureListExpression(ClosureListExpression closureListExpression) {
            List expressions = closureListExpression.getExpressions();
            ArrayList<JRightPadded> results = new ArrayList<JRightPadded>(closureListExpression.getExpressions().size());
            int expressionsSize = expressions.size();
            for (int i = 0; i < expressionsSize; ++i) {
                results.add(JRightPadded.build(this.visit((ASTNode)expressions.get(i))).withAfter(GroovyParserVisitor.this.whitespace()));
                if (i >= expressionsSize - 1) continue;
                GroovyParserVisitor.this.cursor++;
            }
            this.queue.add(results);
        }

        public void visitConstantExpression(ConstantExpression expression) {
            char c;
            JavaType.Primitive jType;
            Space prefix = GroovyParserVisitor.this.whitespace();
            String text = expression.getText();
            ClassNode type = expression.getType();
            if (type == ClassHelper.BigDecimal_TYPE) {
                jType = JavaType.Primitive.Double;
            } else if (type == ClassHelper.boolean_TYPE) {
                jType = JavaType.Primitive.Boolean;
            } else if (type == ClassHelper.byte_TYPE) {
                jType = JavaType.Primitive.Byte;
            } else if (type == ClassHelper.char_TYPE) {
                jType = JavaType.Primitive.Char;
            } else if (type == ClassHelper.double_TYPE || "java.lang.Double".equals(type.getName())) {
                jType = JavaType.Primitive.Double;
            } else if (type == ClassHelper.float_TYPE || "java.lang.Float".equals(type.getName())) {
                jType = JavaType.Primitive.Float;
            } else if (type == ClassHelper.int_TYPE || "java.lang.Integer".equals(type.getName())) {
                jType = JavaType.Primitive.Int;
            } else if (type == ClassHelper.long_TYPE || "java.lang.Long".equals(type.getName())) {
                jType = JavaType.Primitive.Long;
            } else if (type == ClassHelper.short_TYPE || "java.lang.Short".equals(type.getName())) {
                jType = JavaType.Primitive.Short;
            } else if (type == ClassHelper.STRING_TYPE) {
                jType = JavaType.Primitive.String;
                if (GroovyParserVisitor.this.source.startsWith("/", GroovyParserVisitor.this.cursor)) {
                    text = "/" + text + "/";
                } else if (GroovyParserVisitor.this.source.startsWith("\"\"\"", GroovyParserVisitor.this.cursor)) {
                    text = "\"\"\"" + text + "\"\"\"";
                } else if (GroovyParserVisitor.this.source.startsWith("'", GroovyParserVisitor.this.cursor)) {
                    text = "'" + text + "'";
                } else if (GroovyParserVisitor.this.source.startsWith("\"", GroovyParserVisitor.this.cursor)) {
                    text = "\"" + text + "\"";
                }
            } else if (expression.isNullExpression()) {
                text = "null";
                jType = JavaType.Primitive.Null;
            } else {
                GroovyParserVisitor.this.ctx.getOnError().accept(new IllegalStateException("Unexpected constant type " + type));
                return;
            }
            GroovyParserVisitor.this.cursor += text.length();
            if (!(jType != JavaType.Primitive.Double && jType != JavaType.Primitive.Float && jType != JavaType.Primitive.Long || (c = Character.toLowerCase(GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor))) != 'f' && c != 'd' && c != 'l')) {
                text = text + GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor);
                GroovyParserVisitor.this.cursor++;
            }
            this.queue.add(new J.Literal(Tree.randomId(), prefix, Markers.EMPTY, expression.getValue(), text, null, jType));
        }

        public void visitConstructorCallExpression(ConstructorCallExpression ctor) {
            Space fmt = GroovyParserVisitor.this.sourceBefore("new");
            TypeTree clazz = GroovyParserVisitor.this.visitTypeTree(ctor.getType());
            JContainer args = (JContainer)this.visit((ASTNode)ctor.getArguments());
            this.queue.add(new J.NewClass(Tree.randomId(), fmt, Markers.EMPTY, null, Space.EMPTY, clazz, args, null, null, GroovyParserVisitor.this.typeMapping.type(ctor.getType())));
        }

        public void visitDeclarationExpression(DeclarationExpression expression) {
            TypeTree typeExpr = this.visitVariableExpressionType(expression.getVariableExpression());
            if (expression.isMultipleAssignmentDeclaration()) {
                throw new UnsupportedOperationException("FIXME");
            }
            J.Identifier name = (J.Identifier)this.visit((ASTNode)expression.getVariableExpression());
            J.VariableDeclarations.NamedVariable namedVariable = new J.VariableDeclarations.NamedVariable(Tree.randomId(), name.getPrefix(), Markers.EMPTY, name.withPrefix(Space.EMPTY), Collections.emptyList(), null, name.getType());
            if (!(expression.getRightExpression() instanceof EmptyExpression)) {
                Space beforeAssign = GroovyParserVisitor.this.sourceBefore("=");
                Expression initializer = (Expression)this.visit((ASTNode)expression.getRightExpression());
                namedVariable = namedVariable.getPadding().withInitializer(GroovyParserVisitor.this.padLeft(beforeAssign, initializer));
            }
            J.VariableDeclarations variableDeclarations = new J.VariableDeclarations(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), Collections.emptyList(), typeExpr, null, Collections.emptyList(), Collections.singletonList(JRightPadded.build((Object)namedVariable)));
            this.queue.add(variableDeclarations);
        }

        public void visitEmptyExpression(EmptyExpression expression) {
            this.queue.add(new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY));
        }

        public void visitForLoop(ForStatement forLoop) {
            Space fmt = GroovyParserVisitor.this.sourceBefore("for");
            Space controlFmt = GroovyParserVisitor.this.sourceBefore("(");
            if (forLoop.getCollectionExpression() instanceof ClosureListExpression) {
                List controls = (List)this.visit((ASTNode)forLoop.getCollectionExpression());
                List init = ((JRightPadded)controls.get(0)).getElement() instanceof List ? (List)((JRightPadded)controls.get(0)).getElement() : Collections.singletonList((JRightPadded)controls.get(0));
                JRightPadded condition = (JRightPadded)controls.get(1);
                List update = ((JRightPadded)controls.get(2)).getElement() instanceof List ? (List)((JRightPadded)controls.get(2)).getElement() : Collections.singletonList((JRightPadded)controls.get(2));
                GroovyParserVisitor.this.cursor++;
                this.queue.add(new J.ForLoop(Tree.randomId(), fmt, Markers.EMPTY, new J.ForLoop.Control(Tree.randomId(), controlFmt, Markers.EMPTY, init, condition, update), JRightPadded.build((Object)((Statement)this.visit((ASTNode)forLoop.getLoopBlock())))));
            } else {
                Parameter param = forLoop.getVariable();
                TypeTree paramType = GroovyParserVisitor.this.visitTypeTree(param.getOriginType());
                JRightPadded paramName = JRightPadded.build((Object)new J.VariableDeclarations.NamedVariable(Tree.randomId(), GroovyParserVisitor.this.whitespace(), Markers.EMPTY, J.Identifier.build((UUID)Tree.randomId(), (Space)Space.EMPTY, (Markers)Markers.EMPTY, (String)param.getName(), null), Collections.emptyList(), null, null));
                GroovyParserVisitor.this.cursor += param.getName().length();
                Space rightPad = GroovyParserVisitor.this.whitespace();
                Markers forEachMarkers = Markers.EMPTY;
                if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == ':') {
                    GroovyParserVisitor.this.cursor++;
                } else {
                    GroovyParserVisitor.this.cursor += 2;
                    forEachMarkers = forEachMarkers.add((Marker)new InStyleForEachLoop(Tree.randomId()));
                }
                JRightPadded variable = JRightPadded.build((Object)new J.VariableDeclarations(Tree.randomId(), paramType.getPrefix(), Markers.EMPTY, Collections.emptyList(), Collections.emptyList(), (TypeTree)paramType.withPrefix(Space.EMPTY), null, Collections.emptyList(), Collections.singletonList(paramName))).withAfter(rightPad);
                JRightPadded iterable = JRightPadded.build((Object)((Expression)this.visit((ASTNode)forLoop.getCollectionExpression()))).withAfter(GroovyParserVisitor.this.sourceBefore(")"));
                this.queue.add(new J.ForEachLoop(Tree.randomId(), fmt, forEachMarkers, new J.ForEachLoop.Control(Tree.randomId(), Space.EMPTY, Markers.EMPTY, variable, iterable), JRightPadded.build((Object)((Statement)this.visit((ASTNode)forLoop.getLoopBlock())))));
            }
        }

        public void visitIfElse(IfStatement ifElse) {
            Space fmt = GroovyParserVisitor.this.sourceBefore("if");
            J.ControlParentheses ifCondition = new J.ControlParentheses(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("("), Markers.EMPTY, JRightPadded.build((Object)((Expression)this.visit((ASTNode)ifElse.getBooleanExpression().getExpression()))).withAfter(GroovyParserVisitor.this.sourceBefore(")")));
            JRightPadded then = GroovyParserVisitor.this.maybeSemicolon((J)((Statement)this.visit((ASTNode)ifElse.getIfBlock())));
            J.If.Else elze = ifElse.getElseBlock() instanceof EmptyStatement ? null : new J.If.Else(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("else"), Markers.EMPTY, GroovyParserVisitor.this.maybeSemicolon((J)((Statement)this.visit((ASTNode)ifElse.getElseBlock()))));
            this.queue.add(new J.If(Tree.randomId(), fmt, Markers.EMPTY, ifCondition, then, elze));
        }

        public void visitGStringExpression(GStringExpression gstring) {
            Space fmt = GroovyParserVisitor.this.sourceBefore("\"");
            ArrayList<J> strings = new ArrayList<J>(gstring.getStrings().size());
            int valueIndex = 0;
            for (ConstantExpression string : gstring.getStrings()) {
                if (string.getValue().equals("")) {
                    boolean inCurlies;
                    boolean bl = inCurlies = GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor + 1) == '{';
                    if (inCurlies) {
                        GroovyParserVisitor.this.cursor += 2;
                    } else {
                        GroovyParserVisitor.this.cursor += 1;
                    }
                    strings.add(new G.GString.Value(Tree.randomId(), Markers.EMPTY, (J)this.visit((ASTNode)gstring.getValue(valueIndex++)), inCurlies));
                    if (!inCurlies) continue;
                    GroovyParserVisitor.this.cursor++;
                    continue;
                }
                strings.add((J)this.visit((ASTNode)string));
            }
            this.queue.add(new G.GString(Tree.randomId(), fmt, Markers.EMPTY, strings, GroovyParserVisitor.this.typeMapping.type(gstring.getType())));
            GroovyParserVisitor.this.cursor++;
        }

        public void visitListExpression(ListExpression list) {
            this.queue.add(new G.ListLiteral(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("["), Markers.EMPTY, (JContainer<Expression>)JContainer.build(this.visitRightPadded(list.getExpressions().toArray(new ASTNode[0]), ",", "]")), GroovyParserVisitor.this.typeMapping.type(list.getType())));
        }

        public void visitMapEntryExpression(MapEntryExpression expression) {
            G.MapEntry mapEntry = new G.MapEntry(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (JRightPadded<Expression>)JRightPadded.build((Object)((Expression)this.visit((ASTNode)expression.getKeyExpression()))).withAfter(GroovyParserVisitor.this.sourceBefore(":")), (Expression)this.visit((ASTNode)expression.getValueExpression()), null);
            this.queue.add(mapEntry);
        }

        public void visitMapExpression(MapExpression map) {
            this.queue.add(new G.MapLiteral(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("["), Markers.EMPTY, (JContainer<G.MapEntry>)JContainer.build(this.visitRightPadded(map.getMapEntryExpressions().toArray(new ASTNode[0]), ",", "]")), GroovyParserVisitor.this.typeMapping.type(map.getType())));
        }

        public void visitMethodCallExpression(MethodCallExpression call) {
            Space fmt = GroovyParserVisitor.this.whitespace();
            ImplicitDot implicitDot = null;
            JRightPadded select = null;
            if (!call.isImplicitThis()) {
                Expression selectExpr = (Expression)this.visit((ASTNode)call.getObjectExpression());
                int saveCursor = GroovyParserVisitor.this.cursor;
                Space afterSelect = GroovyParserVisitor.this.whitespace();
                if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '.' || GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '?' || GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '*') {
                    GroovyParserVisitor.this.cursor = saveCursor;
                    afterSelect = GroovyParserVisitor.this.sourceBefore(call.isSpreadSafe() ? "*." : (call.isSafe() ? "?." : "."));
                } else {
                    implicitDot = new ImplicitDot(Tree.randomId());
                }
                select = JRightPadded.build((Object)selectExpr).withAfter(afterSelect);
            }
            J.Identifier name = J.Identifier.build((UUID)Tree.randomId(), (Space)GroovyParserVisitor.this.sourceBefore(call.getMethodAsString()), (Markers)Markers.EMPTY, (String)call.getMethodAsString(), null);
            if (call.isSpreadSafe()) {
                name = name.withMarkers(name.getMarkers().add((Marker)new StarDot(Tree.randomId())));
            }
            if (call.isSafe()) {
                name = name.withMarkers(name.getMarkers().add((Marker)new NullSafe(Tree.randomId())));
            }
            if (implicitDot != null) {
                name = name.withMarkers(name.getMarkers().add(implicitDot));
            }
            JContainer args = (JContainer)this.visit((ASTNode)call.getArguments());
            MethodNode methodNode = (MethodNode)call.getNodeMetaData().get(StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
            JavaType.Method methodType = GroovyParserVisitor.this.typeMapping.type(methodNode);
            this.queue.add(new J.MethodInvocation(Tree.randomId(), fmt, Markers.EMPTY, select, null, name, args, methodType));
        }

        public void visitPropertyExpression(PropertyExpression prop) {
            Space fmt = GroovyParserVisitor.this.whitespace();
            Expression target = (Expression)this.visit((ASTNode)prop.getObjectExpression());
            Space beforeDot = prop.isSafe() ? GroovyParserVisitor.this.sourceBefore("?.") : GroovyParserVisitor.this.sourceBefore(prop.isSpreadSafe() ? "*." : ".");
            J name = (J)this.visit((ASTNode)prop.getProperty());
            if (name instanceof J.Literal) {
                String nameStr = ((J.Literal)name).getValueSource();
                assert (nameStr != null);
                name = J.Identifier.build((UUID)Tree.randomId(), (Space)name.getPrefix(), (Markers)Markers.EMPTY, (String)nameStr, null);
            }
            if (prop.isSpreadSafe()) {
                name = name.withMarkers(name.getMarkers().add((Marker)new StarDot(Tree.randomId())));
            }
            if (prop.isSafe()) {
                name = name.withMarkers(name.getMarkers().add((Marker)new NullSafe(Tree.randomId())));
            }
            this.queue.add(new J.FieldAccess(Tree.randomId(), fmt, Markers.EMPTY, target, GroovyParserVisitor.this.padLeft(beforeDot, (J.Identifier)name), null));
        }

        public void visitReturnStatement(ReturnStatement retn) {
            Space fmt = GroovyParserVisitor.this.sourceBefore("return");
            this.queue.add(new J.Return(Tree.randomId(), fmt, Markers.EMPTY, (Expression)this.visit((ASTNode)retn.getExpression())));
        }

        public void visitShortTernaryExpression(ElvisOperatorExpression ternary) {
            Space fmt = GroovyParserVisitor.this.whitespace();
            Expression trueExpr = (Expression)this.visit((ASTNode)ternary.getBooleanExpression());
            J.Ternary elvis = new J.Ternary(Tree.randomId(), fmt, Markers.EMPTY, trueExpr, GroovyParserVisitor.this.padLeft(GroovyParserVisitor.this.sourceBefore("?"), trueExpr), GroovyParserVisitor.this.padLeft(GroovyParserVisitor.this.sourceBefore(":"), (Expression)this.visit((ASTNode)ternary.getFalseExpression())), GroovyParserVisitor.this.typeMapping.type(ternary.getType()));
            elvis = elvis.withMarkers(elvis.getMarkers().add((Marker)new Elvis(Tree.randomId())));
            this.queue.add(elvis);
        }

        public void visitSynchronizedStatement(SynchronizedStatement statement) {
            Space fmt = GroovyParserVisitor.this.sourceBefore("synchronized");
            this.queue.add(new J.Synchronized(Tree.randomId(), fmt, Markers.EMPTY, new J.ControlParentheses(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("("), Markers.EMPTY, JRightPadded.build((Object)((Expression)this.visit((ASTNode)statement.getExpression()))).withAfter(GroovyParserVisitor.this.sourceBefore(")"))), (J.Block)this.visit((ASTNode)statement.getCode())));
        }

        public void visitTernaryExpression(TernaryExpression ternary) {
            this.queue.add(new J.Ternary(Tree.randomId(), GroovyParserVisitor.this.whitespace(), Markers.EMPTY, (Expression)this.visit((ASTNode)ternary.getBooleanExpression()), GroovyParserVisitor.this.padLeft(GroovyParserVisitor.this.sourceBefore("?"), (Expression)this.visit((ASTNode)ternary.getTrueExpression())), GroovyParserVisitor.this.padLeft(GroovyParserVisitor.this.sourceBefore(":"), (Expression)this.visit((ASTNode)ternary.getFalseExpression())), GroovyParserVisitor.this.typeMapping.type(ternary.getType())));
        }

        public void visitThrowStatement(ThrowStatement statement) {
            Space fmt = GroovyParserVisitor.this.sourceBefore("throw");
            this.queue.add(new J.Throw(Tree.randomId(), fmt, Markers.EMPTY, (Expression)this.visit((ASTNode)statement.getExpression())));
        }

        public void visitTupleExpression(TupleExpression tuple) {
            int saveCursor = GroovyParserVisitor.this.cursor;
            Space beforeOpenParen = GroovyParserVisitor.this.whitespace();
            OmitParentheses omitParentheses = null;
            if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '(') {
                GroovyParserVisitor.this.cursor++;
            } else {
                omitParentheses = new OmitParentheses(Tree.randomId());
                beforeOpenParen = Space.EMPTY;
                GroovyParserVisitor.this.cursor = saveCursor;
            }
            ArrayList<JRightPadded> args = new ArrayList<JRightPadded>(tuple.getExpressions().size());
            for (org.codehaus.groovy.ast.expr.Expression expression : tuple.getExpressions()) {
                NamedArgumentListExpression namedArgList = (NamedArgumentListExpression)expression;
                List mapEntryExpressions = namedArgList.getMapEntryExpressions();
                for (int i = 0; i < mapEntryExpressions.size(); ++i) {
                    Expression arg = (Expression)this.visit((ASTNode)mapEntryExpressions.get(i));
                    if (omitParentheses != null) {
                        arg = (Expression)arg.withMarkers(arg.getMarkers().add((Marker)omitParentheses));
                    }
                    Space after = Space.EMPTY;
                    if (i == mapEntryExpressions.size() - 1) {
                        if (omitParentheses == null) {
                            after = GroovyParserVisitor.this.sourceBefore(")");
                        }
                    } else {
                        after = GroovyParserVisitor.this.whitespace();
                        if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == ')') {
                            omitParentheses = new OmitParentheses(Tree.randomId());
                        }
                        GroovyParserVisitor.this.cursor++;
                    }
                    args.add(JRightPadded.build((Object)arg).withAfter(after));
                }
            }
            this.queue.add(JContainer.build((Space)beforeOpenParen, args, (Markers)Markers.EMPTY));
        }

        public void visitPostfixExpression(PostfixExpression unary) {
            Space fmt = GroovyParserVisitor.this.whitespace();
            Expression expression = (Expression)this.visit((ASTNode)unary.getExpression());
            Space operatorPrefix = GroovyParserVisitor.this.whitespace();
            String typeToken = unary.getOperation().getText();
            GroovyParserVisitor.this.cursor += typeToken.length();
            J.Unary.Type operator = null;
            switch (typeToken) {
                case "++": {
                    operator = J.Unary.Type.PostIncrement;
                    break;
                }
                case "--": {
                    operator = J.Unary.Type.PostDecrement;
                }
            }
            assert (operator != null);
            this.queue.add(new J.Unary(Tree.randomId(), fmt, Markers.EMPTY, JLeftPadded.build((Object)operator).withBefore(operatorPrefix), expression, null));
        }

        public void visitPrefixExpression(PrefixExpression unary) {
            Space fmt = GroovyParserVisitor.this.whitespace();
            String typeToken = unary.getOperation().getText();
            GroovyParserVisitor.this.cursor += typeToken.length();
            J.Unary.Type operator = null;
            switch (typeToken) {
                case "++": {
                    operator = J.Unary.Type.PreIncrement;
                    break;
                }
                case "--": {
                    operator = J.Unary.Type.PreDecrement;
                    break;
                }
                case "+": {
                    operator = J.Unary.Type.Positive;
                    break;
                }
                case "-": {
                    operator = J.Unary.Type.Negative;
                    break;
                }
                case "~": {
                    operator = J.Unary.Type.Complement;
                    break;
                }
                case "!": {
                    operator = J.Unary.Type.Not;
                }
            }
            assert (operator != null);
            this.queue.add(new J.Unary(Tree.randomId(), fmt, Markers.EMPTY, JLeftPadded.build((Object)operator), (Expression)this.visit((ASTNode)unary.getExpression()), null));
        }

        public TypeTree visitVariableExpressionType(VariableExpression expression) {
            JavaType type = GroovyParserVisitor.this.typeMapping.type(expression.getOriginType());
            if (expression.isDynamicTyped()) {
                return J.Identifier.build((UUID)Tree.randomId(), (Space)GroovyParserVisitor.this.sourceBefore("def"), (Markers)Markers.EMPTY, (String)"def", (JavaType)type);
            }
            return J.Identifier.build((UUID)Tree.randomId(), (Space)GroovyParserVisitor.this.sourceBefore(expression.getOriginType().getUnresolvedName()), (Markers)Markers.EMPTY, (String)expression.getOriginType().getUnresolvedName(), (JavaType)type);
        }

        public void visitVariableExpression(VariableExpression expression) {
            JavaType type = GroovyParserVisitor.this.typeMapping.type(expression.getOriginType());
            this.queue.add(J.Identifier.build((UUID)Tree.randomId(), (Space)GroovyParserVisitor.this.sourceBefore(expression.getName()), (Markers)Markers.EMPTY, (String)expression.getName(), (JavaType)type));
        }

        public void visitWhileLoop(WhileStatement loop) {
            Space fmt = GroovyParserVisitor.this.sourceBefore("while");
            this.queue.add(new J.WhileLoop(Tree.randomId(), fmt, Markers.EMPTY, new J.ControlParentheses(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("("), Markers.EMPTY, JRightPadded.build((Object)((Expression)this.visit((ASTNode)loop.getBooleanExpression().getExpression()))).withAfter(GroovyParserVisitor.this.sourceBefore(")"))), JRightPadded.build((Object)((Statement)this.visit((ASTNode)loop.getLoopBlock())))));
        }

        private <T> T pollQueue() {
            return (T)this.queue.poll();
        }
    }

    private class RewriteGroovyClassVisitor
    extends ClassCodeVisitorSupport {
        private final SourceUnit sourceUnit;
        private final Queue<Object> queue = new LinkedList<Object>();

        public void visitClass(ClassNode clazz) {
            Space fmt = GroovyParserVisitor.this.whitespace();
            List modifiers = GroovyParserVisitor.this.visitModifiers(clazz.getModifiers());
            Space kindPrefix = GroovyParserVisitor.this.whitespace();
            J.ClassDeclaration.Kind.Type kindType = null;
            if (GroovyParserVisitor.this.source.startsWith("class", GroovyParserVisitor.this.cursor)) {
                kindType = J.ClassDeclaration.Kind.Type.Class;
                GroovyParserVisitor.this.cursor += "class".length();
            } else if (GroovyParserVisitor.this.source.startsWith("interface", GroovyParserVisitor.this.cursor)) {
                kindType = J.ClassDeclaration.Kind.Type.Interface;
                GroovyParserVisitor.this.cursor += "interface".length();
            }
            assert (kindType != null);
            J.ClassDeclaration.Kind kind = new J.ClassDeclaration.Kind(Tree.randomId(), kindPrefix, Markers.EMPTY, Collections.emptyList(), kindType);
            J.Identifier name = J.Identifier.build((UUID)Tree.randomId(), (Space)GroovyParserVisitor.this.sourceBefore(clazz.getName()), (Markers)Markers.EMPTY, (String)clazz.getName(), null);
            JLeftPadded extendings = null;
            if (clazz.getSuperClass().getLineNumber() >= 0) {
                extendings = GroovyParserVisitor.this.padLeft(GroovyParserVisitor.this.sourceBefore("extends"), GroovyParserVisitor.this.visitTypeTree(clazz.getSuperClass()));
            }
            JContainer implementings = null;
            if (clazz.getInterfaces().length > 0) {
                Space implPrefix = kindType == J.ClassDeclaration.Kind.Type.Interface ? GroovyParserVisitor.this.sourceBefore("extends") : GroovyParserVisitor.this.sourceBefore("implements");
                Iterator<JRightPadded> implTypes = new ArrayList(clazz.getInterfaces().length);
                ClassNode[] interfaces = clazz.getInterfaces();
                for (int i2 = 0; i2 < interfaces.length; ++i2) {
                    ClassNode anInterface = interfaces[i2];
                    implTypes.add(JRightPadded.build((Object)GroovyParserVisitor.this.visitTypeTree(anInterface)).withAfter(i2 == interfaces.length - 1 ? Space.EMPTY : GroovyParserVisitor.this.sourceBefore(",")));
                }
                implementings = JContainer.build((Space)implPrefix, implTypes, (Markers)Markers.EMPTY);
            }
            TreeMap<LineColumn, List> sortedByPosition = new TreeMap<LineColumn, List>();
            for (MethodNode method : clazz.getMethods()) {
                sortedByPosition.computeIfAbsent(GroovyParserVisitor.pos((ASTNode)method), i -> new ArrayList()).add(method);
            }
            for (FieldNode field : clazz.getFields()) {
                sortedByPosition.computeIfAbsent(GroovyParserVisitor.pos((ASTNode)field), i -> new ArrayList()).add(field);
            }
            J.Block body = new J.Block(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("{"), Markers.EMPTY, JRightPadded.build((Object)false), sortedByPosition.values().stream().flatMap(asts -> asts.stream().map(ast -> {
                if (ast instanceof FieldNode) {
                    this.visitField((FieldNode)ast);
                } else if (ast instanceof MethodNode) {
                    this.visitMethod((MethodNode)ast);
                }
                Statement stat = (Statement)this.pollQueue();
                return GroovyParserVisitor.this.maybeSemicolon((J)stat);
            })).collect(Collectors.toList()), GroovyParserVisitor.this.sourceBefore("}"));
            this.queue.add(new J.ClassDeclaration(Tree.randomId(), fmt, Markers.EMPTY, Collections.emptyList(), modifiers, kind, name, null, extendings, implementings, body, TypeUtils.asFullyQualified((JavaType)GroovyParserVisitor.this.typeMapping.type(clazz))));
        }

        public void visitField(FieldNode field) {
            RewriteGroovyVisitor visitor = new RewriteGroovyVisitor((ASTNode)field);
            List modifiers = GroovyParserVisitor.this.visitModifiers(field.getModifiers());
            TypeTree typeExpr = GroovyParserVisitor.this.visitTypeTree(field.getOriginType());
            J.Identifier name = J.Identifier.build((UUID)Tree.randomId(), (Space)GroovyParserVisitor.this.sourceBefore(field.getName()), (Markers)Markers.EMPTY, (String)field.getName(), (JavaType)GroovyParserVisitor.this.typeMapping.type(field.getOriginType()));
            J.VariableDeclarations.NamedVariable namedVariable = new J.VariableDeclarations.NamedVariable(Tree.randomId(), name.getPrefix(), Markers.EMPTY, name.withPrefix(Space.EMPTY), Collections.emptyList(), null, name.getType());
            if (field.getInitialExpression() != null) {
                Space beforeAssign = GroovyParserVisitor.this.sourceBefore("=");
                Expression initializer = (Expression)visitor.visit((ASTNode)field.getInitialExpression());
                namedVariable = namedVariable.getPadding().withInitializer(GroovyParserVisitor.this.padLeft(beforeAssign, initializer));
            }
            J.VariableDeclarations variableDeclarations = new J.VariableDeclarations(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), modifiers, typeExpr, null, Collections.emptyList(), Collections.singletonList(JRightPadded.build((Object)namedVariable)));
            this.queue.add(variableDeclarations);
        }

        protected void visitAnnotation(AnnotationNode annotation) {
            RewriteGroovyVisitor bodyVisitor = new RewriteGroovyVisitor((ASTNode)annotation);
            String lastArgKey = annotation.getMembers().keySet().stream().reduce("", (k1, k2) -> k2);
            this.queue.add(new J.Annotation(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("@"), Markers.EMPTY, (NameTree)GroovyParserVisitor.this.visitTypeTree(annotation.getClassNode()), JContainer.build((Space)GroovyParserVisitor.this.sourceBefore("("), annotation.getMembers().entrySet().stream().map(arg -> {
                Space argPrefix = GroovyParserVisitor.this.sourceBefore((String)arg.getKey());
                J.Identifier argName = J.Identifier.build((UUID)Tree.randomId(), (Space)Space.EMPTY, (Markers)Markers.EMPTY, (String)((String)arg.getKey()), null);
                J.Assignment assign = new J.Assignment(Tree.randomId(), argPrefix, Markers.EMPTY, (Expression)argName, GroovyParserVisitor.this.padLeft(GroovyParserVisitor.this.sourceBefore("="), (Expression)bodyVisitor.visit((ASTNode)arg.getValue())), null);
                return JRightPadded.build((Object)assign).withAfter(((String)arg.getKey()).equals(lastArgKey) ? GroovyParserVisitor.this.sourceBefore(")") : GroovyParserVisitor.this.sourceBefore(","));
            }).collect(Collectors.toList()), (Markers)Markers.EMPTY)));
        }

        public void visitMethod(MethodNode method) {
            Space fmt = GroovyParserVisitor.this.whitespace();
            List annotations = method.getAnnotations().stream().map(a -> {
                this.visitAnnotation((AnnotationNode)a);
                return (J.Annotation)this.pollQueue();
            }).collect(Collectors.toList());
            List modifiers = GroovyParserVisitor.this.visitModifiers(method.getModifiers());
            TypeTree returnType = GroovyParserVisitor.this.visitTypeTree(method.getReturnType());
            J.Identifier name = J.Identifier.build((UUID)Tree.randomId(), (Space)GroovyParserVisitor.this.sourceBefore(method.getName()), (Markers)Markers.EMPTY, (String)method.getName(), null);
            RewriteGroovyVisitor bodyVisitor = new RewriteGroovyVisitor((ASTNode)method);
            Space beforeParen = GroovyParserVisitor.this.sourceBefore("(");
            ArrayList<JRightPadded> params = new ArrayList<JRightPadded>(method.getParameters().length);
            Parameter[] unparsedParams = method.getParameters();
            for (int i = 0; i < unparsedParams.length; ++i) {
                Parameter param = unparsedParams[i];
                List paramAnnotations = param.getAnnotations().stream().map(a -> {
                    this.visitAnnotation((AnnotationNode)a);
                    return (J.Annotation)this.pollQueue();
                }).collect(Collectors.toList());
                TypeTree paramType = GroovyParserVisitor.this.visitTypeTree(param.getOriginType());
                JRightPadded paramName = JRightPadded.build((Object)new J.VariableDeclarations.NamedVariable(Tree.randomId(), GroovyParserVisitor.this.whitespace(), Markers.EMPTY, J.Identifier.build((UUID)Tree.randomId(), (Space)Space.EMPTY, (Markers)Markers.EMPTY, (String)param.getName(), null), Collections.emptyList(), null, null));
                GroovyParserVisitor.this.cursor += param.getName().length();
                Space rightPad = GroovyParserVisitor.this.sourceBefore(i == unparsedParams.length - 1 ? ")" : ",");
                params.add(JRightPadded.build((Object)new J.VariableDeclarations(Tree.randomId(), paramType.getPrefix(), Markers.EMPTY, paramAnnotations, Collections.emptyList(), (TypeTree)paramType.withPrefix(Space.EMPTY), null, Collections.emptyList(), Collections.singletonList(paramName))).withAfter(rightPad));
            }
            if (unparsedParams.length == 0) {
                params.add(JRightPadded.build((Object)new J.Empty(Tree.randomId(), GroovyParserVisitor.this.sourceBefore(")"), Markers.EMPTY)));
            }
            JContainer throwz = method.getExceptions().length == 0 ? null : JContainer.build((Space)GroovyParserVisitor.this.sourceBefore("throws"), (List)bodyVisitor.visitRightPadded((ASTNode[])method.getExceptions(), ",", null), (Markers)Markers.EMPTY);
            J.Block body = method.getCode() == null ? null : (J.Block)bodyVisitor.visit((ASTNode)method.getCode());
            this.queue.add(new J.MethodDeclaration(Tree.randomId(), fmt, Markers.EMPTY, annotations, modifiers, null, returnType, new J.MethodDeclaration.IdentifierWithAnnotations(name, Collections.emptyList()), JContainer.build((Space)beforeParen, params, (Markers)Markers.EMPTY), throwz, body, null, null));
        }

        private <T> T pollQueue() {
            return (T)this.queue.poll();
        }

        public RewriteGroovyClassVisitor(SourceUnit sourceUnit) {
            this.sourceUnit = sourceUnit;
        }

        public SourceUnit getSourceUnit() {
            return this.sourceUnit;
        }
    }
}

