/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy;

import groovy.lang.GroovyClassLoader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.Janitor;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.InputStreamReaderSource;
import org.codehaus.groovy.control.io.ReaderSource;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.groovy.GroovyParserVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.style.NamedStyles;
import org.slf4j.LoggerFactory;

public class GroovyParser
implements Parser<G.CompilationUnit> {
    @Nullable
    private final Collection<Path> classpath;

    public List<G.CompilationUnit> parse(String ... sources) {
        Pattern packagePattern = Pattern.compile("^package\\s+([^;]+);");
        Pattern classPattern = Pattern.compile("(class|interface|enum)\\s*(<[^>]*>)?\\s+(\\w+)");
        Function<String, String> simpleName = sourceStr -> {
            Matcher classMatcher = classPattern.matcher((CharSequence)sourceStr);
            return classMatcher.find() ? classMatcher.group(3) : null;
        };
        return this.parseInputs(Arrays.stream(sources).map(sourceFile -> {
            Matcher packageMatcher = packagePattern.matcher((CharSequence)sourceFile);
            String pkg = packageMatcher.find() ? packageMatcher.group(1).replace('.', '/') + "/" : "";
            String className = Optional.ofNullable((String)simpleName.apply((String)sourceFile)).orElse(Long.toString(System.nanoTime())) + ".java";
            Path path = Paths.get(pkg + className, new String[0]);
            return new Parser.Input(path, () -> new ByteArrayInputStream(sourceFile.getBytes()));
        }).collect(Collectors.toList()), null, (ExecutionContext)new InMemoryExecutionContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<G.CompilationUnit> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        ArrayList<G.CompilationUnit> cus = new ArrayList<G.CompilationUnit>();
        HashMap<String, JavaType.Class> sharedClassTypes = new HashMap<String, JavaType.Class>();
        for (Parser.Input input : sources) {
            CompilerConfiguration configuration = new CompilerConfiguration();
            configuration.setTolerance(Integer.MAX_VALUE);
            configuration.setClasspathList(this.classpath == null ? Collections.emptyList() : this.classpath.stream().map(cp -> cp.toFile().toString()).collect(Collectors.toList()));
            ErrorCollector errorCollector = new ErrorCollector(configuration);
            SourceUnit unit = new SourceUnit("doesntmatter", (ReaderSource)new InputStreamReaderSource(input.getSource(), configuration), configuration, null, errorCollector);
            GroovyClassLoader transformLoader = new GroovyClassLoader(this.getClass().getClassLoader());
            CompilationUnit compUnit = new CompilationUnit(configuration, null, null, transformLoader);
            compUnit.addSource(unit);
            try {
                compUnit.compile(5);
                ModuleNode ast = unit.getAST();
                GroovyParserVisitor mappingVisitor = new GroovyParserVisitor(input.getPath(), StringUtils.readFully((InputStream)input.getSource()), sharedClassTypes, ctx);
                cus.add(mappingVisitor.visit(unit, ast));
            }
            catch (Throwable t) {
                ctx.getOnError().accept(t);
            }
            finally {
                if (!errorCollector.hasErrors() && !errorCollector.hasWarnings()) continue;
                try (StringWriter sw = new StringWriter();
                     PrintWriter pw = new PrintWriter(sw);){
                    errorCollector.write(pw, new Janitor());
                    LoggerFactory.getLogger(GroovyParser.class).warn(sw.toString());
                }
                catch (IOException sw2) {}
            }
        }
        return cus;
    }

    public boolean accept(Path path) {
        return path.toString().endsWith(".groovy");
    }

    public GroovyParser reset() {
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    private GroovyParser(@Nullable Collection<Path> classpath) {
        this.classpath = classpath;
    }

    public static class Builder {
        @Nullable
        protected Collection<Path> classpath = JavaParser.runtimeClasspath();
        protected Collection<byte[]> classBytesClasspath = Collections.emptyList();
        @Nullable
        protected Collection<Parser.Input> dependsOn;
        protected boolean logCompilationWarningsAndErrors = false;
        protected final List<NamedStyles> styles = new ArrayList<NamedStyles>();

        public Builder logCompilationWarningsAndErrors(boolean logCompilationWarningsAndErrors) {
            this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
            return this;
        }

        public Builder dependsOn(Collection<Parser.Input> inputs) {
            this.dependsOn = inputs;
            return this;
        }

        public Builder classpath(Collection<Path> classpath) {
            this.classpath = classpath;
            return this;
        }

        public Builder classpath(String ... classpath) {
            this.classpath = JavaParser.dependenciesFromClasspath((String[])classpath);
            return this;
        }

        public Builder classpath(byte[] ... classpath) {
            this.classBytesClasspath = Arrays.asList(classpath);
            return this;
        }

        public Builder styles(Iterable<? extends NamedStyles> styles) {
            for (NamedStyles namedStyles : styles) {
                this.styles.add(namedStyles);
            }
            return this;
        }

        public GroovyParser build() {
            return new GroovyParser(this.classpath);
        }
    }
}

