/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.InputStream;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.Option;
import org.openrewrite.PathUtils;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.util.GradleWrapper;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.BuildTool;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.properties.PropertiesParser;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.search.FindProperties;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.text.PlainText;

public class UpdateGradleWrapper
extends ScanningRecipe<GradleWrapperState> {
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number. Defaults to the latest release if not specified.", example="7.x", required=false)
    @Nullable
    private final String version;
    @Option(displayName="Distribution type", description="The distribution of Gradle to use. \"bin\" includes Gradle binaries. \"all\" includes Gradle binaries, source code, and documentation. Defaults to \"bin\".", valid={"bin", "all"}, required=false)
    @Nullable
    private final String distribution;
    @Option(displayName="Repository URL", description="The URL of the repository to download the Gradle distribution from. Currently only supports repositories like services.gradle.org, not arbitrary maven or ivy repositories. Defaults to `https://services.gradle.org/versions/all`.", example="https://services.gradle.org/versions/all", required=false)
    @Nullable
    private final String repositoryUrl;
    @Option(displayName="Add if missing", description="Add a Gradle wrapper, if it's missing. Defaults to `true`.", required=false)
    @Nullable
    private final Boolean addIfMissing;
    private transient GradleWrapper gradleWrapper;

    public String getDisplayName() {
        return "Update Gradle wrapper";
    }

    public String getDescription() {
        return "Update the version of Gradle used in an existing Gradle wrapper.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.version != null) {
            validated = validated.and(Semver.validate((String)this.version, null));
        }
        return validated;
    }

    private GradleWrapper getGradleWrapper(ExecutionContext ctx) {
        if (this.gradleWrapper == null) {
            this.gradleWrapper = GradleWrapper.create(this.distribution, this.version, this.repositoryUrl, ctx);
        }
        return this.gradleWrapper;
    }

    public GradleWrapperState getInitialValue(ExecutionContext ctx) {
        return new GradleWrapperState();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final GradleWrapperState acc) {
        return Preconditions.or((TreeVisitor[])new TreeVisitor[]{new PropertiesVisitor<ExecutionContext>(){

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                if (!super.isAcceptable(sourceFile, (Object)ctx)) {
                    return false;
                }
                if (PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)GradleWrapper.WRAPPER_PROPERTIES_LOCATION)) {
                    acc.addGradleWrapperProperties = false;
                } else if (!PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/gradle/wrapper/gradle-wrapper.properties")) {
                    return false;
                }
                Optional maybeBuildTool = sourceFile.getMarkers().findFirst(BuildTool.class);
                if (!maybeBuildTool.isPresent()) {
                    return false;
                }
                BuildTool buildTool = (BuildTool)maybeBuildTool.get();
                if (buildTool.getType() != BuildTool.Type.Gradle) {
                    return false;
                }
                GradleWrapper gradleWrapper = UpdateGradleWrapper.this.getGradleWrapper(ctx);
                VersionComparator versionComparator = Objects.requireNonNull((VersionComparator)Semver.validate((String)(StringUtils.isBlank((String)UpdateGradleWrapper.this.version) ? "latest.release" : UpdateGradleWrapper.this.version), null).getValue());
                int compare = versionComparator.compare(null, buildTool.getVersion(), gradleWrapper.getVersion());
                if (compare < 0) {
                    acc.needsWrapperUpdate = true;
                    acc.updatedMarker = buildTool.withVersion(gradleWrapper.getVersion());
                    return true;
                }
                return compare == 0;
            }

            public Properties visitEntry(Properties.Entry entry, ExecutionContext ctx) {
                if (!"distributionUrl".equals(entry.getKey())) {
                    return entry;
                }
                GradleWrapper gradleWrapper = UpdateGradleWrapper.this.getGradleWrapper(ctx);
                String currentDistributionUrl = entry.getValue().getText();
                if (!gradleWrapper.getPropertiesFormattedUrl().equals(currentDistributionUrl)) {
                    acc.needsWrapperUpdate = true;
                }
                return entry;
            }
        }, new TreeVisitor<Tree, ExecutionContext>(){

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext executionContext) {
                if (!super.isAcceptable(sourceFile, (Object)executionContext)) {
                    return false;
                }
                if ((sourceFile instanceof Quark || sourceFile instanceof Remote) && PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)GradleWrapper.WRAPPER_JAR_LOCATION)) {
                    acc.addGradleWrapperJar = false;
                    return true;
                }
                if (sourceFile instanceof PlainText) {
                    if (PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)GradleWrapper.WRAPPER_BATCH_LOCATION)) {
                        acc.addGradleBatchScript = false;
                        return true;
                    }
                    if (PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)GradleWrapper.WRAPPER_SCRIPT_LOCATION)) {
                        acc.addGradleShellScript = false;
                        return true;
                    }
                }
                return false;
            }
        }});
    }

    public Collection<SourceFile> generate(GradleWrapperState acc, ExecutionContext ctx) {
        if (Boolean.FALSE.equals(this.addIfMissing)) {
            return Collections.emptyList();
        }
        if (!(acc.addGradleWrapperJar || acc.addGradleWrapperProperties || acc.addGradleBatchScript || acc.addGradleShellScript)) {
            return Collections.emptyList();
        }
        ArrayList<SourceFile> gradleWrapperFiles = new ArrayList<SourceFile>();
        ZonedDateTime now = ZonedDateTime.now();
        GradleWrapper gradleWrapper = this.getGradleWrapper(ctx);
        if (acc.addGradleWrapperProperties) {
            Properties.File gradleWrapperProperties = (Properties.File)((SourceFile)new PropertiesParser().parse(new String[]{"distributionBase=GRADLE_USER_HOME\ndistributionPath=wrapper/dists\ndistributionUrl=" + gradleWrapper.getPropertiesFormattedUrl() + "\ndistributionSha256Sum=" + gradleWrapper.getDistributionChecksum().getHexValue() + "\nzipStoreBase=GRADLE_USER_HOME\nzipStorePath=wrapper/dists"}).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not parse as properties"))).withSourcePath(GradleWrapper.WRAPPER_PROPERTIES_LOCATION);
            gradleWrapperFiles.add((SourceFile)gradleWrapperProperties);
        }
        FileAttributes wrapperScriptAttributes = new FileAttributes(now, now, now, true, true, true, 1L);
        if (acc.addGradleShellScript) {
            String gradlewText = this.unixScript(gradleWrapper, ctx);
            PlainText gradlew = PlainText.builder().text(gradlewText).sourcePath(GradleWrapper.WRAPPER_SCRIPT_LOCATION).fileAttributes(wrapperScriptAttributes).build();
            gradleWrapperFiles.add((SourceFile)gradlew);
        }
        if (acc.addGradleBatchScript) {
            String gradlewBatText = this.batchScript(gradleWrapper, ctx);
            PlainText gradlewBat = PlainText.builder().text(gradlewBatText).sourcePath(GradleWrapper.WRAPPER_BATCH_LOCATION).fileAttributes(wrapperScriptAttributes).build();
            gradleWrapperFiles.add((SourceFile)gradlewBat);
        }
        if (acc.addGradleWrapperJar) {
            gradleWrapperFiles.add((SourceFile)gradleWrapper.wrapperJar());
        }
        return gradleWrapperFiles;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final GradleWrapperState acc) {
        if (!acc.needsWrapperUpdate) {
            return TreeVisitor.noop();
        }
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile sourceFile = (SourceFile)tree;
                if (acc.updatedMarker != null) {
                    sourceFile = sourceFile.getMarkers().findFirst(BuildTool.class).map(buildTool -> (SourceFile)tree.withMarkers(tree.getMarkers().computeByType((Marker)buildTool, (b, a) -> acc2.updatedMarker))).orElse(sourceFile);
                }
                if (sourceFile instanceof PlainText && PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/gradlew")) {
                    PlainText gradlew;
                    String gradlewText = UpdateGradleWrapper.this.unixScript(UpdateGradleWrapper.this.gradleWrapper, ctx);
                    if (!gradlewText.equals((gradlew = (PlainText)UpdateGradleWrapper.setExecutable(sourceFile)).getText())) {
                        gradlew = gradlew.withText(gradlewText);
                    }
                    return gradlew;
                }
                if (sourceFile instanceof PlainText && PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/gradlew.bat")) {
                    PlainText gradlewBat;
                    String gradlewBatText = UpdateGradleWrapper.this.batchScript(UpdateGradleWrapper.this.gradleWrapper, ctx);
                    if (!gradlewBatText.equals((gradlewBat = (PlainText)UpdateGradleWrapper.setExecutable(sourceFile)).getText())) {
                        gradlewBat = gradlewBat.withText(gradlewBatText);
                    }
                    return gradlewBat;
                }
                if (sourceFile instanceof Properties.File && PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/gradle/wrapper/gradle-wrapper.properties")) {
                    return new WrapperPropertiesVisitor(UpdateGradleWrapper.this.gradleWrapper).visitNonNull((Tree)sourceFile, ctx);
                }
                if ((sourceFile instanceof Quark || sourceFile instanceof Remote) && PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/gradle/wrapper/gradle-wrapper.jar")) {
                    return UpdateGradleWrapper.this.gradleWrapper.wrapperJar().withId(sourceFile.getId()).withMarkers(sourceFile.getMarkers());
                }
                return sourceFile;
            }
        };
    }

    private static <T extends SourceFile> T setExecutable(T sourceFile) {
        FileAttributes attributes = sourceFile.getFileAttributes();
        if (attributes == null) {
            ZonedDateTime now = ZonedDateTime.now();
            return (T)sourceFile.withFileAttributes(new FileAttributes(now, now, now, true, true, true, 1L));
        }
        if (!attributes.isExecutable()) {
            return (T)sourceFile.withFileAttributes(attributes.withExecutable(true));
        }
        return sourceFile;
    }

    private String unixScript(GradleWrapper gradleWrapper, ExecutionContext ctx) {
        HashMap<String, String> binding = new HashMap<String, String>();
        String defaultJvmOpts = this.defaultJvmOpts(gradleWrapper);
        binding.put("defaultJvmOpts", StringUtils.isNotEmpty((String)defaultJvmOpts) ? "'" + defaultJvmOpts + "'" : "");
        binding.put("classpath", "$APP_HOME/gradle/wrapper/gradle-wrapper.jar");
        String gradlewTemplate = StringUtils.readFully((InputStream)gradleWrapper.gradlew().getInputStream(ctx));
        return this.renderTemplate(gradlewTemplate, binding, "\n");
    }

    private String batchScript(GradleWrapper gradleWrapper, ExecutionContext ctx) {
        HashMap<String, String> binding = new HashMap<String, String>();
        binding.put("defaultJvmOpts", this.defaultJvmOpts(gradleWrapper));
        binding.put("classpath", "%APP_HOME%\\gradle\\wrapper\\gradle-wrapper.jar");
        String gradlewBatTemplate = StringUtils.readFully((InputStream)gradleWrapper.gradlewBat().getInputStream(ctx));
        return this.renderTemplate(gradlewBatTemplate, binding, "\r\n");
    }

    private String defaultJvmOpts(GradleWrapper gradleWrapper) {
        VersionComparator gradle53VersionComparator = Objects.requireNonNull((VersionComparator)Semver.validate((String)"[5.3,)", null).getValue());
        VersionComparator gradle50VersionComparator = Objects.requireNonNull((VersionComparator)Semver.validate((String)"[5.0,)", null).getValue());
        if (gradle53VersionComparator.isValid(null, gradleWrapper.getVersion())) {
            return "\"-Xmx64m\" \"-Xms64m\"";
        }
        if (gradle50VersionComparator.isValid(null, gradleWrapper.getVersion())) {
            return "\"-Xmx64m\"";
        }
        return "";
    }

    private String renderTemplate(String source, Map<String, String> parameters, String lineSeparator) {
        HashMap<String, String> binding = new HashMap<String, String>(parameters);
        binding.put("applicationName", "Gradle");
        binding.put("optsEnvironmentVar", "GRADLE_OPTS");
        binding.put("exitEnvironmentVar", "GRADLE_EXIT_CONSOLE");
        binding.put("mainClassName", "org.gradle.wrapper.GradleWrapperMain");
        binding.put("appNameSystemProperty", "org.gradle.appname");
        binding.put("appHomeRelativePath", "");
        binding.put("modulePath", "");
        String script = source;
        for (Map.Entry variable : binding.entrySet()) {
            script = script.replace("${" + (String)variable.getKey() + "}", (CharSequence)variable.getValue()).replace("$" + (String)variable.getKey(), (CharSequence)variable.getValue());
        }
        script = script.replaceAll("(?sm)<% /\\*.*?\\*/ %>", "");
        script = script.replaceAll("(?sm)<% if \\( mainClassName\\.startsWith\\('--module '\\) \\) \\{.*?} %>", "");
        script = script.replaceAll("(?sm)<% if \\( appNameSystemProperty \\) \\{.*?%>(.*?)<% } %>", "$1");
        script = script.replace("\\$", "$");
        script = script.replaceAll("DIRNAME=\\.\\\\[\r\n]", "DIRNAME=.");
        script = script.replace("\\\\", "\\");
        script = script.replaceAll("\r\n|\r|\n", lineSeparator);
        return script;
    }

    public UpdateGradleWrapper(@Nullable String version, @Nullable String distribution, @Nullable String repositoryUrl, @Nullable Boolean addIfMissing) {
        this.version = version;
        this.distribution = distribution;
        this.repositoryUrl = repositoryUrl;
        this.addIfMissing = addIfMissing;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateGradleWrapper)) {
            return false;
        }
        UpdateGradleWrapper other = (UpdateGradleWrapper)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$addIfMissing = this.getAddIfMissing();
        Boolean other$addIfMissing = other.getAddIfMissing();
        if (this$addIfMissing == null ? other$addIfMissing != null : !((Object)this$addIfMissing).equals(other$addIfMissing)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$distribution = this.getDistribution();
        String other$distribution = other.getDistribution();
        if (this$distribution == null ? other$distribution != null : !this$distribution.equals(other$distribution)) {
            return false;
        }
        String this$repositoryUrl = this.getRepositoryUrl();
        String other$repositoryUrl = other.getRepositoryUrl();
        return !(this$repositoryUrl == null ? other$repositoryUrl != null : !this$repositoryUrl.equals(other$repositoryUrl));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpdateGradleWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $addIfMissing = this.getAddIfMissing();
        result = result * 59 + ($addIfMissing == null ? 43 : ((Object)$addIfMissing).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $distribution = this.getDistribution();
        result = result * 59 + ($distribution == null ? 43 : $distribution.hashCode());
        String $repositoryUrl = this.getRepositoryUrl();
        result = result * 59 + ($repositoryUrl == null ? 43 : $repositoryUrl.hashCode());
        return result;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getDistribution() {
        return this.distribution;
    }

    @Nullable
    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    @Nullable
    public Boolean getAddIfMissing() {
        return this.addIfMissing;
    }

    static class GradleWrapperState {
        boolean needsWrapperUpdate = false;
        BuildTool updatedMarker;
        boolean addGradleWrapperProperties = true;
        boolean addGradleWrapperJar = true;
        boolean addGradleShellScript = true;
        boolean addGradleBatchScript = true;

        GradleWrapperState() {
        }
    }

    private static class WrapperPropertiesVisitor
    extends PropertiesVisitor<ExecutionContext> {
        private static final String DISTRIBUTION_SHA_256_SUM_KEY = "distributionSha256Sum";
        private final GradleWrapper gradleWrapper;

        public WrapperPropertiesVisitor(GradleWrapper gradleWrapper) {
            this.gradleWrapper = gradleWrapper;
        }

        public Properties visitFile(Properties.File file, ExecutionContext executionContext) {
            Properties p = super.visitFile(file, (Object)executionContext);
            Set properties = FindProperties.find((Properties)p, (String)DISTRIBUTION_SHA_256_SUM_KEY, (Boolean)false);
            if (properties.isEmpty()) {
                Properties.Value propertyValue = new Properties.Value(Tree.randomId(), "", Markers.EMPTY, this.gradleWrapper.getDistributionChecksum().getHexValue());
                Properties.Entry entry = new Properties.Entry(Tree.randomId(), "\n", Markers.EMPTY, DISTRIBUTION_SHA_256_SUM_KEY, "", Properties.Entry.Delimiter.EQUALS, propertyValue);
                List contentList = ListUtils.concat((List)((Properties.File)p).getContent(), (Object)entry);
                p = ((Properties.File)p).withContent(contentList);
            }
            return p;
        }

        public Properties visitEntry(Properties.Entry entry, ExecutionContext context) {
            if ("distributionUrl".equals(entry.getKey())) {
                return entry.withValue(entry.getValue().withText(this.gradleWrapper.getPropertiesFormattedUrl()));
            }
            if (DISTRIBUTION_SHA_256_SUM_KEY.equals(entry.getKey())) {
                return entry.withValue(entry.getValue().withText(this.gradleWrapper.getDistributionChecksum().getHexValue()));
            }
            return entry;
        }
    }
}

