/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.trait;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.internal.ChangeStringLiteral;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.trait.GradleTraitMatcher;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.Markers;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.DependencyNotation;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.semver.DependencyMatcher;
import org.openrewrite.trait.Trait;
import org.openrewrite.trait.VisitFunction2;

public final class GradleDependency
implements Trait<J.MethodInvocation> {
    private static final MethodMatcher DEPENDENCY_DSL_MATCHER = new MethodMatcher("DependencyHandlerSpec *(..)");
    private final Cursor cursor;
    private final ResolvedDependency resolvedDependency;

    private static @Nullable GradleProject getGradleProject(Cursor cursor) {
        SourceFile sourceFile = (SourceFile)cursor.firstEnclosing(SourceFile.class);
        if (sourceFile == null) {
            return null;
        }
        Optional maybeGp = sourceFile.getMarkers().findFirst(GradleProject.class);
        return maybeGp.orElse(null);
    }

    private static boolean withinBlock(Cursor cursor, String name) {
        for (Cursor parentCursor = cursor.getParent(); parentCursor != null; parentCursor = parentCursor.getParent()) {
            J.MethodInvocation m;
            if (!(parentCursor.getValue() instanceof J.MethodInvocation) || !(m = (J.MethodInvocation)parentCursor.getValue()).getSimpleName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private static boolean withinDependenciesBlock(Cursor cursor) {
        return GradleDependency.withinBlock(cursor, "dependencies");
    }

    private static boolean withinDependencyConstraintsBlock(Cursor cursor) {
        return GradleDependency.withinBlock(cursor, "constraints") && GradleDependency.withinDependenciesBlock(cursor);
    }

    private static @Nullable GradleDependencyConfiguration getConfiguration(@Nullable GradleProject gradleProject, J.MethodInvocation methodInvocation) {
        if (gradleProject == null) {
            return null;
        }
        String methodName = methodInvocation.getSimpleName();
        if ("classpath".equals(methodName)) {
            return gradleProject.getBuildscript().getConfiguration(methodName);
        }
        return gradleProject.getConfiguration(methodName);
    }

    public static boolean isDependencyDeclaration(Cursor cursor) {
        Object object = cursor.getValue();
        if (!(object instanceof J.MethodInvocation)) {
            return false;
        }
        J.MethodInvocation methodInvocation = (J.MethodInvocation)object;
        if (!GradleDependency.withinDependenciesBlock(cursor)) {
            return false;
        }
        if (GradleDependency.withinDependencyConstraintsBlock(cursor)) {
            return false;
        }
        GradleProject gradleProject = GradleDependency.getGradleProject(cursor);
        GradleDependencyConfiguration gdc = GradleDependency.getConfiguration(gradleProject, methodInvocation);
        if (gdc == null && (!DEPENDENCY_DSL_MATCHER.matches((MethodCall)methodInvocation) || "project".equals(methodInvocation.getSimpleName()))) {
            return false;
        }
        if (DEPENDENCY_DSL_MATCHER.matches((MethodCall)methodInvocation)) {
            return true;
        }
        return gdc != null;
    }

    public String getGroupId() {
        return this.resolvedDependency.getGroupId();
    }

    public String getArtifactId() {
        return this.resolvedDependency.getArtifactId();
    }

    public String getVersion() {
        return this.resolvedDependency.getVersion();
    }

    public GroupArtifactVersion getGav() {
        return this.resolvedDependency.getGav().asGroupArtifactVersion();
    }

    public ResolvedGroupArtifactVersion getResolvedGav() {
        return this.resolvedDependency.getGav();
    }

    public String getConfigurationName() {
        return ((J.MethodInvocation)this.getTree()).getSimpleName();
    }

    public @Nullable String getDeclaredGroupId() {
        Dependency dep;
        List strings;
        J.Literal left;
        J.Binary binary;
        if (this.isPlatform()) {
            GradleDependency platformDep = this.getPlatformDependency();
            return platformDep != null ? platformDep.getDeclaredGroupId() : null;
        }
        J.MethodInvocation m = (J.MethodInvocation)this.cursor.getValue();
        List depArgs = m.getArguments();
        if (depArgs.isEmpty()) {
            return null;
        }
        Expression arg = (Expression)depArgs.get(0);
        if (arg instanceof J.Binary && (binary = (J.Binary)arg).getLeft() instanceof J.Literal && (left = (J.Literal)binary.getLeft()).getValue() instanceof String) {
            String leftStr = (String)left.getValue();
            if (!leftStr.contains(":")) {
                return null;
            }
            String toParse = leftStr.endsWith(":") ? leftStr + "1.0" : leftStr;
            Dependency dep2 = DependencyNotation.parse((String)toParse);
            return dep2 != null ? dep2.getGroupId() : null;
        }
        if (arg instanceof J.Literal && ((J.Literal)arg).getValue() instanceof String) {
            Dependency dep3 = DependencyNotation.parse((String)((String)((J.Literal)arg).getValue()));
            return dep3 != null ? dep3.getGroupId() : null;
        }
        if (arg instanceof G.GString && !(strings = ((G.GString)arg).getStrings()).isEmpty() && strings.get(0) instanceof J.Literal) {
            dep = DependencyNotation.parse((String)((String)((J.Literal)strings.get(0)).getValue()));
            return dep != null ? dep.getGroupId() : null;
        }
        if (arg instanceof K.StringTemplate && !(strings = ((K.StringTemplate)arg).getStrings()).isEmpty() && strings.get(0) instanceof J.Literal) {
            dep = DependencyNotation.parse((String)((String)((J.Literal)strings.get(0)).getValue()));
            return dep != null ? dep.getGroupId() : null;
        }
        if (depArgs.size() >= 2) {
            for (Expression e : depArgs) {
                J.Assignment assignment;
                if (e instanceof G.MapEntry) {
                    G.MapEntry entry = (G.MapEntry)e;
                    if (!(entry.getKey() instanceof J.Literal) || !"group".equals(((J.Literal)entry.getKey()).getValue())) continue;
                    return this.extractValueAsString(entry.getValue());
                }
                if (!(e instanceof J.Assignment) || !((assignment = (J.Assignment)e).getVariable() instanceof J.Identifier) || !"group".equals(((J.Identifier)assignment.getVariable()).getSimpleName())) continue;
                return this.extractValueAsString(assignment.getAssignment());
            }
        }
        if (arg instanceof G.MapLiteral) {
            for (G.MapEntry entry : ((G.MapLiteral)arg).getElements()) {
                if (!(entry.getKey() instanceof J.Literal) || !"group".equals(((J.Literal)entry.getKey()).getValue())) continue;
                return this.extractValueAsString(entry.getValue());
            }
        }
        return null;
    }

    public @Nullable String getDeclaredArtifactId() {
        Dependency dep;
        List strings;
        J.Literal left;
        J.Binary binary;
        if (this.isPlatform()) {
            GradleDependency platformDep = this.getPlatformDependency();
            return platformDep != null ? platformDep.getDeclaredArtifactId() : null;
        }
        J.MethodInvocation m = (J.MethodInvocation)this.cursor.getValue();
        List depArgs = m.getArguments();
        if (depArgs.isEmpty()) {
            return null;
        }
        Expression arg = (Expression)depArgs.get(0);
        if (arg instanceof J.Binary && (binary = (J.Binary)arg).getLeft() instanceof J.Literal && (left = (J.Literal)binary.getLeft()).getValue() instanceof String) {
            String leftStr = (String)left.getValue();
            if (!leftStr.contains(":")) {
                return null;
            }
            String toParse = leftStr.endsWith(":") ? leftStr + "1.0" : leftStr;
            Dependency dep2 = DependencyNotation.parse((String)toParse);
            return dep2 != null ? dep2.getArtifactId() : null;
        }
        if (arg instanceof J.Literal && ((J.Literal)arg).getValue() instanceof String) {
            Dependency dep3 = DependencyNotation.parse((String)((String)((J.Literal)arg).getValue()));
            return dep3 != null ? dep3.getArtifactId() : null;
        }
        if (arg instanceof G.GString && !(strings = ((G.GString)arg).getStrings()).isEmpty() && strings.get(0) instanceof J.Literal) {
            dep = DependencyNotation.parse((String)((String)((J.Literal)strings.get(0)).getValue()));
            return dep != null ? dep.getArtifactId() : null;
        }
        if (arg instanceof K.StringTemplate && !(strings = ((K.StringTemplate)arg).getStrings()).isEmpty() && strings.get(0) instanceof J.Literal) {
            dep = DependencyNotation.parse((String)((String)((J.Literal)strings.get(0)).getValue()));
            return dep != null ? dep.getArtifactId() : null;
        }
        if (depArgs.size() >= 2) {
            for (Expression e : depArgs) {
                J.Assignment assignment;
                String key;
                if (e instanceof G.MapEntry) {
                    G.MapEntry entry = (G.MapEntry)e;
                    if (!(entry.getKey() instanceof J.Literal) || !"name".equals(key = (String)((J.Literal)entry.getKey()).getValue()) && !"artifact".equals(key)) continue;
                    return this.extractValueAsString(entry.getValue());
                }
                if (!(e instanceof J.Assignment) || !((assignment = (J.Assignment)e).getVariable() instanceof J.Identifier) || !"name".equals(key = ((J.Identifier)assignment.getVariable()).getSimpleName()) && !"artifact".equals(key)) continue;
                return this.extractValueAsString(assignment.getAssignment());
            }
        }
        if (arg instanceof G.MapLiteral) {
            for (G.MapEntry entry : ((G.MapLiteral)arg).getElements()) {
                String key;
                if (!(entry.getKey() instanceof J.Literal) || !"name".equals(key = (String)((J.Literal)entry.getKey()).getValue()) && !"artifact".equals(key)) continue;
                return this.extractValueAsString(entry.getValue());
            }
        }
        return null;
    }

    public @Nullable String getDeclaredVersion() {
        String versionVar = this.getVersionVariable();
        if (versionVar != null) {
            return versionVar;
        }
        if (this.isPlatform()) {
            GradleDependency platformDep = this.getPlatformDependency();
            return platformDep != null ? platformDep.getDeclaredVersion() : null;
        }
        J.MethodInvocation m = (J.MethodInvocation)this.cursor.getValue();
        List depArgs = m.getArguments();
        if (depArgs.isEmpty()) {
            return null;
        }
        Expression arg = (Expression)depArgs.get(0);
        if (arg instanceof J.Literal && ((J.Literal)arg).getValue() instanceof String) {
            Dependency dep = DependencyNotation.parse((String)((String)((J.Literal)arg).getValue()));
            return dep != null ? dep.getVersion() : null;
        }
        if (depArgs.size() >= 3) {
            for (Expression e : depArgs) {
                J.Assignment assignment;
                if (e instanceof G.MapEntry) {
                    G.MapEntry entry = (G.MapEntry)e;
                    if (!(entry.getKey() instanceof J.Literal) || !"version".equals(((J.Literal)entry.getKey()).getValue())) continue;
                    return this.extractValueAsString(entry.getValue());
                }
                if (!(e instanceof J.Assignment) || !((assignment = (J.Assignment)e).getVariable() instanceof J.Identifier) || !"version".equals(((J.Identifier)assignment.getVariable()).getSimpleName())) continue;
                return this.extractValueAsString(assignment.getAssignment());
            }
        }
        if (arg instanceof G.MapLiteral) {
            for (G.MapEntry entry : ((G.MapLiteral)arg).getElements()) {
                if (!(entry.getKey() instanceof J.Literal) || !"version".equals(((J.Literal)entry.getKey()).getValue())) continue;
                return this.extractValueAsString(entry.getValue());
            }
        }
        return null;
    }

    private @Nullable String extractValueAsString(Expression value) {
        K.StringTemplate.Expression templateExp;
        J tree;
        K.StringTemplate template;
        List strings;
        Expression v = (Expression)value.withMarkers(Markers.EMPTY);
        if (v instanceof J.Literal) {
            Object literalValue = ((J.Literal)v).getValue();
            return literalValue instanceof String ? (String)literalValue : null;
        }
        if (v instanceof J.Identifier) {
            return ((J.Identifier)v).getSimpleName();
        }
        if (v instanceof J.FieldAccess) {
            return v.printTrimmed(this.cursor);
        }
        if (v instanceof J.MethodInvocation) {
            Object arg;
            J.MethodInvocation mi = (J.MethodInvocation)v;
            String methodName = mi.getSimpleName();
            if (("property".equals(methodName) || "findProperty".equals(methodName)) && mi.getArguments().size() == 1 && mi.getArguments().get(0) instanceof J.Literal && (arg = ((J.Literal)mi.getArguments().get(0)).getValue()) instanceof String) {
                return (String)arg;
            }
            if (mi.getSelect() instanceof J.Identifier && "project".equals(((J.Identifier)mi.getSelect()).getSimpleName()) && ("property".equals(methodName) || "findProperty".equals(methodName)) && mi.getArguments().size() == 1 && mi.getArguments().get(0) instanceof J.Literal && (arg = ((J.Literal)mi.getArguments().get(0)).getValue()) instanceof String) {
                return (String)arg;
            }
            return v.printTrimmed(this.cursor);
        }
        if (v instanceof G.Binary) {
            J.Literal right;
            G.Binary binary = (G.Binary)v;
            if (binary.getOperator() == G.Binary.Type.Access && binary.getRight() instanceof J.Literal && (right = (J.Literal)binary.getRight()).getValue() instanceof String) {
                return (String)right.getValue();
            }
            if (binary.getLeft() instanceof G.GString) {
                G.GString.Value gStringValue;
                J tree2;
                G.GString left = (G.GString)binary.getLeft();
                List strings2 = left.getStrings();
                if (strings2.size() == 1 && strings2.get(0) instanceof G.GString.Value && (tree2 = (gStringValue = (G.GString.Value)strings2.get(0)).getTree()) instanceof J.Identifier) {
                    return ((J.Identifier)tree2).getSimpleName();
                }
            } else if (binary.getLeft() instanceof J.Identifier) {
                return ((J.Identifier)binary.getLeft()).getSimpleName();
            }
            return v.printTrimmed(this.cursor);
        }
        if (v instanceof G.GString) {
            G.GString gString = (G.GString)v;
            List strings3 = gString.getStrings();
            if (!strings3.isEmpty() && strings3.get(0) instanceof G.GString.Value) {
                G.GString.Value gStringValue = (G.GString.Value)strings3.get(0);
                J tree3 = gStringValue.getTree();
                if (tree3 instanceof J.Identifier) {
                    return ((J.Identifier)tree3).getSimpleName();
                }
                if (tree3 instanceof J.FieldAccess) {
                    return tree3.printTrimmed(this.cursor);
                }
                if (tree3 instanceof J.MethodInvocation) {
                    return this.extractValueAsString((Expression)((J.MethodInvocation)tree3));
                }
                if (tree3 instanceof G.Binary) {
                    return this.extractValueAsString((Expression)((G.Binary)tree3));
                }
            }
        } else if (v instanceof K.StringTemplate && !(strings = (template = (K.StringTemplate)v).getStrings()).isEmpty() && strings.get(0) instanceof K.StringTemplate.Expression && (tree = (templateExp = (K.StringTemplate.Expression)strings.get(0)).getTree()) instanceof J.Identifier) {
            return ((J.Identifier)tree).getSimpleName();
        }
        return null;
    }

    public boolean isPlatform() {
        J.MethodInvocation m = (J.MethodInvocation)this.cursor.getValue();
        if (m.getArguments().isEmpty()) {
            return false;
        }
        Expression firstArg = (Expression)m.getArguments().get(0);
        if (!(firstArg instanceof J.MethodInvocation)) {
            return false;
        }
        String methodName = ((J.MethodInvocation)firstArg).getSimpleName();
        return "platform".equals(methodName) || "enforcedPlatform".equals(methodName);
    }

    public @Nullable GradleDependency getPlatformDependency() {
        J.MethodInvocation m = (J.MethodInvocation)this.cursor.getValue();
        if (m.getArguments().isEmpty()) {
            return null;
        }
        Expression firstArg = (Expression)m.getArguments().get(0);
        if (!(firstArg instanceof J.MethodInvocation)) {
            return null;
        }
        J.MethodInvocation platformMethod = (J.MethodInvocation)firstArg;
        String methodName = platformMethod.getSimpleName();
        if (!"platform".equals(methodName) && !"enforcedPlatform".equals(methodName)) {
            return null;
        }
        Cursor platformCursor = new Cursor(this.cursor, (Object)platformMethod);
        return new GradleDependency(platformCursor, this.resolvedDependency);
    }

    public @Nullable String getVersionVariable() {
        J versionTree;
        List strings;
        String leftStr;
        String[] parts;
        J.Literal left;
        J.Binary binary;
        if (this.isPlatform()) {
            GradleDependency platformDep = this.getPlatformDependency();
            return platformDep != null ? platformDep.getVersionVariable() : null;
        }
        J.MethodInvocation m = (J.MethodInvocation)this.cursor.getValue();
        List depArgs = m.getArguments();
        if (depArgs.isEmpty()) {
            return null;
        }
        Expression arg = (Expression)depArgs.get(0);
        if (arg instanceof J.Binary && (binary = (J.Binary)arg).getLeft() instanceof J.Literal && binary.getRight() instanceof J.Identifier && (left = (J.Literal)binary.getLeft()).getValue() instanceof String && (parts = (leftStr = (String)left.getValue()).split(":")).length >= 2) {
            return ((J.Identifier)binary.getRight()).getSimpleName();
        }
        if (arg instanceof G.GString && (strings = ((G.GString)arg).getStrings()).size() == 2 && strings.get(0) instanceof J.Literal && strings.get(1) instanceof G.GString.Value) {
            String propName;
            versionTree = ((G.GString.Value)strings.get(1)).getTree();
            if (versionTree instanceof J.Identifier) {
                return ((J.Identifier)versionTree).getSimpleName();
            }
            if (versionTree instanceof J.FieldAccess) {
                return ((J.FieldAccess)versionTree).printTrimmed(this.cursor);
            }
            if (versionTree instanceof J.MethodInvocation ? (propName = GradleDependency.extractPropertyNameFromMethodInvocation((J.MethodInvocation)versionTree)) != null : versionTree instanceof G.Binary && (propName = GradleDependency.extractPropertyNameFromGBinary((G.Binary)versionTree)) != null) {
                return propName;
            }
        }
        if (arg instanceof K.StringTemplate && (strings = ((K.StringTemplate)arg).getStrings()).size() == 2 && strings.get(0) instanceof J.Literal && strings.get(1) instanceof K.StringTemplate.Expression && (versionTree = ((K.StringTemplate.Expression)strings.get(1)).getTree()) instanceof J.Identifier) {
            return ((J.Identifier)versionTree).getSimpleName();
        }
        if (depArgs.size() >= 3) {
            K.StringTemplate template;
            List strings2;
            Expression versionExp = null;
            if (depArgs.get(0) instanceof G.MapEntry && depArgs.get(1) instanceof G.MapEntry && depArgs.get(2) instanceof G.MapEntry) {
                versionExp = ((G.MapEntry)depArgs.get(2)).getValue();
            } else if (depArgs.get(0) instanceof J.Assignment && depArgs.get(1) instanceof J.Assignment && depArgs.get(2) instanceof J.Assignment) {
                versionExp = ((J.Assignment)depArgs.get(2)).getAssignment();
            }
            if (versionExp instanceof J.Identifier) {
                return ((J.Identifier)versionExp).getSimpleName();
            }
            if (versionExp instanceof J.FieldAccess) {
                return versionExp.printTrimmed(this.cursor);
            }
            if (versionExp instanceof J.MethodInvocation) {
                return GradleDependency.extractPropertyNameFromMethodInvocation((J.MethodInvocation)versionExp);
            }
            if (versionExp instanceof G.Binary) {
                return GradleDependency.extractPropertyNameFromGBinary((G.Binary)versionExp);
            }
            if (versionExp instanceof G.GString) {
                G.GString gString = (G.GString)versionExp;
                strings2 = gString.getStrings();
                if (!strings2.isEmpty() && strings2.get(0) instanceof G.GString.Value) {
                    String propName;
                    G.GString.Value versionGStringValue = (G.GString.Value)strings2.get(0);
                    J tree = versionGStringValue.getTree();
                    if (tree instanceof J.Identifier) {
                        return ((J.Identifier)tree).getSimpleName();
                    }
                    if (tree instanceof J.FieldAccess) {
                        return ((J.FieldAccess)tree).printTrimmed(this.cursor);
                    }
                    if (tree instanceof J.MethodInvocation) {
                        String propName2 = GradleDependency.extractPropertyNameFromMethodInvocation((J.MethodInvocation)tree);
                        if (propName2 != null) {
                            return propName2;
                        }
                    } else if (tree instanceof G.Binary && (propName = GradleDependency.extractPropertyNameFromGBinary((G.Binary)tree)) != null) {
                        return propName;
                    }
                }
            } else if (versionExp instanceof K.StringTemplate && !(strings2 = (template = (K.StringTemplate)versionExp).getStrings()).isEmpty() && strings2.get(0) instanceof K.StringTemplate.Expression) {
                K.StringTemplate.Expression versionTemplateExpr = (K.StringTemplate.Expression)strings2.get(0);
                J tree = versionTemplateExpr.getTree();
                if (tree instanceof J.Identifier) {
                    return ((J.Identifier)tree).getSimpleName();
                }
                if (tree instanceof J.FieldAccess) {
                    return ((J.FieldAccess)tree).printTrimmed(this.cursor);
                }
            }
        }
        return null;
    }

    public boolean matches(DependencyMatcher matcher) {
        String groupId = this.getDeclaredGroupId();
        String artifactId = this.getDeclaredArtifactId();
        if (groupId == null || artifactId == null) {
            return false;
        }
        return matcher.matches(this.getDeclaredGroupId(), this.getDeclaredArtifactId());
    }

    private static @Nullable String extractPropertyNameFromMethodInvocation(J.MethodInvocation mi) {
        J.Literal literal;
        if (("property".equals(mi.getSimpleName()) || "findProperty".equals(mi.getSimpleName())) && !mi.getArguments().isEmpty() && mi.getArguments().get(0) instanceof J.Literal && (literal = (J.Literal)mi.getArguments().get(0)).getValue() instanceof String) {
            return (String)literal.getValue();
        }
        return null;
    }

    private static @Nullable String extractPropertyNameFromGBinary(G.Binary binary) {
        J.Literal right;
        if (binary.getOperator() == G.Binary.Type.Access && binary.getRight() instanceof J.Literal && (right = (J.Literal)binary.getRight()).getValue() instanceof String) {
            return (String)right.getValue();
        }
        return null;
    }

    public GradleDependency removeVersion() {
        J.MethodInvocation m;
        J.MethodInvocation updated = m = (J.MethodInvocation)this.cursor.getValue();
        if (this.isPlatform() && m.getArguments().get(0) instanceof J.MethodInvocation) {
            GradleDependency updatedPlatformDep;
            J.MethodInvocation platformMethod = (J.MethodInvocation)m.getArguments().get(0);
            GradleDependency platformDep = this.getPlatformDependency();
            if (platformDep != null && (updatedPlatformDep = platformDep.removeVersion()) != platformDep) {
                updated = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> platformMethod.withArguments(((J.MethodInvocation)updatedPlatformDep.getTree()).getArguments())));
                return new GradleDependency(new Cursor(this.cursor.getParent(), (Object)updated), this.resolvedDependency);
            }
            return this;
        }
        if (m.getArguments().get(0) instanceof J.Literal) {
            J.Literal l = (J.Literal)m.getArguments().get(0);
            if (l.getType() == JavaType.Primitive.String) {
                Dependency dep = DependencyNotation.parse((String)((String)l.getValue()));
                if (dep == null || dep.getClassifier() != null || dep.getType() != null && !"jar".equals(dep.getType())) {
                    return this;
                }
                updated = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> ChangeStringLiteral.withStringValue(l, DependencyNotation.toStringNotation((Dependency)dep.withGav(dep.getGav().withVersion(null))))));
            }
        } else if (m.getArguments().get(0) instanceof G.MapLiteral) {
            updated = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> {
                G.MapLiteral mapLiteral = (G.MapLiteral)arg;
                return mapLiteral.withElements(ListUtils.map((List)mapLiteral.getElements(), entry -> {
                    if (entry.getKey() instanceof J.Literal && "version".equals(((J.Literal)entry.getKey()).getValue())) {
                        return null;
                    }
                    return entry;
                }));
            }));
        } else if (m.getArguments().get(0) instanceof G.MapEntry) {
            updated = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> {
                G.MapEntry entry = (G.MapEntry)arg;
                if (entry.getKey() instanceof J.Literal && "version".equals(((J.Literal)entry.getKey()).getValue())) {
                    return null;
                }
                return entry;
            }));
        }
        if (updated == m) {
            return this;
        }
        return new GradleDependency(new Cursor(this.cursor.getParent(), (Object)updated), this.resolvedDependency);
    }

    public GradleDependency withDeclaredGroupId(String newGroupId) {
        J.Literal literal;
        Dependency dep;
        K.StringTemplate template;
        List strings;
        if (StringUtils.isBlank((String)newGroupId)) {
            return this;
        }
        J.MethodInvocation m = (J.MethodInvocation)this.getTree();
        if (this.isPlatform() && m.getArguments().get(0) instanceof J.MethodInvocation) {
            GradleDependency updated;
            GradleDependency platformDep = this.getPlatformDependency();
            if (platformDep != null && (updated = platformDep.withDeclaredGroupId(newGroupId)) != platformDep) {
                return new GradleDependency(new Cursor(this.cursor.getParent(), (Object)m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> (Expression)updated.getTree()))), this.resolvedDependency);
            }
            return this;
        }
        J.MethodInvocation updated = m;
        Expression firstArg = (Expression)m.getArguments().get(0);
        if (firstArg instanceof J.Literal) {
            Dependency dep2;
            String gav = (String)((J.Literal)firstArg).getValue();
            if (gav != null && (dep2 = DependencyNotation.parse((String)gav)) != null && !newGroupId.equals(dep2.getGroupId())) {
                Dependency updatedDep = dep2.withGav(dep2.getGav().withGroupId(newGroupId));
                updated = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> ChangeStringLiteral.withStringValue((J.Literal)arg, DependencyNotation.toStringNotation((Dependency)updatedDep))));
            }
        } else if (firstArg instanceof G.GString) {
            J.Literal literal2;
            String originalValue;
            Dependency dep3;
            G.GString gstring = (G.GString)firstArg;
            List strings2 = gstring.getStrings();
            if (strings2.size() >= 2 && strings2.get(0) instanceof J.Literal && (dep3 = DependencyNotation.parse((String)(originalValue = (String)(literal2 = (J.Literal)strings2.get(0)).getValue()))) != null && !newGroupId.equals(dep3.getGroupId())) {
                Dependency updatedDep = dep3.withGav(dep3.getGav().withGroupId(newGroupId));
                String replacement = DependencyNotation.toStringNotation((Dependency)updatedDep);
                if (originalValue.endsWith(":")) {
                    replacement = replacement + ":";
                }
                J.Literal newLiteral = literal2.withValue((Object)replacement).withValueSource(replacement);
                G.GString updatedGString = gstring.withStrings(ListUtils.mapFirst((List)strings2, s -> newLiteral));
                updated = m.withArguments(Collections.singletonList(updatedGString));
            }
        } else if (firstArg instanceof G.MapEntry || firstArg instanceof G.MapLiteral) {
            List entries = firstArg instanceof G.MapLiteral ? ((G.MapLiteral)firstArg).getElements() : m.getArguments().stream().filter(G.MapEntry.class::isInstance).map(G.MapEntry.class::cast).collect(Collectors.toList());
            for (G.MapEntry entry : entries) {
                if (!(entry.getKey() instanceof J.Literal) || !"group".equals(((J.Literal)entry.getKey()).getValue()) || !(entry.getValue() instanceof J.Literal)) continue;
                String currentGroup = (String)((J.Literal)entry.getValue()).getValue();
                if (!newGroupId.equals(currentGroup)) {
                    G.MapEntry updatedEntry = entry.withValue((Expression)ChangeStringLiteral.withStringValue((J.Literal)entry.getValue(), newGroupId));
                    if (firstArg instanceof G.MapLiteral) {
                        G.MapLiteral mapLiteral = (G.MapLiteral)firstArg;
                        updated = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> mapLiteral.withElements(ListUtils.map((List)mapLiteral.getElements(), e -> e == entry ? updatedEntry : e))));
                    } else {
                        updated = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> arg == entry ? updatedEntry : arg));
                    }
                }
                break;
            }
        } else if (firstArg instanceof J.Assignment) {
            List updatedArgs = m.getArguments();
            for (Expression updatedArg : updatedArgs) {
                J.Assignment assignment;
                if (!(updatedArg instanceof J.Assignment) || !((assignment = (J.Assignment)updatedArg).getVariable() instanceof J.Identifier) || !"group".equals(((J.Identifier)assignment.getVariable()).getSimpleName()) || !(assignment.getAssignment() instanceof J.Literal)) continue;
                String currentGroup = (String)((J.Literal)assignment.getAssignment()).getValue();
                if (!newGroupId.equals(currentGroup)) {
                    J.Assignment updatedAssignment = assignment.withAssignment((Expression)ChangeStringLiteral.withStringValue((J.Literal)assignment.getAssignment(), newGroupId));
                    updated = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> arg == assignment ? updatedAssignment : arg));
                }
                break;
            }
        } else if (firstArg instanceof K.StringTemplate && !(strings = (template = (K.StringTemplate)firstArg).getStrings()).isEmpty() && strings.get(0) instanceof J.Literal && (dep = DependencyNotation.parse((String)((String)(literal = (J.Literal)strings.get(0)).getValue()))) != null && !newGroupId.equals(dep.getGroupId())) {
            Dependency updatedDep = dep.withGav(dep.getGav().withGroupId(newGroupId));
            String replacement = DependencyNotation.toStringNotation((Dependency)updatedDep);
            J.Literal newLiteral = literal.withValue((Object)replacement).withValueSource(template.getDelimiter() + replacement + template.getDelimiter());
            updated = m.withArguments(Collections.singletonList(newLiteral));
        }
        return updated == m ? this : new GradleDependency(new Cursor(this.cursor.getParent(), (Object)updated), this.resolvedDependency);
    }

    public GradleDependency withDeclaredArtifactId(String newArtifactId) {
        J.Literal literal;
        Dependency dep;
        K.StringTemplate template;
        List strings;
        if (StringUtils.isBlank((String)newArtifactId)) {
            return this;
        }
        J.MethodInvocation m = (J.MethodInvocation)this.getTree();
        if (this.isPlatform() && m.getArguments().get(0) instanceof J.MethodInvocation) {
            GradleDependency updated;
            GradleDependency platformDep = this.getPlatformDependency();
            if (platformDep != null && (updated = platformDep.withDeclaredArtifactId(newArtifactId)) != platformDep) {
                return new GradleDependency(new Cursor(this.cursor.getParent(), (Object)m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> (Expression)updated.getTree()))), this.resolvedDependency);
            }
            return this;
        }
        J.MethodInvocation updated = m;
        Expression firstArg = (Expression)m.getArguments().get(0);
        if (firstArg instanceof J.Literal) {
            Dependency dep2;
            String gav = (String)((J.Literal)firstArg).getValue();
            if (gav != null && (dep2 = DependencyNotation.parse((String)gav)) != null && !newArtifactId.equals(dep2.getArtifactId())) {
                Dependency updatedDep = dep2.withGav(dep2.getGav().withArtifactId(newArtifactId));
                updated = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> ChangeStringLiteral.withStringValue((J.Literal)arg, DependencyNotation.toStringNotation((Dependency)updatedDep))));
            }
        } else if (firstArg instanceof G.GString) {
            J.Literal literal2;
            String originalValue;
            Dependency dep3;
            G.GString gstring = (G.GString)firstArg;
            List strings2 = gstring.getStrings();
            if (strings2.size() >= 2 && strings2.get(0) instanceof J.Literal && (dep3 = DependencyNotation.parse((String)(originalValue = (String)(literal2 = (J.Literal)strings2.get(0)).getValue()))) != null && !newArtifactId.equals(dep3.getArtifactId())) {
                Dependency updatedDep = dep3.withGav(dep3.getGav().withArtifactId(newArtifactId));
                String replacement = DependencyNotation.toStringNotation((Dependency)updatedDep);
                if (originalValue.endsWith(":")) {
                    replacement = replacement + ":";
                }
                J.Literal newLiteral = literal2.withValue((Object)replacement).withValueSource(replacement);
                G.GString updatedGString = gstring.withStrings(ListUtils.mapFirst((List)strings2, s -> newLiteral));
                updated = m.withArguments(Collections.singletonList(updatedGString));
            }
        } else if (firstArg instanceof G.MapEntry || firstArg instanceof G.MapLiteral) {
            List entries = firstArg instanceof G.MapLiteral ? ((G.MapLiteral)firstArg).getElements() : m.getArguments().stream().filter(G.MapEntry.class::isInstance).map(G.MapEntry.class::cast).collect(Collectors.toList());
            for (G.MapEntry entry : entries) {
                if (!(entry.getKey() instanceof J.Literal) || !"name".equals(((J.Literal)entry.getKey()).getValue()) || !(entry.getValue() instanceof J.Literal)) continue;
                String currentArtifact = (String)((J.Literal)entry.getValue()).getValue();
                if (!newArtifactId.equals(currentArtifact)) {
                    G.MapEntry updatedEntry = entry.withValue((Expression)ChangeStringLiteral.withStringValue((J.Literal)entry.getValue(), newArtifactId));
                    if (firstArg instanceof G.MapLiteral) {
                        G.MapLiteral mapLiteral = (G.MapLiteral)firstArg;
                        updated = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> mapLiteral.withElements(ListUtils.map((List)mapLiteral.getElements(), e -> e == entry ? updatedEntry : e))));
                    } else {
                        updated = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> arg == entry ? updatedEntry : arg));
                    }
                }
                break;
            }
        } else if (firstArg instanceof J.Assignment) {
            List updatedArgs = m.getArguments();
            for (Expression updatedArg : updatedArgs) {
                J.Assignment assignment;
                if (!(updatedArg instanceof J.Assignment) || !((assignment = (J.Assignment)updatedArg).getVariable() instanceof J.Identifier) || !"name".equals(((J.Identifier)assignment.getVariable()).getSimpleName()) || !(assignment.getAssignment() instanceof J.Literal)) continue;
                String currentArtifact = (String)((J.Literal)assignment.getAssignment()).getValue();
                if (!newArtifactId.equals(currentArtifact)) {
                    J.Assignment updatedAssignment = assignment.withAssignment((Expression)ChangeStringLiteral.withStringValue((J.Literal)assignment.getAssignment(), newArtifactId));
                    updated = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> arg == assignment ? updatedAssignment : arg));
                }
                break;
            }
        } else if (firstArg instanceof K.StringTemplate && !(strings = (template = (K.StringTemplate)firstArg).getStrings()).isEmpty() && strings.get(0) instanceof J.Literal && (dep = DependencyNotation.parse((String)((String)(literal = (J.Literal)strings.get(0)).getValue()))) != null && !newArtifactId.equals(dep.getArtifactId())) {
            Dependency updatedDep = dep.withGav(dep.getGav().withArtifactId(newArtifactId));
            String replacement = DependencyNotation.toStringNotation((Dependency)updatedDep);
            J.Literal newLiteral = literal.withValue((Object)replacement).withValueSource(template.getDelimiter() + replacement + template.getDelimiter());
            updated = m.withArguments(Collections.singletonList(newLiteral));
        }
        return updated == m ? this : new GradleDependency(new Cursor(this.cursor.getParent(), (Object)updated), this.resolvedDependency);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GradleDependency withDeclaredVersion(@Nullable String newVersion) {
        J.Literal literal;
        Dependency dep;
        K.StringTemplate template;
        List strings;
        if (newVersion == null || newVersion.isEmpty()) {
            return this.removeVersion();
        }
        J.MethodInvocation m = (J.MethodInvocation)this.getTree();
        if (this.isPlatform() && m.getArguments().get(0) instanceof J.MethodInvocation) {
            GradleDependency updated;
            GradleDependency platformDep = this.getPlatformDependency();
            if (platformDep == null || (updated = platformDep.withDeclaredVersion(newVersion)) == platformDep) return this;
            return new GradleDependency(new Cursor(this.cursor.getParent(), (Object)m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> (Expression)updated.getTree()))), this.resolvedDependency);
        }
        J.MethodInvocation updated = m;
        Expression firstArg = (Expression)m.getArguments().get(0);
        if (firstArg instanceof J.Literal) {
            Dependency dep2;
            String gav = (String)((J.Literal)firstArg).getValue();
            if (gav == null || (dep2 = DependencyNotation.parse((String)gav)) == null || newVersion.equals(dep2.getVersion())) return updated == m ? this : new GradleDependency(new Cursor(this.cursor.getParent(), (Object)updated), this.resolvedDependency);
            Dependency updatedDep = dep2.withGav(dep2.getGav().withVersion(newVersion));
            updated = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> ChangeStringLiteral.withStringValue((J.Literal)arg, DependencyNotation.toStringNotation((Dependency)updatedDep))));
            return updated == m ? this : new GradleDependency(new Cursor(this.cursor.getParent(), (Object)updated), this.resolvedDependency);
        }
        if (firstArg instanceof G.GString) {
            J.Literal literal2;
            Dependency dep3;
            G.GString gstring = (G.GString)firstArg;
            List strings2 = gstring.getStrings();
            if (strings2.size() < 2 || !(strings2.get(0) instanceof J.Literal) || (dep3 = DependencyNotation.parse((String)((String)(literal2 = (J.Literal)strings2.get(0)).getValue()))) == null) return updated == m ? this : new GradleDependency(new Cursor(this.cursor.getParent(), (Object)updated), this.resolvedDependency);
            Dependency updatedDep = dep3.withGav(dep3.getGav().withVersion(newVersion));
            String replacement = DependencyNotation.toStringNotation((Dependency)updatedDep);
            J.Literal newLiteral = literal2.withValue((Object)replacement).withValueSource(gstring.getDelimiter() + replacement + gstring.getDelimiter());
            updated = m.withArguments(Collections.singletonList(newLiteral));
            return updated == m ? this : new GradleDependency(new Cursor(this.cursor.getParent(), (Object)updated), this.resolvedDependency);
        }
        if (firstArg instanceof G.MapEntry || firstArg instanceof G.MapLiteral) {
            ArrayList entries = firstArg instanceof G.MapLiteral ? new ArrayList(((G.MapLiteral)firstArg).getElements()) : m.getArguments().stream().filter(G.MapEntry.class::isInstance).map(G.MapEntry.class::cast).collect(Collectors.toList());
            boolean versionFound = false;
            for (G.MapEntry entry : entries) {
                if (!(entry.getKey() instanceof J.Literal) || !"version".equals(((J.Literal)entry.getKey()).getValue()) || !(entry.getValue() instanceof J.Literal)) continue;
                String currentVersion = (String)((J.Literal)entry.getValue()).getValue();
                if (!newVersion.equals(currentVersion)) {
                    G.MapEntry updatedEntry = entry.withValue((Expression)ChangeStringLiteral.withStringValue((J.Literal)entry.getValue(), newVersion));
                    if (firstArg instanceof G.MapLiteral) {
                        G.MapLiteral mapLiteral = (G.MapLiteral)firstArg;
                        updated = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> mapLiteral.withElements(ListUtils.map((List)mapLiteral.getElements(), e -> e == entry ? updatedEntry : e))));
                    } else {
                        updated = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> arg == entry ? updatedEntry : arg));
                    }
                }
                versionFound = true;
                break;
            }
            if (!versionFound && !(firstArg instanceof G.MapLiteral)) return updated == m ? this : new GradleDependency(new Cursor(this.cursor.getParent(), (Object)updated), this.resolvedDependency);
        }
        if (firstArg instanceof J.Assignment) {
            List updatedArgs = m.getArguments();
            for (Expression updatedArg : updatedArgs) {
                J.Assignment assignment;
                if (!(updatedArg instanceof J.Assignment) || !((assignment = (J.Assignment)updatedArg).getVariable() instanceof J.Identifier) || !"version".equals(((J.Identifier)assignment.getVariable()).getSimpleName()) || !(assignment.getAssignment() instanceof J.Literal)) continue;
                String currentVersion = (String)((J.Literal)assignment.getAssignment()).getValue();
                if (newVersion.equals(currentVersion)) return updated == m ? this : new GradleDependency(new Cursor(this.cursor.getParent(), (Object)updated), this.resolvedDependency);
                J.Assignment updatedAssignment = assignment.withAssignment((Expression)ChangeStringLiteral.withStringValue((J.Literal)assignment.getAssignment(), newVersion));
                updated = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> arg == assignment ? updatedAssignment : arg));
                return updated == m ? this : new GradleDependency(new Cursor(this.cursor.getParent(), (Object)updated), this.resolvedDependency);
            }
            return updated == m ? this : new GradleDependency(new Cursor(this.cursor.getParent(), (Object)updated), this.resolvedDependency);
        }
        if (!(firstArg instanceof K.StringTemplate) || (strings = (template = (K.StringTemplate)firstArg).getStrings()).isEmpty() || !(strings.get(0) instanceof J.Literal) || (dep = DependencyNotation.parse((String)((String)(literal = (J.Literal)strings.get(0)).getValue()))) == null) return updated == m ? this : new GradleDependency(new Cursor(this.cursor.getParent(), (Object)updated), this.resolvedDependency);
        Dependency updatedDep = dep.withGav(dep.getGav().withVersion(newVersion));
        String replacement = DependencyNotation.toStringNotation((Dependency)updatedDep);
        J.Literal newLiteral = literal.withValue((Object)replacement).withValueSource(template.getDelimiter() + replacement + template.getDelimiter());
        updated = m.withArguments(Collections.singletonList(newLiteral));
        return updated == m ? this : new GradleDependency(new Cursor(this.cursor.getParent(), (Object)updated), this.resolvedDependency);
    }

    @Generated
    public GradleDependency(Cursor cursor, ResolvedDependency resolvedDependency) {
        this.cursor = cursor;
        this.resolvedDependency = resolvedDependency;
    }

    @Generated
    public Cursor getCursor() {
        return this.cursor;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradleDependency)) {
            return false;
        }
        GradleDependency other = (GradleDependency)o;
        Cursor this$cursor = this.getCursor();
        Cursor other$cursor = other.getCursor();
        if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
            return false;
        }
        ResolvedDependency this$resolvedDependency = this.getResolvedDependency();
        ResolvedDependency other$resolvedDependency = other.getResolvedDependency();
        return !(this$resolvedDependency == null ? other$resolvedDependency != null : !this$resolvedDependency.equals(other$resolvedDependency));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Cursor $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        ResolvedDependency $resolvedDependency = this.getResolvedDependency();
        result = result * 59 + ($resolvedDependency == null ? 43 : $resolvedDependency.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "GradleDependency(cursor=" + this.getCursor() + ", resolvedDependency=" + this.getResolvedDependency() + ")";
    }

    @NonNull
    @Generated
    public GradleDependency withCursor(Cursor cursor) {
        return this.cursor == cursor ? this : new GradleDependency(cursor, this.resolvedDependency);
    }

    @Generated
    public ResolvedDependency getResolvedDependency() {
        return this.resolvedDependency;
    }

    public static class Matcher
    extends GradleTraitMatcher<GradleDependency> {
        protected @Nullable String configuration;
        protected @Nullable DependencyMatcher matcher;

        public Matcher configuration(@Nullable String configuration) {
            this.configuration = configuration;
            return this;
        }

        public Matcher groupId(@Nullable String groupPattern) {
            this.matcher = this.matcher == null ? new DependencyMatcher(groupPattern, null, null) : this.matcher.withGroupPattern(groupPattern);
            return this;
        }

        public Matcher artifactId(@Nullable String artifactPattern) {
            this.matcher = this.matcher == null ? new DependencyMatcher(null, artifactPattern, null) : this.matcher.withArtifactPattern(artifactPattern);
            return this;
        }

        public Matcher matcher(@Nullable DependencyMatcher matcher) {
            this.matcher = matcher;
            return this;
        }

        public <P> TreeVisitor<? extends Tree, P> asVisitor(final VisitFunction2<GradleDependency, P> visitor) {
            return new JavaVisitor<P>(){

                public J visitMethodInvocation(J.MethodInvocation method, P p) {
                    GradleDependency dependency = this.test(this.getCursor());
                    return dependency != null ? (J)visitor.visit((Trait)dependency, p) : super.visitMethodInvocation(method, p);
                }
            };
        }

        protected @Nullable GradleDependency test(Cursor cursor) {
            if (!GradleDependency.isDependencyDeclaration(cursor)) {
                return null;
            }
            J.MethodInvocation methodInvocation = (J.MethodInvocation)cursor.getValue();
            GradleProject gradleProject = this.getGradleProject(cursor);
            GradleDependencyConfiguration gdc = GradleDependency.getConfiguration(gradleProject, methodInvocation);
            if (!StringUtils.isBlank((String)this.configuration) && !methodInvocation.getSimpleName().equals(this.configuration)) {
                return null;
            }
            Dependency dependency = null;
            Expression argument = (Expression)methodInvocation.getArguments().get(0);
            if (argument instanceof J.Literal || argument instanceof G.GString || argument instanceof G.MapEntry || argument instanceof G.MapLiteral || argument instanceof J.Assignment || argument instanceof K.StringTemplate) {
                dependency = this.parseDependency(methodInvocation.getArguments());
            } else if (argument instanceof J.Binary && ((J.Binary)argument).getLeft() instanceof J.Literal) {
                dependency = this.parseDependency(Collections.singletonList(((J.Binary)argument).getLeft()));
            } else if (argument instanceof J.MethodInvocation) {
                if ("platform".equals(((J.MethodInvocation)argument).getSimpleName()) || "enforcedPlatform".equals(((J.MethodInvocation)argument).getSimpleName())) {
                    dependency = this.parseDependency(((J.MethodInvocation)argument).getArguments());
                } else if ("project".equals(((J.MethodInvocation)argument).getSimpleName())) {
                    return null;
                }
            }
            if (dependency == null) {
                return null;
            }
            if (gdc != null) {
                if (gdc.isCanBeResolved()) {
                    for (ResolvedDependency resolvedDependency : gdc.getDirectResolved()) {
                        Dependency req;
                        if (this.matcher != null && !this.matcher.matches(resolvedDependency.getGroupId(), resolvedDependency.getArtifactId()) || (req = resolvedDependency.getRequested()).getGroupId() != null && !req.getGroupId().equals(dependency.getGroupId()) || !req.getArtifactId().equals(dependency.getArtifactId())) continue;
                        return new GradleDependency(cursor, Matcher.withRequested(resolvedDependency, dependency));
                    }
                } else {
                    for (GradleDependencyConfiguration transitiveConfiguration : gradleProject.configurationsExtendingFrom(gdc, true)) {
                        if (!transitiveConfiguration.isCanBeResolved()) continue;
                        for (ResolvedDependency resolvedDependency : transitiveConfiguration.getDirectResolved()) {
                            Dependency req;
                            if (this.matcher != null && !this.matcher.matches(resolvedDependency.getGroupId(), resolvedDependency.getArtifactId()) || (req = resolvedDependency.getRequested()).getGroupId() != null && !req.getGroupId().equals(dependency.getGroupId()) || !req.getArtifactId().equals(dependency.getArtifactId())) continue;
                            return new GradleDependency(cursor, Matcher.withRequested(resolvedDependency, dependency));
                        }
                    }
                }
            }
            if (this.matcher == null || this.matcher.matches(dependency.getGroupId(), dependency.getArtifactId())) {
                ResolvedDependency resolvedDependency = ResolvedDependency.builder().depth(-1).gav(new ResolvedGroupArtifactVersion(null, dependency.getGroupId() == null ? "" : dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion() != null ? dependency.getVersion() : "", null)).classifier(dependency.getClassifier()).type(dependency.getType()).requested(Dependency.builder().scope(methodInvocation.getSimpleName()).type(dependency.getType()).gav(dependency.getGav()).classifier(dependency.getClassifier()).build()).build();
                return new GradleDependency(cursor, Matcher.withRequested(resolvedDependency, dependency));
            }
            return null;
        }

        private static ResolvedDependency withRequested(ResolvedDependency resolved, Dependency requested) {
            return resolved.withRequested(resolved.getRequested().withGav(requested.getGav()));
        }

        private @Nullable Dependency parseDependency(List<Expression> arguments) {
            Expression argument = arguments.get(0);
            if (argument instanceof J.Literal) {
                return DependencyNotation.parse((String)((String)((J.Literal)argument).getValue()));
            }
            if (argument instanceof G.GString) {
                G.GString gstring = (G.GString)argument;
                List strings = gstring.getStrings();
                if (strings.size() >= 2 && strings.get(0) instanceof J.Literal && ((J.Literal)strings.get(0)).getValue() != null) {
                    return DependencyNotation.parse((String)((String)((J.Literal)strings.get(0)).getValue()));
                }
            } else {
                K.StringTemplate template;
                List strings;
                if (argument instanceof G.MapLiteral) {
                    List<Expression> mapEntryExpressions = ((G.MapLiteral)argument).getElements().stream().map(e -> e).collect(Collectors.toList());
                    return Matcher.getMapEntriesDependency(mapEntryExpressions);
                }
                if (argument instanceof G.MapEntry) {
                    return Matcher.getMapEntriesDependency(arguments);
                }
                if (argument instanceof J.Assignment) {
                    String group = null;
                    String artifact = null;
                    String version = null;
                    for (Expression e2 : arguments) {
                        J.Assignment arg;
                        if (!(e2 instanceof J.Assignment) || !((arg = (J.Assignment)e2).getVariable() instanceof J.Identifier) || !(arg.getAssignment() instanceof J.Literal)) continue;
                        J.Identifier identifier = (J.Identifier)arg.getVariable();
                        J.Literal value = (J.Literal)arg.getAssignment();
                        if (!(value.getValue() instanceof String)) continue;
                        String name = identifier.getSimpleName();
                        if ("group".equals(name)) {
                            group = (String)value.getValue();
                            continue;
                        }
                        if ("name".equals(name)) {
                            artifact = (String)value.getValue();
                            continue;
                        }
                        if (!"version".equals(name)) continue;
                        version = (String)value.getValue();
                    }
                    if (group == null || artifact == null) {
                        return null;
                    }
                    return Dependency.builder().gav(new GroupArtifactVersion(group, artifact, version)).build();
                }
                if (argument instanceof K.StringTemplate && !(strings = (template = (K.StringTemplate)argument).getStrings()).isEmpty() && strings.get(0) instanceof J.Literal && ((J.Literal)strings.get(0)).getValue() != null) {
                    return DependencyNotation.parse((String)((String)((J.Literal)strings.get(0)).getValue()));
                }
            }
            return null;
        }

        private static @Nullable Dependency getMapEntriesDependency(List<Expression> arguments) {
            String group = null;
            String artifact = null;
            String version = null;
            for (Expression e : arguments) {
                G.MapEntry arg;
                if (!(e instanceof G.MapEntry) || !((arg = (G.MapEntry)e).getKey() instanceof J.Literal) || !(arg.getValue() instanceof J.Literal)) continue;
                J.Literal key = (J.Literal)arg.getKey();
                J.Literal value = (J.Literal)arg.getValue();
                if (!(key.getValue() instanceof String) || !(value.getValue() instanceof String)) continue;
                String keyValue = (String)key.getValue();
                if ("group".equals(keyValue)) {
                    group = (String)value.getValue();
                    continue;
                }
                if ("name".equals(keyValue)) {
                    artifact = (String)value.getValue();
                    continue;
                }
                if (!"version".equals(keyValue)) continue;
                version = (String)value.getValue();
            }
            if (group == null || artifact == null) {
                return null;
            }
            return Dependency.builder().gav(new GroupArtifactVersion(group, artifact, version)).build();
        }
    }
}

