/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.gradle.util.GradleWrapper;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Markup;
import org.openrewrite.remote.Remote;
import org.openrewrite.remote.RemoteResource;

public class GradleWrapperScriptLoader {
    private final Map<String, Version> allVersions = new HashMap<String, Version>();

    public GradleWrapperScriptLoader() {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(Objects.requireNonNull(this.getClass().getResourceAsStream("/META-INF/rewrite/gradle-wrapper/versions.csv"))));){
            String line;
            in.readLine();
            while ((line = in.readLine()) != null) {
                String[] row = line.split(",");
                Version version = new Version(row[0], row[1], row[2]);
                this.allVersions.put(row[0], version);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Nearest findNearest(String requestedVersion) {
        return new Nearest(requestedVersion, this.allVersions.get(requestedVersion));
    }

    @Generated
    public Map<String, Version> getAllVersions() {
        return this.allVersions;
    }

    public static final class Version {
        private final String version;
        private final String gradlewChecksum;
        private final String gradlewBatChecksum;

        @Generated
        public Version(String version, String gradlewChecksum, String gradlewBatChecksum) {
            this.version = version;
            this.gradlewChecksum = gradlewChecksum;
            this.gradlewBatChecksum = gradlewBatChecksum;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public String getGradlewChecksum() {
            return this.gradlewChecksum;
        }

        @Generated
        public String getGradlewBatChecksum() {
            return this.gradlewBatChecksum;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Version)) {
                return false;
            }
            Version other = (Version)o;
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$gradlewChecksum = this.getGradlewChecksum();
            String other$gradlewChecksum = other.getGradlewChecksum();
            if (this$gradlewChecksum == null ? other$gradlewChecksum != null : !this$gradlewChecksum.equals(other$gradlewChecksum)) {
                return false;
            }
            String this$gradlewBatChecksum = this.getGradlewBatChecksum();
            String other$gradlewBatChecksum = other.getGradlewBatChecksum();
            return !(this$gradlewBatChecksum == null ? other$gradlewBatChecksum != null : !this$gradlewBatChecksum.equals(other$gradlewBatChecksum));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $gradlewChecksum = this.getGradlewChecksum();
            result = result * 59 + ($gradlewChecksum == null ? 43 : $gradlewChecksum.hashCode());
            String $gradlewBatChecksum = this.getGradlewBatChecksum();
            result = result * 59 + ($gradlewBatChecksum == null ? 43 : $gradlewBatChecksum.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "GradleWrapperScriptLoader.Version(version=" + this.getVersion() + ", gradlewChecksum=" + this.getGradlewChecksum() + ", gradlewBatChecksum=" + this.getGradlewBatChecksum() + ")";
        }
    }

    public static final class Nearest {
        private final @Nullable String requestedVersion;
        private final Version resolved;

        public RemoteResource gradlew() {
            InputStream script = this.getClass().getResourceAsStream("/META-INF/rewrite/gradle-wrapper/unix/" + this.resolved.getGradlewChecksum() + ".txt");
            return this.maybeWarn(Remote.builder((Path)GradleWrapper.WRAPPER_SCRIPT_LOCATION).description(String.format("Unix Gradle wrapper script template for %s", this.resolved.getVersion())).charset(StandardCharsets.UTF_8).build(Objects.requireNonNull(script)));
        }

        public RemoteResource gradlewBat() {
            InputStream script = this.getClass().getResourceAsStream("/META-INF/rewrite/gradle-wrapper/windows/" + this.resolved.getGradlewBatChecksum() + ".txt");
            return this.maybeWarn(Remote.builder((Path)GradleWrapper.WRAPPER_BATCH_LOCATION).description(String.format("Windows Gradle wrapper script template for %s", this.resolved.getVersion())).charset(Charset.forName("Windows-1252")).build(Objects.requireNonNull(script)));
        }

        public RemoteResource maybeWarn(RemoteResource script) {
            if (!this.resolved.getVersion().equals(this.requestedVersion)) {
                return (RemoteResource)Markup.warn((Tree)script, (Throwable)new Exception("rewrite-gradle does not contain a script for requested version" + (this.requestedVersion == null ? "" : this.requestedVersion + ". ") + "Using the script from nearest available version " + this.resolved.getVersion() + " instead."));
            }
            return script;
        }

        @Generated
        public Nearest(@Nullable String requestedVersion, Version resolved) {
            this.requestedVersion = requestedVersion;
            this.resolved = resolved;
        }

        @Generated
        public @Nullable String getRequestedVersion() {
            return this.requestedVersion;
        }

        @Generated
        public Version getResolved() {
            return this.resolved;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Nearest)) {
                return false;
            }
            Nearest other = (Nearest)o;
            String this$requestedVersion = this.getRequestedVersion();
            String other$requestedVersion = other.getRequestedVersion();
            if (this$requestedVersion == null ? other$requestedVersion != null : !this$requestedVersion.equals(other$requestedVersion)) {
                return false;
            }
            Version this$resolved = this.getResolved();
            Version other$resolved = other.getResolved();
            return !(this$resolved == null ? other$resolved != null : !((Object)this$resolved).equals(other$resolved));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $requestedVersion = this.getRequestedVersion();
            result = result * 59 + ($requestedVersion == null ? 43 : $requestedVersion.hashCode());
            Version $resolved = this.getResolved();
            result = result * 59 + ($resolved == null ? 43 : ((Object)$resolved).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "GradleWrapperScriptLoader.Nearest(requestedVersion=" + this.getRequestedVersion() + ", resolved=" + this.getResolved() + ")";
        }
    }
}

