/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.internal;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.gradle.AddDependencyVisitor;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.gradle.internal.InsertDependencyComparator;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.trait.GradleDependency;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.RandomizeIdVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markup;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenDownloadingExceptions;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.maven.tree.Scope;

public class AddDependencyVisitor
extends JavaIsoVisitor<ExecutionContext> {
    private static final MethodMatcher DEPENDENCIES_DSL_MATCHER = new MethodMatcher("* dependencies(..)");
    private static final GradleParser GRADLE_PARSER = GradleParser.builder().build();
    private static final String TEMPLATE_CACHE_MESSAGE_KEY = "__org.openrewrite.gradle.internal.AddDependencyVisitor.cache__";
    public static final String KOTLIN_MAP_SEPARATOR = " = ";
    public static final String GROOVY_MAP_SEPARATOR = ": ";
    private final String configuration;
    private final String groupId;
    private final String artifactId;
    private final @Nullable String version;
    private final @Nullable String classifier;
    private final @Nullable String extension;
    private final @Nullable Predicate<Cursor> insertPredicate;
    private final @Nullable AddDependencyVisitor.DependencyModifier dependencyModifier;
    private final boolean isKotlinDsl;

    public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
        J j = (J)super.visit(tree, (Object)ctx);
        if (j instanceof JavaSourceFile) {
            G.CompilationUnit g;
            JavaSourceFile cu = (JavaSourceFile)j;
            if (j == tree && this.insertPredicate != null && this.insertPredicate.test(new Cursor(this.getCursor(), (Object)j)) && cu instanceof G.CompilationUnit && !this.hasDependenciesBlock((g = (G.CompilationUnit)cu).getStatements())) {
                Cursor parent = this.getCursor();
                this.setCursor(new Cursor(parent, (Object)g));
                J.MethodInvocation dependencies = this.dependenciesDeclaration(ctx).withPrefix(Space.format((String)"\n\n"));
                cu = g.withStatements(ListUtils.concat((List)g.getStatements(), (Object)dependencies));
                this.setCursor(parent);
            }
            return cu;
        }
        return j;
    }

    public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
        J.Block b = super.visitBlock(block, (Object)ctx);
        if (b == block && this.insertPredicate != null && this.insertPredicate.test(this.getCursor()) && !this.hasDependenciesBlock(b.getStatements())) {
            Cursor parent = this.getCursor().dropParentUntil(value -> value instanceof J.MethodInvocation || value == "root");
            Space prefix = b.getStatements().isEmpty() ? Space.format((String)"\n") : Space.format((String)"\n\n");
            J.MethodInvocation dependencies = parent.isRoot() ? this.dependenciesDeclaration(ctx).withPrefix(prefix) : (Statement)this.autoFormat((J)this.dependenciesDeclaration(ctx).withPrefix(prefix), ctx, this.getCursor());
            return b.withStatements(ListUtils.concat((List)b.getStatements(), (Object)dependencies));
        }
        return b;
    }

    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
        J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
        if (DEPENDENCIES_DSL_MATCHER.matches(m, true)) {
            if (this.insertPredicate != null && !this.insertPredicate.test(this.getCursor())) {
                return m;
            }
            Optional maybeDependency = new GradleDependency.Matcher().configuration(this.configuration).groupId(this.groupId).artifactId(this.artifactId).lower(this.getCursor()).findFirst();
            if (maybeDependency.isPresent()) {
                return m;
            }
            return m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> {
                if (arg instanceof J.Lambda) {
                    int i;
                    J.Lambda lambda = (J.Lambda)arg;
                    J.Block body = (J.Block)lambda.getBody();
                    J.MethodInvocation addDependencyInvocation = this.dependencyDeclaration(body, ctx, new Cursor(new Cursor(this.getCursor(), (Object)lambda), (Object)body));
                    InsertDependencyComparator dependencyComparator = new InsertDependencyComparator(body.getStatements(), addDependencyInvocation);
                    ArrayList<Object> statements = new ArrayList<Object>(body.getStatements());
                    for (i = 0; i < body.getStatements().size(); ++i) {
                        Statement currentStatement = (Statement)body.getStatements().get(i);
                        if (dependencyComparator.compare(currentStatement, (Statement)addDependencyInvocation) <= 0) continue;
                        if (dependencyComparator.getBeforeDependency() != null) {
                            J.MethodInvocation beforeDependency = (J.MethodInvocation)(dependencyComparator.getBeforeDependency() instanceof J.Return ? (J)Objects.requireNonNull(((J.Return)dependencyComparator.getBeforeDependency()).getExpression()) : dependencyComparator.getBeforeDependency());
                            if (i == 0) {
                                if (!addDependencyInvocation.getSimpleName().equals(beforeDependency.getSimpleName())) {
                                    statements.set(i, (Statement)currentStatement.withPrefix(Space.format((String)("\n\n" + currentStatement.getPrefix().getIndent()))));
                                }
                            } else {
                                Space originalPrefix = addDependencyInvocation.getPrefix();
                                if ((addDependencyInvocation = addDependencyInvocation.withPrefix(currentStatement.getPrefix())).getSimpleName().equals(beforeDependency.getSimpleName()) && !currentStatement.getPrefix().equals((Object)originalPrefix)) {
                                    statements.set(i, (Statement)currentStatement.withPrefix(originalPrefix));
                                }
                            }
                        }
                        statements.add(i, addDependencyInvocation);
                        break;
                    }
                    if (body.getStatements().size() == i) {
                        if (!body.getStatements().isEmpty()) {
                            Statement lastStatement;
                            if (statements.get(i - 1) instanceof J.Return) {
                                J.Return r = (J.Return)statements.remove(i - 1);
                                lastStatement = (Statement)Objects.requireNonNull(r.getExpression()).withPrefix(r.getPrefix());
                                statements.add(lastStatement);
                            } else {
                                lastStatement = (Statement)statements.get(i - 1);
                            }
                            if (lastStatement instanceof J.MethodInvocation && !((J.MethodInvocation)lastStatement).getSimpleName().equals(addDependencyInvocation.getSimpleName())) {
                                addDependencyInvocation = addDependencyInvocation.withPrefix(Space.format((String)("\n\n" + addDependencyInvocation.getPrefix().getIndent())));
                            }
                        }
                        statements.add(addDependencyInvocation);
                    }
                    body = body.withStatements(statements);
                    return lambda.withBody((J)body.withStatements(statements));
                }
                return arg;
            }));
        }
        return m;
    }

    public static JavaSourceFile addDependency(JavaSourceFile buildScript, @Nullable GradleDependencyConfiguration configuration, GroupArtifactVersion gav, @Nullable String classifier, ExecutionContext ctx) {
        if (gav.getGroupId() == null || gav.getArtifactId() == null || configuration == null) {
            return buildScript;
        }
        GradleProject gp = (GradleProject)buildScript.getMarkers().findFirst(GradleProject.class).orElseThrow(() -> new IllegalArgumentException("Could not find GradleProject"));
        try {
            List transitiveDependencies;
            ResolvedGroupArtifactVersion resolvedGav;
            if (gav.getVersion() == null) {
                resolvedGav = null;
                transitiveDependencies = Collections.emptyList();
            } else {
                MavenPomDownloader mpd = new MavenPomDownloader(ctx);
                Pom pom = mpd.download(gav, null, null, gp.getMavenRepositories());
                ResolvedPom resolvedPom = pom.resolve(Collections.emptyList(), mpd, gp.getMavenRepositories(), ctx);
                resolvedGav = resolvedPom.getGav();
                transitiveDependencies = resolvedPom.resolveDependencies(Scope.Runtime, mpd, ctx);
            }
            Map<String, GradleDependencyConfiguration> nameToConfiguration = gp.getNameToConfiguration();
            HashMap<String, GradleDependencyConfiguration> newNameToConfiguration = new HashMap<String, GradleDependencyConfiguration>(nameToConfiguration.size());
            Set configurationsToAdd = Stream.concat(Stream.of(configuration), gp.configurationsExtendingFrom(configuration, true).stream()).collect(Collectors.toSet());
            for (GradleDependencyConfiguration gdc : nameToConfiguration.values()) {
                if (!configurationsToAdd.contains(gdc)) {
                    newNameToConfiguration.put(gdc.getName(), gdc);
                    continue;
                }
                GradleDependencyConfiguration newGdc = gdc;
                Dependency newRequested = Dependency.builder().gav(gav).classifier(classifier).type("jar").scope(gdc.getName()).build();
                if ((newGdc = newGdc.withRequested(ListUtils.concat((List)ListUtils.map(gdc.getRequested(), requested -> {
                    if (Objects.equals(requested.getGroupId(), gav.getGroupId()) && Objects.equals(requested.getArtifactId(), gav.getArtifactId())) {
                        return null;
                    }
                    return requested;
                }), (Object)newRequested))).isCanBeResolved() && resolvedGav != null) {
                    newGdc = newGdc.withDirectResolved(ListUtils.concat((List)ListUtils.map(gdc.getDirectResolved(), resolved -> {
                        if (Objects.equals(resolved.getGroupId(), resolvedGav.getGroupId()) && Objects.equals(resolved.getArtifactId(), resolvedGav.getArtifactId())) {
                            return null;
                        }
                        return resolved;
                    }), (Object)new ResolvedDependency(null, resolvedGav, newRequested, transitiveDependencies, Collections.emptyList(), "jar", classifier, null, 0, null)));
                }
                newNameToConfiguration.put(newGdc.getName(), newGdc);
            }
            gp = gp.withNameToConfiguration(newNameToConfiguration);
        }
        catch (IllegalArgumentException | MavenDownloadingException | MavenDownloadingExceptions e) {
            return (JavaSourceFile)Markup.warn((Tree)buildScript, (Throwable)e);
        }
        return (JavaSourceFile)buildScript.withMarkers(buildScript.getMarkers().setByType((Marker)gp));
    }

    private <J2 extends J> List<J2> cache(Cursor cursor, Object key, Supplier<List<? extends J>> ifAbsent) {
        List<? extends J> js = null;
        Cursor root = cursor.getRoot();
        HashMap<Object, List<? extends J>> cache = (HashMap<Object, List<? extends J>>)root.getMessage(TEMPLATE_CACHE_MESSAGE_KEY);
        if (cache == null) {
            cache = new HashMap<Object, List<? extends J>>();
            root.putMessage(TEMPLATE_CACHE_MESSAGE_KEY, cache);
        } else {
            js = (List<? extends J>)cache.get(key);
        }
        if (js == null) {
            js = ifAbsent.get();
            cache.put(key, js);
        }
        return ListUtils.map((List)js, j -> (J)new RandomizeIdVisitor().visit((Tree)j, (Object)0));
    }

    private boolean hasDependenciesBlock(List<Statement> statements) {
        for (Statement statement : statements) {
            if (statement instanceof J.MethodInvocation && DEPENDENCIES_DSL_MATCHER.matches((J.MethodInvocation)statement, true)) {
                return true;
            }
            if (!(statement instanceof J.Return) || !(((J.Return)statement).getExpression() instanceof J.MethodInvocation) || !DEPENDENCIES_DSL_MATCHER.matches((J.MethodInvocation)((J.Return)statement).getExpression(), true)) continue;
            return true;
        }
        return false;
    }

    private J.MethodInvocation dependenciesDeclaration(ExecutionContext ctx) {
        String template = this.templateDependencies();
        return (J.MethodInvocation)this.cache(this.getCursor(), new ContextFreeCacheKey(template, this.isKotlinDsl, J.MethodInvocation.class), () -> {
            Boolean requirePrintEqualsInput = (Boolean)ctx.getMessage("org.openrewrite.requirePrintEqualsInput");
            try {
                ctx.putMessage("org.openrewrite.requirePrintEqualsInput", (Object)false);
                J.MethodInvocation dependencies = this.isKotlinDsl ? (J.MethodInvocation)((J.Block)GRADLE_PARSER.parseInputs(Collections.singletonList(new Parser.Input(Paths.get("build.gradle.kts", new String[0]), () -> new ByteArrayInputStream(template.getBytes(StandardCharsets.UTF_8)))), null, ctx).findFirst().map(K.CompilationUnit.class::cast).orElseThrow(() -> new IllegalArgumentException("Could not parse as Gradle")).getStatements().get(0)).getStatements().get(0) : (J.MethodInvocation)GRADLE_PARSER.parse(ctx, new String[]{template}).findFirst().map(G.CompilationUnit.class::cast).orElseThrow(() -> new IllegalArgumentException("Could not parse as Gradle")).getStatements().get(0);
                List<J.MethodInvocation> list = Collections.singletonList(dependencies);
                return list;
            }
            finally {
                ctx.putMessage("org.openrewrite.requirePrintEqualsInput", (Object)requirePrintEqualsInput);
            }
        }).get(0);
    }

    private J.MethodInvocation dependencyDeclaration(J.Block body, ExecutionContext ctx, Cursor cursor) {
        String template = this.templateDependency(body);
        return (J.MethodInvocation)this.autoFormat((J)this.cache(cursor, new ContextFreeCacheKey(template, this.isKotlinDsl, J.MethodInvocation.class), () -> {
            Boolean requirePrintEqualsInput = (Boolean)ctx.getMessage("org.openrewrite.requirePrintEqualsInput");
            try {
                ctx.putMessage("org.openrewrite.requirePrintEqualsInput", (Object)false);
                J.MethodInvocation dependency = this.isKotlinDsl ? (J.MethodInvocation)((J.Block)GRADLE_PARSER.parseInputs(Collections.singletonList(new Parser.Input(Paths.get("build.gradle.kts", new String[0]), () -> new ByteArrayInputStream(template.getBytes(StandardCharsets.UTF_8)))), null, ctx).findFirst().map(K.CompilationUnit.class::cast).orElseThrow(() -> new IllegalArgumentException("Could not parse as Gradle")).getStatements().get(0)).getStatements().get(0) : (J.MethodInvocation)GRADLE_PARSER.parse(ctx, new String[]{template}).findFirst().map(G.CompilationUnit.class::cast).orElseThrow(() -> new IllegalArgumentException("Could not parse as Gradle")).getStatements().get(0);
                List<J.MethodInvocation> list = Collections.singletonList(dependency.withPrefix(Space.format((String)"\n")));
                return list;
            }
            finally {
                ctx.putMessage("org.openrewrite.requirePrintEqualsInput", (Object)requirePrintEqualsInput);
            }
        }).get(0), ctx, cursor);
    }

    private String templateDependencies() {
        return "dependencies {\n    " + this.templateDependency(null) + "\n}";
    }

    private String templateDependency(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable J.Block body) {
        DependencyStyle style = this.autodetectDependencyStyle(body);
        if (this.isKotlinDsl) {
            return this.escapeIfNecessary(this.configuration) + "(" + this.templatePlatform(this.templateDependencyNotation(KOTLIN_MAP_SEPARATOR, style)) + ")";
        }
        return this.escapeIfNecessary(this.configuration) + " " + this.templatePlatform(this.templateDependencyNotation(GROOVY_MAP_SEPARATOR, style));
    }

    private String templatePlatform(String dependencyNotation) {
        if (this.dependencyModifier == AddDependencyVisitor.DependencyModifier.PLATFORM) {
            return "platform(" + dependencyNotation + ")";
        }
        if (this.dependencyModifier == AddDependencyVisitor.DependencyModifier.ENFORCED_PLATFORM) {
            return "enforcedPlatform(" + dependencyNotation + ")";
        }
        return dependencyNotation;
    }

    private String templateDependencyNotation(String mapSeparator, DependencyStyle style) {
        if (style == DependencyStyle.String) {
            return "\"" + this.groupId + ":" + this.artifactId + (this.version == null ? "" : ":" + this.version) + (this.version == null || this.classifier == null ? "" : ":" + this.classifier) + (this.extension == null ? "" : "@" + this.extension) + "\"";
        }
        return "group" + mapSeparator + "\"" + this.groupId + "\", name" + mapSeparator + "\"" + this.artifactId + "\"" + (this.version == null ? "" : ", version" + mapSeparator + "\"" + this.version + "\"") + (this.classifier == null ? "" : ", classifier" + mapSeparator + "\"" + this.classifier + "\"") + (this.extension == null ? "" : ", ext" + mapSeparator + "\"" + this.extension + "\"");
    }

    private String escapeIfNecessary(String configurationName) {
        return "default".equals(configurationName) ? "'" + configurationName + "'" : configurationName;
    }

    private DependencyStyle autodetectDependencyStyle(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable J.Block block) {
        if (block == null) {
            return DependencyStyle.String;
        }
        List statements = block.getStatements();
        int string = 0;
        int map = 0;
        for (Statement statement : statements) {
            J.MethodInvocation invocation;
            if (statement instanceof J.Return && ((J.Return)statement).getExpression() instanceof J.MethodInvocation) {
                invocation = (J.MethodInvocation)((J.Return)statement).getExpression();
                if (invocation.getArguments().get(0) instanceof J.Literal || invocation.getArguments().get(0) instanceof G.GString) {
                    ++string;
                    continue;
                }
                if (invocation.getArguments().get(0) instanceof G.MapEntry) {
                    ++map;
                    continue;
                }
                if (!(invocation.getArguments().get(0) instanceof J.Assignment)) continue;
                ++map;
                continue;
            }
            if (!(statement instanceof J.MethodInvocation)) continue;
            invocation = (J.MethodInvocation)statement;
            if (invocation.getArguments().get(0) instanceof J.Literal || invocation.getArguments().get(0) instanceof G.GString) {
                ++string;
                continue;
            }
            if (invocation.getArguments().get(0) instanceof G.MapEntry) {
                ++map;
                continue;
            }
            if (!(invocation.getArguments().get(0) instanceof J.Assignment)) continue;
            ++map;
        }
        return string >= map ? DependencyStyle.String : DependencyStyle.Map;
    }

    @Generated
    public AddDependencyVisitor(String configuration, String groupId, String artifactId, @Nullable String version, @Nullable String classifier, @Nullable String extension, @Nullable Predicate<Cursor> insertPredicate, @Nullable AddDependencyVisitor.DependencyModifier dependencyModifier, boolean isKotlinDsl) {
        this.configuration = configuration;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
        this.extension = extension;
        this.insertPredicate = insertPredicate;
        this.dependencyModifier = dependencyModifier;
        this.isKotlinDsl = isKotlinDsl;
    }

    private static final class ContextFreeCacheKey {
        private final String template;
        private final boolean isKotlinDsl;
        private final Class<? extends J> expected;

        @Generated
        public ContextFreeCacheKey(String template, boolean isKotlinDsl, Class<? extends J> expected) {
            this.template = template;
            this.isKotlinDsl = isKotlinDsl;
            this.expected = expected;
        }

        @Generated
        public String getTemplate() {
            return this.template;
        }

        @Generated
        public boolean isKotlinDsl() {
            return this.isKotlinDsl;
        }

        @Generated
        public Class<? extends J> getExpected() {
            return this.expected;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContextFreeCacheKey)) {
                return false;
            }
            ContextFreeCacheKey other = (ContextFreeCacheKey)o;
            if (this.isKotlinDsl() != other.isKotlinDsl()) {
                return false;
            }
            String this$template = this.getTemplate();
            String other$template = other.getTemplate();
            if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
                return false;
            }
            Class<? extends J> this$expected = this.getExpected();
            Class<? extends J> other$expected = other.getExpected();
            return !(this$expected == null ? other$expected != null : !this$expected.equals(other$expected));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isKotlinDsl() ? 79 : 97);
            String $template = this.getTemplate();
            result = result * 59 + ($template == null ? 43 : $template.hashCode());
            Class<? extends J> $expected = this.getExpected();
            result = result * 59 + ($expected == null ? 43 : $expected.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "AddDependencyVisitor.ContextFreeCacheKey(template=" + this.getTemplate() + ", isKotlinDsl=" + this.isKotlinDsl() + ", expected=" + this.getExpected() + ")";
        }
    }

    static enum DependencyStyle {
        Map,
        String;

    }
}

