/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.marker.GradleBuildscript;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.semver.LatestIntegration;

public final class RemoveRedundantSecurityResolutionRules
extends Recipe {
    private static final String DEFAULT_SECURITY_PATTERN = "(CVE-\\d|GHSA-[a-z0-9])";
    private static final String METHOD_ALL = "all";
    private static final String METHOD_BECAUSE = "because";
    private static final String METHOD_BUILDSCRIPT = "buildscript";
    private static final String METHOD_CONFIGURATIONS = "configurations";
    private static final String METHOD_EACH_DEPENDENCY = "eachDependency";
    private static final String METHOD_NAMED = "named";
    private static final String METHOD_RESOLUTION_STRATEGY = "resolutionStrategy";
    private static final String METHOD_USE_VERSION = "useVersion";
    @Option(displayName="Security pattern", description="A regular expression pattern to identify security-related resolution rules by matching against the `because` clause. Rules matching this pattern will be considered for removal. The pattern is searched within the clause, so a `because` containing multiple identifiers (e.g., `CVE-2024-1234, GHSA-abcd-1234-efgh`) will match if any identifier matches. Default pattern matches CVE identifiers (e.g., `CVE-2024-1234`) and GitHub Security Advisory identifiers (e.g., `GHSA-xxxx-xxxx-xxxx`).", example="(CVE-\\d|GHSA-[a-z0-9])", required=false)
    private final @Nullable String securityPattern;

    public String getDisplayName() {
        return "Remove redundant security resolution rules";
    }

    public String getDescription() {
        return "Remove `resolutionStrategy.eachDependency` rules that pin dependencies to versions that are already being managed by a platform/BOM to equal or newer versions. Only removes rules that have a security advisory identifier (CVE or GHSA) in the `because` clause, unless a custom pattern is specified.";
    }

    public Set<String> getTags() {
        return Collections.singleton("security");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final Pattern compiledPattern = Pattern.compile(this.securityPattern != null ? this.securityPattern : DEFAULT_SECURITY_PATTERN, 2);
        JavaIsoVisitor<ExecutionContext> removeRulesVisitor = new JavaIsoVisitor<ExecutionContext>(){
            @Nullable GradleProject gradleProject;
            boolean insideBuildscript;

            private void maybeInitialize() {
                JavaSourceFile sourceFile;
                if (this.gradleProject == null && (sourceFile = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class)) != null) {
                    this.gradleProject = sourceFile.getMarkers().findFirst(GradleProject.class).orElse(null);
                }
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                this.maybeInitialize();
                boolean enteredBuildscript = RemoveRedundantSecurityResolutionRules.METHOD_BUILDSCRIPT.equals(method.getSimpleName());
                if (enteredBuildscript) {
                    this.insideBuildscript = true;
                }
                boolean currentlyInBuildscript = this.insideBuildscript;
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (enteredBuildscript) {
                    this.insideBuildscript = false;
                }
                if (!RemoveRedundantSecurityResolutionRules.isEachDependency(m, this.getCursor())) {
                    return m;
                }
                if (m.getArguments().isEmpty()) {
                    return m;
                }
                Expression maybeClosure = (Expression)m.getArguments().get(0);
                if (!(maybeClosure instanceof J.Lambda) || !(((J.Lambda)maybeClosure).getBody() instanceof J.Block)) {
                    return m;
                }
                J.Lambda closure = (J.Lambda)maybeClosure;
                J.Block closureBody = (J.Block)closure.getBody();
                List<Statement> newStatements = this.processStatements(closureBody.getStatements(), currentlyInBuildscript, ctx);
                if (newStatements.equals(closureBody.getStatements())) {
                    return m;
                }
                if (newStatements.isEmpty() || this.allStatementsAreEmptyReturns(newStatements)) {
                    return null;
                }
                return m.withArguments(Collections.singletonList(closure.withBody((J)closureBody.withStatements(newStatements))));
            }

            private List<Statement> processStatements(List<Statement> statements, boolean inBuildscript, ExecutionContext ctx) {
                return ListUtils.flatMap(statements, statement -> {
                    if (statement instanceof J.If) {
                        return this.processIfStatement((J.If)statement, inBuildscript, ctx);
                    }
                    return statement;
                });
            }

            private J.If processIfStatement(J.If ifStatement, boolean inBuildscript, ExecutionContext ctx) {
                Statement elseBody;
                ResolutionRuleInfo ruleInfo = RemoveRedundantSecurityResolutionRules.extractRuleInfo(ifStatement);
                if (ruleInfo != null && this.shouldRemoveRule(ruleInfo, inBuildscript, ctx)) {
                    if (ifStatement.getElsePart() != null) {
                        Statement elseBody2 = ifStatement.getElsePart().getBody();
                        if (elseBody2 instanceof J.If) {
                            return this.processIfStatement((J.If)elseBody2, inBuildscript, ctx);
                        }
                        if (elseBody2 instanceof J.Block) {
                            return null;
                        }
                    }
                    return null;
                }
                if (ifStatement.getElsePart() != null && (elseBody = ifStatement.getElsePart().getBody()) instanceof J.If) {
                    J.If processedElseIf = this.processIfStatement((J.If)elseBody, inBuildscript, ctx);
                    if (processedElseIf == null) {
                        J.If originalElseIf = (J.If)elseBody;
                        if (originalElseIf.getElsePart() != null && !(originalElseIf.getElsePart().getBody() instanceof J.If)) {
                            return ifStatement.withElsePart(originalElseIf.getElsePart());
                        }
                        return ifStatement.withElsePart(null);
                    }
                    return ifStatement.withElsePart(ifStatement.getElsePart().withBody((Statement)processedElseIf));
                }
                return ifStatement;
            }

            private boolean shouldRemoveRule(ResolutionRuleInfo ruleInfo, boolean inBuildscript, ExecutionContext ctx) {
                String resolvedVersion;
                if (!this.isSecurityRelated(ruleInfo.because)) {
                    return false;
                }
                if (this.gradleProject == null) {
                    return false;
                }
                GroupArtifactVersion gav = ruleInfo.gav;
                if (inBuildscript && this.gradleProject.getBuildscript() != null) {
                    resolvedVersion = this.findResolvedVersionWithoutConstraint(this.gradleProject.getBuildscript(), gav, ctx);
                } else {
                    GradleProject simulatedProject = this.removeResolutionStrategyConstraint(this.gradleProject, gav, ctx);
                    resolvedVersion = this.findResolvedVersion(simulatedProject, gav.getGroupId(), gav.getArtifactId());
                }
                if (resolvedVersion == null) {
                    return false;
                }
                int comparison = new LatestIntegration(null).compare(null, resolvedVersion, gav.getVersion());
                return comparison >= 0;
            }

            private GradleProject removeResolutionStrategyConstraint(GradleProject project, GroupArtifactVersion gav, ExecutionContext ctx) {
                GroupArtifact ga = new GroupArtifact(gav.getGroupId(), gav.getArtifactId());
                return project.removeConstraints(Collections.singleton(ga), ctx);
            }

            private boolean isSecurityRelated(@Nullable String because) {
                if (because == null || because.isEmpty()) {
                    return false;
                }
                return compiledPattern.matcher(because).find();
            }

            private @Nullable String findResolvedVersion(GradleProject project, String groupId, String artifactId) {
                for (GradleDependencyConfiguration config : project.getConfigurations()) {
                    ResolvedDependency resolved;
                    if (!config.isCanBeResolved() || (resolved = config.findResolvedDependency(groupId, artifactId)) == null) continue;
                    return resolved.getVersion();
                }
                return null;
            }

            private @Nullable String findResolvedVersionWithoutConstraint(GradleBuildscript buildscript, GroupArtifactVersion gav, ExecutionContext ctx) {
                GroupArtifact ga = new GroupArtifact(gav.getGroupId(), gav.getArtifactId());
                for (GradleDependencyConfiguration config : buildscript.getConfigurations()) {
                    GradleDependencyConfiguration simulated;
                    ResolvedDependency resolved;
                    if (!config.isCanBeResolved() || (resolved = (simulated = config.removeConstraints(Collections.singleton(ga), buildscript.getMavenRepositories(), ctx)).findResolvedDependency(gav.getGroupId(), gav.getArtifactId())) == null) continue;
                    return resolved.getVersion();
                }
                return null;
            }

            private boolean allStatementsAreEmptyReturns(List<Statement> statements) {
                for (Statement s : statements) {
                    if (s instanceof J.Return && ((J.Return)s).getExpression() == null) continue;
                    return false;
                }
                return true;
            }
        };
        return Preconditions.check(new IsBuildGradle(), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>((JavaIsoVisitor)removeRulesVisitor){
            final /* synthetic */ JavaIsoVisitor val$removeRulesVisitor;
            {
                this.val$removeRulesVisitor = javaIsoVisitor;
            }

            public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof JavaSourceFile)) {
                    return (J)tree;
                }
                J result = (J)this.val$removeRulesVisitor.visit(tree, (Object)ctx);
                return (J)new MaybeRemoveEmptyConfigurationsAll().visit((Tree)result, ctx);
            }
        });
    }

    private static @Nullable ResolutionRuleInfo extractRuleInfo(J.If ifStatement) {
        Expression predicate = (Expression)ifStatement.getIfCondition().getTree();
        if (!(predicate instanceof J.Binary)) {
            return null;
        }
        J.Binary and = (J.Binary)predicate;
        if (and.getOperator() != J.Binary.Type.And) {
            return null;
        }
        final AtomicReference groupId = new AtomicReference();
        final AtomicReference artifactId = new AtomicReference();
        new JavaIsoVisitor<Integer>(){

            public J.Binary visitBinary(J.Binary binary, Integer integer) {
                J.Binary b = super.visitBinary(binary, (Object)integer);
                if (b.getOperator() != J.Binary.Type.Equal) {
                    return b;
                }
                J.FieldAccess access = null;
                J.Literal literal = null;
                if (b.getLeft() instanceof J.FieldAccess && b.getRight() instanceof J.Literal) {
                    access = (J.FieldAccess)b.getLeft();
                    literal = (J.Literal)b.getRight();
                } else if (b.getRight() instanceof J.FieldAccess && b.getLeft() instanceof J.Literal) {
                    access = (J.FieldAccess)b.getRight();
                    literal = (J.Literal)b.getLeft();
                }
                if (access == null || literal == null || literal.getValue() == null) {
                    return b;
                }
                String fieldName = access.getSimpleName();
                String value = literal.getValue().toString();
                if ("group".equals(fieldName)) {
                    groupId.set(value);
                } else if ("name".equals(fieldName)) {
                    artifactId.set(value);
                }
                return b;
            }
        }.visit((Tree)and, (Object)0);
        if (groupId.get() == null || artifactId.get() == null) {
            return null;
        }
        Statement thenPart = ifStatement.getThenPart();
        if (!(thenPart instanceof J.Block)) {
            return null;
        }
        final AtomicReference version = new AtomicReference();
        final AtomicReference because = new AtomicReference();
        new JavaIsoVisitor<Integer>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, Integer integer) {
                Expression arg;
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)integer);
                if (RemoveRedundantSecurityResolutionRules.METHOD_USE_VERSION.equals(m.getSimpleName()) && !m.getArguments().isEmpty()) {
                    Expression arg2 = (Expression)m.getArguments().get(0);
                    if (arg2 instanceof J.Literal && ((J.Literal)arg2).getValue() != null) {
                        version.set(((J.Literal)arg2).getValue().toString());
                    }
                } else if (RemoveRedundantSecurityResolutionRules.METHOD_BECAUSE.equals(m.getSimpleName()) && !m.getArguments().isEmpty() && (arg = (Expression)m.getArguments().get(0)) instanceof J.Literal && ((J.Literal)arg).getValue() != null) {
                    because.set(((J.Literal)arg).getValue().toString());
                }
                return m;
            }
        }.visit((Tree)thenPart, (Object)0);
        if (version.get() == null) {
            return null;
        }
        return new ResolutionRuleInfo(new GroupArtifactVersion((String)groupId.get(), (String)artifactId.get(), (String)version.get()), (String)because.get());
    }

    private static boolean isEachDependency(J.MethodInvocation m, Cursor cursor) {
        if (!METHOD_EACH_DEPENDENCY.equals(m.getSimpleName())) {
            return false;
        }
        if (m.getSelect() instanceof J.Identifier && METHOD_RESOLUTION_STRATEGY.equals(((J.Identifier)m.getSelect()).getSimpleName())) {
            return true;
        }
        if (m.getSelect() == null) {
            return RemoveRedundantSecurityResolutionRules.isInsideResolutionStrategyBlock(cursor);
        }
        return false;
    }

    private static boolean isInsideResolutionStrategyBlock(Cursor cursor) {
        Cursor parent = cursor.dropParentUntil(value -> value == "root" || value instanceof J.MethodInvocation && METHOD_RESOLUTION_STRATEGY.equals(((J.MethodInvocation)value).getSimpleName()));
        return parent.getValue() != "root";
    }

    @Generated
    public RemoveRedundantSecurityResolutionRules(@Nullable String securityPattern) {
        this.securityPattern = securityPattern;
    }

    @Generated
    public @Nullable String getSecurityPattern() {
        return this.securityPattern;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveRedundantSecurityResolutionRules(securityPattern=" + this.getSecurityPattern() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveRedundantSecurityResolutionRules)) {
            return false;
        }
        RemoveRedundantSecurityResolutionRules other = (RemoveRedundantSecurityResolutionRules)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$securityPattern = this.getSecurityPattern();
        String other$securityPattern = other.getSecurityPattern();
        return !(this$securityPattern == null ? other$securityPattern != null : !this$securityPattern.equals(other$securityPattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof RemoveRedundantSecurityResolutionRules;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $securityPattern = this.getSecurityPattern();
        result = result * 59 + ($securityPattern == null ? 43 : $securityPattern.hashCode());
        return result;
    }

    static final class ResolutionRuleInfo {
        private final GroupArtifactVersion gav;
        private final @Nullable String because;

        @Generated
        public ResolutionRuleInfo(GroupArtifactVersion gav, @Nullable String because) {
            this.gav = gav;
            this.because = because;
        }

        @Generated
        public GroupArtifactVersion getGav() {
            return this.gav;
        }

        @Generated
        public @Nullable String getBecause() {
            return this.because;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResolutionRuleInfo)) {
                return false;
            }
            ResolutionRuleInfo other = (ResolutionRuleInfo)o;
            GroupArtifactVersion this$gav = this.getGav();
            GroupArtifactVersion other$gav = other.getGav();
            if (this$gav == null ? other$gav != null : !this$gav.equals(other$gav)) {
                return false;
            }
            String this$because = this.getBecause();
            String other$because = other.getBecause();
            return !(this$because == null ? other$because != null : !this$because.equals(other$because));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GroupArtifactVersion $gav = this.getGav();
            result = result * 59 + ($gav == null ? 43 : $gav.hashCode());
            String $because = this.getBecause();
            result = result * 59 + ($because == null ? 43 : $because.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RemoveRedundantSecurityResolutionRules.ResolutionRuleInfo(gav=" + this.getGav() + ", because=" + this.getBecause() + ")";
        }
    }

    static class MaybeRemoveEmptyConfigurationsAll
    extends JavaIsoVisitor<ExecutionContext> {
        MaybeRemoveEmptyConfigurationsAll() {
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.Block newBlock;
            int newSize;
            J.Lambda newLambda;
            J.MethodInvocation m;
            J.Lambda lambda;
            int originalSize = -1;
            if (RemoveRedundantSecurityResolutionRules.METHOD_CONFIGURATIONS.equals(method.getSimpleName()) && method.getArguments().size() == 1 && method.getArguments().get(0) instanceof J.Lambda && (lambda = (J.Lambda)method.getArguments().get(0)).getBody() instanceof J.Block) {
                originalSize = ((J.Block)lambda.getBody()).getStatements().size();
            }
            if (MaybeRemoveEmptyConfigurationsAll.isEmptyConfigurationsAll(m = super.visitMethodInvocation(method, (Object)ctx), this.getCursor()) || MaybeRemoveEmptyConfigurationsAll.isEmptyConfigurationsBlock(m) || MaybeRemoveEmptyConfigurationsAll.isEmptyResolutionStrategyBlock(m) || MaybeRemoveEmptyConfigurationsAll.isEmptyNestedConfigurationBlock(m, this.getCursor()) || MaybeRemoveEmptyConfigurationsAll.isEmptyConfigurationsMethodBlock(m) || MaybeRemoveEmptyConfigurationsAll.isEmptyNamedConfigurationBlock(m, this.getCursor())) {
                return null;
            }
            if (originalSize > 0 && m.getArguments().size() == 1 && m.getArguments().get(0) instanceof J.Lambda && (newLambda = (J.Lambda)m.getArguments().get(0)).getBody() instanceof J.Block && (newSize = (newBlock = (J.Block)newLambda.getBody()).getStatements().size()) < originalSize && newSize > 0) {
                newBlock = MaybeRemoveEmptyConfigurationsAll.cleanupBlockWhitespace(newBlock);
                newLambda = newLambda.withBody((J)newBlock);
                m = m.withArguments(Collections.singletonList(newLambda));
            }
            return m;
        }

        private static J.Block cleanupBlockWhitespace(J.Block block) {
            int lastIdx;
            JRightPadded lastStmt;
            Space afterSpace;
            String afterWs;
            int afterNewlineCount;
            List stmts;
            Space endSpace = block.getEnd();
            String endWs = endSpace.getWhitespace();
            int endNewlineCount = endWs.length() - endWs.replace("\n", "").length();
            if (endNewlineCount > 1) {
                int lastNewline = endWs.lastIndexOf(10);
                block = block.withEnd(endSpace.withWhitespace(endWs.substring(lastNewline)));
            }
            if (!(stmts = block.getPadding().getStatements()).isEmpty() && (afterNewlineCount = (afterWs = (afterSpace = (lastStmt = (JRightPadded)stmts.get(lastIdx = stmts.size() - 1)).getAfter()).getWhitespace()).length() - afterWs.replace("\n", "").length()) > 1) {
                int firstNewline = afterWs.indexOf(10);
                ArrayList<JRightPadded> newStmts = new ArrayList<JRightPadded>(stmts);
                newStmts.set(lastIdx, lastStmt.withAfter(afterSpace.withWhitespace(afterWs.substring(0, firstNewline + 1))));
                block = block.getPadding().withStatements(newStmts);
            }
            return block;
        }

        private static boolean isEmptyResolutionStrategyBlock(J.MethodInvocation m) {
            if (!RemoveRedundantSecurityResolutionRules.METHOD_RESOLUTION_STRATEGY.equals(m.getSimpleName())) {
                return false;
            }
            J.Block block = MaybeRemoveEmptyConfigurationsAll.getBlockFromLambdaArg(m, 0);
            return block != null && MaybeRemoveEmptyConfigurationsAll.isBlockEmptyOrOnlyEmptyReturns(block);
        }

        private static boolean isEmptyNestedConfigurationBlock(J.MethodInvocation m, Cursor cursor) {
            if (!MaybeRemoveEmptyConfigurationsAll.isInsideConfigurationsBlock(cursor)) {
                return false;
            }
            if (RemoveRedundantSecurityResolutionRules.METHOD_ALL.equals(m.getSimpleName())) {
                return false;
            }
            J.Block block = MaybeRemoveEmptyConfigurationsAll.getBlockFromLambdaArg(m, 0);
            return block != null && MaybeRemoveEmptyConfigurationsAll.isBlockEmptyOrOnlyEmptyReturns(block);
        }

        private static boolean isEmptyConfigurationsBlock(J.MethodInvocation m) {
            if (!(m.getSelect() instanceof J.Identifier) || !RemoveRedundantSecurityResolutionRules.METHOD_CONFIGURATIONS.equals(((J.Identifier)m.getSelect()).getSimpleName())) {
                return false;
            }
            if (RemoveRedundantSecurityResolutionRules.METHOD_ALL.equals(m.getSimpleName())) {
                return false;
            }
            J.Block block = MaybeRemoveEmptyConfigurationsAll.getBlockFromLambdaArg(m, 0);
            return block != null && MaybeRemoveEmptyConfigurationsAll.isBlockEmptyOrOnlyEmptyReturns(block);
        }

        private static boolean isEmptyConfigurationsAll(J.MethodInvocation m, Cursor cursor) {
            if (!RemoveRedundantSecurityResolutionRules.METHOD_ALL.equals(m.getSimpleName())) {
                return false;
            }
            boolean isConfigurationsAll = false;
            if (m.getSelect() instanceof J.Identifier && RemoveRedundantSecurityResolutionRules.METHOD_CONFIGURATIONS.equals(((J.Identifier)m.getSelect()).getSimpleName())) {
                isConfigurationsAll = true;
            } else if (m.getSelect() == null) {
                isConfigurationsAll = MaybeRemoveEmptyConfigurationsAll.isInsideConfigurationsBlock(cursor);
            }
            if (!isConfigurationsAll) {
                return false;
            }
            J.Block block = MaybeRemoveEmptyConfigurationsAll.getBlockFromLambdaArg(m, 0);
            return block != null && MaybeRemoveEmptyConfigurationsAll.isBlockEmptyOrOnlyEmptyReturns(block);
        }

        private static boolean isInsideConfigurationsBlock(Cursor cursor) {
            Cursor parent = cursor.dropParentUntil(value -> value == "root" || value instanceof J.MethodInvocation && RemoveRedundantSecurityResolutionRules.METHOD_CONFIGURATIONS.equals(((J.MethodInvocation)value).getSimpleName()));
            return parent.getValue() != "root";
        }

        private static boolean isEmptyNamedConfigurationBlock(J.MethodInvocation m, Cursor cursor) {
            if (!RemoveRedundantSecurityResolutionRules.METHOD_NAMED.equals(m.getSimpleName())) {
                return false;
            }
            boolean isConfigurationsNamed = false;
            if (m.getSelect() instanceof J.Identifier && RemoveRedundantSecurityResolutionRules.METHOD_CONFIGURATIONS.equals(((J.Identifier)m.getSelect()).getSimpleName())) {
                isConfigurationsNamed = true;
            } else if (m.getSelect() == null) {
                isConfigurationsNamed = MaybeRemoveEmptyConfigurationsAll.isInsideConfigurationsBlock(cursor);
            }
            if (!isConfigurationsNamed) {
                return false;
            }
            J.Block block = MaybeRemoveEmptyConfigurationsAll.getBlockFromLambdaArg(m, 1);
            return block != null && MaybeRemoveEmptyConfigurationsAll.isBlockEmptyOrOnlyEmptyReturns(block);
        }

        private static boolean isEmptyConfigurationsMethodBlock(J.MethodInvocation m) {
            if (!RemoveRedundantSecurityResolutionRules.METHOD_CONFIGURATIONS.equals(m.getSimpleName())) {
                return false;
            }
            if (m.getSelect() != null) {
                return false;
            }
            J.Block block = MaybeRemoveEmptyConfigurationsAll.getBlockFromLambdaArg(m, 0);
            return block != null && MaybeRemoveEmptyConfigurationsAll.isBlockEmptyOrOnlyEmptyReturns(block);
        }

        private static // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Block getBlockFromLambdaArg(J.MethodInvocation m, int argIndex) {
            if (m.getArguments().size() <= argIndex) {
                return null;
            }
            Expression arg = (Expression)m.getArguments().get(argIndex);
            if (!(arg instanceof J.Lambda)) {
                return null;
            }
            J.Lambda lambda = (J.Lambda)arg;
            if (!(lambda.getBody() instanceof J.Block)) {
                return null;
            }
            return (J.Block)lambda.getBody();
        }

        private static boolean isBlockEmptyOrOnlyEmptyReturns(J.Block block) {
            if (block.getStatements().isEmpty()) {
                return true;
            }
            if (block.getStatements().size() == 1) {
                Statement stmt = (Statement)block.getStatements().get(0);
                return stmt instanceof J.Return && ((J.Return)stmt).getExpression() == null;
            }
            return false;
        }
    }
}

