/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.function.Predicate;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.gradle.DependencyVersionSelector;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;

public class AddDependencyVisitor
extends JavaIsoVisitor<ExecutionContext> {
    private final String groupId;
    private final String artifactId;
    private final @Nullable String version;
    private final @Nullable String versionPattern;
    private final String configuration;
    private final @Nullable String classifier;
    private final @Nullable String extension;
    private final @Nullable MavenMetadataFailures metadataFailures;
    private @Nullable String resolvedVersion;
    private final @Nullable Predicate<Cursor> insertPredicate;
    private final @Nullable DependencyModifier dependencyModifier;
    private transient @Nullable GradleProject gradleProject;
    private transient boolean isKotlinDsl;

    public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
        if (tree instanceof JavaSourceFile) {
            JavaSourceFile sourceFile = (JavaSourceFile)tree;
            this.gradleProject = sourceFile.getMarkers().findFirst(GradleProject.class).orElse(null);
            if (this.gradleProject == null) {
                return sourceFile;
            }
            GradleDependencyConfiguration gdc = this.gradleProject.getConfiguration(this.configuration);
            if (gdc == null || gdc.findRequestedDependency(this.groupId, this.artifactId) != null) {
                return sourceFile;
            }
            this.isKotlinDsl = sourceFile instanceof K.CompilationUnit;
            if (this.version != null) {
                if (this.version.startsWith("$")) {
                    this.resolvedVersion = this.version;
                } else {
                    try {
                        this.resolvedVersion = new DependencyVersionSelector(this.metadataFailures, this.gradleProject, null).select(new GroupArtifact(this.groupId, this.artifactId), this.configuration, this.version, this.versionPattern, ctx);
                    }
                    catch (MavenDownloadingException e) {
                        return (J)e.warn(tree);
                    }
                }
            }
            if ((sourceFile = (JavaSourceFile)new org.openrewrite.gradle.internal.AddDependencyVisitor(this.configuration, this.groupId, this.artifactId, this.resolvedVersion, this.classifier, this.extension, this.insertPredicate, this.dependencyModifier, this.isKotlinDsl).visitNonNull((Tree)sourceFile, ctx)) != tree) {
                String versionWithPattern = StringUtils.isBlank((String)this.resolvedVersion) || this.resolvedVersion.startsWith("$") ? null : this.resolvedVersion;
                sourceFile = org.openrewrite.gradle.internal.AddDependencyVisitor.addDependency(sourceFile, this.gradleProject.getConfiguration(this.configuration), new GroupArtifactVersion(this.groupId, this.artifactId, versionWithPattern), this.classifier, ctx);
            }
            return sourceFile;
        }
        return (J)tree;
    }

    @Generated
    public AddDependencyVisitor(String groupId, String artifactId, @Nullable String version, @Nullable String versionPattern, String configuration, @Nullable String classifier, @Nullable String extension, @Nullable MavenMetadataFailures metadataFailures, @Nullable Predicate<Cursor> insertPredicate, @Nullable DependencyModifier dependencyModifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.versionPattern = versionPattern;
        this.configuration = configuration;
        this.classifier = classifier;
        this.extension = extension;
        this.metadataFailures = metadataFailures;
        this.insertPredicate = insertPredicate;
        this.dependencyModifier = dependencyModifier;
    }

    public static enum DependencyModifier {
        PLATFORM,
        ENFORCED_PLATFORM;

    }
}

