/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.internal.ChangeStringLiteral;
import org.openrewrite.gradle.internal.Dependency;
import org.openrewrite.gradle.internal.DependencyStringNotationConverter;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleDependencyConstraint;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.trait.GradleDependencies;
import org.openrewrite.gradle.trait.GradleDependency;
import org.openrewrite.gradle.trait.SpringDependencyManagementPluginEntry;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Markup;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenDownloadingExceptions;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.semver.ExactVersion;
import org.openrewrite.semver.LatestIntegration;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.trait.Trait;

public final class RemoveRedundantDependencyVersions
extends Recipe {
    @Option(displayName="Group", description="Group glob expression pattern used to match dependencies that should be managed.Group is the first part of a dependency coordinate `com.google.guava:guava:VERSION`.", example="com.google.*", required=false)
    private final @Nullable String groupPattern;
    @Option(displayName="Artifact", description="Artifact glob expression pattern used to match dependencies that should be managed.Artifact is the second part of a dependency coordinate `com.google.guava:guava:VERSION`.", example="guava*", required=false)
    private final @Nullable String artifactPattern;
    @Option(displayName="Only if managed version is ...", description="Only remove the explicit version if the managed version has the specified comparative relationship to the explicit version. For example, `gte` will only remove the explicit version if the managed version is the same or newer. Default `eq`.", valid={"ANY", "EQ", "LT", "LTE", "GT", "GTE"}, required=false)
    private final @Nullable Comparator onlyIfManagedVersionIs;
    private static final List<String> DEPENDENCY_MANAGEMENT_METHODS = Arrays.asList("api", "implementation", "compileOnly", "runtimeOnly", "testImplementation", "testCompileOnly", "testRuntimeOnly", "debugImplementation", "releaseImplementation", "androidTestImplementation", "featureImplementation", "annotationProcessor", "kapt", "ksp", "compile", "runtime", "testCompile", "testRuntime");
    private static final VersionComparator VERSION_COMPARATOR = Objects.requireNonNull((VersionComparator)Semver.validate((String)"latest.release", null).getValue());

    public String getDisplayName() {
        return "Remove redundant explicit dependencies and versions";
    }

    public String getDescription() {
        return "Remove explicitly-specified dependency versions that are managed by a Gradle `platform`, `enforcedPlatform` or the `io.spring.dependency-management` plugin. Also removes redundant direct dependencies and dependency constraints that are already satisfied by transitive dependencies.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsBuildGradle(), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            GradleProject gp;
            final Map<String, List<ResolvedPom>> platforms = new HashMap<String, List<ResolvedPom>>();
            final Map<String, List<ResolvedDependency>> directDependencies = new HashMap<String, List<ResolvedDependency>>();
            final Map<GroupArtifact, String> springPluginManagedDependencies = new HashMap<GroupArtifact, String>();

            public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    Optional maybeGp = tree.getMarkers().findFirst(GradleProject.class);
                    if (!maybeGp.isPresent()) {
                        return (J)tree;
                    }
                    this.gp = (GradleProject)maybeGp.get();
                    if (this.gp.getPlugins().stream().anyMatch(plugin -> "io.spring.dependency-management".equals(plugin.getId()))) {
                        String springBootVersion = Optional.ofNullable(this.getSpringBootVersionFromConfiguration("testRuntimeClasspath")).orElseGet(() -> this.gp.getNameToConfiguration().keySet().stream().map(this::getSpringBootVersionFromConfiguration).filter(Objects::nonNull).findFirst().orElse(null));
                        if (springBootVersion != null) {
                            MavenPomDownloader mpd = new MavenPomDownloader(ctx);
                            try {
                                ResolvedPom platformPom = mpd.download(new GroupArtifactVersion("org.springframework.boot", "spring-boot-dependencies", springBootVersion), null, null, this.gp.getMavenRepositories()).resolve(Collections.emptyList(), mpd, ctx);
                                platformPom.getDependencyManagement().stream().filter(managedVersion -> managedVersion.getVersion() != null).forEach(managedVersion -> this.springPluginManagedDependencies.put(managedVersion.getGav().asGroupArtifact(), managedVersion.getVersion()));
                            }
                            catch (MavenDownloadingException mavenDownloadingException) {
                                // empty catch block
                            }
                        }
                        new JavaIsoVisitor<ExecutionContext>(){

                            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                                new SpringDependencyManagementPluginEntry.Matcher().get(this.getCursor()).ifPresent(entry -> entry.getArtifacts().forEach(artifact -> {
                                    if ("mavenBom".equals(method.getSimpleName())) {
                                        MavenPomDownloader mpd = new MavenPomDownloader(ctx);
                                        try {
                                            ResolvedPom platformPom = mpd.download(new GroupArtifactVersion(entry.getGroup(), artifact, entry.getVersion()), null, null, gp.getMavenRepositories()).resolve(Collections.emptyList(), mpd, ctx);
                                            platformPom.getDependencyManagement().stream().filter(managedVersion -> managedVersion.getVersion() != null).forEach(managedVersion -> springPluginManagedDependencies.put(managedVersion.getGav().asGroupArtifact(), managedVersion.getVersion()));
                                        }
                                        catch (MavenDownloadingException mavenDownloadingException) {}
                                    } else {
                                        springPluginManagedDependencies.put(new GroupArtifact(entry.getGroup(), artifact), entry.getVersion());
                                    }
                                }));
                                return m;
                            }
                        }.visit(tree, (Object)ctx);
                    }
                    new JavaIsoVisitor<ExecutionContext>(){

                        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                            new GradleDependency.Matcher().groupId(RemoveRedundantDependencyVersions.this.groupPattern).artifactId(RemoveRedundantDependencyVersions.this.artifactPattern).get(this.getCursor()).ifPresent(it -> directDependencies.computeIfAbsent(m.getSimpleName(), k -> new ArrayList()).add(it.getResolvedDependency()));
                            if (!"platform".equals(m.getSimpleName()) && !"enforcedPlatform".equals(m.getSimpleName())) {
                                return m;
                            }
                            GroupArtifactVersion gav = null;
                            if (m.getArguments().get(0) instanceof J.Literal) {
                                J.Literal l = (J.Literal)m.getArguments().get(0);
                                if (l.getType() == JavaType.Primitive.String) {
                                    Dependency dependency = DependencyStringNotationConverter.parse((String)l.getValue());
                                    gav = new GroupArtifactVersion(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
                                }
                            } else if (m.getArguments().get(0) instanceof G.MapEntry) {
                                String groupId = null;
                                String artifactId = null;
                                String version = null;
                                for (Expression arg : m.getArguments()) {
                                    if (!(arg instanceof G.MapEntry) || ((G.MapEntry)arg).getKey().getType() != JavaType.Primitive.String || ((G.MapEntry)arg).getValue().getType() != JavaType.Primitive.String) continue;
                                    Object key = ((J.Literal)((G.MapEntry)arg).getKey()).getValue();
                                    if ("group".equals(key)) {
                                        groupId = (String)((J.Literal)((G.MapEntry)arg).getValue()).getValue();
                                        continue;
                                    }
                                    if ("name".equals(key)) {
                                        artifactId = (String)((J.Literal)((G.MapEntry)arg).getValue()).getValue();
                                        continue;
                                    }
                                    if (!"version".equals(key)) continue;
                                    version = (String)((J.Literal)((G.MapEntry)arg).getValue()).getValue();
                                }
                                if (groupId != null && artifactId != null && version != null) {
                                    gav = new GroupArtifactVersion(groupId, artifactId, version);
                                }
                            }
                            if (gav != null) {
                                MavenPomDownloader mpd = new MavenPomDownloader(ctx);
                                try {
                                    ResolvedPom platformPom = mpd.download(gav, null, null, gp.getMavenRepositories()).resolve(Collections.emptyList(), mpd, ctx);
                                    platforms.computeIfAbsent(((J.MethodInvocation)this.getCursor().getParentOrThrow(1).firstEnclosingOrThrow(J.MethodInvocation.class)).getSimpleName(), k -> new ArrayList()).add(platformPom);
                                }
                                catch (MavenDownloadingException mavenDownloadingException) {
                                    // empty catch block
                                }
                            }
                            return m;
                        }
                    }.visit(tree, (Object)ctx);
                    final HashSet statementsToRemove = new HashSet();
                    tree = new JavaIsoVisitor<ExecutionContext>(){

                        public // Could not load outer class - annotation placement on inner may be incorrect
                        @Nullable J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                            if ("dependencies".equals(m.getSimpleName())) {
                                final HashMap requestedToDeclaration = new HashMap();
                                final HashMap gaToRequested = new HashMap();
                                new JavaIsoVisitor<ExecutionContext>(){

                                    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                                        J.MethodInvocation m1 = super.visitMethodInvocation(method, (Object)executionContext);
                                        new GradleDependency.Matcher().get(this.getCursor()).ifPresent(it -> {
                                            if (it.getResolvedDependency().getRequested().getVersion() != null) {
                                                requestedToDeclaration.put(it.getResolvedDependency().getRequested().getGav(), m1);
                                                gaToRequested.computeIfAbsent(it.getResolvedDependency().getGav().asGroupArtifact(), groupArtifact -> new ArrayList()).add(it.getResolvedDependency().getRequested().getVersion());
                                            }
                                        });
                                        return m1;
                                    }
                                }.visit((Tree)m.getArguments().get(0), (Object)ctx, this.getCursor());
                                for (Map.Entry gaToRequestedVersions : gaToRequested.entrySet()) {
                                    GroupArtifact ga = (GroupArtifact)gaToRequestedVersions.getKey();
                                    List requested = (List)gaToRequestedVersions.getValue();
                                    if (requested.size() < 2) continue;
                                    requested.stream().sorted(VERSION_COMPARATOR.reversed()).skip(1L).forEach(redundant -> statementsToRemove.add((Statement)requestedToDeclaration.get(new GroupArtifactVersion(ga.getGroupId(), ga.getArtifactId(), redundant))));
                                }
                            } else {
                                if ("constraints".equals(m.getSimpleName())) {
                                    if (m.getArguments().isEmpty() || !(m.getArguments().get(0) instanceof J.Lambda) || !(((J.Lambda)m.getArguments().get(0)).getBody() instanceof J.Block)) {
                                        return m;
                                    }
                                    if (((J.Block)((J.Lambda)m.getArguments().get(0)).getBody()).getStatements().isEmpty()) {
                                        statementsToRemove.add(m);
                                        return m;
                                    }
                                    return m;
                                }
                                if (!this.isDependencyManagementMethod(m.getSimpleName()) || m.getArguments().isEmpty() || ((Expression)m.getArguments().get(0)).getType() != JavaType.Primitive.String) {
                                    return m;
                                }
                                String value = (String)((J.Literal)m.getArguments().get(0)).getValue();
                                Dependency dependency = DependencyStringNotationConverter.parse(value);
                                try {
                                    this.getCursor().dropParentUntil(obj -> obj instanceof J.MethodInvocation && "constraints".equals(((J.MethodInvocation)obj).getSimpleName())).getValue();
                                    if (this.shouldRemoveRedundantConstraint(dependency, gp.getConfiguration(m.getSimpleName()))) {
                                        return null;
                                    }
                                    return m;
                                }
                                catch (Exception exception) {
                                    try {
                                        if (this.shouldRemoveRedundantDependency(dependency, m.getSimpleName(), gp.getMavenRepositories(), ctx)) {
                                            statementsToRemove.add(m);
                                            return m;
                                        }
                                    }
                                    catch (MavenDownloadingException e) {
                                        return (J.MethodInvocation)Markup.error((Tree)m, (Throwable)e);
                                    }
                                }
                            }
                            return m;
                        }

                        public // Could not load outer class - annotation placement on inner may be incorrect
                        @Nullable J.Return visitReturn(J.Return _return, ExecutionContext ctx) {
                            J.Return r = super.visitReturn(_return, (Object)ctx);
                            if (r.getExpression() == null) {
                                return null;
                            }
                            return r;
                        }

                        private boolean isDependencyManagementMethod(String methodName) {
                            return DEPENDENCY_MANAGEMENT_METHODS.contains(methodName);
                        }

                        private boolean shouldRemoveRedundantDependency(@Nullable Dependency dependency, String configurationName, List<MavenRepository> repositories, ExecutionContext ctx) throws MavenDownloadingException {
                            if (dependency == null || RemoveRedundantDependencyVersions.this.groupPattern != null && !StringUtils.matchesGlob((String)dependency.getGroupId(), (String)RemoveRedundantDependencyVersions.this.groupPattern) || RemoveRedundantDependencyVersions.this.artifactPattern != null && !StringUtils.matchesGlob((String)dependency.getArtifactId(), (String)RemoveRedundantDependencyVersions.this.artifactPattern)) {
                                return false;
                            }
                            for (Map.Entry<String, List<ResolvedDependency>> entry : directDependencies.entrySet()) {
                                for (ResolvedDependency d : entry.getValue()) {
                                    if (d.getGroupId().equals(dependency.getGroupId()) && d.getArtifactId().equals(dependency.getArtifactId()) || d.getDependencies() == null || !this.matchesConfiguration(configurationName, entry.getKey()) || d.findDependency(dependency.getGroupId(), dependency.getArtifactId()) == null || !this.dependsOnNewerVersion(dependency.getGav(), d.getGav().asGroupArtifactVersion(), repositories, ctx)) continue;
                                    return true;
                                }
                            }
                            return false;
                        }

                        private boolean dependsOnNewerVersion(GroupArtifactVersion searchGav, GroupArtifactVersion toSearch, List<MavenRepository> repositories, ExecutionContext ctx) throws MavenDownloadingException {
                            if (toSearch.getVersion() == null) {
                                return false;
                            }
                            if (searchGav.asGroupArtifact().equals((Object)toSearch.asGroupArtifact())) {
                                return searchGav.getVersion() == null || RemoveRedundantDependencyVersions.this.matchesComparator(toSearch.getVersion(), searchGav.getVersion());
                            }
                            MavenPomDownloader mpd = new MavenPomDownloader(ctx);
                            try {
                                List resolved = mpd.download(toSearch, null, null, repositories).resolve(Collections.emptyList(), mpd, repositories, ctx).resolveDependencies(Scope.Runtime, mpd, ctx);
                                for (ResolvedDependency r : resolved) {
                                    if (!Objects.equals(searchGav.getGroupId(), r.getGroupId()) || !Objects.equals(searchGav.getArtifactId(), r.getArtifactId())) continue;
                                    return searchGav.getVersion() == null || RemoveRedundantDependencyVersions.this.matchesComparator(r.getVersion(), searchGav.getVersion());
                                }
                            }
                            catch (MavenDownloadingExceptions e) {
                                throw (MavenDownloadingException)((Object)e.getExceptions().get(0));
                            }
                            return false;
                        }

                        boolean matchesConfiguration(String configA, String configB) {
                            if ("runtimeOnly".equals(configA) && "implementation".equals(configB)) {
                                return true;
                            }
                            if ("testRuntimeOnly".equals(configA) && ("testImplementation".equals(configB) || "implementation".equals(configB))) {
                                return true;
                            }
                            return configA.equals(configB);
                        }

                        boolean shouldRemoveRedundantConstraint(@Nullable Dependency constraint, @Nullable GradleDependencyConfiguration c) {
                            if (c == null || constraint == null || constraint.getVersion() == null) {
                                return false;
                            }
                            if (constraint.getVersion().contains("[") || constraint.getVersion().contains("!!")) {
                                return false;
                            }
                            if (RemoveRedundantDependencyVersions.this.groupPattern != null && !StringUtils.matchesGlob((String)constraint.getGroupId(), (String)RemoveRedundantDependencyVersions.this.groupPattern) || RemoveRedundantDependencyVersions.this.artifactPattern != null && !StringUtils.matchesGlob((String)constraint.getArtifactId(), (String)RemoveRedundantDependencyVersions.this.artifactPattern)) {
                                return false;
                            }
                            return Stream.concat(Stream.of(c), gp.configurationsExtendingFrom(c, true).stream()).filter(GradleDependencyConfiguration::isCanBeResolved).distinct().map(conf -> conf.findResolvedDependency(Objects.requireNonNull(constraint.getGroupId()), constraint.getArtifactId())).filter(Objects::nonNull).anyMatch(resolvedDependency -> VERSION_COMPARATOR.compare(null, resolvedDependency.getVersion(), constraint.getVersion()) > 0);
                        }
                    }.visitNonNull(tree, (Object)ctx);
                    tree = new JavaVisitor<ExecutionContext>(){

                        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                            J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                            return (J)new GradleDependencies.Matcher().get(this.getCursor()).map(dependencies -> dependencies.filterStatements(s -> !statementsToRemove.contains(s))).map(Trait::getTree).orElse(m);
                        }
                    }.visitNonNull(tree, (Object)ctx);
                }
                return (J)super.visit(tree, (Object)ctx);
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                GradleDependencyConfiguration gdc;
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                Optional maybeGradleDependency = new GradleDependency.Matcher().groupId(RemoveRedundantDependencyVersions.this.groupPattern).artifactId(RemoveRedundantDependencyVersions.this.artifactPattern).get(this.getCursor());
                if (!maybeGradleDependency.isPresent()) {
                    return m;
                }
                GradleDependency gradleDependency = (GradleDependency)maybeGradleDependency.get();
                ResolvedDependency dep = gradleDependency.getResolvedDependency();
                if (StringUtils.isBlank((String)dep.getVersion())) {
                    return m;
                }
                if (this.springPluginManagedDependencies.containsKey(dep.getGav().asGroupArtifact()) && RemoveRedundantDependencyVersions.this.matchesComparator(this.springPluginManagedDependencies.get(dep.getGav().asGroupArtifact()), dep.getVersion())) {
                    return this.maybeRemoveVersion(m);
                }
                if (this.platforms.containsKey(m.getSimpleName())) {
                    for (ResolvedPom platform : this.platforms.get(m.getSimpleName())) {
                        String managedVersion = platform.getManagedVersion(dep.getGroupId(), dep.getArtifactId(), null, dep.getRequested().getClassifier());
                        if (!RemoveRedundantDependencyVersions.this.matchesComparator(managedVersion, dep.getVersion())) continue;
                        return this.maybeRemoveVersion(m);
                    }
                }
                if ((gdc = this.gp.getConfiguration(m.getSimpleName())) != null) {
                    for (GradleDependencyConfiguration configuration : gdc.allExtendsFrom()) {
                        if (!this.platforms.containsKey(configuration.getName())) continue;
                        for (ResolvedPom platform : this.platforms.get(configuration.getName())) {
                            String managedVersion = platform.getManagedVersion(dep.getGroupId(), dep.getArtifactId(), null, dep.getRequested().getClassifier());
                            if (!RemoveRedundantDependencyVersions.this.matchesComparator(managedVersion, dep.getVersion())) continue;
                            return this.maybeRemoveVersion(m);
                        }
                    }
                }
                return m;
            }

            private J.MethodInvocation maybeRemoveVersion(J.MethodInvocation m) {
                if (m.getArguments().get(0) instanceof J.Literal) {
                    J.Literal l = (J.Literal)m.getArguments().get(0);
                    if (l.getType() == JavaType.Primitive.String) {
                        Dependency dep = DependencyStringNotationConverter.parse((String)l.getValue());
                        if (dep == null || dep.getClassifier() != null || dep.getExt() != null) {
                            return m;
                        }
                        return m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> ChangeStringLiteral.withStringValue(l, dep.withVersion(null).toStringNotation())));
                    }
                } else {
                    if (m.getArguments().get(0) instanceof G.MapLiteral) {
                        return m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> {
                            G.MapLiteral mapLiteral = (G.MapLiteral)arg;
                            return mapLiteral.withElements(ListUtils.map((List)mapLiteral.getElements(), entry -> {
                                if (entry.getKey() instanceof J.Literal && "version".equals(((J.Literal)entry.getKey()).getValue())) {
                                    return null;
                                }
                                return entry;
                            }));
                        }));
                    }
                    if (m.getArguments().get(0) instanceof G.MapEntry) {
                        return m.withArguments(ListUtils.map((List)m.getArguments(), arg -> {
                            G.MapEntry entry = (G.MapEntry)arg;
                            if (entry.getKey() instanceof J.Literal && "version".equals(((J.Literal)entry.getKey()).getValue())) {
                                return null;
                            }
                            return entry;
                        }));
                    }
                }
                return m;
            }

            private @Nullable String getSpringBootVersionFromConfiguration(String configuration) {
                GradleDependencyConfiguration testRuntimeConfiguration = this.gp.getConfiguration(configuration);
                if (testRuntimeConfiguration != null) {
                    for (GradleDependencyConstraint constraint : testRuntimeConfiguration.getConstraints()) {
                        if (!"org.springframework.boot".equals(constraint.getGroupId()) || constraint.getStrictVersion() == null) continue;
                        return constraint.getStrictVersion();
                    }
                    for (ResolvedDependency dependency : testRuntimeConfiguration.getDirectResolved()) {
                        if (dependency.getRequested().getVersion() != null || !"org.springframework.boot".equals(dependency.getGroupId())) continue;
                        return dependency.getVersion();
                    }
                }
                return null;
            }
        });
    }

    private Comparator determineComparator() {
        if (this.onlyIfManagedVersionIs != null) {
            return this.onlyIfManagedVersionIs;
        }
        return Comparator.EQ;
    }

    private boolean matchesComparator(@Nullable String managedVersion, String requestedVersion) {
        Comparator comparator = this.determineComparator();
        if (managedVersion == null) {
            return false;
        }
        if (comparator == Comparator.ANY) {
            return true;
        }
        if (!this.isExact(managedVersion)) {
            return false;
        }
        int comparison = new LatestIntegration(null).compare(null, managedVersion, requestedVersion);
        if (comparison < 0) {
            return comparator == Comparator.LT || comparator == Comparator.LTE;
        }
        if (comparison > 0) {
            return comparator == Comparator.GT || comparator == Comparator.GTE;
        }
        return comparator == Comparator.EQ || comparator == Comparator.LTE || comparator == Comparator.GTE;
    }

    private boolean isExact(String managedVersion) {
        Validated maybeVersionComparator = Semver.validate((String)managedVersion, null);
        return maybeVersionComparator.isValid() && maybeVersionComparator.getValue() instanceof ExactVersion;
    }

    @Generated
    public RemoveRedundantDependencyVersions(@Nullable String groupPattern, @Nullable String artifactPattern, @Nullable Comparator onlyIfManagedVersionIs) {
        this.groupPattern = groupPattern;
        this.artifactPattern = artifactPattern;
        this.onlyIfManagedVersionIs = onlyIfManagedVersionIs;
    }

    @Generated
    public @Nullable String getGroupPattern() {
        return this.groupPattern;
    }

    @Generated
    public @Nullable String getArtifactPattern() {
        return this.artifactPattern;
    }

    @Generated
    public @Nullable Comparator getOnlyIfManagedVersionIs() {
        return this.onlyIfManagedVersionIs;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveRedundantDependencyVersions(groupPattern=" + this.getGroupPattern() + ", artifactPattern=" + this.getArtifactPattern() + ", onlyIfManagedVersionIs=" + (Object)((Object)this.getOnlyIfManagedVersionIs()) + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveRedundantDependencyVersions)) {
            return false;
        }
        RemoveRedundantDependencyVersions other = (RemoveRedundantDependencyVersions)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupPattern = this.getGroupPattern();
        String other$groupPattern = other.getGroupPattern();
        if (this$groupPattern == null ? other$groupPattern != null : !this$groupPattern.equals(other$groupPattern)) {
            return false;
        }
        String this$artifactPattern = this.getArtifactPattern();
        String other$artifactPattern = other.getArtifactPattern();
        if (this$artifactPattern == null ? other$artifactPattern != null : !this$artifactPattern.equals(other$artifactPattern)) {
            return false;
        }
        Comparator this$onlyIfManagedVersionIs = this.getOnlyIfManagedVersionIs();
        Comparator other$onlyIfManagedVersionIs = other.getOnlyIfManagedVersionIs();
        return !(this$onlyIfManagedVersionIs == null ? other$onlyIfManagedVersionIs != null : !((Object)((Object)this$onlyIfManagedVersionIs)).equals((Object)other$onlyIfManagedVersionIs));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof RemoveRedundantDependencyVersions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupPattern = this.getGroupPattern();
        result = result * 59 + ($groupPattern == null ? 43 : $groupPattern.hashCode());
        String $artifactPattern = this.getArtifactPattern();
        result = result * 59 + ($artifactPattern == null ? 43 : $artifactPattern.hashCode());
        Comparator $onlyIfManagedVersionIs = this.getOnlyIfManagedVersionIs();
        result = result * 59 + ($onlyIfManagedVersionIs == null ? 43 : ((Object)((Object)$onlyIfManagedVersionIs)).hashCode());
        return result;
    }

    public static enum Comparator {
        ANY,
        EQ,
        LT,
        LTE,
        GT,
        GTE;

    }
}

