/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.groovy.GroovyParser;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.kotlin.KotlinParser;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.Markers;

public final class DependencyConstraintToRule
extends Recipe {
    private static final MethodMatcher DEPENDENCIES_DSL_MATCHER = new MethodMatcher("RewriteGradleProject dependencies(..)");
    private static final String CONSTRAINT_MATCHER = "org.gradle.api.artifacts.dsl.DependencyHandler *(..)";

    public String getDisplayName() {
        return "Dependency constraint to resolution rule";
    }

    public String getDescription() {
        return "Gradle [dependency constraints](https://docs.gradle.org/current/userguide/dependency_constraints.html#dependency-constraints) are useful for managing the versions of transitive dependencies. Some plugins, such as the Spring Dependency Management plugin, do not respect these constraints. This recipe converts constraints into [resolution rules](https://docs.gradle.org/current/userguide/resolution_rules.html), which can achieve similar effects to constraints but are harder for plugins to ignore.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsBuildGradle(), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof JavaSourceFile)) {
                    return (J)tree;
                }
                ArrayList<GroupArtifactVersionBecause> gavs = new ArrayList<GroupArtifactVersionBecause>();
                JavaSourceFile cu = (JavaSourceFile)new RemoveConstraints().visitNonNull(tree, gavs);
                if (gavs.isEmpty()) {
                    return (J)tree;
                }
                cu = (JavaSourceFile)new MaybeAddEachDependency().visitNonNull((Tree)cu, ctx);
                cu = (JavaSourceFile)new UpdateEachDependency(gavs, cu instanceof K.CompilationUnit).visitNonNull((Tree)cu, ctx);
                return (J)new MaybeRemoveDependencyBlock().visitNonNull((Tree)cu, ctx);
            }
        });
    }

    private static boolean isEmptyDependenciesBlock(J.MethodInvocation m) {
        J.Block b;
        if (!"dependencies".equals(m.getSimpleName())) {
            return false;
        }
        if (m.getArguments().size() != 1 || !(m.getArguments().get(0) instanceof J.Lambda)) {
            return false;
        }
        if (m.getArguments().size() != 1 || !(m.getArguments().get(0) instanceof J.Lambda)) {
            return false;
        }
        J.Lambda l = (J.Lambda)m.getArguments().get(0);
        if (l.getBody() instanceof J.Block && (b = (J.Block)l.getBody()).getStatements().size() == 1) {
            return b.getStatements().get(0) instanceof J.Return && ((J.Return)b.getStatements().get(0)).getExpression() == null;
        }
        return false;
    }

    private static boolean isInDependenciesBlock(Cursor cursor) {
        Cursor c = cursor.dropParentUntil(value -> value == "root" || value instanceof J.MethodInvocation && "dependencies".equals(((J.MethodInvocation)value).getSimpleName()));
        if (!(c.getValue() instanceof J.MethodInvocation)) {
            return false;
        }
        return !DependencyConstraintToRule.isInBuildscriptBlock(c);
    }

    private static boolean isInBuildscriptBlock(Cursor c) {
        Cursor maybeBuildscript = c.dropParentUntil(value -> value == "root" || value instanceof J.MethodInvocation && "buildscript".equals(((J.MethodInvocation)value).getSimpleName()));
        return maybeBuildscript.getValue() != "root";
    }

    private static boolean isEachDependency(J.MethodInvocation m) {
        return "eachDependency".equals(m.getSimpleName()) && m.getSelect() instanceof J.Identifier && "resolutionStrategy".equals(((J.Identifier)m.getSelect()).getSimpleName());
    }

    private static boolean predicateRelatesToGav(J.If iff, GroupArtifactVersionBecause groupArtifactVersion) {
        Expression predicate = (Expression)iff.getIfCondition().getTree();
        if (!(predicate instanceof J.Binary)) {
            return false;
        }
        J.Binary and = (J.Binary)predicate;
        if (and.getOperator() != J.Binary.Type.And) {
            return false;
        }
        final AtomicBoolean groupIdCompared = new AtomicBoolean();
        final AtomicBoolean artifactIdCompared = new AtomicBoolean();
        new JavaIsoVisitor<GroupArtifactVersionBecause>(){

            public J.Binary visitBinary(J.Binary binary, GroupArtifactVersionBecause groupArtifactVersion) {
                J.Binary b = super.visitBinary(binary, (Object)groupArtifactVersion);
                if (b.getOperator() != J.Binary.Type.Equal) {
                    return b;
                }
                J.FieldAccess access = null;
                J.Literal literal = null;
                if (b.getLeft() instanceof J.FieldAccess && b.getRight() instanceof J.Literal) {
                    access = (J.FieldAccess)b.getLeft();
                    literal = (J.Literal)b.getRight();
                } else if (b.getRight() instanceof J.FieldAccess && b.getLeft() instanceof J.Literal) {
                    access = (J.FieldAccess)b.getRight();
                    literal = (J.Literal)b.getLeft();
                }
                if (access == null || literal == null) {
                    return b;
                }
                if ("group".equals(access.getSimpleName()) && Objects.equals(groupArtifactVersion.getGroupId(), literal.getValue())) {
                    groupIdCompared.set(true);
                } else if ("name".equals(access.getSimpleName()) && Objects.equals(groupArtifactVersion.getArtifactId(), literal.getValue())) {
                    artifactIdCompared.set(true);
                }
                return b;
            }
        }.visit((Tree)and, (Object)groupArtifactVersion);
        return groupIdCompared.get() && artifactIdCompared.get();
    }

    @Generated
    public DependencyConstraintToRule() {
    }

    @org.openrewrite.internal.lang.NonNull
    @Generated
    public String toString() {
        return "DependencyConstraintToRule()";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyConstraintToRule)) {
            return false;
        }
        DependencyConstraintToRule other = (DependencyConstraintToRule)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof DependencyConstraintToRule;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    static final class GroupArtifactVersionBecause {
        private final @Nullable String groupId;
        private final String artifactId;
        private final @Nullable String version;
        private final @Nullable String because;

        @Generated
        public GroupArtifactVersionBecause(@Nullable String groupId, String artifactId, @Nullable String version, @Nullable String because) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.because = because;
        }

        @Generated
        public @Nullable String getGroupId() {
            return this.groupId;
        }

        @Generated
        public String getArtifactId() {
            return this.artifactId;
        }

        @Generated
        public @Nullable String getVersion() {
            return this.version;
        }

        @Generated
        public @Nullable String getBecause() {
            return this.because;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupArtifactVersionBecause)) {
                return false;
            }
            GroupArtifactVersionBecause other = (GroupArtifactVersionBecause)o;
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$because = this.getBecause();
            String other$because = other.getBecause();
            return !(this$because == null ? other$because != null : !this$because.equals(other$because));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $because = this.getBecause();
            result = result * 59 + ($because == null ? 43 : $because.hashCode());
            return result;
        }

        @org.openrewrite.internal.lang.NonNull
        @Generated
        public String toString() {
            return "DependencyConstraintToRule.GroupArtifactVersionBecause(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", because=" + this.getBecause() + ")";
        }
    }

    static class MaybeRemoveDependencyBlock
    extends JavaIsoVisitor<ExecutionContext> {
        MaybeRemoveDependencyBlock() {
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            if (DependencyConstraintToRule.isEmptyDependenciesBlock(m)) {
                return null;
            }
            return m;
        }
    }

    static class MaybeAddEachDependency
    extends JavaIsoVisitor<ExecutionContext> {
        boolean alreadyExists;

        MaybeAddEachDependency() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            if (DependencyConstraintToRule.isEachDependency(m) && !DependencyConstraintToRule.isInBuildscriptBlock(this.getCursor())) {
                this.alreadyExists = true;
            }
            return m;
        }

        public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (this.alreadyExists) {
                return (J)tree;
            }
            if (tree instanceof JavaSourceFile) {
                Statement s;
                int insertionIndex;
                JavaSourceFile sourceFile = (JavaSourceFile)super.visit(tree, (Object)ctx);
                if (this.alreadyExists) {
                    return sourceFile;
                }
                if (sourceFile instanceof G.CompilationUnit) {
                    Statement s2;
                    int insertionIndex2;
                    G.CompilationUnit cu = (G.CompilationUnit)sourceFile;
                    for (insertionIndex2 = 0; !(insertionIndex2 >= cu.getStatements().size() || (s2 = (Statement)cu.getStatements().get(insertionIndex2)) instanceof J.MethodInvocation && DEPENDENCIES_DSL_MATCHER.matches((MethodCall)((J.MethodInvocation)s2))); ++insertionIndex2) {
                    }
                    J.MethodInvocation m = GradleParser.builder().build().parse(ctx, new String[]{"\nconfigurations.all {\n    resolutionStrategy.eachDependency { details ->\n    }\n}"}).map(G.CompilationUnit.class::cast).map(G.CompilationUnit::getStatements).map(it -> (Statement)it.get(0)).map(J.MethodInvocation.class::cast).findFirst().orElseThrow(() -> new IllegalStateException("Unable to create a new configurations.all block"));
                    return cu.withStatements(ListUtils.insert((List)cu.getStatements(), (Object)m, (int)insertionIndex2));
                }
                K.CompilationUnit cu = (K.CompilationUnit)sourceFile;
                assert (cu != null);
                J.Block block = (J.Block)cu.getStatements().get(0);
                for (insertionIndex = 0; !(insertionIndex >= block.getStatements().size() || (s = (Statement)block.getStatements().get(insertionIndex)) instanceof J.MethodInvocation && "dependencies".equals(((J.MethodInvocation)s).getSimpleName())); ++insertionIndex) {
                }
                J.MethodInvocation m = GradleParser.builder().build().parseInputs(Collections.singletonList(new Parser.Input(Paths.get("build.gradle.kts", new String[0]), () -> new ByteArrayInputStream("\nconfigurations.all {\n    resolutionStrategy.eachDependency { details ->}\n}".getBytes(StandardCharsets.UTF_8)))), null, ctx).map(K.CompilationUnit.class::cast).map(k -> (J.Block)k.getStatements().get(0)).map(J.Block::getStatements).map(it -> (Statement)it.get(0)).map(J.MethodInvocation.class::cast).findFirst().map(m2 -> m2.withArguments(ListUtils.mapFirst((List)m2.getArguments(), arg -> {
                    J.Lambda lambda1 = (J.Lambda)arg;
                    J.Block block1 = (J.Block)lambda1.getBody();
                    return lambda1.withBody((J)block1.withStatements(ListUtils.mapFirst((List)block1.getStatements(), arg2 -> {
                        J.MethodInvocation m3 = (J.MethodInvocation)arg2;
                        return m3.withArguments(ListUtils.mapFirst((List)m3.getArguments(), arg3 -> {
                            J.Lambda lambda2 = (J.Lambda)arg3;
                            return lambda2.withBody((J)((J.Block)lambda2.getBody()).withEnd(Space.format((String)"\n")));
                        }));
                    })));
                }))).orElseThrow(() -> new IllegalStateException("Unable to create a new configurations.all block"));
                int finalInsertionIndex = insertionIndex;
                return cu.withStatements(ListUtils.mapFirst((List)cu.getStatements(), arg -> {
                    if (arg == block) {
                        return block.withStatements(ListUtils.insert((List)block.getStatements(), (Object)m, (int)finalInsertionIndex));
                    }
                    return arg;
                }));
            }
            return (J)super.visit(tree, (Object)ctx);
        }
    }

    static class UpdateIf
    extends JavaIsoVisitor<ExecutionContext> {
        GroupArtifactVersionBecause groupArtifactVersionBecause;
        boolean isKotlinDsl;

        public J.If visitIf(J.If iff, ExecutionContext ctx) {
            J.If anIf = super.visitIf(iff, (Object)ctx);
            if (DependencyConstraintToRule.predicateRelatesToGav(anIf, this.groupArtifactVersionBecause)) {
                List newStatements;
                String snippet;
                final AtomicReference variableName = new AtomicReference();
                new JavaIsoVisitor<Integer>(){

                    public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, Integer integer) {
                        J.FieldAccess field = super.visitFieldAccess(fieldAccess, (Object)integer);
                        if (field.getTarget() instanceof J.Identifier) {
                            variableName.set(((J.Identifier)field.getTarget()).getSimpleName());
                        }
                        return fieldAccess;
                    }
                }.visit((Tree)anIf.getIfCondition(), (Object)0);
                if (!this.isKotlinDsl) {
                    snippet = variableName + ".useVersion('" + this.groupArtifactVersionBecause.getVersion() + "')\n";
                    if (this.groupArtifactVersionBecause.getBecause() != null) {
                        snippet = snippet + variableName + ".because('" + this.groupArtifactVersionBecause.getBecause() + "')\n";
                    }
                    newStatements = GroovyParser.builder().build().parse(ctx, new String[]{snippet}).map(G.CompilationUnit.class::cast).map(G.CompilationUnit::getStatements).findFirst().orElseThrow(() -> new IllegalStateException("Unable to produce a new block statement"));
                } else {
                    snippet = variableName + ".useVersion(\"" + this.groupArtifactVersionBecause.getVersion() + "\")\n";
                    if (this.groupArtifactVersionBecause.getBecause() != null) {
                        snippet = snippet + variableName + ".because(\"" + this.groupArtifactVersionBecause.getBecause() + "\")\n";
                    }
                    newStatements = KotlinParser.builder().isKotlinScript(true).build().parse(ctx, new String[]{snippet}).map(K.CompilationUnit.class::cast).map(cu -> (J.Block)cu.getStatements().get(0)).map(J.Block::getStatements).findFirst().orElseThrow(() -> new IllegalStateException("Unable to produce a new block statement"));
                }
                J.Block block = (J.Block)anIf.getThenPart();
                block = block.withStatements(newStatements);
                block = (J.Block)this.autoFormat((J)block, ctx, this.getCursor());
                anIf = anIf.withThenPart((Statement)block);
            }
            return anIf;
        }

        @Generated
        public UpdateIf(GroupArtifactVersionBecause groupArtifactVersionBecause, boolean isKotlinDsl) {
            this.groupArtifactVersionBecause = groupArtifactVersionBecause;
            this.isKotlinDsl = isKotlinDsl;
        }
    }

    static class MaybeAddIf
    extends JavaIsoVisitor<ExecutionContext> {
        @NonNull
        GroupArtifactVersionBecause groupArtifactVersion;
        final boolean isKotlinDsl;
        boolean containsAnyIfStatement;
        boolean containsMatchingIfStatement;

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.If newIf;
            String snippet;
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            if (this.containsMatchingIfStatement) {
                return m;
            }
            if (!DependencyConstraintToRule.isEachDependency(m)) {
                return m;
            }
            Expression maybeClosure = (Expression)m.getArguments().get(0);
            if (!(maybeClosure instanceof J.Lambda) || !(((J.Lambda)maybeClosure).getBody() instanceof J.Block)) {
                return m;
            }
            J.Lambda closure = (J.Lambda)maybeClosure;
            J.Block closureBody = (J.Block)closure.getBody();
            J rawParam = (J)((J.Lambda)maybeClosure).getParameters().getParameters().get(0);
            if (!(rawParam instanceof J.VariableDeclarations)) {
                return m;
            }
            String p = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)rawParam).getVariables().get(0)).getSimpleName();
            if (!this.isKotlinDsl) {
                snippet = "Object " + p + " = null\nif (" + p + ".requested.group == '" + this.groupArtifactVersion.getGroupId() + "' && " + p + ".requested.name == '" + this.groupArtifactVersion.getArtifactId() + "') {\n}";
                newIf = GroovyParser.builder().build().parse(ctx, new String[]{snippet}).map(G.CompilationUnit.class::cast).map(cu -> (Statement)cu.getStatements().get(1)).map(J.If.class::cast).findFirst().orElseThrow(() -> new IllegalStateException("Unable to produce a new if statement"));
            } else {
                snippet = "var " + p + ": Any = null\nif (" + p + ".requested.group == \"" + this.groupArtifactVersion.getGroupId() + "\" && " + p + ".requested.name == \"" + this.groupArtifactVersion.getArtifactId() + "\") {\n}";
                newIf = KotlinParser.builder().isKotlinScript(true).build().parse(ctx, new String[]{snippet}).map(K.CompilationUnit.class::cast).map(cu -> (J.Block)cu.getStatements().get(0)).map(block -> (J.If)block.getStatements().get(1)).findFirst().orElseThrow(() -> new IllegalStateException("Unable to produce a new if statement"));
            }
            if (this.containsAnyIfStatement) {
                m = (J.MethodInvocation)new JavaIsoVisitor<Integer>(){
                    boolean inserted;

                    public J.If visitIf(J.If iff, Integer integer) {
                        J.If anIf = super.visitIf(iff, (Object)integer);
                        J.If.Else currentElse = anIf.getElsePart();
                        if (!this.inserted && (currentElse == null || currentElse.getBody() instanceof J.Block)) {
                            this.inserted = true;
                            J.If.Else newElsePart = new J.If.Else(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, JRightPadded.build((Object)newIf.withPrefix(Space.SINGLE_SPACE).withElsePart(currentElse)));
                            anIf = (J.If)this.autoFormat((J)anIf.withElsePart(newElsePart), 0, Objects.requireNonNull(this.getCursor().getParent()));
                        }
                        return anIf;
                    }
                }.visitNonNull((Tree)m, (Object)0, Objects.requireNonNull(this.getCursor().getParent()));
            } else {
                J.Block newBody = (J.Block)this.autoFormat((J)closureBody.withStatements(ListUtils.concat((Object)newIf, (List)closureBody.getStatements())), ctx, this.getCursor());
                m = m.withArguments(Collections.singletonList(closure.withBody((J)newBody)));
            }
            return m;
        }

        public J.If visitIf(J.If iff, ExecutionContext ctx) {
            this.containsAnyIfStatement = true;
            J.If f = super.visitIf(iff, (Object)ctx);
            if (DependencyConstraintToRule.predicateRelatesToGav(f, this.groupArtifactVersion)) {
                this.containsMatchingIfStatement = true;
            }
            return iff;
        }

        public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (this.containsMatchingIfStatement) {
                return (J)tree;
            }
            return (J)super.visit(tree, (Object)ctx);
        }

        @Generated
        public MaybeAddIf(@NonNull GroupArtifactVersionBecause groupArtifactVersion, boolean isKotlinDsl) {
            if (groupArtifactVersion == null) {
                throw new NullPointerException("groupArtifactVersion is marked non-null but is null");
            }
            this.groupArtifactVersion = groupArtifactVersion;
            this.isKotlinDsl = isKotlinDsl;
        }
    }

    static final class UpdateEachDependency
    extends JavaIsoVisitor<ExecutionContext> {
        private final List<GroupArtifactVersionBecause> groupArtifactVersions;
        private final boolean isKotlinDsl;

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            if (DependencyConstraintToRule.isEachDependency(m) && !DependencyConstraintToRule.isInBuildscriptBlock(this.getCursor())) {
                Cursor parent = Objects.requireNonNull(this.getCursor().getParent());
                for (GroupArtifactVersionBecause gav : this.groupArtifactVersions) {
                    m = (J.MethodInvocation)new MaybeAddIf(gav, this.isKotlinDsl).visitNonNull((Tree)m, ctx, parent);
                    m = (J.MethodInvocation)new UpdateIf(gav, this.isKotlinDsl).visitNonNull((Tree)m, ctx, parent);
                }
            }
            return m;
        }

        @Generated
        public UpdateEachDependency(List<GroupArtifactVersionBecause> groupArtifactVersions, boolean isKotlinDsl) {
            this.groupArtifactVersions = groupArtifactVersions;
            this.isKotlinDsl = isKotlinDsl;
        }

        @Generated
        public List<GroupArtifactVersionBecause> getGroupArtifactVersions() {
            return this.groupArtifactVersions;
        }

        @Generated
        public boolean isKotlinDsl() {
            return this.isKotlinDsl;
        }

        @org.openrewrite.internal.lang.NonNull
        @Generated
        public String toString() {
            return "DependencyConstraintToRule.UpdateEachDependency(groupArtifactVersions=" + this.getGroupArtifactVersions() + ", isKotlinDsl=" + this.isKotlinDsl() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateEachDependency)) {
                return false;
            }
            UpdateEachDependency other = (UpdateEachDependency)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (this.isKotlinDsl() != other.isKotlinDsl()) {
                return false;
            }
            List<GroupArtifactVersionBecause> this$groupArtifactVersions = this.getGroupArtifactVersions();
            List<GroupArtifactVersionBecause> other$groupArtifactVersions = other.getGroupArtifactVersions();
            return !(this$groupArtifactVersions == null ? other$groupArtifactVersions != null : !((Object)this$groupArtifactVersions).equals(other$groupArtifactVersions));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof UpdateEachDependency;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isKotlinDsl() ? 79 : 97);
            List<GroupArtifactVersionBecause> $groupArtifactVersions = this.getGroupArtifactVersions();
            result = result * 59 + ($groupArtifactVersions == null ? 43 : ((Object)$groupArtifactVersions).hashCode());
            return result;
        }
    }

    static class RemoveConstraints
    extends JavaIsoVisitor<List<GroupArtifactVersionBecause>> {
        RemoveConstraints() {
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, List<GroupArtifactVersionBecause> groupArtifactVersions) {
            J.MethodInvocation m = super.visitMethodInvocation(method, groupArtifactVersions);
            if ("constraints".equals(m.getSimpleName()) && DependencyConstraintToRule.isInDependenciesBlock(this.getCursor())) {
                if (!(m.getArguments().get(0) instanceof J.Lambda)) {
                    return null;
                }
                J.Lambda closure = (J.Lambda)m.getArguments().get(0);
                if (!(closure.getBody() instanceof J.Block)) {
                    return null;
                }
                List withoutConvertableConstraints = ListUtils.map((List)((J.Block)closure.getBody()).getStatements(), statement -> {
                    J.MethodInvocation constraint = null;
                    if (statement instanceof J.MethodInvocation) {
                        constraint = (J.MethodInvocation)statement;
                    } else if (statement instanceof J.Return) {
                        constraint = (J.MethodInvocation)((J.Return)statement).getExpression();
                    }
                    if (constraint == null) {
                        return statement;
                    }
                    if (!(constraint.getArguments().get(0) instanceof J.Literal)) {
                        return statement;
                    }
                    J.Literal rawGav = (J.Literal)constraint.getArguments().get(0);
                    String[] gav = rawGav.getValue().toString().split(":");
                    if (gav.length != 3) {
                        return statement;
                    }
                    final AtomicReference<Object> because = new AtomicReference<Object>(null);
                    new JavaIsoVisitor<Integer>(){

                        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, Integer integer) {
                            J.MethodInvocation m1 = super.visitMethodInvocation(method, (Object)integer);
                            if ("because".equals(m1.getSimpleName()) && m1.getArguments().get(0) instanceof J.Literal) {
                                because.set(((J.Literal)m1.getArguments().get(0)).getValue().toString());
                            }
                            return m1;
                        }
                    }.visit(constraint.getArguments(), (Object)0);
                    groupArtifactVersions.add(new GroupArtifactVersionBecause(gav[0], gav[1], gav[2], because.get()));
                    return null;
                });
                if (withoutConvertableConstraints.isEmpty()) {
                    return null;
                }
                return m.withArguments(Collections.singletonList(closure.withBody((J)((J.Block)closure.getBody()).withStatements(withoutConvertableConstraints))));
            }
            return m;
        }
    }
}

