/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.security;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.internal.ChangeStringLiteral;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.kotlin.tree.K;

public class UseHttpsForRepositories
extends Recipe {
    public String getDisplayName() {
        return "Use HTTPS for repositories";
    }

    public String getDescription() {
        return "Use HTTPS for repository URLs.";
    }

    public Set<String> getTags() {
        return Collections.singleton("security");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsBuildGradle(), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            private J.Literal fixupLiteralIfNeeded(J.Literal arg) {
                String url = (String)arg.getValue();
                if (url != null && url.startsWith("http://")) {
                    String newUrl = url.replaceAll("^http://(.*)", "https://$1");
                    return ChangeStringLiteral.withStringValue(arg, newUrl);
                }
                return arg;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if ("url".equals(m.getSimpleName()) || "uri".equals(m.getSimpleName())) {
                    try {
                        this.getCursor().dropParentUntil(e -> e instanceof J.MethodInvocation && "maven".equals(((J.MethodInvocation)e).getSimpleName())).dropParentUntil(e -> e instanceof J.MethodInvocation && "repositories".equals(((J.MethodInvocation)e).getSimpleName()));
                        m = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> {
                            if (arg instanceof J.Literal) {
                                return this.fixupLiteralIfNeeded((J.Literal)arg);
                            }
                            if (arg instanceof G.GString) {
                                G.GString garg = (G.GString)arg;
                                return garg.withStrings(ListUtils.mapFirst((List)garg.getStrings(), lit -> lit instanceof J.Literal ? this.fixupLiteralIfNeeded((J.Literal)lit) : lit));
                            }
                            if (arg instanceof K.StringTemplate) {
                                K.StringTemplate karg = (K.StringTemplate)arg;
                                return karg.withStrings(ListUtils.mapFirst((List)karg.getStrings(), lit -> lit instanceof J.Literal ? this.fixupLiteralIfNeeded((J.Literal)lit) : lit));
                            }
                            return arg;
                        }));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return m;
            }
        });
    }
}

