/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.plugins;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Parser;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.DependencyVersionSelector;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.IsSettingsGradle;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.marker.GradleSettings;
import org.openrewrite.gradle.plugins.AddPluginVisitor;
import org.openrewrite.gradle.plugins.UpgradePluginVersion;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.marker.BuildTool;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.style.Style;

public final class AddDevelocityGradlePlugin
extends Recipe {
    private final transient MavenMetadataFailures metadataFailures = new MavenMetadataFailures((Recipe)this);
    @Option(displayName="Plugin version", description="An exact version number or node-style semver selector used to select the version number. You can also use `latest.release` for the latest available version and `latest.patch` if the current version is a valid semantic version. For more details, you can look at the documentation page of [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors). Defaults to `latest.release`.", example="3.x", required=false)
    private final @Nullable String version;
    @Option(displayName="Server URL", description="The URL of the Develocity server. If omitted the recipe will set no URL and Gradle will direct scans to https://scans.gradle.com/", required=false, example="https://scans.gradle.com/")
    private final @Nullable String server;
    @Option(displayName="Allow untrusted server", description="When set to `true` the plugin will be configured to allow unencrypted http connections with the server. If set to `false` or omitted, the plugin will refuse to communicate without transport layer security enabled.", required=false, example="true")
    private final @Nullable Boolean allowUntrustedServer;
    @Option(displayName="Capture task input files", description="When set to `true` the plugin will capture additional information about the inputs to Gradle tasks. This increases the size of build scans, but is useful for diagnosing issues with task caching. ", required=false, example="true")
    private final @Nullable Boolean captureTaskInputFiles;
    @Option(displayName="Upload in background", description="When set to `true` the plugin will capture additional information about the outputs of Gradle tasks. This increases the size of build scans, but is useful for diagnosing issues with task caching. ", required=false, example="true")
    private final @Nullable Boolean uploadInBackground;
    @Option(displayName="Publish criteria", description="When set to `Always` the plugin will publish build scans of every single build. When set to `Failure` the plugin will only publish build scans when the build fails. When omitted scans will be published only when the `--scan` option is passed to the build.", required=false, valid={"Always", "Failure"}, example="Always")
    private final @Nullable PublishCriteria publishCriteria;

    public String getDisplayName() {
        return "Add the Develocity Gradle plugin";
    }

    public String getDescription() {
        return "Add the Develocity Gradle plugin to settings.gradle files.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.version != null) {
            validated = validated.and(Semver.validate((String)this.version, null));
        }
        return validated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new IsBuildGradle(), new IsSettingsGradle()}), (TreeVisitor)new GroovyIsoVisitor<ExecutionContext>(){

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                boolean gradleSixOrLater;
                Optional maybeBuildTool = cu.getMarkers().findFirst(BuildTool.class);
                if (!maybeBuildTool.isPresent()) {
                    return cu;
                }
                BuildTool buildTool = (BuildTool)maybeBuildTool.get();
                if (buildTool.getType() != BuildTool.Type.Gradle) {
                    return cu;
                }
                VersionComparator versionComparator = (VersionComparator)Semver.validate((String)"(,6)", null).getValue();
                if (versionComparator == null) {
                    return cu;
                }
                if (AddDevelocityGradlePlugin.containsGradleDevelocityDsl((JavaSourceFile)cu)) {
                    return cu;
                }
                boolean bl = gradleSixOrLater = versionComparator.compare(null, buildTool.getVersion(), "6.0") >= 0;
                if (gradleSixOrLater && cu.getSourcePath().endsWith("settings.gradle")) {
                    Optional maybeGradleSettings = cu.getMarkers().findFirst(GradleSettings.class);
                    if (!maybeGradleSettings.isPresent()) {
                        return cu;
                    }
                    GradleSettings gradleSettings = (GradleSettings)maybeGradleSettings.get();
                    try {
                        String newVersion = this.findNewerVersion(new DependencyVersionSelector(AddDevelocityGradlePlugin.this.metadataFailures, null, gradleSettings), ctx);
                        if (newVersion == null) {
                            return cu;
                        }
                        String pluginId = versionComparator.compare(null, newVersion, "3.17") >= 0 ? "com.gradle.develocity" : "com.gradle.enterprise";
                        cu = AddDevelocityGradlePlugin.this.withPlugin(cu, pluginId, newVersion, versionComparator, ctx);
                    }
                    catch (MavenDownloadingException e) {
                        return (G.CompilationUnit)e.warn((Tree)cu);
                    }
                }
                if (!gradleSixOrLater && "build.gradle".equals(cu.getSourcePath().toString())) {
                    Optional maybeGradleProject = cu.getMarkers().findFirst(GradleProject.class);
                    if (!maybeGradleProject.isPresent()) {
                        return cu;
                    }
                    GradleProject gradleProject = (GradleProject)maybeGradleProject.get();
                    try {
                        String newVersion = this.findNewerVersion(new DependencyVersionSelector(AddDevelocityGradlePlugin.this.metadataFailures, gradleProject, null), ctx);
                        if (newVersion == null) {
                            return cu;
                        }
                        cu = AddDevelocityGradlePlugin.this.withPlugin(cu, "com.gradle.build-scan", newVersion, versionComparator, ctx);
                    }
                    catch (MavenDownloadingException e) {
                        return (G.CompilationUnit)e.warn((Tree)cu);
                    }
                }
                return cu;
            }

            private @Nullable String findNewerVersion(DependencyVersionSelector versionSelector, ExecutionContext ctx) throws MavenDownloadingException {
                String newVersion = versionSelector.select(new GroupArtifact("com.gradle.develocity", "com.gradle.develocity.gradle.plugin"), "classpath", AddDevelocityGradlePlugin.this.version, null, ctx);
                if (newVersion == null) {
                    newVersion = versionSelector.select(new GroupArtifact("com.gradle.enterprise", "com.gradle.enterprise.gradle.plugin"), "classpath", AddDevelocityGradlePlugin.this.version, null, ctx);
                }
                return newVersion;
            }
        });
    }

    private G.CompilationUnit withPlugin(G.CompilationUnit cu, String pluginId, String newVersion, VersionComparator versionComparator, ExecutionContext ctx) {
        cu = (G.CompilationUnit)new AddPluginVisitor(pluginId, newVersion, null, null, false).visitNonNull((Tree)cu, ctx);
        cu = (G.CompilationUnit)new UpgradePluginVersion(pluginId, newVersion, null).getVisitor().visitNonNull((Tree)cu, (Object)ctx);
        J.MethodInvocation gradleEnterpriseInvocation = this.gradleEnterpriseDsl(newVersion, versionComparator, AddDevelocityGradlePlugin.getIndent(cu), ctx);
        return cu.withStatements(ListUtils.concat((List)cu.getStatements(), (Object)gradleEnterpriseInvocation));
    }

    private static boolean containsGradleDevelocityDsl(JavaSourceFile cu) {
        AtomicBoolean found = new AtomicBoolean(false);
        new GroovyIsoVisitor<AtomicBoolean>(){

            public @Nullable J visit(@Nullable Tree tree, AtomicBoolean atomicBoolean) {
                if (atomicBoolean.get()) {
                    return (J)tree;
                }
                return (J)super.visit(tree, (Object)atomicBoolean);
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, AtomicBoolean atomicBoolean) {
                if ("gradleEnterprise".equals(method.getSimpleName()) || "develocity".equals(method.getSimpleName())) {
                    atomicBoolean.set(true);
                }
                return super.visitMethodInvocation(method, (Object)atomicBoolean);
            }
        }.visit((Tree)cu, found);
        return found.get();
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable J.MethodInvocation gradleEnterpriseDsl(String newVersion, VersionComparator versionComparator, String indent, ExecutionContext ctx) {
        if (this.server == null && this.allowUntrustedServer == null && this.captureTaskInputFiles == null && this.uploadInBackground == null && this.publishCriteria == null) {
            return null;
        }
        boolean versionIsAtLeast3_2 = versionComparator.compare(null, newVersion, "3.2") >= 0;
        boolean versionIsAtLeast3_7 = versionComparator.compare(null, newVersion, "3.7") >= 0;
        boolean versionIsAtLeast3_17 = versionComparator.compare(null, newVersion, "3.17") >= 0;
        StringBuilder ge = versionIsAtLeast3_17 ? new StringBuilder("\ndevelocity {\n") : new StringBuilder("\ngradleEnterprise {\n");
        if (this.server != null && !this.server.isEmpty()) {
            ge.append(indent).append("server = '").append(this.server).append("'\n");
        }
        if (this.allowUntrustedServer != null && versionIsAtLeast3_2) {
            ge.append(indent).append("allowUntrustedServer = ").append(this.allowUntrustedServer).append("\n");
        }
        if (this.captureTaskInputFiles != null || this.uploadInBackground != null || this.allowUntrustedServer != null && !versionIsAtLeast3_2 || this.publishCriteria != null) {
            ge.append(indent).append("buildScan {\n");
            if (this.publishCriteria != null) {
                if (this.publishCriteria == PublishCriteria.Always) {
                    if (versionIsAtLeast3_17) {
                        ge.append(indent).append(indent).append("publishing.onlyIf { true }\n");
                    } else {
                        ge.append(indent).append(indent).append("publishAlways()\n");
                    }
                } else if (versionIsAtLeast3_17) {
                    ge.append(indent).append(indent).append("publishing.onlyIf { !it.buildResult.failures.empty }\n");
                } else {
                    ge.append(indent).append(indent).append("publishOnFailure()\n");
                }
            }
            if (this.allowUntrustedServer != null && !versionIsAtLeast3_2) {
                ge.append(indent).append(indent).append("allowUntrustedServer = ").append(this.allowUntrustedServer).append("\n");
            }
            if (this.uploadInBackground != null) {
                ge.append(indent).append(indent).append("uploadInBackground = ").append(this.uploadInBackground).append("\n");
            }
            if (this.captureTaskInputFiles != null) {
                if (versionIsAtLeast3_7) {
                    ge.append(indent).append(indent).append("capture {\n");
                    if (versionIsAtLeast3_17) {
                        ge.append(indent).append(indent).append(indent).append("fileFingerprints = ").append(this.captureTaskInputFiles).append("\n");
                    } else {
                        ge.append(indent).append(indent).append(indent).append("taskInputFiles = ").append(this.captureTaskInputFiles).append("\n");
                    }
                    ge.append(indent).append(indent).append("}\n");
                } else {
                    ge.append(indent).append(indent).append("captureTaskInputFiles = ").append(this.captureTaskInputFiles).append("\n");
                }
            }
            ge.append(indent).append("}\n");
        }
        ge.append("}\n");
        G.CompilationUnit cu = GradleParser.builder().build().parseInputs(Collections.singletonList(Parser.Input.fromString((Path)Paths.get("settings.gradle", new String[0]), (String)ge.toString())), null, ctx).map(G.CompilationUnit.class::cast).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not parse as Gradle"));
        return (J.MethodInvocation)cu.getStatements().get(0);
    }

    private static String getIndent(G.CompilationUnit cu) {
        TabsAndIndentsStyle style = (TabsAndIndentsStyle)Style.from(TabsAndIndentsStyle.class, (SourceFile)cu, IntelliJ::tabsAndIndents);
        if (style.getUseTabCharacter().booleanValue()) {
            return "\t";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < style.getIndentSize(); ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    @Generated
    public AddDevelocityGradlePlugin(@Nullable String version, @Nullable String server, @Nullable Boolean allowUntrustedServer, @Nullable Boolean captureTaskInputFiles, @Nullable Boolean uploadInBackground, @Nullable PublishCriteria publishCriteria) {
        this.version = version;
        this.server = server;
        this.allowUntrustedServer = allowUntrustedServer;
        this.captureTaskInputFiles = captureTaskInputFiles;
        this.uploadInBackground = uploadInBackground;
        this.publishCriteria = publishCriteria;
    }

    @Generated
    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable String getServer() {
        return this.server;
    }

    @Generated
    public @Nullable Boolean getAllowUntrustedServer() {
        return this.allowUntrustedServer;
    }

    @Generated
    public @Nullable Boolean getCaptureTaskInputFiles() {
        return this.captureTaskInputFiles;
    }

    @Generated
    public @Nullable Boolean getUploadInBackground() {
        return this.uploadInBackground;
    }

    @Generated
    public @Nullable PublishCriteria getPublishCriteria() {
        return this.publishCriteria;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddDevelocityGradlePlugin(metadataFailures=" + this.getMetadataFailures() + ", version=" + this.getVersion() + ", server=" + this.getServer() + ", allowUntrustedServer=" + this.getAllowUntrustedServer() + ", captureTaskInputFiles=" + this.getCaptureTaskInputFiles() + ", uploadInBackground=" + this.getUploadInBackground() + ", publishCriteria=" + (Object)((Object)this.getPublishCriteria()) + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddDevelocityGradlePlugin)) {
            return false;
        }
        AddDevelocityGradlePlugin other = (AddDevelocityGradlePlugin)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$allowUntrustedServer = this.getAllowUntrustedServer();
        Boolean other$allowUntrustedServer = other.getAllowUntrustedServer();
        if (this$allowUntrustedServer == null ? other$allowUntrustedServer != null : !((Object)this$allowUntrustedServer).equals(other$allowUntrustedServer)) {
            return false;
        }
        Boolean this$captureTaskInputFiles = this.getCaptureTaskInputFiles();
        Boolean other$captureTaskInputFiles = other.getCaptureTaskInputFiles();
        if (this$captureTaskInputFiles == null ? other$captureTaskInputFiles != null : !((Object)this$captureTaskInputFiles).equals(other$captureTaskInputFiles)) {
            return false;
        }
        Boolean this$uploadInBackground = this.getUploadInBackground();
        Boolean other$uploadInBackground = other.getUploadInBackground();
        if (this$uploadInBackground == null ? other$uploadInBackground != null : !((Object)this$uploadInBackground).equals(other$uploadInBackground)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        PublishCriteria this$publishCriteria = this.getPublishCriteria();
        PublishCriteria other$publishCriteria = other.getPublishCriteria();
        return !(this$publishCriteria == null ? other$publishCriteria != null : !((Object)((Object)this$publishCriteria)).equals((Object)other$publishCriteria));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddDevelocityGradlePlugin;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $allowUntrustedServer = this.getAllowUntrustedServer();
        result = result * 59 + ($allowUntrustedServer == null ? 43 : ((Object)$allowUntrustedServer).hashCode());
        Boolean $captureTaskInputFiles = this.getCaptureTaskInputFiles();
        result = result * 59 + ($captureTaskInputFiles == null ? 43 : ((Object)$captureTaskInputFiles).hashCode());
        Boolean $uploadInBackground = this.getUploadInBackground();
        result = result * 59 + ($uploadInBackground == null ? 43 : ((Object)$uploadInBackground).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        PublishCriteria $publishCriteria = this.getPublishCriteria();
        result = result * 59 + ($publishCriteria == null ? 43 : ((Object)((Object)$publishCriteria)).hashCode());
        return result;
    }

    public static enum PublishCriteria {
        Always,
        Failure;

    }
}

